/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.SideModels;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.KDebug;
import cerent.util.SDebug;

public class SidesManager
extends WzTask {
    private SideModels model = this.node.getSideModelsModel();
    private static final String SP_START = ">> Starting Optical Sides Provisioning...\n";
    private static final String SP_PROB = ">> Side could not be provisioned: ";
    private static final String SP_CORE = ">> Provisioning Side ";
    private static final String SP_EXC = ">> Exception in provisioning side ";
    private static final String SP_WARN = ">> Side already provisioned with same parameters\n";
    private static final SDebug db = new SDebug("SidesManager");

    public SidesManager(NsdWizardInfo nsdWizardInfo, NodeModelDelegate nodeModelDelegate) {
        super(nsdWizardInfo, nodeModelDelegate);
    }

    @Override
    public synchronized void doTask() {
        this.setWorking();
        this.wzInfo.logInfo(SP_START);
        for (int i = 0; i < this.wzInfo.getSides().size(); ++i) {
            NsdWizardInfo.SidesStructure sidesStructure = this.wzInfo.getSides().elementAt(i);
            this.wzInfo.logInfo(SP_CORE + sidesStructure.side_name + " Line In: Shelf " + sidesStructure.shelf_in + ", Slot " + sidesStructure.slot_in + ", Port " + sidesStructure.port_in + " Line Out: Shelf " + sidesStructure.shelf_out + ", Slot " + sidesStructure.slot_out + ", Port " + sidesStructure.port_out + "\n");
            int n = this.getSideid(sidesStructure.side_name);
            if (n == 0) {
                this.wzInfo.logError(">> Side could not be provisioned: wrong side name\n");
                continue;
            }
            PortModel portModel = this.getPortModel(sidesStructure.shelf_in, sidesStructure.slot_in, null, sidesStructure.port_in);
            if (portModel == null) {
                this.wzInfo.logError(">> Side could not be provisioned: no in port found\n");
                continue;
            }
            PortModel portModel2 = this.getPortModel(sidesStructure.shelf_out, sidesStructure.slot_out, null, sidesStructure.port_out);
            if (portModel2 == null) {
                this.wzInfo.logError(">> Side could not be provisioned: no out port found\n");
                continue;
            }
            int n2 = portModel.getEntityIndex();
            int n3 = portModel2.getEntityIndex();
            try {
                this.model.addSide(n, n2, n3);
                this.wzInfo.logSuccess(">> Done...\n");
                continue;
            }
            catch (Exception exception) {
                if (this.model.getSide(n, portModel, portModel2) != null) {
                    this.wzInfo.logWarning(SP_WARN);
                    continue;
                }
                if (SidesManager.db.on) {
                    KDebug.printStackTrace((Throwable)exception);
                    db.println("Side provisioning failed");
                }
                this.wzInfo.logError(SP_EXC + sidesStructure.side_name + "\n");
            }
        }
        this.setCompleted();
    }

    private int getSideid(String string) {
        DwdmSide.SideEnum sideEnum = DwdmSide.getValue(string);
        if (sideEnum != null) {
            return sideEnum.toInt();
        }
        return 0;
    }
}

