/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.util.Vector;

public class WzTasksController
implements Runnable {
    private final Vector<WzTask> tasks;
    private final NsdWizardInfo wzInfo;
    private final int wakeupTime;
    private static final SDebug db = new SDebug("WzTaskController");

    public WzTasksController(Vector<WzTask> vector, NsdWizardInfo nsdWizardInfo, boolean bl) {
        this.tasks = vector;
        this.wzInfo = nsdWizardInfo;
        this.wakeupTime = Preferences.instance().getInt("ctc.nodesetup", "wakeupTime", 1000);
        db.info("Wakeup Time set to (mSecs): " + this.wakeupTime);
    }

    @Override
    public void run() {
        block3: {
            try {
                WzTask.begin(this.wzInfo);
                while (this.checkTasks()) {
                    Thread.sleep(this.wakeupTime);
                }
                WzTask.end(this.wzInfo);
            }
            catch (InterruptedException interruptedException) {
                db.println("InterruptedException during WzTasksCotroller thread execution: " + interruptedException);
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)interruptedException);
            }
        }
        this.wzInfo.terminate(null);
    }

    private boolean checkTasks() {
        boolean bl = false;
        WzTask wzTask = null;
        for (int i = 0; i < this.tasks.size(); ++i) {
            wzTask = this.tasks.elementAt(i);
            if (wzTask == null) continue;
            if (wzTask.isIdle()) {
                wzTask.doTask();
                bl = true;
                break;
            }
            if (wzTask.isCompleted()) {
                this.tasks.remove(i);
                --i;
                continue;
            }
            if (!wzTask.isWorking()) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

