/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oadm;

import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.oadm.OadmInventoryPane;
import cerent.cms.ui.oadm.OadmMaintenancePane;
import cerent.cms.ui.oadm.OadmPerfPane;
import cerent.cms.ui.oadm.OadmProvPane;
import cerent.util.SDebug;
import java.awt.Component;

public class OadmCardTabbedView
extends CardTabbedView
implements ITabName {
    ModuleModel module = null;
    NodeModelDelegate node = null;
    private static final SDebug db = new SDebug("OadmCardTabbedView");

    public OadmCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        this.init();
    }

    @Override
    public void showTabs() {
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
        this.addTab("Inventory", (Component)this.getInventoryTab());
        this.addTab("Performance", (Component)this.getPerformanceTab());
    }

    private void init() {
        this.module = (ModuleModel)this.getUiModel();
        this.node = ((ModuleModel)this.getUiModel()).getNodeModelDelegate();
        this.showTabs();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public Pane getMaintenanceTab() {
        int n = this.module.getEqType();
        switch (n) {
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                return new OadmMaintenancePane("Maintenance", this, this.module);
            }
        }
        return null;
    }

    @Override
    public Pane getPerformanceTab() {
        return new OadmPerfPane("Performance", this, this.module);
    }

    @Override
    public Pane getProvTab() {
        return new OadmProvPane("Provisioning", this, this.module);
    }

    public Pane getInventoryTab() {
        return new OadmInventoryPane("Inventory", this);
    }
}

