/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oadm;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Optics.eBand;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.OpticalTableModel;
import cerent.cms.ui.Wavelength;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;

public class OadmParametersTableModel
extends OpticalTableModel {
    public static final int ACTUAL_WAVEL_INDEX = 14;
    public static final int EXPECTED_WAVEL_INDEX = 15;
    public static final int ACTUAL_BAND_INDEX = 16;
    public static final int EXPECTED_BAND_INDEX = 17;
    public static String[] columnNames = new String[]{"Actual Wavelength", "Expected Wavelength", "Actual Band", "Expected Band"};
    private static final String[] WavelengthStrings = new String[]{"AUTOPROV", "1530.33 nm", "1531.12 nm", "1531.90 nm", "1532.68 nm", "1534.25 nm", "1535.04 nm", "1535.82 nm", "1536.61 nm", "1538.19 nm", "1538.98 nm", "1539.77 nm", "1540.56 nm", "1542.14 nm", "1542.94 nm", "1543.73 nm", "1544.53 nm", "1546.12 nm", "1546.92 nm", "1547.72 nm", "1548.51 nm", "1550.12 nm", "1550.92 nm", "1551.72 nm", "1552.52 nm", "1554.13 nm", "1554.94 nm", "1555.75 nm", "1556.55 nm", "1558.17 nm", "1558.98 nm", "1559.79 nm", "1560.61 nm"};
    private static final String[] Oadm2Chn_WavelengthStrings = new String[]{"AUTOPROV", "1530.33 nm", "1531.90 nm", "1534.25 nm", "1535.82 nm", "1538.19 nm", "1539.77 nm", "1542.14 nm", "1543.73 nm", "1546.12 nm", "1547.72 nm", "1550.12 nm", "1551.72 nm", "1554.13 nm", "1555.75 nm", "1558.17 nm", "1559.79 nm"};
    private static final String[] Oadm4Chn_WavelengthStrings = new String[]{"AUTOPROV", "1530.33 nm", "1534.25 nm", "1538.19 nm", "1542.14 nm", "1546.12 nm", "1550.12 nm", "1554.13 nm", "1558.17 nm"};
    private static final String[] Oadm1Band_WavelengthStrings = new String[]{"AUTOPROV", "1530.33 nm", "1534.25 nm", "1538.19 nm", "1542.14 nm", "1546.12 nm", "1550.12 nm", "1554.13 nm", "1558.17 nm"};
    private static final String[] Oadm4Band_WavelengthStrings = new String[]{"AUTOPROV", "1530.33 nm", "1546.12 nm"};
    private int[] expectedWavelength;
    private int[] expectedBandWavelength;
    private int[] actualWavelength;
    private int[] actualBandWavelength;
    private static final SDebug db = new SDebug("OadmParametersTableModel");

    public OadmParametersTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(db, abstractOpticsLineModelArray);
        this.expectedWavelength = new int[this.numLines];
        this.expectedBandWavelength = new int[this.numLines];
        this.actualWavelength = new int[this.numLines];
        this.actualBandWavelength = new int[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.expectedWavelength[i] = -1;
            this.expectedBandWavelength[i] = -1;
            this.actualWavelength[i] = -1;
            this.actualBandWavelength[i] = -1;
        }
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount() + columnNames.length;
    }

    public String[] getWavelengthStrings() {
        return WavelengthStrings;
    }

    public String[] getOadm2Chn_WavelengthStrings() {
        return Oadm2Chn_WavelengthStrings;
    }

    public String[] getOadm4Chn_WavelengthStrings() {
        return Oadm4Chn_WavelengthStrings;
    }

    public String[] getOadm1Band_WavelengthStrings() {
        return Oadm1Band_WavelengthStrings;
    }

    public String[] getOadm4Band_WavelengthStrings() {
        return Oadm4Band_WavelengthStrings;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        if (n2 == 17 && n == 0 || n2 == 15 && n == 0) {
            return true;
        }
        return super.isCellEditable(n, n2);
    }

    @Override
    public String getColumnName(int n) {
        if (n < 14) {
            return super.getColumnName(n);
        }
        return columnNames[n - 14];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 14: {
                    return this.getActualWavelength(n);
                }
                case 16: {
                    return this.getActualBandWavelength(n);
                }
                case 15: {
                    return this.getExpectedWavelength(n);
                }
                case 17: {
                    return this.getExpectedBandWavelength(n);
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OadmParametersTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private String getActualBandWavelength(int n) {
        int n2 = 0;
        if (this.actualBandWavelength[n] == -1) {
            if (this.model[n] != null && this.model[n] instanceof OpticsMultiplexSectionModel) {
                OpticsMultiplexSectionModel opticsMultiplexSectionModel = (OpticsMultiplexSectionModel)this.model[n];
                try {
                    this.actualBandWavelength[n] = n2 = opticsMultiplexSectionModel.getActualBand().value();
                }
                catch (Exception exception) {
                    n2 = 0;
                }
            } else {
                this.actualBandWavelength[n] = n2;
            }
        }
        return Oadm1Band_WavelengthStrings[this.actualBandWavelength[n]];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                case 15: {
                    int n3 = 0;
                    if (134 == this.eqpmtModel.getEqType()) {
                        n3 = this.getIndexOf((String)object, WavelengthStrings);
                    } else if (135 == this.eqpmtModel.getEqType()) {
                        n3 = this.getIndexOf((String)object, Oadm2Chn_WavelengthStrings);
                    } else if (136 == this.eqpmtModel.getEqType()) {
                        n3 = this.getIndexOf((String)object, Oadm4Chn_WavelengthStrings);
                    }
                    if (this.expectedWavelength[n] == n3) {
                        return;
                    }
                    this.expectedWavelength[n] = n3;
                    break;
                }
                case 17: {
                    if (137 == this.eqpmtModel.getEqType()) {
                        int n4;
                        this.expectedBandWavelength[n] = n4 = this.getIndexOf((String)object, Oadm1Band_WavelengthStrings);
                        break;
                    }
                    if (138 == this.eqpmtModel.getEqType()) {
                        int n5;
                        this.expectedBandWavelength[n] = n5 = this.getIndexOf((String)object, Oadm4Band_WavelengthStrings);
                    }
                    break;
                }
                default: {
                    super.setValueAt(object, n, n2);
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private String getExpectedWavelength(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        if (134 == this.eqpmtModel.getEqType()) {
            n2 = 1;
            n3 = 0;
        } else if (135 == this.eqpmtModel.getEqType()) {
            n2 = 2;
            n3 = 1;
        } else if (136 == this.eqpmtModel.getEqType()) {
            n2 = 4;
            n3 = 1;
        }
        if (this.expectedWavelength[n] == -1 && this.model[n] != null && this.model[n] instanceof OpticsChannelModel) {
            OpticsChannelModel opticsChannelModel = (OpticsChannelModel)this.model[n];
            try {
                this.expectedWavelength[n] = opticsChannelModel.getExpectedWaveLength();
                bl = true;
            }
            catch (Exception exception) {
                this.expectedWavelength[n] = 0;
            }
        }
        if (134 == this.eqpmtModel.getEqType()) {
            if (this.expectedWavelength[n] == -1) {
                return WavelengthStrings[0];
            }
            int n4 = this.expectedWavelength[n];
            if (n4 > 1) {
                n4 = n4 / n2 + n3;
            }
            if (bl) {
                if (n > 0) {
                    return WavelengthStrings[this.expectedWavelength[n]];
                }
                this.expectedWavelength[n] = n4;
                return WavelengthStrings[this.expectedWavelength[n]];
            }
            return WavelengthStrings[this.expectedWavelength[n]];
        }
        if (135 == this.eqpmtModel.getEqType()) {
            if (this.expectedWavelength[n] == -1) {
                return WavelengthStrings[0];
            }
            int n5 = this.expectedWavelength[n];
            if (n5 > 1) {
                n5 = n5 / n2 + n3;
            }
            if (bl) {
                if (n > 0) {
                    return WavelengthStrings[this.expectedWavelength[n]];
                }
                this.expectedWavelength[n] = n5;
                return Oadm2Chn_WavelengthStrings[this.expectedWavelength[n]];
            }
            if (n > 0) {
                return WavelengthStrings[this.expectedWavelength[n]];
            }
            return Oadm2Chn_WavelengthStrings[this.expectedWavelength[n]];
        }
        if (this.expectedWavelength[n] == -1) {
            return Oadm4Chn_WavelengthStrings[0];
        }
        int n6 = this.expectedWavelength[n];
        if (n6 > 1) {
            n6 = n6 / n2 + n3;
        }
        if (bl) {
            if (n > 0) {
                return WavelengthStrings[this.expectedWavelength[n]];
            }
            this.expectedWavelength[n] = n6;
            return Oadm4Chn_WavelengthStrings[this.expectedWavelength[n]];
        }
        if (n > 0) {
            return WavelengthStrings[this.expectedWavelength[n]];
        }
        return Oadm4Chn_WavelengthStrings[this.expectedWavelength[n]];
    }

    private void setExpectedWavelength(int n) throws AnnotatedException {
        int n2 = 0;
        int n3 = 0;
        if (134 == this.eqpmtModel.getEqType()) {
            n2 = 1;
            n3 = 0;
        } else if (135 == this.eqpmtModel.getEqType()) {
            n2 = 2;
            n3 = 1;
        } else if (136 == this.eqpmtModel.getEqType()) {
            n2 = 4;
            n3 = 3;
        }
        int n4 = this.expectedWavelength[n];
        if (n4 > 1) {
            n4 = n4 * n2 - n3;
        }
        try {
            OpticsChannelModel opticsChannelModel = (OpticsChannelModel)this.model[n];
            opticsChannelModel.setExpectedWaveLength(eWavelength.from_int(n4));
        }
        catch (Exception exception) {
            throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_SETEXPECTED_WAVELENGTH), exception);
        }
    }

    private void setExpectedBandWavelength(int n) throws AnnotatedException {
        int n2 = 0;
        int n3 = 0;
        if (137 == this.eqpmtModel.getEqType()) {
            n2 = 1;
            n3 = 0;
        } else {
            n2 = 4;
            n3 = 3;
        }
        int n4 = this.expectedBandWavelength[n];
        if (n4 > 1) {
            n4 = n4 * n2 - n3;
        }
        try {
            OpticsMultiplexSectionModel opticsMultiplexSectionModel = (OpticsMultiplexSectionModel)this.model[n];
            opticsMultiplexSectionModel.setExpectedBand(eBand.from_int(n4));
        }
        catch (Exception exception) {
            throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_SETEXPECTED_BAND), exception);
        }
    }

    private String getExpectedBandWavelength(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (137 == this.eqpmtModel.getEqType()) {
            n2 = 1;
            n3 = 0;
        } else {
            n2 = 4;
            n3 = 1;
        }
        if (this.expectedBandWavelength[n] == -1 && this.model[n] != null && this.model[n] instanceof OpticsMultiplexSectionModel) {
            OpticsMultiplexSectionModel opticsMultiplexSectionModel = (OpticsMultiplexSectionModel)this.model[n];
            try {
                this.expectedBandWavelength[n] = opticsMultiplexSectionModel.getExpectedBand().value();
                bl = true;
            }
            catch (Exception exception) {
                this.expectedBandWavelength[n] = 0;
            }
        }
        if (137 == this.eqpmtModel.getEqType()) {
            if (this.expectedBandWavelength[n] == -1) {
                return Oadm1Band_WavelengthStrings[0];
            }
            n4 = this.expectedBandWavelength[n];
            if (n4 > 1) {
                n4 = n4 / n2 + n3;
            }
            if (bl) {
                if (n > 0) {
                    return Oadm1Band_WavelengthStrings[this.expectedBandWavelength[n]];
                }
                this.expectedBandWavelength[n] = n4;
                return Oadm1Band_WavelengthStrings[this.expectedBandWavelength[n]];
            }
            return Oadm1Band_WavelengthStrings[this.expectedBandWavelength[n]];
        }
        if (this.expectedBandWavelength[n] == -1) {
            return Oadm4Band_WavelengthStrings[0];
        }
        n4 = this.expectedBandWavelength[n];
        if (n4 > 1) {
            n4 = n4 / n2 + n3;
        }
        if (bl) {
            if (n > 0) {
                return Oadm1Band_WavelengthStrings[this.expectedBandWavelength[n]];
            }
            this.expectedBandWavelength[n] = n4;
            return Oadm4Band_WavelengthStrings[this.expectedBandWavelength[n]];
        }
        if (n > 0) {
            return Oadm1Band_WavelengthStrings[this.expectedBandWavelength[n]];
        }
        return Oadm4Band_WavelengthStrings[this.expectedBandWavelength[n]];
    }

    @Override
    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.getExpectedWavelength(n);
        this.getExpectedBandWavelength(n);
        this.getActualBandWavelength(n);
        this.getActualWavelength(n);
        super.refreshLineFromModel(n);
    }

    @Override
    protected void resetLineCache(int n) {
        super.resetLineCache(n);
        this.expectedWavelength[n] = -1;
        this.expectedBandWavelength[n] = -1;
        this.actualWavelength[n] = -1;
        this.actualBandWavelength[n] = -1;
    }

    @Override
    public void applyToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (this.isDirty[n][15]) {
                    this.setExpectedWavelength(n);
                }
                if (!this.isDirty[n][17]) continue;
                this.setExpectedBandWavelength(n);
            }
            super.applyToModel();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            this.refreshFromModel();
        }
        catch (Exception exception) {
            if (this.FlgAdminStateChanged) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_CHANGE_ADMIN_STATE_NOTALLOWED);
            } else {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            }
            this.refreshFromModel();
        }
    }

    protected String getActualWavelength(int n) {
        int n2 = 0;
        if (this.actualBandWavelength[n] == -1) {
            if (this.model[n] != null && this.model[n] instanceof OpticsChannelModel) {
                OpticsChannelModel opticsChannelModel = (OpticsChannelModel)this.model[n];
                try {
                    this.actualWavelength[n] = n2 = opticsChannelModel.getActualWaveLength();
                }
                catch (Exception exception) {
                    n2 = 0;
                }
            } else {
                this.actualWavelength[n] = n2;
            }
        }
        return Wavelength.getWavelengthStringFromWavelength(this.actualWavelength[n]);
    }
}

