/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.oscm.OscOTSProvPane;
import cerent.cms.ui.oscm.OscOc3ThresholdProvPane;
import cerent.cms.ui.oscm.OscThresholdPane;
import cerent.cms.ui.oscm.OscmOcLineProvPane;
import cerent.util.SDebug;
import java.awt.Component;

public class OscProvPane
extends NodeProvPane
implements ITabName {
    private TdmLineModel[] lineModels = null;
    private OpticsModuleModel model = (OpticsModuleModel)this.getUiModel();
    private OpticsLineModel[] otsModels;
    private static final SDebug db = new SDebug("OscProvPane");

    OscProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        boolean bl;
        this.lineModels = ((OpticsModuleModel)this.getUiModel()).getTdmLineModels();
        this.otsModels = this.model.getOpticsLineModels();
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        int n = this.model.getChassis().getChassisType();
        boolean bl2 = bl = n == 336 || n == 334;
        if (this.pci.is455() || bl) {
            this.subTabs.addTab("STM-1 Line", (Component)this.getOc3ProvTabs(this.subTabs));
        } else {
            this.subTabs.addTab("OC3 Line", (Component)this.getOc3ProvTabs(this.subTabs));
        }
        this.subTabs.addTab("Optical Line", (Component)this.getOtsTabs(this.otsModels, this.subTabs));
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    protected Pane getThresholdsPane() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new OscOc3ThresholdProvPane("OC3 Line Thresholds", this.getParentView(), this.lineModels));
    }

    protected Pane getOc3ProvTabs(TabbedView tabbedView) {
        return new OscmOc3ProvPane(tabbedView);
    }

    protected Pane getLineProvTab() {
        return new OscmOcLineProvPane("Line", this.getParentView());
    }

    protected Pane getOTSProvTab(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new OscOTSProvPane("Line", this.getParentView(), abstractOpticsLineModelArray);
    }

    protected Pane getOc3ThresholdsPane() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new OscOc3ThresholdProvPane("OC3 Line Thresholds", this.getParentView(), this.lineModels));
    }

    @Override
    public boolean hasSubTabs() {
        return true;
    }

    protected Pane getOptThresholdsTab(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new OscThresholdPane("Optics Thresholds", this.getParentView(), abstractOpticsLineModelArray);
    }

    protected Pane getOtsTabs(AbstractOpticsLineModel[] abstractOpticsLineModelArray, TabbedView tabbedView) {
        return new OSCOTSProvPane(tabbedView, abstractOpticsLineModelArray);
    }

    private class OSCOTSProvPane
    extends NodeProvPane {
        public OSCOTSProvPane(TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
            super("OSCOTSProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            this.subTabs.addTab("Parameters", (Component)OscProvPane.this.getOTSProvTab(abstractOpticsLineModelArray));
            this.subTabs.addTab("Optics Thresholds", (Component)OscProvPane.this.getOptThresholdsTab(abstractOpticsLineModelArray));
            this.add((Component)this.subTabs);
        }

        @Override
        public boolean hasSubTabs() {
            return true;
        }
    }

    private class OscmOc3ProvPane
    extends NodeProvPane {
        public OscmOc3ProvPane(TabbedView tabbedView) {
            boolean bl;
            super("OscmOc3ProvPane", tabbedView);
            this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
            int n = OscProvPane.this.model.getChassis().getChassisType();
            boolean bl2 = bl = n == 336 || n == 334;
            if (this.pci.is455() || bl) {
                this.subTabs.addTab("STM-1 Line", (Component)OscProvPane.this.getLineProvTab());
                this.subTabs.addTab("SDH Thresholds", (Component)OscProvPane.this.getOc3ThresholdsPane());
            } else {
                this.subTabs.addTab("OC3 Line", (Component)OscProvPane.this.getLineProvTab());
                this.subTabs.addTab("SONET Thresholds", (Component)OscProvPane.this.getOc3ThresholdsPane());
            }
            this.add((Component)this.subTabs);
        }

        @Override
        public boolean hasSubTabs() {
            return true;
        }
    }
}

