/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.ui.OpticalTableModel;
import cerent.util.KDebug;
import cerent.util.SDebug;

public class OscmOTSTableModel
extends OpticalTableModel {
    public static final int OSC_POWER_INDEX = 14;
    public static String[] columnNames = new String[]{"OSC Power"};
    private String[] oscPower;
    private static final SDebug db = new SDebug("OscmOTSTableModel");

    public OscmOTSTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(db, abstractOpticsLineModelArray);
        this.oscPower = new String[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.oscPower[i] = null;
        }
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount() + columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n < 14) {
            return super.getColumnName(n);
        }
        return columnNames[n - 14];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 14: {
                    return this.getOSCPower(n);
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OscmOTSTableModel: error in getValueAt" + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        if (db.on()) {
            db.println("refresh from model line: " + n);
        }
        this.resetLineCache(n);
        this.oscPower[n] = this.getOSCPowerFromUnit(n);
        super.refreshLineFromModel(n);
    }

    @Override
    protected void resetLineCache(int n) {
        super.resetLineCache(n);
        this.oscPower[n] = null;
    }

    protected String getOSCPowerFromUnit(int n) {
        return this.model[n].getOSCPowerString();
    }

    public String getOSCPower(int n) {
        return this.oscPower[n];
    }
}

