/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sPmStatRatio;
import cerent.cms.idl.Ds123Media.eStatsType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayerDsnEn;
import cerent.util.SDebug;

public class PmLayerDs3iCpbit
extends PmLayerDsnEn {
    protected int numParms;
    public static String[] parmNames;
    public static final int CVCP_P_INDEX = 0;
    public static final int ESCP_P_INDEX = 1;
    public static final int SESCP_P_INDEX = 2;
    public static final int SASCP_P_INDEX = 3;
    public static final int UASCP_P_INDEX = 4;
    public static final int NUM_OF_PARMS = 5;
    private static final SDebug db;

    public PmLayerDs3iCpbit(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n, boolean bl) {
        super(pmTableModel, ds123LineModel, n, bl, db);
        this.initParmName();
        this.numParms = parmNames.length;
    }

    public PmLayerDs3iCpbit(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n) {
        this(pmTableModel, ds123LineModel, n, true);
    }

    @Override
    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_VALID;
        sPmStatRatio sPmStatRatio2 = PM_STATS_RATIO_INVALID;
        boolean bl = false;
        if (PmLayerDs3iCpbit.db.on) {
            db.println("entering getPmValue - row= " + n + ", interval= " + n2);
        }
        switch (n) {
            case 0: {
                sPmStat2 = this.statsVal[n2].cv;
                break;
            }
            case 1: {
                sPmStat2 = this.statsVal[n2].es;
                break;
            }
            case 2: {
                sPmStat2 = this.statsVal[n2].ses;
                break;
            }
            case 3: {
                sPmStat2 = this.statsVal[n2].sas;
                break;
            }
            case 4: {
                sPmStat2 = this.statsVal[n2].uas;
                break;
            }
        }
        if (bl) {
            return new PmRendererStatRatio(sPmStatRatio2);
        }
        return new PmRendererStat(sPmStat2);
    }

    @Override
    public String layerLabel() {
        return "Cpbit";
    }

    @Override
    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.refreshPmStats(n, this.nearEnd ? eStatsType.CP_BIT_STATS : eStatsType.FE_CP_BIT_STATS);
    }

    @Override
    public String parmName(int n) {
        return parmNames[n];
    }

    @Override
    public int parmCount() {
        return parmNames.length;
    }

    private void initParmName() {
        parmNames = new String[5];
        PmLayerDs3iCpbit.parmNames[0] = "DS3 CVCP-P";
        PmLayerDs3iCpbit.parmNames[1] = "DS3 ESCP-P";
        PmLayerDs3iCpbit.parmNames[2] = "DS3 SESCP-P";
        PmLayerDs3iCpbit.parmNames[3] = "DS3 SASCP-P";
        PmLayerDs3iCpbit.parmNames[4] = "DS3 UASCP-P";
    }

    static {
        db = new SDebug("PmLayerDs3iCpbit");
    }
}

