/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sPmStatRatio;
import cerent.cms.idl.Ds123Media.eStatsType;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayerDsnEn;
import cerent.util.SDebug;

public class PmLayerDs3iLine
extends PmLayerDsnEn {
    protected int numParms;
    public static String[] parmNames;
    public static final int EB_L_INDEX = 0;
    public static final int ES_L_INDEX = 1;
    public static final int SES_L_INDEX = 2;
    public static final int LOSS_L_INDEX = 3;
    public static final int NUM_OF_PARMS = 4;
    private static final SDebug db;

    public PmLayerDs3iLine(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n) {
        super(pmTableModel, ds123LineModel, n, db);
        this.initParmName();
        this.numParms = parmNames.length;
    }

    @Override
    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        this.model.clearStats(this.nearEnd, this.intervalType);
    }

    @Override
    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_VALID;
        sPmStatRatio sPmStatRatio2 = PM_STATS_RATIO_INVALID;
        boolean bl = false;
        if (PmLayerDs3iLine.db.on) {
            db.println("entering getPmValue - row= " + n + ", interval= " + n2);
        }
        switch (n) {
            case 0: {
                sPmStat2 = this.statsVal[n2].cv;
                break;
            }
            case 1: {
                sPmStat2 = this.statsVal[n2].es;
                break;
            }
            case 3: {
                sPmStat2 = this.statsVal[n2].loss;
                break;
            }
            case 2: {
                sPmStat2 = this.statsVal[n2].ses;
                break;
            }
        }
        if (bl) {
            return new PmRendererStatRatio(sPmStatRatio2);
        }
        return new PmRendererStat(sPmStat2);
    }

    @Override
    public String layerLabel() {
        return "DS3I";
    }

    @Override
    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.refreshPmStats(n, eStatsType.LINE_STATS);
    }

    @Override
    public String parmName(int n) {
        return parmNames[n];
    }

    @Override
    public int parmCount() {
        return parmNames.length;
    }

    private void initParmName() {
        parmNames = new String[4];
        PmLayerDs3iLine.parmNames[0] = "DS3 CV-L";
        PmLayerDs3iLine.parmNames[1] = "DS3 ES-L";
        PmLayerDs3iLine.parmNames[2] = "DS3 SES-L";
        PmLayerDs3iLine.parmNames[3] = "DS3 LOSS-L";
    }

    static {
        db = new SDebug("PmLayerDs3iLine");
    }
}

