/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sPmStatRatio;
import cerent.cms.idl.SonetMedia.sPathStats;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.AnnotatedException;
import cerent.util.SDHTDMTerminology;
import cerent.util.SDebug;

public class PmLayerStm1ePath
extends PmLayer {
    public static final int CV_P_INDEX = 0;
    public static final int ES_P_INDEX = 1;
    public static final int SDH_SES_P_INDEX = 2;
    public static final int SDH_UAS_P_INDEX = 3;
    public static final int SDH_BBE_P_INDEX = 4;
    public static final int SDH_PPJC_PDET_P_INDEX = 5;
    public static final int SDH_NPJC_PDET_P_INDEX = 6;
    public static final int SDH_PPJC_PGEN_P_INDEX = 7;
    public static final int SDH_NPJC_PGEN_P_INDEX = 8;
    public static final int SDH_PJC_DIFF_P_INDEX = 9;
    public static final int SDH_PJCS_PDET_P_INDEX = 10;
    public static final int SDH_PJCS_PGEN_P_INDEX = 11;
    public static final int SDH_ESR_P_INDEX = 12;
    public static final int SDH_SESR_P_INDEX = 13;
    public static final int SDH_BBER_P_INDEX = 14;
    private static final String[] parmNames = new String[15];
    private static final int PARAM_COUNT = 15;
    protected sPathStats[] pathStatsVal;
    protected TdmHoModel model = null;
    protected TdmHoModel stsModel = null;
    protected int numParms;
    protected int numRegisters;
    private static final sPathStats _defaultPathStats;
    private static final SDebug db;

    public PmLayerStm1ePath(PmTableModel pmTableModel, TdmHoModel tdmHoModel, int n) {
        this.model = tdmHoModel;
        this.numRegisters = n;
        this.numParms = parmNames.length;
        this.pathStatsVal = new sPathStats[n];
        for (int i = 0; i < n; ++i) {
            this.pathStatsVal[i] = null;
        }
    }

    @Override
    public void clearStats() {
        try {
            this.model.clearStats(this.nearEnd, this.intervalType);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (InternalCommError internalCommError) {
            SDebug.printStackTrace((Throwable)internalCommError);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public String layerLabel() {
        String string = "VC4";
        try {
            string = Model.getTDMTerminology(this.model).getGeneralTerms(0);
        }
        catch (AnnotatedException annotatedException) {
            // empty catch block
        }
        return string;
    }

    @Override
    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.pathStatsVal[i] = null;
        }
    }

    @Override
    public String parmName(int n) {
        return parmNames[n];
    }

    @Override
    public int parmCount() {
        return parmNames.length;
    }

    @Override
    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_INVALID;
        sPmStatRatio sPmStatRatio2 = PM_STATS_RATIO_INVALID;
        boolean bl = false;
        this.refreshPmStats(n2);
        switch (n) {
            case 0: {
                sPmStat2 = this.pathStatsVal[n2].cv;
                break;
            }
            case 1: {
                sPmStat2 = this.pathStatsVal[n2].es;
                break;
            }
            case 2: {
                sPmStat2 = this.pathStatsVal[n2].ses;
                break;
            }
            case 3: {
                sPmStat2 = this.pathStatsVal[n2].uas;
                break;
            }
            case 4: {
                sPmStat2 = this.pathStatsVal[n2].bbe;
                break;
            }
            case 5: {
                sPmStat2 = this.pathStatsVal[n2].pjpIn;
                break;
            }
            case 6: {
                sPmStat2 = this.pathStatsVal[n2].pjnIn;
                break;
            }
            case 7: {
                sPmStat2 = this.pathStatsVal[n2].pjpOut;
                break;
            }
            case 8: {
                sPmStat2 = this.pathStatsVal[n2].pjnOut;
                break;
            }
            case 9: {
                sPmStat2 = this.pathStatsVal[n2].pjDiff;
                break;
            }
            case 10: {
                sPmStat2 = this.pathStatsVal[n2].pjInSec;
                break;
            }
            case 11: {
                sPmStat2 = this.pathStatsVal[n2].pjOutSec;
                break;
            }
            case 12: {
                bl = true;
                sPmStatRatio2 = this.pathStatsVal[n2].esr;
                break;
            }
            case 13: {
                bl = true;
                sPmStatRatio2 = this.pathStatsVal[n2].sesr;
                break;
            }
            case 14: {
                bl = true;
                sPmStatRatio2 = this.pathStatsVal[n2].bber;
                break;
            }
        }
        if (bl) {
            if (sPmStatRatio2.cnt == -1) {
                return null;
            }
            return new PmRendererStatRatio(sPmStatRatio2);
        }
        if (sPmStat2.cnt == -1) {
            return null;
        }
        return new PmRendererStat(sPmStat2);
    }

    @Override
    public void setModel(InterfaceModel interfaceModel) {
        this.model = (TdmHoModel)interfaceModel;
    }

    @Override
    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.pathStatsVal[n] == null || this.pathStatsVal[n] == _defaultPathStats) {
            this.pathStatsVal[n] = _defaultPathStats;
            this.pathStatsVal[n] = this.model.getStats(this.nearEnd, this.intervalType, (short)n);
        }
    }

    static {
        SDHTDMTerminology sDHTDMTerminology = SDHTDMTerminology.instance();
        PmLayerStm1ePath.parmNames[0] = sDHTDMTerminology.createPmColumnName(3, 1);
        PmLayerStm1ePath.parmNames[1] = sDHTDMTerminology.createPmColumnName(3, 2);
        PmLayerStm1ePath.parmNames[2] = sDHTDMTerminology.createPmColumnName(3, 3);
        PmLayerStm1ePath.parmNames[3] = sDHTDMTerminology.createPmColumnName(3, 9);
        PmLayerStm1ePath.parmNames[4] = sDHTDMTerminology.createPmColumnName(3, 5);
        PmLayerStm1ePath.parmNames[5] = sDHTDMTerminology.createPmColumnName(3, 10);
        PmLayerStm1ePath.parmNames[6] = sDHTDMTerminology.createPmColumnName(3, 11);
        PmLayerStm1ePath.parmNames[7] = sDHTDMTerminology.createPmColumnName(3, 12);
        PmLayerStm1ePath.parmNames[8] = sDHTDMTerminology.createPmColumnName(3, 13);
        PmLayerStm1ePath.parmNames[9] = sDHTDMTerminology.createPmColumnName(3, 28);
        PmLayerStm1ePath.parmNames[10] = sDHTDMTerminology.createPmColumnName(3, 29);
        PmLayerStm1ePath.parmNames[11] = sDHTDMTerminology.createPmColumnName(3, 30);
        PmLayerStm1ePath.parmNames[12] = sDHTDMTerminology.createPmColumnName(3, 6);
        PmLayerStm1ePath.parmNames[13] = sDHTDMTerminology.createPmColumnName(3, 7);
        PmLayerStm1ePath.parmNames[14] = sDHTDMTerminology.createPmColumnName(3, 8);
        _defaultPathStats = new sPathStats(false, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
        db = new SDebug("PmLayerStm1ePath");
    }
}

