/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppm;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AsapModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.ppm.PpmCardView;
import cerent.cms.ui.shelf.PluggableSlotView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.List;

public class PpmSlotView
extends PluggableSlotView {
    public PpmSlotView(EntityModel entityModel) {
        super(entityModel);
        this.setLayout(new GridBagLayout());
        if (db.on()) {
            db.println("PpmSlotView: " + entityModel.getEqLabel() + "\tIndex: " + entityModel.getPositionInParent() + "\tNum of children: " + entityModel.getChildren().size());
        }
    }

    @Override
    protected void addChildren() {
        if (this.model == null) {
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (this.pci.positionPortsVertically()) {
            gridBagConstraints.gridy = 1;
        } else {
            gridBagConstraints.gridx = 1;
        }
        List list = this.model.getChildren();
        if (list.size() > 0) {
            EntityModel entityModel = (EntityModel)list.get(0);
            if (entityModel instanceof PpmModel) {
                this.pluggableCardModel = (PpmModel)entityModel;
                this.add((Component)this.createPpmCard((PpmModel)this.pluggableCardModel), gridBagConstraints);
            } else if (db.on()) {
                db.println("PpmSlotView: Entity is NOT PpmModel");
            }
        } else if (this.isAsap()) {
            this.add((Component)this.getLabel(), gridBagConstraints);
        }
    }

    @Override
    protected void doActionEvent(ActionEvent actionEvent) {
        try {
            PluggableSlotModel pluggableSlotModel = (PluggableSlotModel)this.model;
            pluggableSlotModel.provisionPluggable(eEqType.PPM_1_PORT);
        }
        catch (ProvisionError provisionError) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_CARD_ADD);
        }
        catch (ResourceInUse resourceInUse) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_CARD_ADD);
        }
        catch (NotSupportedOnEquipment notSupportedOnEquipment) {
            ErrorMsg.displayDetailed((Component)this, EMC.EID_FAIL_APPLY_CHANGES, notSupportedOnEquipment.getMessage());
        }
    }

    protected PpmCardView createPpmCard(PpmModel ppmModel) {
        this.pluggableCardView = new PpmCardView(ppmModel);
        return (PpmCardView)this.pluggableCardView;
    }

    @Override
    protected String getMenuTitle() {
        return "Add PPM";
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.model == null || this.model.getModuleModel() == null) {
            return super.getPreferredSize();
        }
        int n = this.model.getModuleModel().getEqType();
        if (n == 219 || n == 253 || n == 272 || n == 273 || n == 254) {
            return new Dimension(36, 26);
        }
        if (this.isAsap()) {
            return new Dimension(61, 36);
        }
        return super.getPreferredSize();
    }

    public void addCardViewPaneToPort(AbstractCardViewPanel abstractCardViewPanel) {
        if (this.pluggableCardView == null) {
            return;
        }
        ((PpmCardView)this.pluggableCardView).addCardViewPaneToPort(abstractCardViewPanel);
    }

    protected boolean isAsap() {
        return this.model.getModuleModel() instanceof AsapModuleModel;
    }
}

