/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ransvc;

import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.ransvc.RanSvcPortGraphic;
import cerent.cms.ui.shelf.CardView;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;

public class RanSvcCardView
extends CardView {
    private static final int MAX_PER_COLUMN = 14;
    private JLabel DS1_LABEL;
    private JLabel OC3_LABEL;

    public RanSvcCardView(ModuleModel moduleModel) {
        super(moduleModel);
    }

    @Override
    protected void addPorts(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 3, 2, 2);
        if (this.DS1_LABEL == null) {
            boolean bl2 = this.model.getNodeModel().getTdmProtocolTypeObj().isSonet();
            this.DS1_LABEL = new JLabel(bl2 ? "DS1" : "E1");
            this.OC3_LABEL = new JLabel(bl2 ? "OC3" : "STM1");
        }
        this.add((Component)this.OC3_LABEL, gridBagConstraints);
        this.addPorts(this.getOc3Types(), gridBagConstraints);
        this.add((Component)this.DS1_LABEL, gridBagConstraints);
        this.addPorts(this.getDs1E1Types(), gridBagConstraints);
        this.repaint();
    }

    private int[] getOc3Types() {
        return new int[]{28};
    }

    private int[] getDs1E1Types() {
        return new int[]{34, 68};
    }

    private void addPorts(int[] nArray, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridy = 1;
        for (int i = 0; i < this.numPorts; ++i) {
            EntityModel entityModel;
            Object e = this.portModels.get(i);
            if (!(e instanceof EntityModel) || !this.isa(entityModel = (EntityModel)e, nArray)) continue;
            this.ports[i] = new RanSvcPortGraphic(this, entityModel, entityModel.getPort());
            this.add((Component)this.ports[i], gridBagConstraints);
            if (++gridBagConstraints.gridy <= 14) continue;
            gridBagConstraints.gridy = 1;
            ++gridBagConstraints.gridx;
        }
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
    }

    private boolean isa(EntityModel entityModel, int[] nArray) {
        int n = entityModel.getEqType();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }
}

