/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.rmon;

import cerent.cms.idl.EtherMedia.eMauType;
import cerent.cms.idl.Rmon.sTimedStatsPair;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchStatsSeries;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.rmon.RmonPmCellRenderer;
import cerent.cms.ui.rmon.RmonPmUtilPane;
import cerent.util.SDebug;
import cerent.util.gui.IFixedColumnsTableModel;
import cerent.util.gui.TransmitReceive;
import javax.swing.table.AbstractTableModel;

public class RmonPmUtilTableModel
extends AbstractTableModel
implements IFixedColumnsTableModel {
    protected IRmonModel[] rmonModels;
    protected ModuleModel eqpmtModel;
    private int numLines;
    private boolean[] refresh;
    private int nCols;
    private sTimedStatsPair[][] txRxTimedStats;
    private RmonPmUtilPane parent;
    private String lastIntervalTimeStamp;
    private int fixedColumns;
    private EventUtilities eventUtilities;
    private Attribute[] defaultMauType = null;
    private static final String PREFIX = "ETHER.";
    private static final String PREFIX100 = "ETHER100.";
    private static final String PREFIX1000 = "ETHER1000.";
    private static final SDebug db = new SDebug("RmonPmUtilTableModel");

    public RmonPmUtilTableModel(RmonPmUtilPane rmonPmUtilPane, ModuleModel moduleModel, IRmonModel[] iRmonModelArray) {
        this.eqpmtModel = moduleModel;
        this.rmonModels = iRmonModelArray;
        this.parent = rmonPmUtilPane;
        this.numLines = iRmonModelArray == null ? 0 : iRmonModelArray.length;
        this.fixedColumns = moduleModel.getEqType() == 14 || moduleModel.getEqType() == 15 ? 2 : 1;
        this.refresh = new boolean[this.numLines];
        this.nCols = 0;
        this.lastIntervalTimeStamp = "";
        this.eventUtilities = EventUtilities.getInstance(moduleModel.getNodeModelDelegate());
        this.defaultMauType = new Attribute[this.numLines];
    }

    public void refreshMyLines(IRmonModel[] iRmonModelArray) {
        this.rmonModels = iRmonModelArray;
        this.numLines = iRmonModelArray.length;
        this.refresh = new boolean[this.numLines];
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            if (n2 < this.fixedColumns) {
                if (n2 == 0) {
                    return RmonPmCellRenderer.getPortName(this.rmonModels[n]);
                }
                if (n2 == 1) {
                    return this.getDefaultMauTypeFor(n);
                }
            } else if (this.refresh[n] && n2 < this.txRxTimedStats[n].length + this.fixedColumns) {
                return new TransmitReceive(this.txRxTimedStats[n][n2 - this.fixedColumns]);
            }
            return "";
        }
        catch (Exception exception) {
            db.println("Caught exception in getValueAt");
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private Attribute getDefaultMauTypeFor(int n) {
        block4: {
            try {
                this.defaultMauType[n] = this.getAttributeFor(eMauType.class.getName(), this.rmonModels[n].getModeType().value(), this.eqpmtModel);
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    db.println("NoSuchInterface Exception ");
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!db.on()) break block4;
                db.println("WrongInterfaceType Exception ");
            }
        }
        return this.defaultMauType[n];
    }

    private Attribute getAttributeFor(String string, int n, ModuleModel moduleModel) {
        String string2 = null;
        try {
            switch (moduleModel.getEqType()) {
                case 14: {
                    string2 = PREFIX100;
                    break;
                }
                case 15: {
                    string2 = PREFIX1000;
                    break;
                }
                default: {
                    string2 = PREFIX;
                    break;
                }
            }
        }
        catch (Exception exception) {
            string2 = PREFIX;
        }
        return ElementDefaults.getAttributeMap(moduleModel).getAttributeForVal(string2 + string, n);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.fireTableRowsUpdated(n, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError, NoSuchStatsSeries {
        int n;
        for (n = 0; n < this.rmonModels.length; ++n) {
            this.refresh[n] = false;
        }
        n = 0;
        if (this.nCols != ElementDefaults.getMaxBuckets(s)) {
            this.nCols = ElementDefaults.getMaxBuckets(s);
            n = 1;
        }
        this.txRxTimedStats = new sTimedStatsPair[this.rmonModels.length][];
        this.lastIntervalTimeStamp = "";
        try {
            for (int i = 0; i < this.rmonModels.length; ++i) {
                try {
                    this.txRxTimedStats[i] = this.rmonModels[i].getTxRxUtilizationSeries(s);
                    this.refresh[i] = true;
                    if (this.lastIntervalTimeStamp.length() != 0 || this.txRxTimedStats[i].length <= 0) continue;
                    this.lastIntervalTimeStamp = this.eventUtilities.convertSecondsToLongDateFormat(this.txRxTimedStats[i][0].txStat.timeStamp);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    // empty catch block
                }
            }
        }
        finally {
            if (n != 0) {
                this.fireTableStructureChanged();
                this.parent.fixedUpColumn();
            } else {
                this.fireTableDataChanged();
            }
        }
    }

    public String getLastIntervalTimeStamp() {
        return this.lastIntervalTimeStamp;
    }

    private sTimedStatsPair[] getTxRxLineUtilSeries(short s, int n) throws NoSuchStatsSeries, NoSuchInterface, WrongInterfaceType, InternalCommError {
        return this.rmonModels[n].getTxRxUtilizationSeries(s);
    }

    public Class getColumnClass(int n) {
        if (n < this.getFixedColumnCount()) {
            return String.class;
        }
        return TransmitReceive.class;
    }

    @Override
    public int getColumnCount() {
        return this.getFixedColumnCount() + this.nCols;
    }

    @Override
    public String getColumnName(int n) {
        if (n < this.fixedColumns) {
            return n == 0 ? "Port" : "Mode";
        }
        return ElementDefaults.PREV_60_COLUMN_NAMES[n - this.fixedColumns];
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    public int getFixedColumnCount() {
        return this.fixedColumns;
    }
}

