/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.rmon;

import cerent.cms.idl.Rmon.sAlarmAdminInfo;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.DuplicateAlarm;
import cerent.cms.model.InvalidAlarmInterval;
import cerent.cms.model.InvalidAlarmThresholds;
import cerent.cms.model.InvalidAlarmType;
import cerent.cms.model.InvalidSampleType;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoMoreAlarms;
import cerent.cms.model.NoSuchAlarm;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchStatsId;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.RmonThresholdManager;
import cerent.cms.model.RmonThresholdModel;
import cerent.cms.model.UnsupportedAlarm;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.rmon.RmonThresholdColumnRenderer;
import cerent.cms.ui.rmon.RmonThresholdTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

public class RmonThresholdDataSource
extends AbstractRowDataSource
implements Observer {
    private RmonThresholdModel[] rmonThresholdList = new RmonThresholdModel[0];
    private int filterShelfNumber = -1;
    private int filterSlotNumber = -1;
    private boolean isFiltered = true;
    private RmonThresholdManager mgr;
    private ModuleModel card;
    private static final SDebug db = new SDebug("RmonThresholdDataSource");

    public RmonThresholdDataSource(ModuleModel moduleModel) {
        this.card = moduleModel;
        this.filterSlotNumber = moduleModel.getSlot();
        this.filterShelfNumber = moduleModel.getShelfId();
        this.mgr = RmonThresholdManager.getInstance((NodeModelDelegate)moduleModel.getNodeModel());
        this.mgr.addObserver(this);
    }

    public void createThreshold(sAlarmAdminInfo sAlarmAdminInfo2) throws AnnotatedException, NoSuchStatsId, DuplicateAlarm {
        try {
            boolean bl = false;
            Throwable throwable = null;
            try {
                this.mgr.createThreshold(sAlarmAdminInfo2);
            }
            catch (NoMoreAlarms noMoreAlarms) {
                throwable = noMoreAlarms;
            }
            catch (InvalidAlarmThresholds invalidAlarmThresholds) {
                throwable = invalidAlarmThresholds;
            }
            catch (InvalidAlarmType invalidAlarmType) {
                throwable = invalidAlarmType;
            }
            catch (InvalidAlarmInterval invalidAlarmInterval) {
                throwable = invalidAlarmInterval;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                throwable = wrongInterfaceType;
            }
            catch (InvalidSampleType invalidSampleType) {
                throwable = invalidSampleType;
            }
            catch (UnsupportedAlarm unsupportedAlarm) {
                throwable = unsupportedAlarm;
            }
            catch (NoSuchInterface noSuchInterface) {
                throwable = noSuchInterface;
            }
            if (throwable != null) {
                throw new AnnotatedException("The RMON threshold could not be created.", (Exception)throwable);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.finest("Exception in createThreshold() " + (Object)((Object)abstractCmsIOException));
        }
    }

    public void deleteThreshold(RmonThresholdTableModel rmonThresholdTableModel, int[] nArray) {
        RmonThresholdModel rmonThresholdModel;
        if (nArray.length == 0) {
            return;
        }
        ArrayList<RmonThresholdModel> arrayList = new ArrayList<RmonThresholdModel>();
        for (int i = 0; i < nArray.length; ++i) {
            rmonThresholdModel = (RmonThresholdModel)rmonThresholdTableModel.getValueAt(nArray[i], 0);
            arrayList.add(rmonThresholdModel);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                rmonThresholdModel = (RmonThresholdModel)iterator.next();
                this.mgr.deleteThreshold(rmonThresholdModel.getThresholdIndex());
            }
            catch (NoSuchAlarm noSuchAlarm) {
                if (db.on()) {
                    db.println("deleteThreshold failed: " + (Object)((Object)noSuchAlarm));
                }
                SDebug.printStackTrace((Throwable)noSuchAlarm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRmonThresholdList() {
        try {
            this.rmonThresholdList = this.mgr.getRmonThresholdList();
            ArrayList<RmonThresholdModel> arrayList = new ArrayList<RmonThresholdModel>();
            for (int i = 0; i < this.rmonThresholdList.length; ++i) {
                RmonThresholdModel rmonThresholdModel = this.rmonThresholdList[i];
                if (!this.validSlotPort(rmonThresholdModel) || this.isFiltered && !this.passesFilter(rmonThresholdModel)) continue;
                rmonThresholdModel.addObserver(this);
                arrayList.add(rmonThresholdModel);
            }
            this.rmonThresholdList = arrayList.toArray(new RmonThresholdModel[0]);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.finest("Exception in getRmonThresholdList() " + (Object)((Object)abstractCmsIOException));
        }
        finally {
            this.fireDataSourceChanged();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        Integer n = (Integer)object;
        if (object.equals(ModelUpdateType.CHANGED)) {
            if (RmonThresholdDataSource.db.on) {
                db.println("Receiving ModelUpdateType.CHANGE");
            }
        } else if (object.equals(ModelUpdateType.ADDED)) {
            if (RmonThresholdDataSource.db.on) {
                db.println("Receiving ModelUpdateType.ADDED");
            }
        } else if (object.equals(ModelUpdateType.DELETED)) {
            if (observable instanceof RmonThresholdManager) {
                return;
            }
            if (RmonThresholdDataSource.db.on) {
                db.println("Receiving ModelUpdateType.DELETED");
            }
        }
        this.getRmonThresholdList();
    }

    public int getRowCount() {
        return this.rmonThresholdList.length;
    }

    public Object getObjectAtRow(int n) {
        return this.rmonThresholdList[n];
    }

    public Collection getAllObjects() {
        return Arrays.asList(this.rmonThresholdList);
    }

    public void dispose() {
        if (RmonThresholdDataSource.db.on) {
            db.println("Disposing RmonThresholdDataSource");
        }
        try {
            this.mgr.deleteObserver(this);
            for (int i = 0; i < this.rmonThresholdList.length; ++i) {
                this.rmonThresholdList[i].deleteObserver(this);
            }
        }
        catch (Exception exception) {
            db.finest("Exception in dispose() " + exception);
        }
    }

    private boolean validSlotPort(RmonThresholdModel rmonThresholdModel) {
        int n;
        int n2;
        block2: {
            n2 = -1;
            n = -1;
            try {
                NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)rmonThresholdModel.getNodeModel();
                int n3 = rmonThresholdModel.getAlarmAdminInfo().ifIndex;
                n2 = RmonThresholdColumnRenderer.getSlotInt(nodeModelDelegate, n3);
                n = RmonThresholdColumnRenderer.getPortInt(nodeModelDelegate, n3);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("validSlotPort encountered exception for " + rmonThresholdModel);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return n2 != -1 && n != -1;
    }

    private boolean passesFilter(RmonThresholdModel rmonThresholdModel) {
        boolean bl = false;
        if (this.isFiltered) {
            int n;
            int n2;
            block5: {
                n2 = -1;
                n = -1;
                try {
                    NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)rmonThresholdModel.getNodeModel();
                    int n3 = rmonThresholdModel.getAlarmAdminInfo().ifIndex;
                    n2 = RmonThresholdColumnRenderer.getSlotInt(nodeModelDelegate, n3);
                    n = RmonThresholdColumnRenderer.getShelfInt(nodeModelDelegate, n3);
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("passesFilter encountered exception for " + rmonThresholdModel);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (n2 == this.filterSlotNumber && n == this.filterShelfNumber) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void setFiltered(boolean bl) {
        this.isFiltered = bl;
        for (int i = 0; i < this.rmonThresholdList.length; ++i) {
            this.rmonThresholdList[i].deleteObserver(this);
        }
        this.getRmonThresholdList();
    }
}

