/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.GfpPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LexPortModel;
import cerent.cms.model.Model;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.ppm.PpmSlotView;
import cerent.cms.ui.shelf.DwdmCardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.ObservableManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.List;
import java.util.Observable;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ADM10GCardView
extends DwdmCardView {
    private DwdmModuleModel moduleADM;
    private static final int MAX_NUM_GFP_ADM = 10;

    public ADM10GCardView(EntityModel entityModel, AbstractCardViewPanel abstractCardViewPanel) {
        super(entityModel, abstractCardViewPanel);
        for (int i = 0; i < this.ppmSlotViews.length; ++i) {
            this.ppmSlotViews[i].addCardViewPaneToPort(abstractCardViewPanel);
        }
    }

    @Override
    protected void addPorts(boolean bl) {
        this.moduleADM = (DwdmModuleModel)this.model;
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = new Insets(2, 3, 2, 2);
        this.ports = new GenericPortGraphic[this.numPorts + 10];
        this.add((Component)new JLabel("FAC"), this.gbc);
        this.addADMPorts();
        this.invalidate();
    }

    private void addFiller(boolean bl) {
        JPanel jPanel = new JPanel();
        if (bl) {
            jPanel.setPreferredSize(new Dimension(10, 0));
            ++this.gbc.gridx;
            this.gbc.gridy = 0;
            this.add((Component)jPanel, this.gbc);
            ++this.gbc.gridx;
        } else {
            jPanel.setPreferredSize(new Dimension(0, 10));
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.add((Component)jPanel, this.gbc);
            ++this.gbc.gridy;
        }
    }

    private void addADMPorts() {
        PluggableSlotModel[] pluggableSlotModelArray = this.moduleADM.getPpmSlots();
        this.ppmSlotViews = new PpmSlotView[pluggableSlotModelArray.length];
        int n = 0;
        for (n = 0; n < 12; ++n) {
            if (n == 6) {
                this.addFiller(false);
            }
            this.ppmSlotViews[n] = new PpmSlotView(pluggableSlotModelArray[n]);
            ++this.gbc.gridy;
            this.add((Component)this.ppmSlotViews[n], this.gbc);
        }
        this.addFiller(true);
        this.add((Component)new JLabel("GFP/LEX"), this.gbc);
        this.updateADMGfpPorts();
        this.addFiller(true);
        this.gbc.gridy = 3;
        this.add((Component)new JLabel("FAC"), this.gbc);
        for (n = 12; n < 16; ++n) {
            this.ppmSlotViews[n] = new PpmSlotView(pluggableSlotModelArray[n]);
            ++this.gbc.gridy;
            this.add((Component)this.ppmSlotViews[n], this.gbc);
        }
        this.gbc.gridx = 4;
        this.gbc.gridy = 0;
        for (n = 16; n < 19; ++n) {
            this.addAdmTrkPorts(n, pluggableSlotModelArray);
            if (n != 16) continue;
            this.gbc.gridy += 8;
        }
    }

    private void updateADMGfpPorts() {
        IPortModel[] iPortModelArray = this.moduleADM.getAllPosPortModels();
        if (db.on()) {
            db.println("updateGfpPorts: length= " + iPortModelArray.length);
        }
        for (int i = 0; i < iPortModelArray.length; ++i) {
            int n;
            PortModel portModel;
            int n2 = this.portModels.indexOf(iPortModelArray[i]);
            if (n2 != -1) continue;
            if (iPortModelArray[i] instanceof LexPortModel) {
                portModel = (LexPortModel)iPortModelArray[i];
                n = ((LexPortModel)portModel).getGraphPortPosition();
            } else {
                portModel = (GfpPortModel)iPortModelArray[i];
                n = ((GfpPortModel)portModel).getGraphPortPosition();
            }
            if (db.on()) {
                db.println("updateGfpPorts Add Gfp port= " + n);
            }
            if (this.pci.positionPortsVertically()) {
                this.gbc.gridy = n > 6 ? n + 2 : n;
            } else {
                this.gbc.gridx = n;
            }
            this.portModels.add(iPortModelArray[i]);
            this.ports[this.numPorts] = new GenericPortGraphic(this, portModel, n);
            this.add((Component)this.ports[this.numPorts], this.gbc);
            ++this.numPorts;
        }
    }

    @Override
    protected void registerForLocalUpdates() {
        Model model;
        int n;
        Object object;
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager(this, false);
        }
        this._obsMgr.reset();
        if (this.moduleADM == null) {
            this.moduleADM = (DwdmModuleModel)this.model;
        }
        this._obsMgr.addObservable((Observable)((Object)this.moduleADM));
        if (this.moduleADM.supportsGfpPort()) {
            IPortModel[] iPortModelArray = this.moduleADM.getAllPosPortModels();
            for (int i = 0; i < iPortModelArray.length; ++i) {
                object = iPortModelArray[i] instanceof LexPortModel ? (LexPortModel)iPortModelArray[i] : (GfpPortModel)iPortModelArray[i];
                this._obsMgr.addObservable((Observable)object);
            }
        }
        object = this.moduleADM.getPpmSlots();
        for (n = 0; n < ((PluggableSlotModel[])object).length; ++n) {
            this._obsMgr.addObservable((Observable)((Object)object[n]));
        }
        for (n = 0; n < ((PluggableSlotModel[])object).length; ++n) {
            List list = object[n].getChildren();
            for (Object object2 : list) {
                if (!(object2 instanceof PpmModel)) continue;
                this._obsMgr.addObservable((Observable)object2);
                model = (EntityModel)((EntityModel)object2).getParent();
                this._obsMgr.addObservable((Observable)((Object)model));
            }
        }
        List list = null;
        list = this.moduleADM.getDescendantsOfType(eClass.E_SENSOR);
        list.addAll(this.moduleADM.getDescendantsOfType(eClass.SENSOR_OUTPUT));
        list.add(this.moduleADM.getDescendantsOfClassType(7));
        for (Object object3 : list) {
            Object object2;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                model = (Model)object2.next();
                this._obsMgr.addObservable((Observable)((Object)model));
            }
        }
        this._obsMgr.setActive(true);
        this._obsMgr.setPassing(true);
    }

    private void addAdmTrkPorts(int n, PluggableSlotModel[] pluggableSlotModelArray) {
        int n2 = n + 1;
        if (n2 != 19) {
            Object object;
            DwdmPortModel[] dwdmPortModelArray = this.moduleADM.getDwdmTrkPorts();
            boolean bl = false;
            for (int i = 0; i < dwdmPortModelArray.length; ++i) {
                int[] nArray = dwdmPortModelArray[i].getPortNum();
                if (nArray[0] != n2) continue;
                bl = true;
                break;
            }
            DwdmPortModel[] dwdmPortModelArray2 = this.moduleADM.getDwdmIlkPorts();
            boolean bl2 = false;
            if (dwdmPortModelArray2 != null) {
                for (int i = 0; i < dwdmPortModelArray2.length; ++i) {
                    object = dwdmPortModelArray2[i].getPortNum();
                    if (object[0] != n2) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl) {
                this.add((Component)new JLabel("TRK"), this.gbc);
            } else if (bl2) {
                this.add((Component)new JLabel("ILK"), this.gbc);
            } else {
                this.gbc.insets = new Insets(1, 2, 1, 1);
                JLabel jLabel = new JLabel("TRK/ILK");
                object = jLabel.getFont();
                jLabel.setFont(object.deriveFont(object.getSize2D() - 3.0f));
                this.add((Component)jLabel, this.gbc);
                this.gbc.insets = new Insets(2, 3, 2, 2);
            }
            ++this.gbc.gridy;
            this.ppmSlotViews[n] = new PpmSlotView(pluggableSlotModelArray[n]);
            this.add((Component)this.ppmSlotViews[n], this.gbc);
        } else {
            ++this.gbc.gridy;
            this.gbc.gridy += 2;
            this.add((Component)new JLabel("TRK"), this.gbc);
            ++this.gbc.gridy;
            this.ppmSlotViews[n] = new PpmSlotView(pluggableSlotModelArray[n]);
            this.add((Component)this.ppmSlotViews[n], this.gbc);
        }
    }
}

