/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EleNodeShelfModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractSppTimingProvPane;
import cerent.cms.ui.shelf.CFMProfilesTabbedProvPane;
import cerent.cms.ui.shelf.SecurityPane;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.cms.ui.shelf.SppCommChannelsPane;
import cerent.cms.ui.shelf.SppDefaultsEditorPane;
import cerent.cms.ui.shelf.SppGeneralPane;
import cerent.cms.ui.shelf.SppNetworkPane;
import cerent.cms.ui.shelf.SppOsiPane;
import cerent.cms.ui.shelf.SppProtectionPane;
import cerent.cms.ui.shelf.SppProvAlarmsPane;
import cerent.cms.ui.shelf.SppSnmpPane;
import cerent.cms.ui.shelf.SppXcPane;
import cerent.cms.ui.shelf.SvlanTabbedProvPane;
import cerent.cms.ui.tnc.ECUMSPortsPane;
import cerent.util.AnnotatedException;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractShelfProvPane
extends NodeProvPane
implements ITabName {
    public String RING_TAB;
    public static final SDebug db = new SDebug((KDebug)ShelfTabbedView.db, "ShelfProvPane");
    private IGuestPaneFactory gpf;
    private HashMap provTabMap = new HashMap();

    public AbstractShelfProvPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        super(string, tabbedView);
        this.gpf = iGuestPaneFactory;
        this.RING_TAB = "BLSR/MS-SPRing";
        try {
            this.RING_TAB = Model.getTDMTerminology((IModel)this.getUiModel().getNodeModel()).getRingTerms(1);
        }
        catch (AnnotatedException annotatedException) {
            // empty catch block
        }
        this.init(tabbedView);
    }

    protected final void init(TabbedView tabbedView) {
        Component component;
        int n;
        this.initPositions();
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        EleNodeShelfModel eleNodeShelfModel = (EleNodeShelfModel)this.getUiModel();
        if (eleNodeShelfModel instanceof IChassisModel) {
            this.newTab("General", (Component)this.getGeneralPane(this.subTabs));
            if (!eleNodeShelfModel.isMultishelf()) {
                this.newTab("Network", (Component)((Object)new SppNetworkPane("Network", this.subTabs, this.gpf)));
                this.newTab("OSI", (Component)((Object)new SppOsiPane("OSI", this.subTabs)));
                this.newTab("Security", (Component)((Object)new SecurityPane("Security", this.subTabs)));
                this.newTab("SNMP", (Component)((Object)new SppSnmpPane("SNMP", this.subTabs)));
                this.newTab("Comm Channels", (Component)((Object)new SppCommChannelsPane("Comm Channels", this.subTabs, this.gpf)));
                this.newTab("Defaults", (Component)((Object)new SppDefaultsEditorPane("Defaults", this.subTabs)));
            }
            this.newTab("Protection", (Component)((Object)new SppProtectionPane("Protection", this.subTabs)));
            this.newTab("Timing", (Component)((Object)this.getSppTimingPane("Timing", this.subTabs)));
            this.newTab("Alarm Profiles", (Component)this.getProvAlarmingPane(this.subTabs));
            if (this.pci.isXcEnabled(eleNodeShelfModel.getNodeModel())) {
                this.newTab("Cross-Connect", (Component)((Object)new SppXcPane("Cross-Connect", this.subTabs)));
            }
        } else {
            this.newTab("General", (Component)this.getGeneralPane(this.subTabs));
            this.newTab("Network", (Component)((Object)new SppNetworkPane("Network", this.subTabs, this.gpf)));
            this.newTab("OSI", (Component)((Object)new SppOsiPane("OSI", this.subTabs)));
            this.newTab("Protection", (Component)((Object)new SppProtectionPane("Protection", this.subTabs)));
            this.newTab("Security", (Component)((Object)new SecurityPane("Security", this.subTabs)));
            this.newTab("SNMP", (Component)((Object)new SppSnmpPane("SNMP", this.subTabs)));
            this.newTab("Comm Channels", (Component)((Object)new SppCommChannelsPane("Comm Channels", this.subTabs, this.gpf)));
            this.newTab("Alarm Profiles", (Component)this.getMSProvAlarmingPane(this.subTabs));
            this.newTab("Defaults", (Component)((Object)new SppDefaultsEditorPane("Defaults", this.subTabs)));
        }
        this.localInit();
        if (db.on()) {
            db.println("Provisioning Subtabs:");
            for (n = 0; n < this.provTabMap.size(); ++n) {
                component = (Component)this.provTabMap.get(new Integer(n));
                db.println(n + " -> " + component);
            }
        }
        for (n = 0; n < this.provTabMap.size(); ++n) {
            component = (Component)this.provTabMap.get(new Integer(n));
            if (component != null) {
                this.subTabs.add(component, n);
                continue;
            }
            db.severe("ERROR: no component for index " + n);
        }
        this.provTabMap.clear();
        this.provTabMap = null;
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    protected abstract void localInit();

    protected Pane getGeneralPane(TabbedView tabbedView) {
        return new SppGeneralPane("General", this.subTabs);
    }

    private Pane getProvAlarmingPane(TabbedView tabbedView) {
        return new AbstractSubTabbedPane("Alarm Profiles", tabbedView){

            @Override
            public void createSubTabs() {
                IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
                this.subTabs.addTab("Alarm Behavior", (Component)((Object)new SppProvAlarmsPane("Alarm Behavior", this.subTabs, iChassisModel)));
                this.subTabs.addTab("Alarm Profile Editor", (Component)this.uiToolkit.getGuestPane(11, this.subTabs));
                if (iChassisModel.isM6Chassis()) {
                    this.subTabs.add("ECU Multishelf Ports Alarm Suppression", (Component)((Object)new ECUMSPortsPane("ECU Multishelf Ports Alarm Suppression", this.subTabs)));
                }
            }
        };
    }

    private Pane getMSProvAlarmingPane(TabbedView tabbedView) {
        return new AbstractSubTabbedPane("Alarm Profiles", tabbedView){

            @Override
            public void createSubTabs() {
                IChassisModel iChassisModel = ((NodeModelDelegate)this.getUiModel()).getNcChassis();
                this.subTabs.addTab("Alarm Behavior", (Component)((Object)new SppProvAlarmsPane("Alarm Behavior", this.subTabs, iChassisModel, (IChassisModel[])((NodeModelDelegate)this.getUiModel()).getChassisModels())));
                this.subTabs.addTab("Alarm Profile Editor", (Component)this.uiToolkit.getGuestPane(11, this.subTabs));
            }
        };
    }

    protected SvlanTabbedProvPane getSvlanPane(String string, TabbedView tabbedView) {
        return new SvlanTabbedProvPane(string, tabbedView);
    }

    protected CFMProfilesTabbedProvPane getCFMProfilesPane(String string, TabbedView tabbedView) {
        return new CFMProfilesTabbedProvPane(string, tabbedView);
    }

    protected abstract AbstractSppTimingProvPane getSppTimingPane(String var1, TabbedView var2);

    private Integer getTabPos(String string) {
        Map map = this.getTabMap();
        if (map.containsKey(string)) {
            return (Integer)map.get(string);
        }
        db.severe("ERROR: no entry in tab pos map for " + string);
        return new Integer(-1);
    }

    protected abstract Map getTabMap();

    protected abstract void initPositions();

    @Override
    public boolean hasSubTabs() {
        return true;
    }

    protected void newTab(String string, Component component) {
        if (db.on()) {
            db.fine("newTab(" + string + ", " + component + ") -> " + this.getTabPos(string));
        }
        this.provTabMap.put(this.getTabPos(string), component);
    }

    public EnvAlarmModel[] getAlarmInput() {
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        List list = ((EntityModel)((Object)iChassisModel)).getDescendantsOfType(eEqType.ENVIRONMENT_ALARM);
        return list.toArray(new EnvAlarmModel[0]);
    }
}

