/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eBitsFacility;
import cerent.cms.idl.Synchronization.eTimingMode;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.idl.Synchronization.xSyncProvError;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractBitsProvPane;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractSppTimingBitsPane
extends NodeProvPane
implements ActionListener {
    protected static final int BITS_IN = 0;
    protected static final int BITS_OUT = 1;
    public static final int BITS_1 = 0;
    public static final int BITS_2 = 1;
    protected SynchronizationModel syncModel;
    protected AbstractBitsProvPane bits1;
    protected AbstractBitsProvPane bits2;
    protected JComboBox facilityIn;
    protected JComboBox facilityOut;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "AbstractSppTimingBitsPane");

    public AbstractSppTimingBitsPane(String string, TabbedView tabbedView, SynchronizationModel synchronizationModel) {
        super(string, tabbedView);
        this.syncModel = synchronizationModel;
        this.init();
    }

    public abstract AbstractBitsProvPane getBitsProvPane(String var1, TabbedView var2, AbstractSppTimingBitsPane var3, eBits var4);

    protected abstract JPanel createBitsInTimingBox();

    protected abstract JPanel createBitsOutTimingBox();

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public abstract eBitsFacility getFacilityTypeSelection(int var1);

    public abstract int getFacilityTypeIndex(eBitsFacility var1);

    public abstract boolean isBits64K(int var1);

    public abstract boolean isBits2M(int var1);

    public abstract boolean isBitsT1(int var1);

    public abstract boolean isBitsE1(int var1);

    protected JPanel createFacilityType(JComboBox jComboBox) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 3));
        jPanel.add(new JLabel("Facility Type: "));
        jPanel.add(jComboBox);
        return jPanel;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("enter ASSTP.applyChangesToModel");
        }
        try {
            this.bits1.applyChangesToModel();
            if (this.pci.supportsBits2()) {
                this.bits2.applyChangesToModel();
            }
        }
        catch (xSyncProvError xSyncProvError2) {
            this.displayErrorDialog();
        }
        if (db.on()) {
            db.println("leave applyChangesToModel");
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        block5: {
            if (db.on()) {
                db.println("enter STBFP.refreshFromModel");
            }
            try {
                this.refreshBitsFacilities();
                this.bits1.refreshFromModel();
                if (this.pci.supportsBits2()) {
                    this.bits2.refreshFromModel();
                }
            }
            catch (CmsCommFailException cmsCommFailException) {
                if (!db.on()) break block5;
                db.println("CommFailure refreshing pane: " + (Object)((Object)cmsCommFailException));
                SDebug.printStackTrace((Throwable)((Object)cmsCommFailException));
            }
        }
        if (db.on()) {
            db.println("leave STBFP.refreshFromModel");
        }
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.bits1 == null && this.bits2 == null) {
            this.init();
        }
        if (this.syncModel != null) {
            this.syncModel.addObserver((Observer)((Object)this));
        }
        super.enteringPage();
    }

    @Override
    public void leavingPage() throws Exception {
        super.leavingPage();
        if (this.syncModel != null) {
            this.syncModel.deleteObserver((Observer)((Object)this));
        }
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.bits1 = this.getBitsProvPane(null, this.parentTV, this, eBits.BITS_1);
        this.bits2 = this.getBitsProvPane(null, this.parentTV, this, eBits.BITS_2);
        JPanel jPanel = AbstractSppTimingBitsPane.createVerticalPanel(null);
        jPanel.add(this.createBitsInTimingBox());
        jPanel.add(this.createBitsOutTimingBox());
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.add((Component)uScrollPane);
        if (db.on()) {
            db.println("init: finish");
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: start");
        }
        this.requestRefresh(this, null);
    }

    public int getBitsInFacilityType() {
        return this.facilityIn.getSelectedIndex();
    }

    public int getBitsOutFacilityType() {
        return this.facilityOut.getSelectedIndex();
    }

    protected void refreshBitsFacilities() throws Exception {
        if (db.on()) {
            db.println("refreshBitsFacilities");
        }
        sBitsConfig sBitsConfig2 = this.syncModel.getBitsConfig(eBits.BITS_1);
        this.facilityIn.setSelectedIndex(this.getFacilityTypeIndex(sBitsConfig2.facilityType));
        this.facilityOut.setSelectedIndex(this.getFacilityTypeIndex(sBitsConfig2.facilityTypeBitsOut));
    }

    public boolean isLineMode() {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = this.syncModel.getConfig().timingMode == eTimingMode.LINE_TIME;
            }
            catch (NoSuchEquipment noSuchEquipment) {
                db.println("Caught unexpected exception in isLineMode()");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
        }
        return bl;
    }

    public boolean supports64KTiming() {
        boolean bl = false;
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (iChassisModel.is454Chassis()) {
            if (iChassisModel.hasActiveTCC2P()) {
                EntityTableModel entityTableModel = iChassisModel.getEntityTableModel();
                if (entityTableModel != null && entityTableModel.hasStandbyControllerCard(iChassisModel.getShelfId(), eEqType.TCC_CARD)) {
                    if (iChassisModel.hasStandbyTCC2P()) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
        } else if (iChassisModel.isUTSChassis()) {
            List list = iChassisModel.getMfgEntities();
            for (EntityModel entityModel : list) {
                if (entityModel.getEqType() != 330 && entityModel.getEqType() != 331) continue;
                bl = true;
            }
        } else if (this.pci.is600SDH()) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void destroy() {
        if (this.syncModel != null) {
            this.syncModel.deleteObserver((Observer)((Object)this));
            this.syncModel = null;
        }
        super.destroy();
    }

    public void displayErrorDialog() {
        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CANNOT_CHANGE_TIMING_WITH_FORCE);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.SppTimingBitsPane;
    }
}

