/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.AiciModuleModel;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OhTerms;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.AiciPortGraphic;
import cerent.cms.ui.shelf.CardView;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.JLabel;

public class AiciCardView
extends CardView {
    protected static final int EXT_PORTS = 54;
    private static final int ANSI_PORTS = 22;
    private static final int ETSI_PORTS = 26;
    private static final int OH_PORTS = 6;
    private static final int OH_PORTS_PER_ROW = 2;
    private static final int IN_PORTS_PER_ROW = 8;
    private static final int OUT_PORTS_PER_ROW = 4;
    private static final int PORT_STARTED = 9;
    private static final int PORT_NOT_USED = 2;
    private static final String[] LABELS;
    private static final String[] LABELS_EXT;
    private static JLabel[] normalLabels;
    private static JLabel[] extLabels;
    private OhTerms ohTerms;
    private JLabel[] labels;
    private GridBagConstraints gbc;
    private static final SDebug db;

    public AiciCardView(ModuleModel moduleModel) {
        super(moduleModel);
        this.ohTerms = moduleModel.getChassis().getOhConnectionModels().getOhTerms();
        this.ohTerms.addObserver(this);
    }

    @Override
    protected Dimension getCardSize() {
        return new Dimension(500, 500);
    }

    @Override
    protected void addPorts(boolean bl) {
        this.gbc = new GridBagConstraints();
        Insets insets = new Insets(2, 3, 2, 2);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = insets;
        this.gbc.fill = 2;
        this.updateLabels();
        this.updatePorts();
    }

    private synchronized void updateLabels() {
        this.labels = this.numPorts == 54 ? extLabels : normalLabels;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        for (int i = 0; i < this.labels.length; ++i) {
            this.add((Component)this.labels[i], this.gbc);
            ++this.gbc.gridy;
        }
    }

    private synchronized void updatePorts() {
        for (EntityModel entityModel : this.portModels) {
            int n = this.getIndex(entityModel.getPort());
            try {
                this.ports[n] = new AiciPortGraphic(this, entityModel, entityModel.getPort());
                this.gbc.gridx = this.getGridX(n);
                this.gbc.gridy = this.getGridY(n);
                this.add((Component)this.ports[n], this.gbc);
                if (!db.on()) continue;
                db.println("updatePorts: index=" + n);
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!db.on()) continue;
                db.println("updatePorts: " + (Object)((Object)cmsObjectNotExistException));
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof AiciModuleModel) {
            if (db.on()) {
                db.println("Notified by AiciModuleModel");
            }
            this.refreshCard();
        } else if (observable instanceof OhTerms) {
            if (db.on()) {
                db.println("Notified by OhTerms");
            }
            for (int i = 0; i < 6; ++i) {
                ((AiciPortGraphic)this.ports[i]).showState(true);
            }
            this.updateAlarm();
        } else {
            super.update(observable, object);
        }
    }

    @Override
    public void dispose() {
        if (this.getModel() != null) {
            this.getModel().deleteObserver(this);
        }
        if (this.ohTerms != null) {
            this.ohTerms.deleteObserver(this);
        }
        super.dispose();
    }

    @Override
    protected List getPorts() {
        List list = new ArrayList();
        list = this.model.getDescendantsOfClassType(7);
        list.addAll(this.model.getDescendantsOfType(eClass.E_SENSOR));
        list.addAll(this.model.getDescendantsOfType(eClass.SENSOR_OUTPUT));
        return list;
    }

    private synchronized void refreshCard() {
        for (int i = 0; i < this.ports.length; ++i) {
            if (this.ports[i] == null) continue;
            this.ports[i].dispose();
        }
        this.portModels = this.getModel().getChildren();
        this.numPorts = this.portModels.size();
        this.ports = new AbstractPortGraphic[this.numPorts];
        if (db.on()) {
            db.println("run: numPorts=" + this.numPorts);
        }
        this.invalidate();
        this.removeAll();
        this.updateLabels();
        this.updatePorts();
        this.revalidate();
        this.updateAlarm();
    }

    private void updateAlarm() {
        this.update(this.cardAlarmStore.getAlarmStatusObservable(), this.cardAlarmStore.getAlarmStatus());
    }

    private int getIndex(int n) {
        int n2 = 0;
        n2 = n < 15 ? n - 9 : (n < 19 ? n - 9 - 2 : n - 9 - 4);
        db.fine("portNo: " + n + "\tindex: " + n2);
        return n2;
    }

    private int getGridX(int n) {
        int n2 = this.pci.getAiciIoPortsStartNum() - 9 - 4;
        int n3 = 0;
        n3 = n < 6 ? n % 2 + 1 : (this.numPorts == 22 && n >= n2 ? (n - 6) % 4 + 1 : (n - 6) % 8 + 1);
        return n3;
    }

    private int getGridY(int n) {
        int n2 = this.pci.getAiciIoPortsStartNum() - 9 - 4;
        int n3 = 0;
        n3 = this.numPorts == 26 ? (n < 6 ? 5 - n / 2 : (n - 6) / 8) : (this.numPorts == 22 ? (n < 6 ? 5 - n / 2 : (n < n2 ? (n - 6) / 8 : (n - 6) / 4 - 1)) : (n < 6 ? 8 - n / 2 : (n - 6) / 8));
        return n3;
    }

    static {
        int n;
        LABELS = new String[]{"In:", "", "In/Out:", "UDC:", "DCC:", "OW:"};
        LABELS_EXT = new String[]{"In:", "", "", "", "Out:", "", "UDC:", "DCC:", "OW:"};
        normalLabels = new JLabel[LABELS.length];
        extLabels = new JLabel[LABELS_EXT.length];
        for (n = 0; n < LABELS.length; ++n) {
            AiciCardView.normalLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(LABELS[n], 2));
        }
        for (n = 0; n < LABELS_EXT.length; ++n) {
            AiciCardView.extLabels[n] = AbstractShelfLayout.formatLabel(new JLabel(LABELS_EXT[n], 2));
        }
        db = new SDebug("AiciCardView");
    }
}

