/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.SonetTopology.sRipTblEntry;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.shelf.SppRingPane;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class BlsrRipTblDialog
extends UDialog
implements ActionListener {
    private static SDebug db;
    public static final String CLOSE = "Close";
    private JButton closeButton;
    private RipTableModel tableModel;
    private INodeModel node;
    private static String[] columnNames;

    public static BlsrRipTblDialog instance(SppRingPane sppRingPane, SDebug sDebug, BlsrModel blsrModel) {
        db = sDebug;
        INodeModel iNodeModel = blsrModel.getNodeModel();
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        BlsrRipTblDialog.initColumnNames(tDMTerminology);
        String string = tDMTerminology.getRingTerms(1) + " Rip Table: Ring Name ";
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)sppRingPane));
        BlsrRipTblDialog blsrRipTblDialog = (BlsrRipTblDialog)BlsrRipTblDialog.getRecycledDialog((Frame)frame, (String)string, BlsrRipTblDialog.class, (Object)blsrModel);
        if (blsrRipTblDialog == null) {
            blsrRipTblDialog = new BlsrRipTblDialog(frame, blsrModel, string);
        }
        return blsrRipTblDialog;
    }

    private BlsrRipTblDialog(Frame frame, Object object, String string) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        JPanel jPanel2 = new JPanel();
        this.closeButton = new JButton(CLOSE);
        this.closeButton.addActionListener(this);
        jPanel2.add(this.closeButton);
        BlsrModel blsrModel = (BlsrModel)object;
        this.node = blsrModel.getNodeModel();
        this.setTitle(this.getTitle() + blsrModel.getProvision().ringName);
        this.tableModel = new RipTableModel(blsrModel);
        UScrollPane uScrollPane = new UScrollPane((Component)new UTable((TableModel)this.tableModel));
        jPanel.add((Component)uScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
    }

    public void dispose() {
        this.tableModel = null;
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.dispose();
        }
    }

    private static void initColumnNames(TDMTerminology tDMTerminology) {
        columnNames = new String[9];
        String string = tDMTerminology.getGeneralTerms(0);
        BlsrRipTblDialog.columnNames[0] = string + " Number";
        BlsrRipTblDialog.columnNames[1] = "East In " + string + " Pri";
        BlsrRipTblDialog.columnNames[2] = "East In " + string + " Term";
        BlsrRipTblDialog.columnNames[3] = "East Out " + string + " Pri";
        BlsrRipTblDialog.columnNames[4] = "East Out " + string + " Term";
        BlsrRipTblDialog.columnNames[5] = "West In " + string + " Pri";
        BlsrRipTblDialog.columnNames[6] = "West In " + string + " Term";
        BlsrRipTblDialog.columnNames[7] = "West Out " + string + " Pri";
        BlsrRipTblDialog.columnNames[8] = "West Out " + string + " Term";
    }

    class RipTableModel
    extends AbstractTableModel {
        Object MISMATCH_OBJECT = null;
        private BlsrModel model;
        private sRipTblEntry[] ripTable = null;

        RipTableModel(BlsrModel blsrModel) {
            this.model = blsrModel;
            this.ripTable = blsrModel != null ? blsrModel.getRipTbl() : new sRipTblEntry[0];
            if (db.on()) {
                db.println("dumping raw BLSR rip table:");
                for (int i = 0; i < this.ripTable.length; ++i) {
                    db.println(i + "\t" + this.ripTable[i].eastInStsPri + "\t" + this.ripTable[i].eastInStsTerm + "\t" + this.ripTable[i].eastOutStsPri + "\t" + this.ripTable[i].eastOutStsTerm + "\t" + this.ripTable[i].westInStsPri + "\t" + this.ripTable[i].westInStsTerm + "\t" + this.ripTable[i].westOutStsPri + "\t" + this.ripTable[i].westOutStsTerm);
                }
            }
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (BlsrRipTblDialog.this.node.getTdmProtocolTypeObj().isSonet()) {
                return this.ripTable.length;
            }
            return this.ripTable.length / 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            boolean bl = BlsrRipTblDialog.this.node.getTdmProtocolTypeObj().isSdh();
            int n3 = n * 3;
            int n4 = n3 + 1;
            int n5 = n3 + 2;
            switch (n2) {
                case 0: {
                    Object object;
                    int n6 = this.model.getType();
                    if (n6 == 2) {
                        int n7 = this.getRowCount();
                        object = new Integer(n7 + n + 1);
                    } else {
                        object = new Integer(n + 1);
                    }
                    if (db.on() && bl) {
                        object = "[row = " + n + ": " + n3 + " -> " + n4 + " -> " + n5 + "] " + object;
                    }
                    return object;
                }
                case 1: {
                    if (bl) {
                        short s = this.ripTable[n3].eastInStsPri;
                        short s2 = this.ripTable[n4].eastInStsPri;
                        short s3 = this.ripTable[n5].eastInStsPri;
                        if (s != s2 || s2 != s3) {
                            return this.MISMATCH_OBJECT;
                        }
                        return this.formatNodeId(s);
                    }
                    return this.formatNodeId(this.ripTable[n].eastInStsPri);
                }
                case 2: {
                    if (bl) {
                        short s = this.ripTable[n3].eastInStsTerm;
                        short s4 = this.ripTable[n4].eastInStsTerm;
                        short s5 = this.ripTable[n5].eastInStsTerm;
                        if (s != s4 || s4 != s5) {
                            return this.MISMATCH_OBJECT;
                        }
                        return this.formatNodeId(s);
                    }
                    return this.formatNodeId(this.ripTable[n].eastInStsTerm);
                }
                case 3: {
                    if (bl) {
                        short s = this.ripTable[n3].eastOutStsPri;
                        short s6 = this.ripTable[n4].eastOutStsPri;
                        short s7 = this.ripTable[n5].eastOutStsPri;
                        if (s != s6 || s6 != s7) {
                            return this.MISMATCH_OBJECT;
                        }
                        return this.formatNodeId(s);
                    }
                    return this.formatNodeId(this.ripTable[n].eastOutStsPri);
                }
                case 4: {
                    if (bl) {
                        short s = this.ripTable[n3].eastOutStsTerm;
                        short s8 = this.ripTable[n4].eastOutStsTerm;
                        short s9 = this.ripTable[n5].eastOutStsTerm;
                        if (s != s8 || s8 != s9) {
                            return this.MISMATCH_OBJECT;
                        }
                        return this.formatNodeId(s);
                    }
                    return this.formatNodeId(this.ripTable[n].eastOutStsTerm);
                }
                case 5: {
                    if (bl) {
                        short s = this.ripTable[n3].westInStsPri;
                        short s10 = this.ripTable[n4].westInStsPri;
                        short s11 = this.ripTable[n5].westInStsPri;
                        if (s != s10 || s10 != s11) {
                            return this.MISMATCH_OBJECT;
                        }
                        return this.formatNodeId(s);
                    }
                    return this.formatNodeId(this.ripTable[n].westInStsPri);
                }
                case 6: {
                    if (bl) {
                        short s = this.ripTable[n3].westInStsTerm;
                        short s12 = this.ripTable[n4].westInStsTerm;
                        short s13 = this.ripTable[n5].westInStsTerm;
                        if (s != s12 || s12 != s13) {
                            return this.MISMATCH_OBJECT;
                        }
                        return this.formatNodeId(s);
                    }
                    return this.formatNodeId(this.ripTable[n].westInStsTerm);
                }
                case 7: {
                    if (bl) {
                        short s = this.ripTable[n3].westOutStsPri;
                        short s14 = this.ripTable[n4].westOutStsPri;
                        short s15 = this.ripTable[n5].westOutStsPri;
                        if (s != s14 || s14 != s15) {
                            return this.MISMATCH_OBJECT;
                        }
                        return this.formatNodeId(s);
                    }
                    return this.formatNodeId(this.ripTable[n].westOutStsPri);
                }
                case 8: {
                    if (bl) {
                        short s = this.ripTable[n3].westOutStsTerm;
                        short s16 = this.ripTable[n4].westOutStsTerm;
                        short s17 = this.ripTable[n5].westOutStsTerm;
                        if (s != s16 || s16 != s17) {
                            return this.MISMATCH_OBJECT;
                        }
                        return this.formatNodeId(s);
                    }
                    return this.formatNodeId(this.ripTable[n].westOutStsTerm);
                }
            }
            return null;
        }

        private Object formatNodeId(short s) {
            return s == 255 ? (Object)null : new Short(s);
        }
    }
}

