/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.sEnvAlrmInputConfig;
import cerent.cms.idl.Equipment.sEnvCtrlOutputConfig;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.CardView;
import cerent.util.SDebug;

public class EnvPortGraphic
extends AbstractPortGraphic {
    private static final SDebug db = new SDebug("EnvPortGraphic");

    public EnvPortGraphic(CardView cardView, EntityModel entityModel, int n) {
        super(cardView, entityModel, n);
        if (db.on()) {
            db.println("<init>");
        }
        this.showState();
        this.registerWithModel();
    }

    @Override
    protected void registerWithModel() {
        if (db.on()) {
            db.println("registerWithModel");
        }
        this.model.addObserver(this);
    }

    @Override
    public void dispose() {
        if (db.on()) {
            db.println("dispose");
        }
        this.model.deleteObserver(this);
    }

    @Override
    protected synchronized void showState() {
        if (db.on()) {
            db.println("showState");
        }
        int n = -1;
        try {
            if (this.model instanceof EnvAlarmModel) {
                EnvAlarmModel envAlarmModel = (EnvAlarmModel)this.model;
                sEnvAlrmInputConfig sEnvAlrmInputConfig2 = envAlarmModel.settings();
                n = sEnvAlrmInputConfig2.enabled ? 0 : 1;
            } else if (this.model instanceof EnvControlModel) {
                EnvControlModel envControlModel = (EnvControlModel)this.model;
                sEnvCtrlOutputConfig sEnvCtrlOutputConfig2 = envControlModel.settings();
                n = sEnvCtrlOutputConfig2.enabled ? 0 : 1;
            }
            this.statusString = EntityModel.getTDMTerminology(this.model).getTermForAdminState(n);
        }
        catch (Exception exception) {
            db.println("failed to get settings from port");
            SDebug.printStackTrace((Throwable)exception);
        }
        this.setToolTipText("State: " + this.statusString);
        this.setCurrentState(n);
        this.setCurrentColor(EnvPortGraphic.getPortColorByAdminStateAndSeverity(n, this.currentSeverity));
        this.repaint();
    }
}

