/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.IAPCLastModification;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.ApcRenderer;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.shelf.MaintApcDataSource;
import cerent.util.Preferences;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class MaintApcTableColumnRenderer
extends AbstractColumnRenderer {
    public static final int POSITION_INDEX = 0;
    public static final int LASTMOD_INDEX = 1;
    public static final int PARAM_INDEX = 2;
    public static final int LASTCHECK_INDEX = 3;
    public static final int SIDE_INDEX = 4;
    public static final int STATE_INDEX = 5;
    private static final int COLUMN_NO = 6;
    private JLabel label;
    private NodeModelDelegate nm;
    private EventUtilities eventutilities;
    private MaintApcDataSource dataSource;

    public MaintApcTableColumnRenderer(NodeModelDelegate nodeModelDelegate, MaintApcDataSource maintApcDataSource, String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.nm = nodeModelDelegate;
        this.dataSource = maintApcDataSource;
        this.eventutilities = EventUtilities.getInstance(nodeModelDelegate);
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    protected String getStringValue(IAPCLastModification iAPCLastModification, int n) {
        String string = "???";
        long l = 0L;
        if (iAPCLastModification != null) {
            switch (n) {
                case 0: {
                    string = this.getPosition(iAPCLastModification.getIndex());
                    break;
                }
                case 2: {
                    string = this.getApcParameter(iAPCLastModification);
                    break;
                }
                case 1: {
                    if (iAPCLastModification.getLastModification() > 0) {
                        l = this.eventutilities.convertSecondsToMilliSeconds(iAPCLastModification.getLastModification());
                        Preferences preferences = Preferences.instance();
                        if (preferences.getProperty("ctc", "useNeTimeZone", "0").indexOf("0") == 0) {
                            string = this.eventutilities.formatAbsoluteNeTimeasCtcTimeZoneString(l);
                            break;
                        }
                        string = this.eventutilities.formatAbsoluteNeTimeasNeTimeZoneString(l);
                        break;
                    }
                    string = "N/A";
                    break;
                }
                case 3: {
                    if (iAPCLastModification.getLastChecked() > 0) {
                        l = this.eventutilities.convertSecondsToMilliSeconds(iAPCLastModification.getLastChecked());
                        Preferences preferences = Preferences.instance();
                        if (preferences.getProperty("ctc", "useNeTimeZone", "0").indexOf("0") == 0) {
                            string = this.eventutilities.formatAbsoluteNeTimeasCtcTimeZoneString(l);
                            break;
                        }
                        string = this.eventutilities.formatAbsoluteNeTimeasNeTimeZoneString(l);
                        break;
                    }
                    string = "N/A";
                    break;
                }
                case 4: {
                    string = DwdmSide.getSideFromOffset(iAPCLastModification.getSide());
                    break;
                }
                case 5: {
                    try {
                        int n2 = this.dataSource.getApcState(iAPCLastModification.getSide());
                        string = ApcRenderer.getAPCStateAsString(n2);
                        break;
                    }
                    catch (WrongNodeSide wrongNodeSide) {
                        string = "Error";
                    }
                }
            }
        }
        return string;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        IAPCLastModification iAPCLastModification;
        JLabel jLabel = this.label;
        try {
            iAPCLastModification = (IAPCLastModification)object;
        }
        catch (Exception exception) {
            this.label.setText("");
            return jLabel;
        }
        String string = this.getStringValue(iAPCLastModification, n2);
        Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        ((Component)jLabel).setBackground(color);
        Color color2 = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        ((Component)jLabel).setForeground(color2);
        this.label.setToolTipText("");
        this.label.setText(string);
        return jLabel;
    }

    private String getPosition(int n) {
        PortModel portModel = null;
        try {
            portModel = (PortModel)this.nm.getEntityTableModel().getEntityModelByIndex(n);
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            return entityCellRenderer.getFullPortString(portModel, false);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return "N/A";
        }
    }

    private String getApcParameter(IAPCLastModification iAPCLastModification) {
        String string = "Unknown";
        switch (iAPCLastModification.getAttr().value()) {
            case 1: {
                string = "Working Mode";
                break;
            }
            case 2: {
                string = "Per Channel Power";
                break;
            }
            case 3: {
                string = "Gain";
                break;
            }
            case 4: {
                string = "Tilt";
                break;
            }
            case 5: {
                string = "LOS-P Thresold";
                break;
            }
            case 6: {
                string = "LOS-O Thresold";
                break;
            }
            case 7: {
                string = "Voa Target Attenuation";
                break;
            }
            case 8: {
                string = "Voa Target Power";
                break;
            }
            case 9: {
                string = "Total Power";
                break;
            }
        }
        return string;
    }

    static int getSlotInt(NodeModelDelegate nodeModelDelegate, int n) {
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return -1;
        }
        if (entityModel != null && entityModel instanceof PortModel) {
            return entityModel.getSlot();
        }
        return -1;
    }

    static ColumnRenderer[] createTableRenderers(NodeModelDelegate nodeModelDelegate, MaintApcDataSource maintApcDataSource) {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[6];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = MaintApcTableColumnRenderer.createColumnRenderer(nodeModelDelegate, maintApcDataSource, i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(NodeModelDelegate nodeModelDelegate, MaintApcDataSource maintApcDataSource, int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Position";
                n3 = 305;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Parameter";
                n3 = 170;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Last Modification";
                n3 = 170;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Last Check";
                n3 = 160;
                bl = true;
                n2 = 2;
                break;
            }
            case 4: {
                string = "Side";
                n3 = 30;
                bl = true;
                n2 = 2;
                break;
            }
            case 5: {
                string = "APC State";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new MaintApcTableColumnRenderer(nodeModelDelegate, maintApcDataSource, string, n3, bl, n2);
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        String string = this.getStringValue((IAPCLastModification)object, n);
        String string2 = this.getStringValue((IAPCLastModification)object2, n);
        return string.compareTo(string2);
    }
}

