/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.EtherBridgeModel;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.SpanningTreeModel;
import cerent.cms.ui.RoDataSourceControl;
import cerent.cms.ui.shelf.MaintSpTreeRowObject;
import cerent.util.BlockingModeController;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class MaintSpTreeDataSource
extends AbstractRowDataSource
implements Observer,
RoDataSourceControl,
BlockingModeController {
    private static SDebug db = new SDebug("MaintSpTreeDS");
    private ArrayList stmList = new ArrayList();
    private SpanningTreeModel[] models;
    private EtherBridgeModel etherBridgeModel;
    private ObservableManager observableManager;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;

    public MaintSpTreeDataSource(IEtherBridgeModel iEtherBridgeModel) {
        this.etherBridgeModel = (EtherBridgeModel)iEtherBridgeModel;
        this.observableManager = new ObservableManager(this, true);
        this.observableManager.addObservable((Observable)((Object)this.etherBridgeModel));
        this.observableManager.setBlockingModeController(this);
    }

    private void resetFromEtherBridgeModel() {
        this.println("SpTreeDataSource resetting");
        this.observableManager.removeObservable((Observable[])this.models);
        this.models = this.etherBridgeModel.getSpanningTreeList();
        this.observableManager.addObservable((Observable[])this.models);
    }

    public Object getObjectAtRow(int n) {
        return this.stmList.get(n);
    }

    public int getRowCount() {
        return this.stmList.size();
    }

    public Collection getAllObjects() {
        return this.stmList;
    }

    public void refreshFromModel() {
        int n;
        this.println("MaintSpTree refreshing");
        this.stmList.clear();
        for (n = 0; n < this.models.length; ++n) {
            this.stmList.add(new MaintSpTreeRowObject(this.models[n]));
        }
        this.fireDataSourceChanged();
        for (n = 0; n < this.stmList.size(); ++n) {
            MaintSpTreeRowObject maintSpTreeRowObject = (MaintSpTreeRowObject)this.stmList.get(n);
            this.println(maintSpTreeRowObject.toString());
        }
    }

    public void refreshFromModel(int n) throws Exception {
        this.resetFromEtherBridgeModel();
        this.refreshFromModel();
    }

    public IObservableManager getObservableManager() {
        this.println("observable manager fetched, st=" + this.observableManager.getBlockingModeControllerState());
        return this.observableManager;
    }

    public void disposeDataSource() {
        if (this.stmList != null) {
            this.stmList.clear();
        }
        this.models = null;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.resetFromEtherBridgeModel();
        this.refreshFromModel();
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        if (observable.equals(this.etherBridgeModel)) {
            return 2;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }

    private void println(String string) {
        if (MaintSpTreeDataSource.db.on) {
            db.println(string);
        }
    }
}

