/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OpticsTopology.sSideOChEqualizationAttributes;
import cerent.cms.idl.OpticsTopology.sSideOChEqualizationInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OchsPwrMonitoringModel;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.shelf.XAssisChartElements;
import cerent.util.SDebug;
import cerent.util.gui.DefaultChartDataModel;
import ilog.views.chart.IlvStyle;
import java.awt.Color;
import java.awt.Paint;

public class OchsPwrMonitoringChartModel
extends DefaultChartDataModel {
    static final double LOWEST_PWR = -25.0;
    private double[][] yvalues;
    private int sidein_out;
    private OchsPwrMonitoringModel ochsPwrModel = null;
    private XAssisChartElements xAxis;
    private ISideModel iSideModel;
    private sSideOChEqualizationInfo sOchEqAttr = null;
    private double maximum = -25.0;
    private double minimum = -25.0;
    private static final Color[] in_out_style_color = new Color[]{Color.RED, Color.BLUE};
    private String[] lambdaId;

    public OchsPwrMonitoringChartModel(OchsPwrMonitoringModel ochsPwrMonitoringModel, ISideModel iSideModel, int n) {
        this.ochsPwrModel = ochsPwrMonitoringModel;
        this.iSideModel = iSideModel;
        this.sidein_out = n;
    }

    public void init() throws FeatureUnsupported, CTCUserException {
        this.sOchEqAttr = this.ochsPwrModel.getOchEqualizationInfo(this.iSideModel.getId());
        this.xAxis = new XAssisChartElements(this.sOchEqAttr.numChan, this.sidein_out);
        this.fillEqualizationPower();
        for (int i = 0; i < this.getNumSeries(); ++i) {
            this.max(this.getYSeries(i));
        }
    }

    private void fillEqualizationPower() {
        int n;
        this.xAxis = new XAssisChartElements(this.sOchEqAttr.numChan, this.sidein_out);
        double[][] dArray = new double[1][this.sOchEqAttr.numChan];
        for (int i = 0; i < this.sOchEqAttr.numChan; ++i) {
            dArray[0][i] = -25.0;
        }
        sSideOChEqualizationAttributes[] sSideOChEqualizationAttributesArray = this.sidein_out == 0 ? this.sOchEqAttr.ochSideInEqualizationAttributesList : this.sOchEqAttr.ochSideOutEqualizationAttributesList;
        int n2 = -1;
        this.lambdaId = new String[this.sOchEqAttr.numChan];
        for (n = 0; n < this.sOchEqAttr.numChan; ++n) {
            this.lambdaId[n] = "";
        }
        for (n = 0; n < sSideOChEqualizationAttributesArray.length; ++n) {
            n2 = Wavelength.getLambdaCChannelOffset(sSideOChEqualizationAttributesArray[n].lambdaId.value(), this.sOchEqAttr.numChan);
            Attribute attribute = Wavelength.getWlAttribute(sSideOChEqualizationAttributesArray[n].lambdaId.value());
            n2 = Wavelength.isCBandLambda(attribute) ? Wavelength.getLambdaCChannelOffset(sSideOChEqualizationAttributesArray[n].lambdaId.value(), this.sOchEqAttr.numChan) : Wavelength.getLambdaLChannelOffset(sSideOChEqualizationAttributesArray[n].lambdaId.value(), this.sOchEqAttr.numChan);
            if (sSideOChEqualizationAttributesArray[n].power == -1000000 || !((double)sSideOChEqualizationAttributesArray[n].power / 10.0 > -25.0)) continue;
            dArray[0][n2] = (double)sSideOChEqualizationAttributesArray[n].power / 10.0;
            String string = sSideOChEqualizationAttributesArray[n].sideOpposite == this.iSideModel.getNameLabelValue() ? (this.sidein_out == 0 ? "Local DROP " : "Local ADD ") : (this.sidein_out == 0 ? "EXP To " : "EXP From ");
            this.lambdaId[n2] = Wavelength.getWlAttribute(sSideOChEqualizationAttributesArray[n].lambdaId.value()).getKey() + "\n" + string + DwdmSide.getSideFromOffset(sSideOChEqualizationAttributesArray[n].sideOpposite);
        }
        this.yvalues = dArray;
    }

    String[] getActivetLambdas() {
        return this.lambdaId;
    }

    public String getSideStr() {
        return this.iSideModel.getName();
    }

    public void refreshPwrData() throws CTCUserException {
        this.fillEqualizationPower();
        this.reloadData();
    }

    public String[] getPointLabels() {
        return this.xAxis.getPointLabels();
    }

    public String[] getSeriesLabels() {
        return this.xAxis.getSeriesLabels();
    }

    public double[] getXSeries(int n) {
        return this.xAxis.getXvalues();
    }

    public double[][] getYSeries() {
        return this.yvalues;
    }

    public int getNumSeries() {
        return this.yvalues.length;
    }

    public IlvStyle[] getStyles() {
        IlvStyle[] ilvStyleArray = new IlvStyle[this.getNumSeries()];
        ilvStyleArray[0] = new IlvStyle((Paint)in_out_style_color[this.sidein_out]);
        return ilvStyleArray;
    }

    private void max(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > this.maximum)) continue;
            this.maximum = dArray[i];
        }
    }

    public double getMax() {
        if (this.maximum == -25.0) {
            return 0.0;
        }
        return this.maximum + 0.5;
    }

    public double getMin() {
        return this.minimum;
    }

    public double[] getYSeries(int n) {
        return this.yvalues[n];
    }

    boolean IsPortIdxEqualZero() {
        int n = -1;
        n = this.sidein_out == 0 ? this.sOchEqAttr.inRefPort : this.sOchEqAttr.outRefPort;
        return n == 0;
    }

    IEntityModel getPortModel() {
        IEntityModel iEntityModel = null;
        try {
            int n = -1;
            n = this.sidein_out == 0 ? this.sOchEqAttr.inRefPort : this.sOchEqAttr.outRefPort;
            iEntityModel = ((NodeModelDelegate)this.ochsPwrModel.getNodeModel()).getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return iEntityModel;
    }

    boolean isInstanceSideIn() {
        return this.sidein_out == 0;
    }
}

