/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Epos.sSpanningTreeAdminInfo;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElAttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherBridgeModel;
import cerent.cms.model.SpanningTreeModel;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.util.BlockingModeController;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Observable;

public class ProvSpTreeTableModel
extends AbstractProvTableModel
implements BlockingModeController {
    private static SDebug db = new SDebug("ProvSpTreeTableModel");
    private SpanningTreeModel[] models;
    private EtherBridgeModel etherBridgeModel;
    private sSpanningTreeAdminInfo[] admInfo;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    public static final int MIN_MAX_AGE = 6;
    public static final int MAX_MAX_AGE = 40;
    public static final int MIN_HELLO_TIME = 1;
    public static final int MAX_HELLO_TIME = 10;
    public static final int MIN_FORWARD_DELAY = 4;
    public static final int MAX_FORWARD_DELAY = 30;
    public static final int MIN_PRIORITY = 0;
    public static final int MAX_PRIORITY = 65535;
    public static final int SPT_ID_INDEX = 0;
    public static final int PRIO_INDEX = 1;
    public static final int MAX_AGE_INDEX = 2;
    public static final int HELLO_INDEX = 3;
    public static final int FORWARD_DELAY_INDEX = 4;

    public ProvSpTreeTableModel(EtherBridgeModel etherBridgeModel) {
        super(etherBridgeModel.getSpanningTreeList(), true, null);
        this.columnNames = new String[]{"#", "Priority", "Bridge Max Age (sec)", "Bridge Hello Time (sec)", "Bridge Forward Delay (sec)"};
        this.etherBridgeModel = etherBridgeModel;
        this.observableManager.setBlockingModeController((BlockingModeController)this);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.enabled && n2 != 0;
    }

    @Override
    public Class getColumnClass(int n) {
        return Integer.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return new Integer(this.models[n].getIndex());
            }
            case 1: {
                return new Integer(this.admInfo[n].priority & 0xFFFF);
            }
            case 2: {
                return new Integer(this.admInfo[n].bridgeMaxAge);
            }
            case 3: {
                return new Integer(this.admInfo[n].bridgeHelloTime);
            }
            case 4: {
                return new Integer(this.admInfo[n].bridgeForwardDelay);
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3 = -1;
        if (object instanceof Integer) {
            n3 = (Integer)object;
        } else if (object instanceof String) {
            n3 = Integer.parseInt((String)object);
        }
        if (object == null) {
            return;
        }
        switch (n2) {
            case 1: {
                int n4 = n3;
                if (n4 < 0 || n4 > 65535) {
                    n4 = 0;
                }
                this.admInfo[n].priority = (short)n4;
                break;
            }
            case 2: {
                this.admInfo[n].bridgeMaxAge = n3;
                break;
            }
            case 3: {
                this.admInfo[n].bridgeHelloTime = n3;
                break;
            }
            case 4: {
                this.admInfo[n].bridgeForwardDelay = n3;
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableRowsUpdated(n, n);
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel()");
        }
        for (int i = 0; i < this.numLines; ++i) {
            sSpanningTreeAdminInfo sSpanningTreeAdminInfo2 = this.models[i].getSpanningTreeAdminInfo();
            this.admInfo[i] = new sSpanningTreeAdminInfo(sSpanningTreeAdminInfo2.priority, sSpanningTreeAdminInfo2.bridgeMaxAge, sSpanningTreeAdminInfo2.bridgeHelloTime, sSpanningTreeAdminInfo2.bridgeForwardDelay);
            this.printAdmInfo(i);
        }
        super.refreshFromModel();
    }

    protected void refreshFromModel(SpanningTreeModel spanningTreeModel) throws Exception {
        int n = Arrays.asList(this.models).indexOf(spanningTreeModel);
        if (ProvSpTreeTableModel.db.on) {
            db.println("refreshing spanning tree model");
        }
        if (n == -1) {
            if (ProvSpTreeTableModel.db.on) {
                db.println("Unknown spanning tree model to refresh" + spanningTreeModel);
            }
            this.refreshFromModel();
            return;
        }
        sSpanningTreeAdminInfo sSpanningTreeAdminInfo2 = spanningTreeModel.getSpanningTreeAdminInfo();
        this.admInfo[n] = new sSpanningTreeAdminInfo(sSpanningTreeAdminInfo2.priority, sSpanningTreeAdminInfo2.bridgeMaxAge, sSpanningTreeAdminInfo2.bridgeHelloTime, sSpanningTreeAdminInfo2.bridgeForwardDelay);
        if (ProvSpTreeTableModel.db.on) {
            db.println("Update spanning tree UI");
        }
        this.fireTableRowsUpdated(n, n);
    }

    @Override
    public void refreshFromModel(int n) throws Exception {
        if (db.on()) {
            db.println("refreshFromModel(" + n + ")");
        }
        this.resetFromEtherBridgeModel();
        this.refreshFromModel();
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i]) continue;
            if (db.on()) {
                db.println("applyToModel: commiting row " + i);
            }
            this.printAdmInfo(i);
            this.models[i].setSpanningTreeAdminInfo(this.admInfo[i]);
            this.rowDirty[i] = false;
        }
    }

    private void resetFromEtherBridgeModel() {
        if (db.on()) {
            db.println("resetFromEtherBridgeModel");
        }
        this.observableManager.removeObservable((Observable)((Object)this.etherBridgeModel));
        this.models = this.etherBridgeModel.getSpanningTreeList();
        this.admInfo = new sSpanningTreeAdminInfo[this.models.length];
        this.setModels(this.models);
        this.observableManager.addObservable((Observable)((Object)this.etherBridgeModel));
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update");
        }
        if (observable.equals(this.etherBridgeModel)) {
            this.resetFromEtherBridgeModel();
            return;
        }
        try {
            if (observable instanceof SpanningTreeModel) {
                this.refreshFromModel((SpanningTreeModel)((Object)observable));
                return;
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (ProvSpTreeTableModel.db.on) {
                db.println("Caught Exception " + (Object)((Object)abstractCmsIOException));
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in update of ProvSpTree " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        if (observable.equals(this.etherBridgeModel)) {
            if (db.on()) {
                db.println("processBlockedEvent: returning NEEDS_RESET");
            }
            return 2;
        }
        if (n == 0) {
            if (db.on()) {
                db.println("processBlockedEvent: returning NEEDS_REFRESH");
            }
            return 1;
        }
        if (db.on()) {
            db.println("processBlockedEvent: returning " + n);
        }
        return n;
    }

    private void printAdmInfo(int n) {
        if (ProvSpTreeTableModel.db.on) {
            db.print("[" + n + "]");
            db.print(" prio=" + this.admInfo[n].priority);
            db.print(" mxage=" + this.admInfo[n].bridgeMaxAge);
            db.print(" hello=" + this.admInfo[n].bridgeHelloTime);
            db.println(" fwddly=" + this.admInfo[n].bridgeForwardDelay);
        }
    }

    protected Attribute getAttributeFor(String string, int n) {
        return this.getAttributeMap().getAttributeForVal(this.prefix + string, n);
    }

    public ElAttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.etherBridgeModel);
    }
}

