/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AdminState;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.MfgPortModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.DataSourceControl;
import cerent.cms.ui.shelf.ShelfInventoryPane;
import cerent.cms.ui.shelf.ShelfInventoryPortRowObject;
import cerent.cms.ui.shelf.ShelfInventoryRowObject;
import cerent.util.BlockingModeController;
import cerent.util.ComparisonUtil;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.row.AbstractRowDataSource;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class ShelfInventoryDataSource
extends AbstractRowDataSource
implements Observer,
DataSourceControl,
BlockingModeController {
    private NodeModelDelegate nmd;
    private IChassisModel chassis;
    private List entities;
    private ShelfInventoryRowObject[] rowObjects;
    private ShelfInventoryPortRowObject[] portRowObjects;
    private ObservableManager observableManager;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    private static final SDebug db = new SDebug((KDebug)ShelfInventoryPane.db, "ShelfInventoryDataSource");

    public ShelfInventoryDataSource(NodeModelDelegate nodeModelDelegate) {
        this(nodeModelDelegate, null);
    }

    public ShelfInventoryDataSource(NodeModelDelegate nodeModelDelegate, IChassisModel iChassisModel) {
        this.nmd = nodeModelDelegate;
        this.chassis = iChassisModel;
        this.observableManager = new ObservableManager(this, true);
        this.observableManager.setBlockingModeController(this);
    }

    public Object getObjectAtRow(int n) {
        try {
            if (this.entities.get(n) instanceof MfgEntityModel) {
                return this.rowObjects != null ? this.rowObjects[n] : null;
            }
            return this.portRowObjects != null ? this.portRowObjects[n] : null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (db.on()) {
                db.println("getObjectAtRow " + n + " out of bounds");
            }
            return null;
        }
    }

    public int getRowCount() {
        if (this.entities != null && this.entities.size() > 0) {
            return this.entities.size();
        }
        return 0;
    }

    public Collection getAllObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.rowObjects.length; ++i) {
            if (this.rowObjects[i] != null) {
                arrayList.add(this.rowObjects[i]);
                continue;
            }
            arrayList.add(this.portRowObjects[i]);
        }
        return arrayList;
    }

    public void refreshFromModel(int n) throws Exception {
        if (n == -1 || n == 2) {
            this.resetFromNodeModel();
        }
        this.refreshFromModel();
    }

    private void resetFromNodeModel() {
        db.config("resetFromNodeModel invoked");
        this.observableManager.setObservable(null);
        ArrayList arrayList = new ArrayList();
        this.entities = new ArrayList();
        IChassisModel[] iChassisModelArray = this.chassis != null ? new IChassisModel[]{this.chassis} : (IChassisModel[])this.nmd.getChassisModels();
        for (int i = 0; i < iChassisModelArray.length; ++i) {
            MfgEntityModel mfgEntityModel;
            List list = iChassisModelArray[i].getMfgEntities();
            Iterator iterator = list.iterator();
            if (iChassisModelArray[i].getEqType() == 335 || iChassisModelArray[i].getEqType() == 336) {
                while (iterator.hasNext()) {
                    mfgEntityModel = (MfgEntityModel)iterator.next();
                    if (mfgEntityModel.getSlot() > 8 && mfgEntityModel.getSlot() < 30 && mfgEntityModel.getSlot() != 20 && mfgEntityModel.getEqType() != 346) continue;
                    this.entities.add(mfgEntityModel);
                }
            } else if (iChassisModelArray[i].getEqType() == 333 || iChassisModelArray[i].getEqType() == 334) {
                while (iterator.hasNext()) {
                    mfgEntityModel = (MfgEntityModel)iterator.next();
                    if (mfgEntityModel.getEqType() == 345 || mfgEntityModel.getSlot() > 30) continue;
                    this.entities.add(mfgEntityModel);
                }
            } else {
                this.entities.addAll(iChassisModelArray[i].getMfgEntities());
            }
            this.entities.remove(iChassisModelArray[i]);
            arrayList.addAll(iChassisModelArray[i].getDescendantsOfClassType(2));
            this.observableManager.addObservable((Observable)((Object)((Model)((Object)iChassisModelArray[i]))));
        }
        if (this.nmd.isMultishelf()) {
            ChassisModels chassisModels = this.nmd.getChassisModelsInstance();
            this.observableManager.addObservable((Observable)((Object)chassisModels));
        }
        if (this.entities == null || this.entities.size() == 0) {
            if (ShelfInventoryDataSource.db.on) {
                db.println("Can't get mfgd entities!");
            }
        } else {
            if (ShelfInventoryDataSource.db.on) {
                db.println("resetFromNodeModel: " + this.entities.size() + " rows");
            }
            this.observableManager.addObservable((Observable[])this.entities.toArray(new Model[this.entities.size()]));
        }
        if (arrayList == null || arrayList.size() == 0) {
            if (ShelfInventoryDataSource.db.on) {
                db.println("Can't get slots!");
            }
        } else {
            if (ShelfInventoryDataSource.db.on) {
                db.println("resetFromNodeModel: " + arrayList.size() + " slots");
            }
            this.observableManager.addObservable((Observable[])arrayList.toArray(new Model[arrayList.size()]));
        }
    }

    public void refreshFromModel() {
        db.config("refreshFromModel invoked");
        ShelfInventoryRowObject[] shelfInventoryRowObjectArray = new ShelfInventoryRowObject[this.entities.size()];
        ShelfInventoryPortRowObject[] shelfInventoryPortRowObjectArray = new ShelfInventoryPortRowObject[this.entities.size()];
        Collections.sort(this.entities, new Comparator(){

            @Override
            public boolean equals(Object object) {
                return object == this;
            }

            public int compare(Object object, Object object2) {
                EntityModel entityModel = (EntityModel)object;
                EntityModel entityModel2 = (EntityModel)object2;
                if (entityModel != null) {
                    if (entityModel2 != null) {
                        return ComparisonUtil.compare((int)entityModel.getIndex(), (int)entityModel2.getIndex());
                    }
                    return 1;
                }
                return -1;
            }
        });
        for (int i = 0; i < this.entities.size(); ++i) {
            if (ShelfInventoryDataSource.db.on) {
                db.println(this.entities.get(i).toString());
            }
            if (this.entities.get(i) instanceof MfgEntityModel) {
                shelfInventoryRowObjectArray[i] = new ShelfInventoryRowObject((MfgEntityModel)this.entities.get(i));
                continue;
            }
            if (!(this.entities.get(i) instanceof MfgPortModel)) continue;
            shelfInventoryPortRowObjectArray[i] = new ShelfInventoryPortRowObject((MfgPortModel)this.entities.get(i));
        }
        this.rowObjects = shelfInventoryRowObjectArray;
        this.portRowObjects = shelfInventoryPortRowObjectArray;
        this.fireDataSourceChanged();
    }

    public IObservableManager getObservableManager() {
        if (ShelfInventoryDataSource.db.on) {
            db.println("getObservableManager: state = " + this.observableManager.getBlockingModeControllerState());
        }
        return this.observableManager;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            ShelfInventoryRowObject shelfInventoryRowObject = this.rowObjects[i];
            if (shelfInventoryRowObject == null || !shelfInventoryRowObject.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.rowObjects.length; ++i) {
            ShelfInventoryRowObject shelfInventoryRowObject = this.rowObjects[i];
            if (shelfInventoryRowObject == null || !shelfInventoryRowObject.isDirty()) continue;
            if (shelfInventoryRowObject.isDirty(0)) {
                shelfInventoryRowObject.entity.setInventoryCode(shelfInventoryRowObject.getUserCode());
                shelfInventoryRowObject.setDirty(0, false);
            }
            if (shelfInventoryRowObject == null || !shelfInventoryRowObject.isDirty(1)) continue;
            if (shelfInventoryRowObject.adminStateChanged()) {
                shelfInventoryRowObject.entity.setAdminState(shelfInventoryRowObject.getAdminState().getAdminStateEnum());
            }
            shelfInventoryRowObject.setDirty(1, false);
        }
    }

    public boolean validateData() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rowObjects.length; ++i) {
            ShelfInventoryRowObject shelfInventoryRowObject = this.rowObjects[i];
            if (shelfInventoryRowObject == null || !shelfInventoryRowObject.isDirty(1) || !AdminState.isTransitionToOOS(shelfInventoryRowObject.getAdminState().getAdminStateEnum(), shelfInventoryRowObject.getAdminStateFromModel().getAdminStateEnum())) continue;
            stringBuffer.append("Action may be service affecting.").append('\n');
            break;
        }
        if (stringBuffer.length() != 0) {
            stringBuffer.append("Is it OK to apply the changes?");
            if (!CerentDialog.yesNoDialog((Component)this.getFrame(), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return false;
            }
        }
        return true;
    }

    public void setDirty(boolean bl) {
    }

    public void disposeDataSource() {
        if (this.entities != null) {
            this.entities.clear();
        }
        this.rowObjects = null;
        this.portRowObjects = null;
    }

    @Override
    public void update(Observable observable, Object object) {
        int n;
        if (ShelfInventoryDataSource.db.on) {
            try {
                db.println("update: src = " + observable + ", evt = " + object);
            }
            catch (Exception exception) {
                db.warning("Attempted to access an EntityModel which no longer exists");
            }
        }
        if ((n = this.entities.indexOf(observable)) == -1 || object == ModelUpdateType.DELETED) {
            this.resetFromNodeModel();
        }
        this.refreshFromModel();
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        int n2;
        if (ShelfInventoryDataSource.db.on) {
            db.println("processBlockedEvent: src " + observable + ", event = " + object + ", previousState = " + n);
        }
        if ((n2 = this.entities.indexOf(observable)) == -1 || object == ModelUpdateType.DELETED) {
            return 2;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }

    protected Frame getFrame() {
        return this.nmd.getUiToolkit().getApplicationFrame();
    }
}

