/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.InvalidPortsForSide;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortIsConnected;
import cerent.cms.model.PortModel;
import cerent.cms.model.PortUsedBySide;
import cerent.cms.model.SideInUse;
import cerent.cms.model.SideModels;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.omg.CORBA.UserException;

public class SideCreationDialog
extends UDialog
implements ActionListener,
ItemListener,
Observer {
    protected JButton okButton;
    protected JButton cancelButton;
    protected JComboBox sideIdCB;
    protected JComboBox portInCB;
    protected JComboBox portOutCB;
    protected DefaultComboBoxModel sideIdComboModel;
    protected DefaultComboBoxModel portInComboModel;
    protected DefaultComboBoxModel portOutComboModel;
    private JLabel sideIdLabel;
    private JLabel portInLabel;
    private JLabel portOutLabel;
    private final SideModels smod;
    private final NodeModelDelegate nm;
    protected static final SDebug db = new SDebug("SideCreationDialog");
    private static final String CREATE_TITLE = "Create Side";
    private static final String SIDE_ID = "Side ID:   ";
    private static final String LINE_IN = "Line In:    ";
    private static final String LINE_OUT = "Line Out:    ";
    private List<List<PortModel>> allAvailablePorts = null;
    private static final int RX_PORT = 0;
    private static final int TX_PORT = 1;
    private final EntityCellRenderer ecr = new EntityCellRenderer();

    public static SideCreationDialog instance(Frame frame, IModel iModel) {
        return new SideCreationDialog(frame, iModel);
    }

    public static SideCreationDialog instance(INodeModel iNodeModel) {
        return new SideCreationDialog(null, (NodeModelDelegate)iNodeModel);
    }

    private SideCreationDialog(Frame frame, IModel iModel) {
        super(frame, CREATE_TITLE, true);
        if (db.on()) {
            db.println(this.getClass().toString() + " SideCreationDialog constructor");
        }
        this.nm = (NodeModelDelegate)iModel.getNodeModel();
        this.smod = SideModels.getInstance(this.nm);
        this.initMainPane(frame);
        this.regForEvent();
        this.setVisible(true);
    }

    protected void initMainPane(Frame frame) {
        if (db.on()) {
            db.println(this.getClass().toString() + " initMainPane");
        }
        Container container = this.getContentPane();
        this.setSize(new Dimension(430, 200));
        container.setLayout(new BorderLayout());
        container.add((Component)this.getLocalPanel(), "North");
        container.add((Component)this.getButtonPanel(), "South");
    }

    protected JPanel getButtonPanel() {
        if (db.on()) {
            db.println(this.getClass().toString() + " getButtonPanel");
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel2.add(this.okButton);
        this.enableOKButton();
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel2.add(this.cancelButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JPanel getLocalPanel() {
        if (db.on()) {
            db.println(this.getClass().toString() + " getLocalePanel");
        }
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        jPanel.setLayout(borderLayout);
        jPanel.add((Component)new JPanel(), "North");
        jPanel.add((Component)this.createLabelsPanel(), "West");
        jPanel.add((Component)this.createFieldsPanel(), "Center");
        return jPanel;
    }

    private JPanel createFieldsPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 3));
        this.sideIdCB = new JComboBox();
        this.sideIdCB.setRenderer(new ComboBoxCellRenderer());
        jPanel2.add(this.sideIdCB);
        jPanel2.add(new JPanel());
        jPanel2.add(new JPanel());
        this.fillInSideIdCB();
        this.allAvailablePorts = this.getAvailablePortsByType();
        if (db.on()) {
            this.printAllAvailablePorts();
        }
        this.portInCB = new JComboBox();
        this.portInCB.setRenderer(new ComboBoxCellRenderer());
        this.portInCB.addItemListener(this);
        this.fillInPortInCB();
        this.portOutCB = new JComboBox();
        this.portOutCB.setRenderer(new ComboBoxCellRenderer());
        this.fillInPortOutCB();
        jPanel.add(jPanel2);
        jPanel.add(this.portInCB);
        jPanel.add(this.portOutCB);
        return jPanel;
    }

    private JPanel createLabelsPanel() {
        this.sideIdLabel = new JLabel(SIDE_ID);
        this.portInLabel = new JLabel(LINE_IN);
        this.portOutLabel = new JLabel(LINE_OUT);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        jPanel.add(this.sideIdLabel);
        jPanel.add(this.portInLabel);
        jPanel.add(this.portOutLabel);
        return jPanel;
    }

    private void fillInSideIdCB() {
        this.sideIdComboModel = new DefaultComboBoxModel<DwdmSide.SideEnum>(this.filterOutSideInUse().toArray(new DwdmSide.SideEnum[0]));
        this.sideIdCB.setModel(this.sideIdComboModel);
        this.sideIdCB.setEnabled(this.sideIdComboModel.getSize() != 0);
    }

    private void fillInPortInCB() {
        PortModel[] portModelArray = this.allAvailablePorts.get(0).toArray(new PortModel[0]);
        this.portInComboModel = new DefaultComboBoxModel<PortModel>(portModelArray);
        this.portInCB.setModel(this.portInComboModel);
        if (this.portInComboModel.getSize() != 0) {
            this.portInCB.setSelectedIndex(0);
        }
        this.portInCB.setEnabled(this.portInComboModel.getSize() != 0);
    }

    private void fillInPortOutCB() {
        PortModel portModel = (PortModel)this.portInCB.getSelectedItem();
        List<PortModel> list = this.allAvailablePorts.get(1);
        this.portOutComboModel = new DefaultComboBoxModel<Object>(list.toArray());
        this.portOutCB.setModel(this.portOutComboModel);
        PortModel[] portModelArray = this.getReverseTxPortList(portModel, list);
        if (this.portOutComboModel.getSize() != 0 && portModelArray.length > 0) {
            this.portOutCB.setSelectedItem(portModelArray[0]);
        }
        this.portOutCB.setEnabled(this.portOutComboModel.getSize() > 1);
    }

    private List<DwdmSide.SideEnum> filterOutSideInUse() {
        ArrayList<DwdmSide.SideEnum> arrayList = new ArrayList<DwdmSide.SideEnum>(DwdmSide.getSideEnumList());
        ISideModel[] iSideModelArray = this.smod.getSides();
        for (int i = 0; i < iSideModelArray.length; ++i) {
            if (iSideModelArray[i].getId() == 0) continue;
            DwdmSide.SideEnum sideEnum = DwdmSide.getValue(iSideModelArray[i].getId());
            arrayList.remove(sideEnum);
        }
        return arrayList;
    }

    private PortModel[] getReverseTxPortList(PortModel portModel, List<PortModel> list) {
        Object object;
        block5: {
            if (portModel instanceof IOpticsPortModel) {
                try {
                    object = ((IOpticsPortModel)portModel).getReversePortModels();
                    if (((IEntityModel[])object).length > 0) {
                        return SideCreationDialog.toPortModel((IEntityModel[])object);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        object = new ArrayList<PortModel>(list);
        if (portModel == null) {
            return new PortModel[0];
        }
        this.filterTxPortOnSameUnitAsRxPort((List<PortModel>)object, portModel);
        return object.toArray(new PortModel[0]);
    }

    private void filterTxPortOnSameUnitAsRxPort(List<PortModel> list, PortModel portModel) {
        int n = list.size();
        if (this.isInseparableCard(portModel)) {
            int n2 = portModel.getShelfId();
            int n3 = portModel.getSlot();
            for (int i = n - 1; i >= 0; --i) {
                if (list.get(i).getShelfId() != n2) {
                    list.remove(i);
                    continue;
                }
                if (list.get(i).getSlot() == n3) continue;
                list.remove(i);
            }
        }
    }

    private boolean isInseparableCard(PortModel portModel) {
        boolean bl = false;
        switch (portModel.getModuleModel().getEqType()) {
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static PortModel[] toPortModel(IEntityModel[] iEntityModelArray) {
        PortModel[] portModelArray = new PortModel[iEntityModelArray.length];
        int n = 0;
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            if (!(iEntityModelArray[i] instanceof PortModel)) continue;
            portModelArray[n++] = (PortModel)iEntityModelArray[i];
        }
        return portModelArray;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (db.on()) {
            db.println(this.getClass().toString() + " actionPerformed");
        }
        Object object = actionEvent.getSource();
        db.fine("actionPerformed from " + object);
        if (object == this.okButton) {
            this.ok();
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    public void dispose() {
        this.unRegForEvent();
        super.dispose();
    }

    private void regForEvent() {
        if (this.nm != null && this.smod != null) {
            this.smod.addObserver(this);
        }
    }

    private void unRegForEvent() {
        if (this.nm != null && this.smod != null) {
            this.smod.deleteObserver(this);
        }
    }

    protected JButton makeActionButton(String string) {
        if (db.on()) {
            db.println(this.getClass().toString() + " makeActionButton");
        }
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected void ok() {
        if (db.on()) {
            db.println(this.getClass().toString() + " ok");
        }
        DwdmSide.SideEnum sideEnum = (DwdmSide.SideEnum)this.sideIdCB.getSelectedItem();
        IEntityModel iEntityModel = (IEntityModel)this.portInCB.getSelectedItem();
        IEntityModel iEntityModel2 = (IEntityModel)this.portOutCB.getSelectedItem();
        try {
            this.smod.addSide(sideEnum.toInt(), iEntityModel.getEntityIndex(), iEntityModel2.getEntityIndex());
            this.dispose();
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_NO_SUCHINTERFACE, "Either the port " + this.getPosition((PortModel)iEntityModel) + " or  the port " + this.getPosition((PortModel)iEntityModel2) + " is not present.");
        }
        catch (PortUsedBySide portUsedBySide) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)portUsedBySide);
            }
            String string = "N/A";
            try {
                string = this.getPosition((PortModel)this.nm.getEntityTableModel().getEntityModelByIndex(portUsedBySide.getPortBusy()));
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.info(abstractCmsNoSuchEntityException.getMessage());
            }
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_PORT_USED_BY_SIDE, "The port " + string + " is already used by a side.");
        }
        catch (PortIsConnected portIsConnected) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)portIsConnected);
            }
            String string = "N/A";
            try {
                string = this.getPosition((PortModel)this.nm.getEntityTableModel().getEntityModelByIndex(portIsConnected.getConnectedPort()));
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.info(abstractCmsNoSuchEntityException.getMessage());
            }
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_PORT_IS_CONNECTED, "The port " + string + " is already connected to a virtual link.");
        }
        catch (InvalidPortsForSide invalidPortsForSide) {
            if (db.on()) {
                db.println("It is not possible to associate the side " + sideEnum + " to the ports: \n" + "Line In : " + this.getPosition((PortModel)iEntityModel) + "\nLine Out : " + this.getPosition((PortModel)iEntityModel2) + "\n" + invalidPortsForSide.getMessage());
            }
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_INVALID_PORTS_FOR_SIDE, "It is not possible to associate the side " + sideEnum + " to the ports: \n" + "Line In : " + this.getPosition((PortModel)iEntityModel) + "\nLine Out : " + this.getPosition((PortModel)iEntityModel2));
        }
        catch (WrongNodeSide wrongNodeSide) {
            if (db.on()) {
                db.println("The creation of the side " + sideEnum + " failed:\n" + wrongNodeSide.getMessage());
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_WRONG_NODE_SIDE, (Object)("The creation of the side " + sideEnum + " failed."));
        }
        catch (SideInUse sideInUse) {
            if (db.on()) {
                db.println("The side " + sideEnum + " is already in use. \n" + sideInUse.getMessage());
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SIDE_IN_USE, (Object)("The side " + sideEnum + " is already in use."));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            CerentDialog.errorDialog((Component)((Object)this), (String)userException.getMessage(), (String)"Error");
        }
    }

    private boolean isPortRX(PortModel portModel) {
        if (db.on()) {
            db.println(this.getClass().toString() + " isPortRX");
        }
        if (portModel instanceof OpticsPortModel) {
            return ((OpticsPortModel)portModel).isOptPortTypeRX();
        }
        return false;
    }

    private boolean isPortTX(PortModel portModel) {
        if (db.on()) {
            db.println(this.getClass().toString() + " isPortTX");
        }
        if (portModel instanceof OpticsPortModel) {
            return ((OpticsPortModel)portModel).isOptPortTypeTX();
        }
        return false;
    }

    protected List<List<PortModel>> getAvailablePortsByType() {
        Serializable serializable;
        if (db.on()) {
            db.println(this.getClass().toString() + " getAvailablePortsByType");
        }
        IEntityModel[] iEntityModelArray = null;
        ArrayList<ArrayList<List<PortModel>>> arrayList = new ArrayList<ArrayList<List<PortModel>>>();
        ArrayList<ArrayList<List<PortModel>>> arrayList2 = new ArrayList<ArrayList<List<PortModel>>>();
        try {
            iEntityModelArray = this.smod.getAvailablePorts();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            CerentDialog.errorDialog((Component)((Object)this), (String)abstractCmsIOException.getMessage(), (String)"Error");
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            CerentDialog.errorDialog((Component)((Object)this), (String)abstractCmsNoSuchEntityException.getMessage(), (String)"Error");
        }
        catch (UserException userException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            CerentDialog.errorDialog((Component)((Object)this), (String)userException.getMessage(), (String)"Error");
        }
        if (iEntityModelArray != null) {
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                serializable = (PortModel)iEntityModelArray[i];
                if (this.isPortRX((PortModel)serializable)) {
                    arrayList.add((ArrayList<List<PortModel>>)serializable);
                    continue;
                }
                if (!this.isPortTX((PortModel)serializable)) continue;
                arrayList2.add((ArrayList<List<PortModel>>)serializable);
            }
        }
        serializable = new ArrayList<ArrayList<ArrayList<List<PortModel>>>>();
        serializable.add(arrayList);
        serializable.add(arrayList2);
        return serializable;
    }

    private void printAllAvailablePorts() {
        if (this.allAvailablePorts != null) {
            List<PortModel> list = this.allAvailablePorts.get(0);
            db.println("Line In");
            for (int i = 0; i < list.size(); ++i) {
                db.println(this.getPosition(list.get(i)));
            }
            List<PortModel> list2 = this.allAvailablePorts.get(1);
            db.println("Line Out");
            for (int i = 0; i < list2.size(); ++i) {
                db.println(this.getPosition(list2.get(i)));
            }
        }
    }

    private String getPosition(PortModel portModel) {
        return this.ecr.getFullPortString(portModel, false);
    }

    private void enableOKButton() {
        this.okButton.setEnabled(this.sideIdCB.isEnabled() && this.portInCB.isEnabled() && (this.portOutCB.getModel().getSize() == 1 || this.portOutCB.isEnabled()));
    }

    protected void initContentPane(JPanel jPanel, Object object) {
    }

    @Override
    public void update(Observable observable, Object object) {
        this.allAvailablePorts = this.getAvailablePortsByType();
        if (db.on()) {
            this.printAllAvailablePorts();
        }
        this.fillInSideIdCB();
        this.fillInPortInCB();
        this.fillInPortOutCB();
        this.enableOKButton();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (SideCreationDialog.db.on) {
            db.println("------------------------------------");
            db.println(itemEvent.paramString());
            db.println("------------------------------------");
        }
        if (object == this.portInCB && itemEvent.getStateChange() == 2) {
            this.fillInPortOutCB();
            this.enableOKButton();
        }
    }

    private class ComboBoxCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = "";
            if (object instanceof IEntityModel) {
                string = SideCreationDialog.this.getPosition((PortModel)object);
            } else if (object instanceof DwdmSide.SideEnum) {
                string = ((DwdmSide.SideEnum)object).toString();
            }
            this.setText(string);
            Color color = new Color(205, 205, 255);
            this.setBackground(bl ? color : Color.white);
            this.setForeground(Color.black);
            return this;
        }
    }
}

