/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.SideModel;
import cerent.cms.model.SideModels;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class SideDataSource
extends AbstractRowDataSource
implements Observer {
    private static final SDebug db = new SDebug("SideDataSource");
    private SideModels sideM;
    private INodeModel nm;
    private ArrayList rows = new ArrayList();

    public SideDataSource(SideModels sideModels) {
        this.sideM = sideModels;
        this.nm = sideModels.getNodeModel();
        if (this.nm != null && this.sideM != null) {
            this.sideM.addObserver(this);
        }
    }

    public void removeObserver() {
        if (this.nm != null && this.sideM != null) {
            this.sideM.deleteObserver(this);
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.rows.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection getAllObjects() {
        return new ArrayList(this.rows);
    }

    public void changed() {
        this.fireDataSourceChanged();
    }

    @Override
    public void update(Observable observable, Object object) {
        block3: {
            try {
                if (observable instanceof SideModel || observable instanceof SideModels) {
                    this.refresh();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("update(): exception" + exception);
            }
        }
    }

    public void refresh() {
        try {
            this.deleteAll();
            ISideModel[] iSideModelArray = this.sideM.getSides();
            for (int i = 0; i < iSideModelArray.length; ++i) {
                this.rows.add(iSideModelArray[i]);
                ((SideModel)iSideModelArray[i]).addObserver(this);
            }
            this.changed();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("SideDataSource refresh() " + abstractCmsIOException.getMessage());
        }
    }

    private void deleteAll() {
        for (int i = 0; i < this.rows.size(); ++i) {
            ((SideModel)this.rows.get(i)).deleteObserver(this);
        }
        this.rows.clear();
    }
}

