/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.eProtectionState;
import cerent.cms.idl.Equipment.eProtectionType;
import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.idl.SonetTopology.eProtectionOp;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AlreadyLocked;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.Busy;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.DuplexLocked;
import cerent.cms.model.DuplexUnlocked;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ForceToPrimaryNotAllowed;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IProtectedModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.InvalidState;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectActive;
import cerent.cms.model.ProtectFailedOrMissing;
import cerent.cms.model.ProtectLocked;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WorkingFailedOrMissing;
import cerent.cms.model.WorkingLocked;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.YCableModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.PgComparator;
import cerent.cms.ui.shelf.PgListCellRenderer;
import cerent.cms.ui.shelf.PgMemberCellRenderer;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SmpProtectionPane
extends ObserverPane
implements ActionListener,
ListSelectionListener {
    public static final String OPERATION = "Operation: ";
    public static final String APPLY = "Apply";
    public static final Attribute MANUAL = new Attribute("Manual", 0);
    public static final Attribute FORCE = new Attribute("Force", 1);
    private static final String ATTR = "attribute";
    private DefaultListModel pgListModel;
    private DefaultListModel pgMembersModel;
    protected JList pgList;
    protected JList pgMembers;
    protected JComboBox operationCB;
    protected JButton clearPB;
    protected JButton switchPB;
    protected JButton forcePB;
    protected JButton unlockPB;
    protected JButton lockoutPB;
    protected JButton lockonPB;
    protected JPanel membersPanel;
    protected GridBagPanel buttonBar;
    protected AttributeMaps attrMap;
    public Attribute CLEAR;
    public Attribute SWITCH;
    public Attribute UNLOCK;
    public Attribute LOCKOUT;
    public Attribute LOCKON;
    private JPanel warningPanel;
    static final int NONE = 0;
    static final int MODULE = 1;
    static final int ELEMENT = 2;
    protected int opTargetType;
    protected Object opTarget;
    List obsContainers;
    List obsGroups;
    List obsMembers;
    boolean neverEntered = true;
    NodeModelDelegate nodeModel = null;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpProtectionPane");

    public SmpProtectionPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDataSourceControl(new InnerDsc());
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.attrMap = ElementDefaults.getAttributeMap(this.nodeModel);
        this.CLEAR = this.attrMap.getAttributeForVal("moduleOp", 1);
        this.SWITCH = this.attrMap.getAttributeForVal("moduleOp", 4);
        this.UNLOCK = this.attrMap.getAttributeForVal("moduleOp", 7);
        this.LOCKOUT = this.attrMap.getAttributeForVal("moduleOp", 2);
        this.LOCKON = this.attrMap.getAttributeForVal("moduleOp", 3);
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.obsContainers = new ArrayList(2);
        this.obsContainers.add(this.nodeModel.getProtectionGroupModels());
        this.obsContainers.add(this.nodeModel.getElementModelsDelegate());
        GridBagPanel gridBagPanel = new GridBagPanel();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Protection Groups"));
        jPanel.setLayout(new BorderLayout());
        this.pgListModel = new DefaultListModel();
        this.pgList = new JList(this.pgListModel);
        this.pgList.setName("Protection Groups");
        this.pgList.setCellRenderer(new PgListCellRenderer());
        this.pgList.setSelectionMode(0);
        this.pgList.setVisibleRowCount(6);
        this.pgList.addListSelectionListener(this);
        jPanel.add((Component)new UScrollPane((Component)this.pgList), "Center");
        gridBagPanel.fillBoth(40, 100);
        gridBagPanel.add((Component)jPanel, 0, 0);
        this.membersPanel = new JPanel();
        this.membersPanel.setBorder(BorderFactory.createTitledBorder("Selected Group"));
        this.membersPanel.setLayout(new BorderLayout(5, 5));
        this.pgMembersModel = new DefaultListModel();
        this.pgMembers = new JList(this.pgMembersModel);
        this.pgMembers.setName("Selected Group");
        this.pgMembers.setCellRenderer(new PgMemberCellRenderer());
        this.pgMembers.setSelectionMode(0);
        this.pgMembers.setVisibleRowCount(6);
        this.pgMembers.addListSelectionListener(this);
        this.membersPanel.add((Component)new UScrollPane((Component)this.pgMembers), "Center");
        this.buttonBar = this.getButtonBar();
        gridBagPanel.add((Component)this.membersPanel, 1, 0);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.add(gridBagPanel);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        jPanel3.add(new CSHelpButton(CSHelpConst.SmpProtectionPane));
        this.setLayout(new BorderLayout());
        this.add(jPanel2, "Center");
        this.add(jPanel3, "South");
        if (this.nodeModel.getPlatform().is327()) {
            this.warningPanel = new JPanel(new GridLayout(0, 1));
            this.warningPanel.add(new JLabel("WARNING: Only common ports will be protected"));
            this.warningPanel.add(new JLabel("if mismatching XTC cards are used."));
            this.membersPanel.add((Component)this.warningPanel, "North");
            this.warningPanel.setVisible(false);
        }
        if (db.on()) {
            db.println("init: finish");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            Object object = listSelectionEvent.getSource();
            if (object == this.pgList) {
                if (SmpProtectionPane.db.on) {
                    db.println("valueChanged: pgList");
                }
                this.setSelectedModel(this.pgList.getSelectedValue());
            } else if (object == this.pgMembers) {
                if (SmpProtectionPane.db.on) {
                    db.println("valueChanged: pgMembers");
                }
                this.enableButtons(this.pgMembers.getSelectedValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedModel(Object object) {
        Serializable serializable;
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (object == null) {
            if (db.on()) {
                db.println("setSelectedModel: model is null");
            }
            serializable = this.pgMembersModel;
            synchronized (serializable) {
                this.pgMembersModel.setSize(0);
            }
            this.setOpTargetType(0);
        } else if (object instanceof ProtectionGroupModel) {
            if (db.on()) {
                db.println("setSelectedModel: model is a PG");
            }
            serializable = (ProtectionGroupModel)object;
            ModuleModel[] moduleModelArray = (ModuleModel[])((ProtectionGroupModel)serializable).getMainModuleModels();
            for (int i = 0; i < moduleModelArray.length; ++i) {
                arrayList.add(moduleModelArray[i]);
            }
            IModuleModel iModuleModel = ((ProtectionGroupModel)serializable).getProtectModuleModel();
            arrayList.add(iModuleModel);
            Object object2 = this.pgMembersModel;
            synchronized (object2) {
                this.pgMembersModel.setSize(moduleModelArray.length + 1);
                this.pgMembersModel.setElementAt(iModuleModel, 0);
                for (int i = 0; i < moduleModelArray.length; ++i) {
                    this.pgMembersModel.setElementAt(moduleModelArray[i], i + 1);
                }
            }
            this.setOpTargetType(1);
            if (this.warningPanel != null && ((String)(object2 = ((ProtectionGroupModel)serializable).getName())).equals("XTCPROTGRP")) {
                String string = ((ModuleModel)iModuleModel).getMfgData().name;
                for (int i = 0; i < moduleModelArray.length; ++i) {
                    if (moduleModelArray[i] == null || moduleModelArray[i].getMfgData().name.equals(string)) continue;
                    bl = true;
                    break;
                }
            }
        } else if (object instanceof OnePlusOneModel) {
            block53: {
                db.fine("setSelectedModel: model is a 1+1");
                serializable = (OnePlusOneModel)object;
                InterfaceModels interfaceModels = this.nodeModel.getIfModels();
                try {
                    InterfaceModel interfaceModel = interfaceModels.getInterfaceModel((PortModel)((ElementModel)serializable).getMainEntityModel());
                    InterfaceModel interfaceModel2 = interfaceModels.getInterfaceModel((PortModel)((ElementModel)serializable).getProtectEntityModel());
                    DefaultListModel defaultListModel = this.pgMembersModel;
                    synchronized (defaultListModel) {
                        this.pgMembersModel.setSize(2);
                        this.pgMembersModel.setElementAt(interfaceModel2, 0);
                        this.pgMembersModel.setElementAt(interfaceModel, 1);
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    DefaultListModel defaultListModel = this.pgMembersModel;
                    synchronized (defaultListModel) {
                        this.pgMembersModel.setSize(0);
                    }
                    if (db.on()) {
                        db.println("AbstractCmsIOException for 1+1");
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    DefaultListModel defaultListModel = this.pgMembersModel;
                    synchronized (defaultListModel) {
                        this.pgMembersModel.setSize(0);
                    }
                    if (!db.on()) break block53;
                    db.println("AbstractCmsNoSuchEntityException for 1+1");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            this.opTarget = serializable;
            this.setOpTargetType(2);
        } else if (object instanceof YCableModel) {
            block54: {
                db.fine("setSelectedModel: model is a Y Cable");
                serializable = (YCableModel)object;
                InterfaceModels interfaceModels = this.nodeModel.getIfModels();
                try {
                    Serializable serializable2;
                    InterfaceModel interfaceModel = interfaceModels.getInterfaceModel((PortModel)((YCableModel)serializable).getMainEntityModel());
                    InterfaceModel interfaceModel3 = interfaceModels.getInterfaceModel((PortModel)((YCableModel)serializable).getProtectEntityModel());
                    if (interfaceModel instanceof AbstractDwdmLineModel) {
                        serializable2 = ((AbstractDwdmLineModel)interfaceModel).getPayloadModel();
                        arrayList.add(serializable2);
                    }
                    if (interfaceModel3 instanceof AbstractDwdmLineModel) {
                        serializable2 = ((AbstractDwdmLineModel)interfaceModel3).getPayloadModel();
                        arrayList.add(serializable2);
                    }
                    serializable2 = this.pgMembersModel;
                    synchronized (serializable2) {
                        this.pgMembersModel.setSize(2);
                        this.pgMembersModel.setElementAt(interfaceModel3, 0);
                        this.pgMembersModel.setElementAt(interfaceModel, 1);
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    DefaultListModel defaultListModel = this.pgMembersModel;
                    synchronized (defaultListModel) {
                        this.pgMembersModel.setSize(0);
                    }
                    if (db.on()) {
                        db.println("AbstractCmsIOException for YCable");
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    DefaultListModel defaultListModel = this.pgMembersModel;
                    synchronized (defaultListModel) {
                        this.pgMembersModel.setSize(0);
                    }
                    if (!db.on()) break block54;
                    db.println("AbstractCmsNoSuchEntityException for YCable");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            this.opTarget = serializable;
            this.setOpTargetType(2);
        } else {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNEXPECTED_MODEL_CLASS_PARAM_1, object.getClass());
        }
        this.enableButtons(this.pgMembers.getSelectedValue());
        serializable = this.pgMembersModel;
        synchronized (serializable) {
            this.obsMembers = Arrays.asList(this.pgMembersModel.toArray());
        }
        serializable = new ArrayList(this.obsContainers.size() + this.obsGroups.size() + this.obsMembers.size() + arrayList.size());
        serializable.addAll(this.obsContainers);
        serializable.addAll(this.obsGroups);
        serializable.addAll(this.obsMembers);
        serializable.addAll(arrayList);
        this.getObservableManager().setObservable(serializable.toArray(new Observable[0]));
        if (this.warningPanel != null) {
            this.warningPanel.setVisible(bl);
            this.membersPanel.revalidate();
        }
    }

    protected void setOpTargetType(int n) {
        if (this.opTargetType != n) {
            if (n == 0) {
                this.membersPanel.remove(this.buttonBar);
            } else {
                this.membersPanel.add((Component)this.buttonBar, "South");
                if (n == 1) {
                    this.setButtonAttribute(this.switchPB, this.SWITCH);
                    this.forcePB.setVisible(false);
                } else if (n == 2) {
                    this.setButtonAttribute(this.switchPB, MANUAL);
                    this.forcePB.setVisible(true);
                }
            }
            this.opTargetType = n;
            this.membersPanel.revalidate();
        }
    }

    private void disableButtons() {
        this.clearPB.setEnabled(false);
        this.switchPB.setEnabled(false);
        this.forcePB.setEnabled(false);
        this.unlockPB.setEnabled(false);
        this.lockoutPB.setEnabled(false);
        this.lockonPB.setEnabled(false);
    }

    private boolean isNormal(eProtectionState eProtectionState2) {
        return eProtectionState2 == eProtectionState.NORMAL;
    }

    private boolean isLockedOn(eProtectionState eProtectionState2) {
        return eProtectionState2 == eProtectionState.LOCKED_ON;
    }

    private boolean isLockedOut(eProtectionState eProtectionState2) {
        return eProtectionState2 == eProtectionState.LOCKED_OUT;
    }

    private boolean isLocked(eProtectionState eProtectionState2) {
        return this.isLockedOn(eProtectionState2) || this.isLockedOut(eProtectionState2);
    }

    private boolean isSwitching(eProtectionState eProtectionState2) {
        return eProtectionState2 == eProtectionState.SWITCHING;
    }

    private void enableButtonsForModule(ModuleModel moduleModel) {
        int n;
        this.opTarget = moduleModel;
        ProtectionGroupModel protectionGroupModel = moduleModel.getProtectionGroupModel();
        if (protectionGroupModel == null) {
            this.disableButtons();
            return;
        }
        int n2 = this.pgMembersModel.getSize();
        if (n2 <= 1) {
            this.disableButtons();
            return;
        }
        eProtectionType eProtectionType2 = protectionGroupModel.getProtectType();
        IModuleModel iModuleModel = protectionGroupModel.getProtectModuleModel();
        eEqState eEqState2 = moduleModel.getState();
        boolean bl = eEqState2 == eEqState.STANDBY;
        boolean bl2 = eEqState2 == eEqState.ACTIVE;
        boolean bl3 = this.opTarget == iModuleModel;
        eProtectionState eProtectionState2 = moduleModel.getProtectionState();
        boolean bl4 = this.isLocked(eProtectionState2);
        ModuleModel[] moduleModelArray = new ModuleModel[n2 - 1];
        boolean[] blArray = new boolean[n2 - 1];
        boolean[] blArray2 = new boolean[n2 - 1];
        boolean[] blArray3 = new boolean[n2 - 1];
        eProtectionState[] eProtectionStateArray = new eProtectionState[n2 - 1];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            ModuleModel moduleModel2 = (ModuleModel)this.pgMembersModel.getElementAt(n);
            if (moduleModel2 == null) {
                this.disableButtons();
                return;
            }
            if (moduleModel == moduleModel2) continue;
            eEqState eEqState3 = moduleModel2.getState();
            moduleModelArray[n3] = moduleModel2;
            blArray[n3] = moduleModel2 == iModuleModel;
            blArray2[n3] = eEqState3 == eEqState.STANDBY;
            blArray3[n3] = eEqState3 == eEqState.ACTIVE;
            eProtectionStateArray[n3] = moduleModel2.getProtectionState();
            ++n3;
        }
        if (db.on()) {
            for (n = 0; n < moduleModelArray.length; ++n) {
                db.println("Other member is: " + moduleModelArray[n] + " and protect=" + blArray[n] + " and " + "standby=" + blArray2[n] + " and " + "active= " + blArray3[n] + " and state=" + eProtectionStateArray[n]);
            }
        }
        this.clearPB.setEnabled(!this.isNormal(eProtectionState2) && !bl4 && !this.isSwitching(eProtectionState2));
        if (bl2 || bl) {
            this.unlockPB.setEnabled(bl4);
        } else {
            this.unlockPB.setEnabled(false);
        }
        this.switchPB.setEnabled(this.isNormal(eProtectionState2) && !bl4 && bl2);
        n = 1;
        boolean bl5 = true;
        if (this.isSwitching(eProtectionState2)) {
            n = 0;
            bl5 = false;
        } else if (bl3) {
            if (bl) {
                if (eProtectionType2 == eProtectionType.ONE_FOR_ONE && !bl4) {
                    for (int i = 0; i < eProtectionStateArray.length; ++i) {
                        if (!this.isLocked(eProtectionStateArray[i])) continue;
                        n = 0;
                        break;
                    }
                } else {
                    n = 0;
                }
                bl5 = !bl4;
            } else if (bl2) {
                n = !bl4 ? 1 : 0;
                boolean bl6 = bl5 = !bl4;
                if (bl5 || this.switchPB.isEnabled()) {
                    for (int i = 0; i < eProtectionStateArray.length; ++i) {
                        if (blArray[i] || !blArray2[i] || !this.isLockedOut(eProtectionStateArray[i])) continue;
                        bl5 = false;
                        this.switchPB.setEnabled(false);
                        break;
                    }
                }
            } else {
                n = 0;
                bl5 = false;
            }
        } else if (bl2) {
            n = !bl4 ? 1 : 0;
            boolean bl7 = bl5 = !bl4;
            if (bl5) {
                for (int i = 0; i < eProtectionStateArray.length; ++i) {
                    if (blArray[i] && this.isLockedOut(eProtectionStateArray[i])) {
                        bl5 = false;
                        break;
                    }
                    if (!blArray[i] || !blArray3[i]) continue;
                    bl5 = false;
                    break;
                }
            }
            if (this.switchPB.isEnabled()) {
                for (int i = 0; i < eProtectionStateArray.length; ++i) {
                    if (blArray[i] && blArray3[i]) {
                        this.switchPB.setEnabled(false);
                    } else {
                        if ((!blArray[i] || !this.isLockedOn(eProtectionStateArray[i])) && !this.isLockedOut(eProtectionStateArray[i])) continue;
                        this.switchPB.setEnabled(false);
                    }
                    break;
                }
            }
        } else if (bl) {
            n = !bl4 ? 1 : 0;
            boolean bl8 = bl5 = !bl4;
            if (!bl4) {
                for (int i = 0; i < eProtectionStateArray.length; ++i) {
                    if (!blArray[i] || !blArray3[i]) continue;
                    if (this.isLockedOn(eProtectionStateArray[i])) {
                        n = 0;
                    }
                    if (this.isLockedOut(eProtectionStateArray[i])) {
                        bl5 = false;
                    }
                    break;
                }
            }
        } else {
            n = 0;
            bl5 = false;
        }
        this.lockoutPB.setEnabled(bl5);
        this.lockonPB.setEnabled(n != 0);
    }

    private void enableButtonsForElement() {
        eProtectionOp eProtectionOp2 = null;
        IProtectedModel iProtectedModel = null;
        if (!(this.opTarget instanceof IProtectedModel)) {
            db.severe("ERROR in SmpProtectionPane.java");
            return;
        }
        iProtectedModel = (IProtectedModel)this.opTarget;
        eProtectionOp2 = iProtectedModel.getProtectionOp();
        boolean bl = this.pgMembers.getSelectedIndex() == 1;
        boolean bl2 = eProtectionOp2 == eProtectionOp.LOCKOUT_OF_PROTECTION || eProtectionOp2 == eProtectionOp.LOCKOUT_OF_WORKING;
        boolean bl3 = eProtectionOp2 == eProtectionOp.FORCE_SWITCH_TO_WORKING || eProtectionOp2 == eProtectionOp.FORCE_SWITCH_TO_PROTECT;
        boolean bl4 = eProtectionOp2 == eProtectionOp.MANUAL_SWITCH_TO_WORKING || eProtectionOp2 == eProtectionOp.MANUAL_SWITCH_TO_PROTECT;
        boolean bl5 = eProtectionOp2 == eProtectionOp.CLEAR || eProtectionOp2 == eProtectionOp.APS_CLEAR;
        this.clearPB.setEnabled(eProtectionOp2 != eProtectionOp.CLEAR && !bl2);
        this.switchPB.setEnabled(!this.isOnePlusOneOpt(this.opTarget) && bl5);
        this.forcePB.setEnabled(bl5 || bl4);
        this.unlockPB.setEnabled(bl2);
        if (iProtectedModel.supportsLockoutOfWorking()) {
            this.lockoutPB.setEnabled(!bl2);
            this.lockonPB.setEnabled(false);
        } else {
            this.lockoutPB.setEnabled(!bl && !bl2);
            this.lockonPB.setEnabled(bl && !bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableButtons(Object object) {
        block16: {
            Object object2;
            Object e;
            block15: {
                e = this.pgList.getSelectedValue();
                if (e instanceof OnePlusOneModel) {
                    object2 = (OnePlusOneModel)e;
                    try {
                        if (((ElementModel)object2).getProtectEntityModel().getModuleModel().isPreProvisioned() && this.nodeModel.getEntityTableModel().getEntityModelByIndex(((OnePlusOneModel)object2).getWorkingEntityIndex()).getModuleModel().isPreProvisioned()) {
                            object = null;
                        }
                        if (db.on()) {
                            db.println("Disabling all buttons when both working and protection cards are pre provisioned");
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!db.on()) break block15;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            }
            if (e instanceof ProtectionGroupModel && this.nodeModel.getPlatform().is327() && ((String)(object2 = ((ProtectionGroupModel)e).getName())).equals("XTCPROTGRP")) {
                object = null;
            }
            try {
                if (object == null || !this.isUserAuthorized()) {
                    this.disableButtons();
                    break block16;
                }
                if (this.opTargetType == 1) {
                    object2 = this.pgMembersModel;
                    synchronized (object2) {
                        this.enableButtonsForModule((ModuleModel)object);
                        break block16;
                    }
                }
                if (this.opTargetType == 2) {
                    this.enableButtonsForElement();
                }
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                }
                this.disableButtons();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        boolean bl = false;
        boolean bl2 = false;
        eProtectionOp eProtectionOp2 = null;
        Object var6_6 = null;
        String string = "Traffic might not switch away from this line.  Verify\nthe proper switch of traffic prior to performing potentially\nservice affecting work on this line.\n\nIs it OK to continue?\n";
        String string2 = "The switch failed because the protect card is already active.\n";
        if (db.on()) {
            db.println("actionPerformed: " + ((Component)object).getName());
        }
        try {
            Attribute attribute = (Attribute)((JButton)object).getClientProperty(ATTR);
            if (this.opTargetType == 2 && (attribute == MANUAL || attribute == FORCE)) {
                bl = true;
            }
            if (attribute != null) {
                Object object2;
                eProtectionOp2 = this.getProtectionOp(attribute, this.opTarget);
                if (this.opTarget instanceof OnePlusOneModel) {
                    boolean bl3;
                    object2 = (TdmPortModel)((OnePlusOneModel)this.opTarget).getProtectEntityModel();
                    TdmLineModel tdmLineModel = ((TdmPortModel)object2).getTdmLineModel();
                    boolean bl4 = tdmLineModel.isCurrentlyActive();
                    boolean bl5 = bl3 = !bl4;
                    bl2 = (eProtectionOp2 == eProtectionOp.MANUAL_SWITCH_TO_PROTECT || eProtectionOp2 == eProtectionOp.FORCE_SWITCH_TO_PROTECT) && bl4 || (eProtectionOp2 == eProtectionOp.MANUAL_SWITCH_TO_WORKING || eProtectionOp2 == eProtectionOp.FORCE_SWITCH_TO_WORKING) && bl3 ? CerentDialog.yesNoDialog((Component)((Object)this), (String)("The line targeted for this switch request is already\nactive.  The switch request can be applied, but\ntraffic will not switch at this time.\n\nContinue to apply " + attribute + " switch?\n"), (String)("Confirm " + attribute + " Operation")) : (bl ? CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)("Confirm " + attribute + " Operation")) : CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure?", (String)("Confirm " + attribute + " Operation")));
                } else {
                    bl2 = bl ? CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)("Confirm " + attribute + " Operation")) : CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure?", (String)("Confirm " + attribute + " Operation"));
                }
                if (bl2) {
                    if (this.opTargetType == 1) {
                        object2 = eModuleOp.from_int(attribute.getIntValue());
                        ((ModuleModel)this.opTarget).doCommand((eModuleOp)object2);
                    } else if (this.opTargetType == 2 && this.opTarget instanceof IProtectedModel) {
                        ((IProtectedModel)this.opTarget).setProtectionOp(eProtectionOp2);
                    }
                }
            }
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.UNABLE_PROTECTION_SWITCH, EMC.EID_UNABLE_TO_SWITCH.getMessage());
        }
        catch (ForceToPrimaryNotAllowed forceToPrimaryNotAllowed) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNABLE_TO_SWITCH_TO_PRIMARY);
        }
        catch (InternalCommError internalCommError) {
            SDebug.printStackTrace((Throwable)internalCommError);
            String string3 = "protect";
            if (this.opTarget instanceof OnePlusOneModel) {
                string3 = this.getXConnCardName((OnePlusOneModel)this.opTarget);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_APPLY_FORCE_OPERATION_PARAM_1, (Object)string3);
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "A provisioning error occurred.");
        }
        catch (ProtectActive protectActive) {
            SDebug.printStackTrace((Throwable)protectActive);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The protect entity is active.");
        }
        catch (Busy busy) {
            SDebug.printStackTrace((Throwable)busy);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "A previous operation is still in progress.");
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The protection group is being removed.");
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "An interface is missing.");
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The wrong interface type was found.");
        }
        catch (UnsupportedOperation unsupportedOperation) {
            SDebug.printStackTrace((Throwable)unsupportedOperation);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The unsupported operation was found.");
        }
        catch (ProtectFailedOrMissing protectFailedOrMissing) {
            SDebug.printStackTrace((Throwable)protectFailedOrMissing);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The protect entity failed or is missing.");
        }
        catch (WorkingFailedOrMissing workingFailedOrMissing) {
            SDebug.printStackTrace((Throwable)workingFailedOrMissing);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The working entity failed or is missing.");
        }
        catch (AlreadyLocked alreadyLocked) {
            SDebug.printStackTrace((Throwable)alreadyLocked);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The entity is already locked.");
        }
        catch (ProtectLocked protectLocked) {
            SDebug.printStackTrace((Throwable)protectLocked);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The protect entity is locked.");
        }
        catch (WorkingLocked workingLocked) {
            SDebug.printStackTrace((Throwable)workingLocked);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The working entity is locked.");
        }
        catch (InvalidState invalidState) {
            SDebug.printStackTrace((Throwable)invalidState);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The command failed because of an invalid state.");
        }
        catch (DuplexLocked duplexLocked) {
            SDebug.printStackTrace((Throwable)duplexLocked);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The duplex is locked.");
        }
        catch (DuplexUnlocked duplexUnlocked) {
            SDebug.printStackTrace((Throwable)duplexUnlocked);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, "The duplex is unlocked.");
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.finer("AbstractCmsIOException in actionPerformed() " + (Object)((Object)abstractCmsIOException));
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, (Exception)((Object)abstractCmsIOException));
        }
    }

    protected eProtectionOp getProtectionOp(Attribute attribute, Object object) {
        boolean bl;
        eProtectionOp eProtectionOp2 = eProtectionOp.CLEAR;
        boolean bl2 = bl = this.pgMembers.getSelectedIndex() == 1;
        if (attribute == this.CLEAR || attribute == this.UNLOCK) {
            eProtectionOp2 = eProtectionOp.CLEAR;
        } else if (attribute == MANUAL) {
            eProtectionOp2 = bl ? eProtectionOp.MANUAL_SWITCH_TO_PROTECT : eProtectionOp.MANUAL_SWITCH_TO_WORKING;
        } else if (attribute == FORCE) {
            eProtectionOp2 = bl ? eProtectionOp.FORCE_SWITCH_TO_PROTECT : eProtectionOp.FORCE_SWITCH_TO_WORKING;
        } else if (attribute == this.LOCKOUT) {
            eProtectionOp2 = this.isOnePlusOneOpt(object) ? eProtectionOp.LOCKOUT_OF_PROTECTION : (bl ? eProtectionOp.LOCKOUT_OF_WORKING : eProtectionOp.LOCKOUT_OF_PROTECTION);
        } else if (attribute == this.LOCKON) {
            eProtectionOp2 = bl ? eProtectionOp.LOCKOUT_OF_PROTECTION : eProtectionOp.LOCKOUT_OF_WORKING;
        }
        return eProtectionOp2;
    }

    private boolean isOnePlusOneOpt(Object object) {
        if (object instanceof OnePlusOneModel) {
            return ((OnePlusOneModel)object).getOnePlusOneType() == eOnePlusOneType.ONEPLUSONE_OPTIMIZED;
        }
        return false;
    }

    protected GridBagPanel getButtonBar() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.inset(5, 5);
        gridBagPanel.anchorEast();
        gridBagPanel.add("Switch Commands: ", 0, 0);
        gridBagPanel.anchorCenter();
        gridBagPanel.fillHorizontal();
        this.clearPB = this.makeActionButton(this.CLEAR);
        gridBagPanel.add((Component)this.clearPB, 1, 0);
        this.switchPB = this.makeActionButton(this.SWITCH);
        gridBagPanel.add((Component)this.switchPB, 2, 0);
        this.forcePB = this.makeActionButton(FORCE);
        gridBagPanel.add((Component)this.forcePB, 3, 0);
        gridBagPanel.fillNone();
        gridBagPanel.anchorEast();
        gridBagPanel.add("Inhibit Switching: ", 0, 1);
        gridBagPanel.anchorCenter();
        gridBagPanel.fillHorizontal();
        this.unlockPB = this.makeActionButton(this.UNLOCK);
        gridBagPanel.add((Component)this.unlockPB, 1, 1);
        this.lockoutPB = this.makeActionButton(this.LOCKOUT);
        gridBagPanel.add((Component)this.lockoutPB, 2, 1);
        this.lockonPB = this.makeActionButton(this.LOCKON);
        gridBagPanel.add((Component)this.lockonPB, 3, 1);
        return gridBagPanel;
    }

    private JButton makeActionButton(Attribute attribute) {
        JButton jButton = new JButton();
        this.setButtonAttribute(jButton, attribute);
        if (this.isUserAuthorized()) {
            jButton.addActionListener(this);
        } else {
            jButton.setEnabled(false);
        }
        return jButton;
    }

    private void setButtonAttribute(JButton jButton, Attribute attribute) {
        jButton.setText(attribute.toString());
        jButton.putClientProperty(ATTR, attribute);
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.buttonBar == null) {
            this.init();
        }
        super.enteringPage();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.requestRefresh(this, null);
    }

    private Collection filterForModule(Collection collection) {
        db.fine("filterForModule(" + collection + ")");
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        ModuleModel moduleModel = null;
        try {
            if (this.getUiModel() instanceof ModuleModel) {
                moduleModel = (ModuleModel)this.getUiModel();
            } else {
                return collection;
            }
            while (iterator.hasNext()) {
                try {
                    Model model;
                    Object e = iterator.next();
                    if (e instanceof ElementModel) {
                        model = (ElementModel)e;
                        if (!((ElementModel)model).getMainEntityModel().getModuleModel().equals(moduleModel) && !((ElementModel)model).getProtectEntityModel().getModuleModel().equals(moduleModel)) continue;
                        hashSet.add(e);
                        continue;
                    }
                    if (!(e instanceof ProtectionGroupModel)) continue;
                    model = (ProtectionGroupModel)e;
                    ModuleModel[] moduleModelArray = (ModuleModel[])((ProtectionGroupModel)model).getMainModuleModels();
                    ModuleModel moduleModel2 = (ModuleModel)((ProtectionGroupModel)model).getProtectModuleModel();
                    ArrayList<ModuleModel> arrayList = new ArrayList<ModuleModel>(Arrays.asList(moduleModelArray));
                    if (moduleModel2 != null) {
                        arrayList.add(moduleModel2);
                    }
                    if (!arrayList.contains(moduleModel)) continue;
                    hashSet.add(e);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) continue;
                    db.println("No such entity while filtering protection groups");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("error in filtering protection groups");
                SDebug.printStackTrace((Throwable)exception);
            }
            return collection;
        }
        db.fine("filterForModule() - > " + hashSet);
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection filterForChassis(Collection collection) {
        db.fine("filterForChassis(" + collection + ")");
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (!iChassisModel.getNodeModel().isMultishelf()) {
            db.fine("filterForChassis() -> " + collection);
            return collection;
        }
        HashSet<Model> hashSet = new HashSet<Model>();
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                try {
                    Model model;
                    Model model2 = (Model)iterator.next();
                    if (model2 instanceof ElementModel) {
                        model = (ElementModel)model2;
                        if (((EntityModel)((ElementModel)model).getMainEntityModel()).getChassis() != iChassisModel && ((EntityModel)((ElementModel)model).getProtectEntityModel()).getChassis() != iChassisModel) continue;
                        hashSet.add(model2);
                        continue;
                    }
                    if (!(model2 instanceof ProtectionGroupModel) || ((ModuleModel)((ProtectionGroupModel)(model = (ProtectionGroupModel)model2)).getProtectModuleModel()).getChassis() != iChassisModel) continue;
                    hashSet.add(model2);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException));
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        catch (Exception exception) {
            db.fine("Caught " + exception + "in filterForChassis");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return collection;
        }
        db.fine("filterForChassis() -> " + hashSet);
        return hashSet;
    }

    private String getXConnCardName(OnePlusOneModel onePlusOneModel) {
        String string;
        block5: {
            string = "cross-connect";
            try {
                IModuleModel iModuleModel = ((OnePlusOneModel)this.opTarget).getMainEntityModel().getModuleModel();
                if (iModuleModel.getEqType() == 273) {
                    string = iModuleModel.getEqLabel();
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return string;
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        public void refreshFromModel() {
            db.fine("refreshFromModel: start");
            ArrayList arrayList = new ArrayList();
            List<ProtectionGroupModel> list = Arrays.asList(SmpProtectionPane.this.nodeModel.getEntityTableModel().getProtectionGroupModelArray());
            db.fine("modelList is " + list);
            if (SmpProtectionPane.this.getUiModel() instanceof ModuleModel) {
                db.fine("filtering by module ...");
                arrayList.addAll(SmpProtectionPane.this.filterForModule(list));
            } else if (SmpProtectionPane.this.getUiModel() instanceof IChassisModel) {
                db.fine("filtering by chassis ...");
                arrayList.addAll(SmpProtectionPane.this.filterForChassis(list));
            }
            Set set = SmpProtectionPane.this.nodeModel.getElementModelsDelegate().getElementsOfType(1);
            db.fine("modelSet(1+1) is " + set);
            if (SmpProtectionPane.this.getUiModel() instanceof ModuleModel) {
                db.fine("filtering by module ...");
                arrayList.addAll(SmpProtectionPane.this.filterForModule(set));
            } else if (SmpProtectionPane.this.getUiModel() instanceof IChassisModel) {
                db.fine("filtering by chassis ...");
                arrayList.addAll(SmpProtectionPane.this.filterForChassis(set));
            }
            set = SmpProtectionPane.this.nodeModel.getElementModelsDelegate().getElementsOfType(4);
            db.fine("modelSet(Y) is " + set);
            if (SmpProtectionPane.this.getUiModel() instanceof ModuleModel) {
                db.fine("filtering by module ...");
                arrayList.addAll(SmpProtectionPane.this.filterForModule(set));
            } else if (SmpProtectionPane.this.getUiModel() instanceof IChassisModel) {
                db.fine("filtering by chassis ...");
                arrayList.addAll(SmpProtectionPane.this.filterForChassis(set));
            }
            set = SmpProtectionPane.this.nodeModel.getElementModelsDelegate().getElementsOfType(5);
            db.fine("modelSet(Sp) is " + set);
            if (SmpProtectionPane.this.getUiModel() instanceof ModuleModel) {
                db.fine("filtering by module ...");
                arrayList.addAll(SmpProtectionPane.this.filterForModule(set));
            } else if (SmpProtectionPane.this.getUiModel() instanceof IChassisModel) {
                db.fine("filtering by chassis ...");
                arrayList.addAll(SmpProtectionPane.this.filterForChassis(set));
            }
            set = SmpProtectionPane.this.nodeModel.getElementModelsDelegate().getElementsOfType(6);
            db.fine("modelSet(Sp) is " + set);
            if (SmpProtectionPane.this.getUiModel() instanceof ModuleModel) {
                db.fine("filtering by module ...");
                arrayList.addAll(SmpProtectionPane.this.filterForModule(set));
            } else if (SmpProtectionPane.this.getUiModel() instanceof IChassisModel) {
                db.fine("filtering by chassis ...");
                arrayList.addAll(SmpProtectionPane.this.filterForChassis(set));
            } else {
                arrayList.addAll(set);
            }
            Collections.sort(arrayList, new PgComparator());
            SmpProtectionPane.this.obsGroups = arrayList;
            SmpProtectionPane.this.pgListModel.setSize(arrayList.size());
            int n = 0;
            for (Object e : arrayList) {
                SmpProtectionPane.this.pgListModel.setElementAt(e, n++);
                db.fine("refreshFromModel: adding " + e + " to pgList");
            }
            SmpProtectionPane.this.setSelectedModel(SmpProtectionPane.this.pgList.getSelectedValue());
            db.fine("refreshFromModel: finish");
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)SmpProtectionPane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

