/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ILanRipConfigModel;
import cerent.cms.model.IRouteEntry;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.AbstractShelfTablePane;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;

public class SmpRipRoutingPane
extends AbstractShelfTablePane
implements ActionListener {
    private static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpRipRoutingPane");
    public static final int ROUTE_DESTINATION = 0;
    public static final int ROUTE_MASKLENGTH = 1;
    public static final int ROUTE_GATEWAY = 2;
    public static final int ROUTE_USAGE = 3;
    private static final String DATEFORMAT = "MM/dd/yy HH:mm:ss";
    private SimpleDateFormat dateFormat;
    JButton updateRoutesButton = new JButton("Retrieve");
    JLabel updateRoutesLabel = new JLabel("");

    protected void initButtonPanel() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpRipRoutingPane);
        cSHelpButtonPane.addLeft(this.updateRoutesButton);
        cSHelpButtonPane.addRight(this.updateRoutesLabel);
        this.add(cSHelpButtonPane, "South");
    }

    public void updateRoutes() {
        this.updateRoutesLabel.setText(this.getTimeStampString());
        this.repopulateTable();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.updateRoutesButton) {
            this.updateRoutes();
        }
    }

    public SmpRipRoutingPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.ENTRY_TYPE = "Rip Routing";
        this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
    }

    @Override
    protected void localInit() {
        this.dateFormat = new SimpleDateFormat(DATEFORMAT);
        this.setLayout(new BorderLayout());
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.initButtonPanel();
        this.updateRoutesButton.addActionListener(this);
    }

    @Override
    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new DestinationColumnRenderer(), new MaskColumnRenderer(), new GatewayColumnRenderer(), new UsageColumnRenderer()};
        RipRoutingRowSource ripRoutingRowSource = new RipRoutingRowSource();
        this.model = new SortableRowTableModel((RowDataSource)ripRoutingRowSource, columnRendererArray);
        this.registerWithModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateTableData() {
        List list = this.tableData;
        synchronized (list) {
            this.tableData = new ArrayList();
            ILanRipConfigModel iLanRipConfigModel = this.nodeModel.getLanRipConfigModel();
            if (iLanRipConfigModel != null) {
                IRouteEntry[] iRouteEntryArray = iLanRipConfigModel.getRipRoutingTable();
                int n = iRouteEntryArray.length;
                if (db.on()) {
                    db.println("routelength is " + n);
                }
                for (int i = 0; i < n; ++i) {
                    this.tableData.add(iRouteEntryArray[i]);
                }
            } else {
                db.println("RIP config model is null!");
            }
        }
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 150;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(IRouteEntry iRouteEntry, int n) {
            String string = "???";
            if (iRouteEntry != null) {
                switch (n) {
                    case 0: {
                        string = InetUtil.makeDottedString(iRouteEntry.getDestAddr());
                        break;
                    }
                    case 1: {
                        short s = iRouteEntry.getMaskLength();
                        string = InetUtil.makeDottedString(InetUtil.makeNetMask(s));
                        break;
                    }
                    case 2: {
                        string = InetUtil.makeDottedString(iRouteEntry.getGateway());
                        break;
                    }
                    case 3: {
                        string = new Long(iRouteEntry.getUsage()).toString();
                    }
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            IRouteEntry iRouteEntry = (IRouteEntry)jTable.getValueAt(n, 0);
            String string = this.getStringValue(iRouteEntry, n2);
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(true);
            jLabel.setForeground(Color.black);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(Color.white);
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((IRouteEntry)object, n);
            String string2 = this.getStringValue((IRouteEntry)object2, n);
            return string.compareTo(string2);
        }
    }

    class DestinationColumnRenderer
    extends BaseColumnRenderer {
        DestinationColumnRenderer() {
        }

        public String getName() {
            return "Destination";
        }
    }

    class GatewayColumnRenderer
    extends BaseColumnRenderer {
        GatewayColumnRenderer() {
        }

        public String getName() {
            return "Gateway";
        }
    }

    class MaskColumnRenderer
    extends BaseColumnRenderer {
        MaskColumnRenderer() {
        }

        public String getName() {
            return "Mask";
        }
    }

    class RipRoutingRowSource
    extends AbstractRowDataSource {
        RipRoutingRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = SmpRipRoutingPane.this.tableData;
            synchronized (list) {
                var2_2 = SmpRipRoutingPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = SmpRipRoutingPane.this.tableData;
            synchronized (list) {
                n = SmpRipRoutingPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = SmpRipRoutingPane.this.tableData;
            synchronized (list) {
                return SmpRipRoutingPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return IRouteEntry.class;
        }
    }

    class UsageColumnRenderer
    extends BaseColumnRenderer {
        UsageColumnRenderer() {
        }

        public String getName() {
            return "Cost";
        }
    }
}

