/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.SonetTopology.sXcResources;
import cerent.cms.model.Busy;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoPathInfo;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.LoAditModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IHoNum;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SmpXcResourcePane
extends ObserverPane
implements Observer {
    private static final String REFRESH = "Refresh";
    private static final String DELETE = "Delete";
    private JRadioButton vc3RadioBtn;
    private JRadioButton vc12RadioBtn;
    private JRadioButton vc11RadioBtn;
    private JRadioButton unusedRadioBtn;
    private JRadioButton vt15RadioBtn;
    private JRadioButton vt2RadioBtn;
    private ButtonGroup radioButtonGroup;
    private RadioListener matrixSelListener;
    private JButton deleteButton;
    private JButton refreshButton;
    private JLabel refreshLabel;
    private UScrollPane loAditUsageSP;
    private LoAditUsageDataSourceControl _dsc;
    private XcResourceModel _xcResourceModel;
    private IChassisModel chassis = (IChassisModel)this.getUiModel();
    private int defaultHeight;
    private IPlatform _platform = this.chassis.getPlatform();
    protected static final String[] xcResourceNamesVT2 = new String[]{"STS-1 Matrix:", "VT2 Matrix Ports:", "VT2 Matrix:", "VT1.5 Matrix Ports:", "VT1.5 Matrix:"};
    protected static final String[] xcResourceNamesNoVT2 = new String[]{"STS-1 Matrix:", "VT1.5 Matrix Ports:", "VT1.5 Matrix:"};
    private static final String[] xcResourceNamesVc11 = new String[]{"VC4 Matrix:", "TUG3 Matrix Ports:", "TUG3 Matrix:", "VC12 Matrix Ports:", "VC12 Matrix:", "VC11 Matrix Ports:", "VC11 Matrix:"};
    private static final String[] xcResourceNamesNoVc11 = new String[]{"VC4 Matrix:", "TUG3 Matrix Ports:", "TUG3 Matrix:", "VC12 Matrix Ports:", "VC12 Matrix:"};
    public static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpXcResourcePane");

    public SmpXcResourcePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this._dsc = new LoAditUsageDataSourceControl(this.chassis);
        this.setDataSourceControl(this._dsc);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.defaultHeight = -1;
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        this._dsc.refresh();
        TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.leavingPage();
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.destroy();
    }

    private void manageButtons() {
        LoAditUsageRowObject loAditUsageRowObject = this._dsc.getSelected();
        this.deleteButton.setEnabled(this.isUserAuthorized() && loAditUsageRowObject != null && !loAditUsageRowObject.inUse());
        if (!this.deleteButton.isEnabled()) {
            TDMTerminology tDMTerminology = this.chassis.getTDMTerminology();
            String string = tDMTerminology.getGeneralTerms(0);
            this.deleteButton.setToolTipText("Delete limited to authorized users and unused " + string + "s");
        } else {
            this.deleteButton.setToolTipText("");
        }
    }

    private void setTable(JTable jTable) {
        this.table = jTable;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.requestRefresh(observable, null);
    }

    protected void setExportTableName(String string) {
        this.table.setName("Exported Data - Maintenance - Cross-Connect - Resource Usage - " + string + " Table - " + new Date());
    }

    private XcResourcePanel createXcResourcePanel() {
        ITdmProtocolType iTdmProtocolType = this.chassis.getTdmProtocolTypeObj();
        XcResourcePanel xcResourcePanel = iTdmProtocolType.isSdh() ? new SdhXcResourcePanel(this._platform, this.chassis) : new SonetXcResourcePanel(this._platform, this.chassis);
        return xcResourcePanel;
    }

    public boolean isRadioBtnSelected(JRadioButton jRadioButton) {
        return this.radioButtonGroup != null && this.getRadioBtnSelection(this.radioButtonGroup) == jRadioButton;
    }

    private JRadioButton getRadioBtnSelection(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.getModel() != buttonGroup.getSelection()) continue;
            return jRadioButton;
        }
        return null;
    }

    private class JProgressBarRenderer
    extends JProgressBar
    implements TableCellRenderer {
        JProgressBarRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this;
        }

        public void setValue(Object object) {
            if (object instanceof String) {
                this.setValue(Integer.parseInt((String)object));
            }
        }

        @Override
        public String toString() {
            return Math.round(this.getPercentComplete() * 100.0) + " %";
        }
    }

    private class LoAditUnusedTug3RowObject
    extends LoAditUsageRowObject {
        private int tug3;

        LoAditUnusedTug3RowObject() {
            db.fine("LoAditUnusedTug3RowObject constructor");
        }

        public void init(LoAditModel loAditModel, short s) {
            ((LoAditUsageRowObject)this).init(loAditModel, false);
            this.tug3 = s;
            this.connectionDrop = this.getConnectionDrop(loAditModel, this.slot, this.portNum, this.ho);
            this.numberOfPathsUsed = 0;
            this.totalNumberOfPaths = 1;
            this.numberUsed = "NONE";
        }

        private String getConnectionDrop(LoAditModel loAditModel, int n, int[] nArray, int n2) {
            IEntityModel iEntityModel = null;
            try {
                iEntityModel = loAditModel.getHo().getPool().getProtectEntity();
                if (iEntityModel != null) {
                    this.isProtected = true;
                }
            }
            catch (Exception exception) {
                db.info("LoAditUnusedTug3UsageRowObject():" + exception);
            }
            String string = " TUG3 " + this.tug3;
            String string2 = super.getConnectionDrop(loAditModel, n, nArray, n2, string, iEntityModel);
            db.fine("LoAditUnusedTug3RowObject.getConnectionDrop: " + string2);
            return string2;
        }
    }

    private class LoAditUsageDataSource
    extends AbstractRowDataSource {
        LoAditUsageRowObject[] loAditUsageRowObjects;
        IChassisModel chassis;
        private final String[] columnNames = new String[]{"Drop", "Tunnel Name", "% Used", "Usage"};

        LoAditUsageDataSource(IChassisModel iChassisModel) {
            this.chassis = iChassisModel;
        }

        public synchronized Object getObjectAtRow(int n) {
            db.fine("LoAditUsageDataSource.getObjectAtRow() " + n);
            try {
                return this.loAditUsageRowObjects == null ? null : this.loAditUsageRowObjects[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                db.severe(arrayIndexOutOfBoundsException.toString());
                return null;
            }
        }

        public Class getRowObjectClass() {
            db.fine("LoAditUsageDataSource.getRowObjectClass " + LoAditUsageRowObject.class.getName());
            return LoAditUsageRowObject.class;
        }

        public synchronized int getRowCount() {
            db.fine("LoAditUsageDataSource.getRowCount() " + (this.loAditUsageRowObjects == null ? 0 : this.loAditUsageRowObjects.length));
            return this.loAditUsageRowObjects == null ? 0 : this.loAditUsageRowObjects.length;
        }

        public synchronized void disposeDataSource() {
            db.fine("LoAditUsageDataSource.disposeDataSource");
            this.loAditUsageRowObjects = null;
        }

        public synchronized Collection getAllObjects() {
            db.fine("LoAditUsageDataSource.getAllObjects " + (this.loAditUsageRowObjects == null ? 0 : this.loAditUsageRowObjects.length));
            return this.loAditUsageRowObjects == null ? new ArrayList() : Arrays.asList(this.loAditUsageRowObjects);
        }

        private LoAditUsageRowObject[] removeUnusedDropFromTable(LoAditUsageRowObject[] loAditUsageRowObjectArray) {
            LoAditUsageRowObject[] loAditUsageRowObjectArray2 = null;
            ArrayList<LoAditUsageRowObject> arrayList = new ArrayList<LoAditUsageRowObject>();
            for (int i = 0; i < loAditUsageRowObjectArray.length; ++i) {
                if (loAditUsageRowObjectArray[i].numberOfPathsUsed <= 0) continue;
                arrayList.add(loAditUsageRowObjectArray[i]);
            }
            loAditUsageRowObjectArray2 = new LoAditUsageRowObject[arrayList.size()];
            System.arraycopy(arrayList.toArray(), 0, loAditUsageRowObjectArray2, 0, arrayList.size());
            return loAditUsageRowObjectArray2;
        }

        public synchronized void setLoAditUsageRowObjects(LoAditUsageRowObject[] loAditUsageRowObjectArray) {
            ITdmProtocolType iTdmProtocolType = this.chassis.getTdmProtocolTypeObj();
            this.loAditUsageRowObjects = iTdmProtocolType.isSdh() && !SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.unusedRadioBtn) ? this.removeUnusedDropFromTable(loAditUsageRowObjectArray) : loAditUsageRowObjectArray;
        }

        public sXcResources getXcResource() {
            sXcResources sXcResources2 = null;
            try {
                sXcResources2 = ((ConnectionModelsDelegate)this.chassis.getConnectionModels()).getXcResource();
            }
            catch (Exception exception) {
                db.severe(exception.toString());
            }
            return sXcResources2;
        }

        public LoAditUsageRowObject[] getLoAditUsageRowObjects() {
            LoAditUsageRowObject[] loAditUsageRowObjectArray;
            block3: {
                loAditUsageRowObjectArray = null;
                try {
                    ILoAditModel[] iLoAditModelArray = this.chassis.getConnectionModels().getLoAditModels();
                    loAditUsageRowObjectArray = new LoAditUsageRowObject[iLoAditModelArray.length];
                    for (int i = 0; i < iLoAditModelArray.length; ++i) {
                        loAditUsageRowObjectArray[i] = new LoAditUsageRowObject();
                        loAditUsageRowObjectArray[i].init((LoAditModel)iLoAditModelArray[i]);
                    }
                    db.info("refreshFromModel: loAditModels/loAditUsageRowObjects has " + iLoAditModelArray.length + "rows");
                }
                catch (Exception exception) {
                    db.severe("refreshFromModel " + exception.toString());
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            return loAditUsageRowObjectArray;
        }

        public LoAditUsageRowObject[] getLoAditUnusedTug3RowObjects() {
            LoAditUsageRowObject[] loAditUsageRowObjectArray;
            block5: {
                loAditUsageRowObjectArray = new LoAditUsageRowObject[]{};
                if (SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.unusedRadioBtn)) {
                    try {
                        ILoAditModel[] iLoAditModelArray = this.chassis.getConnectionModels().getLoAditModels();
                        ArrayList<LoAditUnusedTug3RowObject> arrayList = new ArrayList<LoAditUnusedTug3RowObject>();
                        for (int i = 0; i < iLoAditModelArray.length; ++i) {
                            ILoPathInfo[] iLoPathInfoArray = iLoAditModelArray[i].getAvailableLos(7);
                            for (int j = 0; j < iLoPathInfoArray.length; ++j) {
                                LoAditUnusedTug3RowObject loAditUnusedTug3RowObject = new LoAditUnusedTug3RowObject();
                                loAditUnusedTug3RowObject.init((LoAditModel)iLoAditModelArray[i], iLoPathInfoArray[j].getLoNum().getVc3OrSts1());
                                arrayList.add(loAditUnusedTug3RowObject);
                            }
                        }
                        loAditUsageRowObjectArray = arrayList.toArray(loAditUsageRowObjectArray);
                        db.info("refreshFromModel: loAditModels/loAditUnusedRowObjects has " + iLoAditModelArray.length + "/" + loAditUsageRowObjectArray.length + " rows");
                    }
                    catch (Exception exception) {
                        db.severe("refreshFromModel " + exception.toString());
                        if (!db.on()) break block5;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
            return loAditUsageRowObjectArray;
        }

        private int getColumnCount() {
            return this.columnNames.length;
        }

        private String getColumnName(int n) {
            return this.columnNames[n];
        }

        public ColumnRenderer[] getRenderers() {
            ColumnRenderer[] columnRendererArray = new ColumnRenderer[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                columnRendererArray[i] = new LoAditUsageTableCellRenderer(this.getColumnName(i));
            }
            db.fine("created " + columnRendererArray.length + " columnRenderers");
            return columnRendererArray;
        }
    }

    private class LoAditUsageDataSourceControl
    extends AbstractRoDataSourceControl {
        private IChassisModel _chassis;
        private LoAditUsageDataSource _ds;
        private XcResourcePanel _rp;
        private SortableRowTableModel _srtm;
        private Thread _updater;
        private boolean _needsUpdate;
        private eEqType prevXCEqType = null;

        LoAditUsageDataSourceControl(IChassisModel iChassisModel) {
            this._chassis = iChassisModel;
            this._ds = null;
            this._rp = null;
            this._srtm = null;
            this._updater = null;
            this._needsUpdate = false;
            this.dscObservableManager = new ObservableManager(SmpXcResourcePane.this, true);
        }

        private synchronized boolean needsUpdate() {
            if (this._needsUpdate) {
                if (db.on()) {
                    db.println("updater starting update");
                }
                this._needsUpdate = false;
                return true;
            }
            return false;
        }

        private eEqType getCurrentXcEqType() {
            eEqType[] eEqTypeArray = new eEqType[]{eEqType.XC_CARD, eEqType.XCVT_CARD, eEqType.XC192_CARD, eEqType.XCVXL_CARD, eEqType.XCVXC_CARD, eEqType.XCVXL25G_CARD};
            for (int i = 0; i < eEqTypeArray.length; ++i) {
                if (((EntityModel)((Object)SmpXcResourcePane.this.chassis)).getDescendantsOfType(eEqTypeArray[i]).size() <= 0) continue;
                return eEqTypeArray[i];
            }
            return null;
        }

        private void doUpdate() {
            try {
                SwingUtilities.invokeAndWait(new Refresher(this._ds.getXcResource(), SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.unusedRadioBtn) ? this._ds.getLoAditUnusedTug3RowObjects() : this._ds.getLoAditUsageRowObjects(), this._srtm));
            }
            catch (InvocationTargetException invocationTargetException) {
                SDebug.printStackTrace((Throwable)invocationTargetException);
                throw new CmsObjectNotExistException("An update error occurred.  It might be caused by requesting resource usage while deleting circuits.");
            }
            catch (Exception exception) {
                db.severe(exception.getMessage());
            }
        }

        private void reInitUi() {
            try {
                SwingUtilities.invokeAndWait(new Thread(){

                    @Override
                    public void run() {
                        SmpXcResourcePane.this.refreshButton.removeAll();
                        SmpXcResourcePane.this.remove(SmpXcResourcePane.this.refreshButton);
                        SmpXcResourcePane.this.refreshButton = null;
                        LoAditUsageDataSourceControl.this._ds.disposeDataSource();
                        SmpXcResourcePane.this._dsc.disposeDataSource();
                        LoAditUsageDataSourceControl.this._srtm = null;
                        LoAditUsageDataSourceControl.this._rp.removeAll();
                        LoAditUsageDataSourceControl.this._rp.dispose();
                        SmpXcResourcePane.this.remove(LoAditUsageDataSourceControl.this._rp);
                        LoAditUsageDataSourceControl.this.initUi();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                SDebug.printStackTrace((Throwable)invocationTargetException);
            }
            catch (Exception exception) {
                db.severe(exception.getMessage());
            }
        }

        public synchronized void refreshFromModel() throws Exception {
            eEqType eEqType2;
            if (db.on()) {
                db.println("refreshFromModel()");
            }
            if ((eEqType2 = this.getCurrentXcEqType()) != null && !eEqType2.equals(this.prevXCEqType)) {
                this.prevXCEqType = eEqType2;
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        LoAditUsageDataSourceControl.this.reInitUi();
                    }
                });
                thread.start();
            }
            this._needsUpdate = true;
            if (this._updater == null) {
                this._updater = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        SmpXcResourcePane.this.uiToolkit.setSBText("Loading Usage...");
                        try {
                            while (LoAditUsageDataSourceControl.this.needsUpdate()) {
                                LoAditUsageDataSourceControl.this.doUpdate();
                            }
                            LoAditUsageDataSourceControl.this._updater = null;
                            SmpXcResourcePane.this.uiToolkit.setSBText("");
                            SmpXcResourcePane.this.refreshLabel.setForeground(Color.black);
                            SmpXcResourcePane.this.refreshLabel.setText("Resource usage refreshed: " + SmpXcResourcePane.getFormattedDateTime());
                            if (db.on()) {
                                db.println("updater done");
                            }
                        }
                        catch (CmsObjectNotExistException cmsObjectNotExistException) {
                            LoAditUsageDataSourceControl.this._updater = null;
                            SmpXcResourcePane.this.uiToolkit.setSBText(cmsObjectNotExistException.getMessage());
                            SmpXcResourcePane.this.refreshLabel.setForeground(Color.red);
                            SmpXcResourcePane.this.refreshLabel.setText("The resource usage table could not be refreshed. Please try again.");
                        }
                    }
                });
                if (db.on()) {
                    db.println("updater created");
                }
                this._updater.start();
            }
        }

        @Override
        public void refreshFromModel(int n) throws Exception {
            if (n == -1) {
                this.prevXCEqType = this.getCurrentXcEqType();
                this.initUi();
            }
            this.refreshFromModel();
        }

        public IObservableManager getObservableManager() {
            return this.dscObservableManager;
        }

        @Override
        public void disposeDataSource() {
            this.dscObservableManager.removeObservable((Observable)SmpXcResourcePane.this._xcResourceModel);
        }

        private LoAditUsageRowObject getSelected() {
            JTable jTable = SmpXcResourcePane.this.getTable();
            jTable.repaint();
            int n = jTable.getSelectedRow();
            if (n >= 0 && n < jTable.getRowCount()) {
                return (LoAditUsageRowObject)this._srtm.getValueAt(n, 0);
            }
            return null;
        }

        private UScrollPane initTable() {
            SmpXcResourcePane.this._xcResourceModel = new XcResourceModel();
            this.dscObservableManager.addObservable((Observable)SmpXcResourcePane.this._xcResourceModel);
            this._ds = new LoAditUsageDataSource(this._chassis);
            this._srtm = new SortableRowTableModel((RowDataSource)this._ds, this._ds.getRenderers(), this._ds.getRowObjectClass());
            RowHeightAdjustableUTable rowHeightAdjustableUTable = new RowHeightAdjustableUTable(this._srtm);
            rowHeightAdjustableUTable.validate();
            JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.validate();
            int n = (int)jProgressBar.getPreferredSize().getHeight() + 5;
            db.fine("table: " + rowHeightAdjustableUTable.getRowHeight() + "; bar: " + n);
            if (rowHeightAdjustableUTable.getRowHeight() < n) {
                db.info("resetting row height: table: " + rowHeightAdjustableUTable.getRowHeight() + "; bar: " + n);
                rowHeightAdjustableUTable.setRowHeight(n);
            }
            if (SmpXcResourcePane.this.defaultHeight < 0) {
                SmpXcResourcePane.this.defaultHeight = rowHeightAdjustableUTable.getRowHeight();
            }
            try {
                rowHeightAdjustableUTable.setDefaultHeight(SmpXcResourcePane.this.defaultHeight);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                db.severe("Default height of " + SmpXcResourcePane.this.defaultHeight + " attempted: " + illegalArgumentException.getMessage());
            }
            SmpXcResourcePane.this.setTable((JTable)((Object)rowHeightAdjustableUTable));
            this._srtm.initTable(SmpXcResourcePane.this.getTable());
            ListSelectionModel listSelectionModel = SmpXcResourcePane.this.getTable().getSelectionModel();
            listSelectionModel.setSelectionMode(0);
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        SmpXcResourcePane.this.manageButtons();
                    }
                }
            });
            return new UScrollPane((Component)SmpXcResourcePane.this.getTable());
        }

        private void initUi() {
            SmpXcResourcePane.this.setLayout(new BorderLayout());
            SmpXcResourcePane.this.setBorder(BorderFactory.createEtchedBorder(1));
            JPanel jPanel = AbstractPane.createHorizontalPanel(null);
            jPanel.setLayout(new BorderLayout());
            SmpXcResourcePane.this.refreshButton = new JButton(SmpXcResourcePane.REFRESH);
            SmpXcResourcePane.this.refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LoAditUsageDataSourceControl.this.refresh();
                }
            });
            SmpXcResourcePane.this.refreshLabel = new JLabel("          ", 2);
            CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpXcResourcePane);
            cSHelpButtonPane.addLeft(SmpXcResourcePane.this.refreshButton);
            cSHelpButtonPane.addRight(SmpXcResourcePane.this.refreshLabel);
            this._rp = SmpXcResourcePane.this.createXcResourcePanel();
            SmpXcResourcePane.this.add(this._rp, "Center");
            SmpXcResourcePane.this.add(cSHelpButtonPane, "South");
        }

        private void refresh() {
            SmpXcResourcePane.this._xcResourceModel.refreshButtonPushed();
        }

        private class Refresher
        implements Runnable {
            private SortableRowTableModel _srtm;
            private sXcResources xcResource;
            private LoAditUsageRowObject[] loAditUsage;

            Refresher(sXcResources sXcResources2, LoAditUsageRowObject[] loAditUsageRowObjectArray, SortableRowTableModel sortableRowTableModel) {
                this.xcResource = sXcResources2;
                this.loAditUsage = loAditUsageRowObjectArray;
                this._srtm = sortableRowTableModel;
            }

            @Override
            public void run() {
                LoAditUsageDataSourceControl.this._rp.resetGaugeValues(this.xcResource);
                LoAditUsageDataSourceControl.this._ds.setLoAditUsageRowObjects(this.loAditUsage);
                this._srtm.dataSourceChanged();
                this.xcResource = null;
                this.loAditUsage = null;
                this._srtm = null;
            }
        }
    }

    private class LoAditUsageRowObject {
        protected LoAditModel loAditModel;
        protected String connectionDrop;
        protected int slot;
        protected int[] portNum;
        protected int ho;
        protected String connectionCircuitName;
        protected int numberOfPathsUsed;
        protected int totalNumberOfPaths;
        protected String numberUsed;
        protected boolean isProtected;
        protected JProgressBarRenderer percentUsed;

        LoAditUsageRowObject() {
            db.fine("LoAditUsageRowObject constructor");
            this.loAditModel = null;
            this.connectionDrop = "";
            this.ho = 0;
            this.slot = 0;
            this.portNum = null;
            this.connectionCircuitName = "";
            this.totalNumberOfPaths = 0;
            this.numberOfPathsUsed = 0;
            this.numberUsed = "";
            this.percentUsed = null;
            this.isProtected = false;
        }

        public void init(LoAditModel loAditModel) {
            this.init(loAditModel, true);
        }

        private void init(LoAditModel loAditModel, boolean bl) {
            IHoNum iHoNum;
            db.fine("LoAditUsageRowObject.init");
            this.loAditModel = loAditModel;
            try {
                this.slot = loAditModel.getSlotByIndex(loAditModel.getEntityIndex());
            }
            catch (Exception exception) {
                db.info("LoAditUsageRowObject():" + exception);
            }
            try {
                this.portNum = loAditModel.getPortNumByIndex(loAditModel.getEntityIndex());
            }
            catch (Exception exception) {
                db.info("LoAditUsageRowObject():" + exception);
            }
            try {
                iHoNum = HoPathDefModel.physicalHo(loAditModel.getHo());
                this.ho = iHoNum.getHoNum();
            }
            catch (Exception exception) {
                db.info("LoAditUsageRowObject():" + exception);
            }
            if (bl) {
                iHoNum = null;
                try {
                    iHoNum = loAditModel.getHo().getPool().getProtectEntity();
                    if (iHoNum != null) {
                        this.isProtected = true;
                    }
                }
                catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                    db.info("LoAditUsageRowObject() protect:" + (Object)((Object)cmsNoSuchEntityException));
                }
                catch (Exception exception) {
                    db.severe("LoAditUsageRowObject() protect:" + exception);
                }
                this.connectionDrop = this.getConnectionDrop(loAditModel, this.slot, this.portNum, this.ho, "", (IEntityModel)iHoNum);
            } else {
                this.connectionDrop = "Unknown";
            }
            this.connectionCircuitName = this.getConnectionCircuitName(loAditModel);
            this.numberOfPathsUsed = this.getNumberOfPathsUsed(loAditModel);
            this.totalNumberOfPaths = this.getTotalNumberOfPaths(loAditModel);
            this.numberUsed = this.getNumberUsed(loAditModel);
            this.percentUsed = this.getPercentUsed(loAditModel);
        }

        protected String getConnectionDrop(LoAditModel loAditModel, int n, int[] nArray, int n2, String string, IEntityModel iEntityModel) {
            String string2 = "UNKNOWN";
            TDMTerminology tDMTerminology = SmpXcResourcePane.this.chassis.getTDMTerminology();
            String string3 = " " + tDMTerminology.getGeneralTerms(0) + " ";
            String string4 = "";
            if (nArray != null && nArray[0] > 0) {
                string2 = "Slot " + n + " Port " + PortHelper.getConcatenatedString((int[])nArray) + string3 + n2 + string;
                if (iEntityModel != null) {
                    string4 = "<em> (Working)</em><br>Slot " + iEntityModel.getSlot() + " Port " + PortHelper.getPortNumString((IPortModel)((IPortModel)iEntityModel)) + string3 + n2 + string + " <em>(Protect)</em>";
                }
            } else {
                string2 = "Slot " + n + string3 + n2;
                if (iEntityModel != null) {
                    string4 = "<em>Working</em><br>Slot " + iEntityModel.getSlot() + string3 + n2 + "<em>Protect</em>";
                }
            }
            db.fine("LoAditUsageRowObject.getConnectionDrop: " + string2);
            return "<html>" + string2 + string4 + "</html>";
        }

        protected String getConnectionCircuitName(LoAditModel loAditModel) {
            String string = loAditModel.getConnectionName();
            if (string == null) {
                string = "";
            }
            db.fine("LoAditUsageRowObject.getConnectionCircuitName: " + string);
            return string;
        }

        private int getNumberOfPathsUsed(LoAditModel loAditModel) {
            ITdmProtocolType iTdmProtocolType = SmpXcResourcePane.this.chassis.getTdmProtocolTypeObj();
            boolean bl = iTdmProtocolType.isSonet();
            ILoPathInfo[] iLoPathInfoArray = null;
            if (bl) {
                iLoPathInfoArray = SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.vt15RadioBtn) ? loAditModel.getConnectedPaths(0) : loAditModel.getConnectedPaths(1);
            } else if (SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.vc11RadioBtn)) {
                iLoPathInfoArray = loAditModel.getConnectedLoPaths(5);
            } else if (SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.vc12RadioBtn)) {
                iLoPathInfoArray = loAditModel.getConnectedLoPaths(6);
            } else if (SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.vc3RadioBtn)) {
                iLoPathInfoArray = loAditModel.getConnectedLoPaths(7);
            }
            return iLoPathInfoArray == null ? 0 : iLoPathInfoArray.length;
        }

        private int getTotalNumberOfPaths(LoAditModel loAditModel) {
            int[] nArray = SmpXcResourcePane.this.chassis.getNodeModelDelegate().getSupportedFramingTypes();
            FramingType[] framingTypeArray = new FramingType[nArray.length];
            for (int i = 0; i < framingTypeArray.length; ++i) {
                framingTypeArray[i] = (FramingType)FramingType.getFramingType((int)nArray[i]);
            }
            ITdmProtocolType iTdmProtocolType = SmpXcResourcePane.this.chassis.getTdmProtocolTypeObj();
            ICircuitSize[] iCircuitSizeArray = CircuitSize.getCircuitSizes((int)iTdmProtocolType.getLoCircuitType(), (FramingType[])framingTypeArray);
            if (iCircuitSizeArray.length != 1) {
                db.severe("loCircuitSizes.length=" + iCircuitSizeArray.length);
            }
            int n = 0;
            for (int i = 0; i < iCircuitSizeArray.length; ++i) {
                try {
                    ICircuitSize iCircuitSize = iCircuitSizeArray[i];
                    if (!iCircuitSize.isLo(SmpXcResourcePane.this.chassis.getTdmProtocolTypeObj().getEnum())) continue;
                    short s = iCircuitSize.size2widthOfLoCircuit();
                    ILoPathInfo[] iLoPathInfoArray = loAditModel.getAvailableLos(s);
                    if (iTdmProtocolType.isSdh()) {
                        if (!(iCircuitSize.getEnum() == 9 && SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.vc11RadioBtn) || iCircuitSize.getEnum() == 10 && SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.vc12RadioBtn)) && (iCircuitSize.getEnum() != 11 || !SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.vc3RadioBtn))) continue;
                        n = iLoPathInfoArray == null ? 0 : iLoPathInfoArray.length;
                        break;
                    }
                    if ((iCircuitSize.getEnum() != 0 || !SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.vt15RadioBtn)) && (iCircuitSize.getEnum() != 30 || !SmpXcResourcePane.this.isRadioBtnSelected(SmpXcResourcePane.this.vt2RadioBtn))) continue;
                    n += iLoPathInfoArray == null ? 0 : iLoPathInfoArray.length;
                    continue;
                }
                catch (Exception exception) {
                    db.severe(exception.toString());
                }
            }
            return this.getNumberOfPathsUsed(loAditModel) + n;
        }

        private String getNumberUsed(LoAditModel loAditModel) {
            int n = this.getNumberOfPathsUsed(loAditModel);
            if (n == 0) {
                return "NONE";
            }
            String string = n + " of " + this.getTotalNumberOfPaths(loAditModel);
            return string;
        }

        protected boolean isProtected() {
            return this.isProtected;
        }

        protected JProgressBarRenderer getPercentUsed(LoAditModel loAditModel) {
            int n = this.getNumberOfPathsUsed(loAditModel);
            JProgressBarRenderer jProgressBarRenderer = new JProgressBarRenderer();
            jProgressBarRenderer.setStringPainted(true);
            if (n == 0) {
                jProgressBarRenderer.setMaximum(100);
            } else {
                jProgressBarRenderer.setMaximum(this.getTotalNumberOfPaths(loAditModel));
            }
            jProgressBarRenderer.setValue(n);
            jProgressBarRenderer.setToolTipText("total = " + this.getTotalNumberOfPaths(loAditModel) + ", used = " + n);
            return jProgressBarRenderer;
        }

        public void deleteLoAdit() throws Busy {
            db.info("Deleting circuit id " + this.loAditModel.getCircuitId());
            this.loAditModel.localDestroy();
        }

        boolean inUse() {
            return this.loAditModel.inUse();
        }

        public String toString() {
            String string = "[" + this.connectionDrop + " " + this.connectionCircuitName + ": " + this.numberUsed + " " + this.percentUsed.getString() + "]";
            return string;
        }
    }

    private class LoAditUsageTableCellRenderer
    extends AbstractColumnRenderer {
        JProgressBarRenderer loAditUsageProgressBarRenderer;
        DefaultTableCellRenderer otherColumnRenderer;
        public static final int CONNECTION_DROP = 0;
        public static final int CIRCUIT_NAME = 1;
        public static final int PERCENT_USED = 2;
        public static final int NUMBER_USED = 3;

        LoAditUsageTableCellRenderer(String string) {
            super(string, 100, true, 2);
            this.loAditUsageProgressBarRenderer = new JProgressBarRenderer();
            this.otherColumnRenderer = new DefaultTableCellRenderer();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = this.otherColumnRenderer;
            String string = "Unknown Object";
            if (object instanceof LoAditUsageRowObject) {
                LoAditUsageRowObject loAditUsageRowObject = (LoAditUsageRowObject)object;
                db.fine("Returning renderer for row " + n + " column " + n2);
                switch (n2) {
                    case 0: {
                        int n3 = SmpXcResourcePane.this.defaultHeight;
                        if (loAditUsageRowObject.isProtected()) {
                            n3 *= 2;
                        }
                        string = loAditUsageRowObject.connectionDrop;
                        if (jTable.getRowHeight(n) == n3) break;
                        db.fine("Resetting row " + n + " height from " + jTable.getRowHeight(n) + " to " + n3);
                        jTable.setRowHeight(n, n3);
                        if (string.indexOf("<html>") == -1) {
                            jTable.getColumnModel().getColumn(0).setPreferredWidth(162);
                            break;
                        }
                        int n4 = string.indexOf("<html>") + "<html>".length();
                        int n5 = string.indexOf("</em>") - "<em>".length();
                        FontMetrics fontMetrics = SmpXcResourcePane.this.getGraphics().getFontMetrics();
                        int n6 = fontMetrics.stringWidth(string.substring(n4, n5));
                        jTable.getColumnModel().getColumn(0).setPreferredWidth(n6);
                        break;
                    }
                    case 1: {
                        string = loAditUsageRowObject.connectionCircuitName;
                        break;
                    }
                    case 2: {
                        this.loAditUsageProgressBarRenderer = loAditUsageRowObject.percentUsed;
                        jComponent = this.loAditUsageProgressBarRenderer;
                        string = String.valueOf(this.loAditUsageProgressBarRenderer.getValue());
                        break;
                    }
                    case 3: {
                        string = loAditUsageRowObject.numberUsed;
                        break;
                    }
                    default: {
                        string = "Unknown Value Type";
                    }
                }
            }
            return jComponent.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        }

        @Override
        public int compareColumn(Object object, Object object2, int n) {
            int n2 = 0;
            if (object == null) {
                db.severe("Comparing column " + n + " of " + object + "/" + object2);
                n2 = -1;
            } else if (object2 == null) {
                db.severe("Comparing column " + n + " of " + object + "/" + object2);
                n2 = 1;
            } else {
                LoAditUsageRowObject loAditUsageRowObject = (LoAditUsageRowObject)object;
                LoAditUsageRowObject loAditUsageRowObject2 = (LoAditUsageRowObject)object2;
                db.fine("Comparing column " + n + " of " + loAditUsageRowObject + "/" + loAditUsageRowObject2);
                switch (n) {
                    case 0: {
                        n2 = ComparisonUtil.compare((int)loAditUsageRowObject.slot, (int)loAditUsageRowObject2.slot);
                        if (n2 == 0) {
                            n2 = ComparisonUtil.compare((int[])loAditUsageRowObject.portNum, (int[])loAditUsageRowObject2.portNum);
                        }
                        if (n2 == 0) {
                            n2 = ComparisonUtil.compare((int)loAditUsageRowObject.ho, (int)loAditUsageRowObject2.ho);
                        }
                        if (n2 != 0 || !(loAditUsageRowObject instanceof LoAditUnusedTug3RowObject) || !(loAditUsageRowObject2 instanceof LoAditUnusedTug3RowObject)) break;
                        n2 = ComparisonUtil.compare((int)((LoAditUnusedTug3RowObject)loAditUsageRowObject).tug3, (int)((LoAditUnusedTug3RowObject)loAditUsageRowObject2).tug3);
                        break;
                    }
                    case 1: {
                        n2 = loAditUsageRowObject.connectionCircuitName.compareTo(loAditUsageRowObject2.connectionCircuitName);
                        break;
                    }
                    case 2: {
                        n2 = ComparisonUtil.compare((int)loAditUsageRowObject.percentUsed.getValue(), (int)loAditUsageRowObject2.percentUsed.getValue());
                        break;
                    }
                    case 3: {
                        n2 = ComparisonUtil.compare((int)loAditUsageRowObject.numberOfPathsUsed, (int)loAditUsageRowObject2.numberOfPathsUsed);
                        if (n2 != 0) break;
                        n2 = ComparisonUtil.compare((int)loAditUsageRowObject.totalNumberOfPaths, (int)loAditUsageRowObject2.totalNumberOfPaths);
                        break;
                    }
                    default: {
                        db.severe("compareColumn(): Undefined column number");
                        n2 = 0;
                    }
                }
            }
            return n2;
        }
    }

    private class RadioListener
    implements ActionListener {
        private JRadioButton prev;

        private RadioListener() {
            this.prev = SmpXcResourcePane.this.getRadioBtnSelection(SmpXcResourcePane.this.radioButtonGroup);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SmpXcResourcePane.this.vt15RadioBtn) {
                if (this.prev != SmpXcResourcePane.this.vt15RadioBtn) {
                    this.prev = SmpXcResourcePane.this.vt15RadioBtn;
                    SmpXcResourcePane.this.refresh();
                    SmpXcResourcePane.this.deleteButton.setVisible(true);
                }
            } else if (actionEvent.getSource() == SmpXcResourcePane.this.vt2RadioBtn) {
                if (this.prev != SmpXcResourcePane.this.vt2RadioBtn) {
                    this.prev = SmpXcResourcePane.this.vt2RadioBtn;
                    SmpXcResourcePane.this.refresh();
                    SmpXcResourcePane.this.deleteButton.setVisible(true);
                }
            } else if (actionEvent.getSource() == SmpXcResourcePane.this.vc11RadioBtn) {
                if (this.prev != SmpXcResourcePane.this.vc11RadioBtn) {
                    this.prev = SmpXcResourcePane.this.vc11RadioBtn;
                    SmpXcResourcePane.this.refresh();
                    SmpXcResourcePane.this.deleteButton.setVisible(true);
                }
            } else if (actionEvent.getSource() == SmpXcResourcePane.this.vc12RadioBtn) {
                if (this.prev != SmpXcResourcePane.this.vc12RadioBtn) {
                    this.prev = SmpXcResourcePane.this.vc12RadioBtn;
                    SmpXcResourcePane.this.refresh();
                    SmpXcResourcePane.this.deleteButton.setVisible(true);
                }
            } else if (actionEvent.getSource() == SmpXcResourcePane.this.vc3RadioBtn) {
                if (this.prev != SmpXcResourcePane.this.vc3RadioBtn) {
                    this.prev = SmpXcResourcePane.this.vc3RadioBtn;
                    SmpXcResourcePane.this.refresh();
                    SmpXcResourcePane.this.deleteButton.setVisible(true);
                }
            } else if (this.prev != SmpXcResourcePane.this.unusedRadioBtn) {
                this.prev = SmpXcResourcePane.this.unusedRadioBtn;
                SmpXcResourcePane.this.refresh();
                SmpXcResourcePane.this.deleteButton.setVisible(false);
            }
            SmpXcResourcePane.this.setExportTableName(((JRadioButton)actionEvent.getSource()).getText());
        }
    }

    private class RowHeightAdjustableUTable
    extends UTable {
        private int defaultHeight;

        public RowHeightAdjustableUTable(SortableRowTableModel sortableRowTableModel) {
            super((TableModel)((Object)sortableRowTableModel));
            this.defaultHeight = this.getRowHeight();
            if (this.defaultHeight < 10) {
                this.defaultHeight = 10;
            }
        }

        public void setDefaultHeight(int n) throws IllegalArgumentException {
            if (n < 10) {
                throw new IllegalArgumentException();
            }
            this.defaultHeight = n;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            db.info("Intervening in tableChange handling... default height: " + this.defaultHeight);
            if (this.defaultHeight >= 10) {
                this.setRowHeight(this.defaultHeight);
                for (int i = 0; i < this.getRowCount(); ++i) {
                    int n = this.defaultHeight;
                    Object object = this.getValueAt(i, 0);
                    if (object != null && object instanceof LoAditUsageRowObject) {
                        LoAditUsageRowObject loAditUsageRowObject = (LoAditUsageRowObject)object;
                        if (loAditUsageRowObject.isProtected()) {
                            n *= 2;
                        }
                        if (SmpXcResourcePane.this.table.getRowHeight(i) == n) continue;
                        db.fine("Resetting row " + i + " height from " + SmpXcResourcePane.this.table.getRowHeight(i) + " to " + n);
                        SmpXcResourcePane.this.table.setRowHeight(i, n);
                        continue;
                    }
                    db.severe("Null object or not a LoAditUsageRowObject");
                }
            }
            super.tableChanged(tableModelEvent);
        }
    }

    private class SdhXcResourcePanel
    extends XcResourcePanel {
        private final int VC4_PATHS = 0;
        private final int TUG3_TERMS = 1;
        private final int TUG3_PATHS = 2;
        private final int VC12_TERMS = 3;
        private final int VC12_PATHS = 4;
        private final int VC11_TERMS = 5;
        private final int VC11_PATHS = 6;

        public SdhXcResourcePanel(IPlatform iPlatform, IChassisModel iChassisModel) {
            super(iPlatform, iChassisModel);
            this.VC4_PATHS = 0;
            this.TUG3_TERMS = 1;
            this.TUG3_PATHS = 2;
            this.VC12_TERMS = 3;
            this.VC12_PATHS = 4;
            this.VC11_TERMS = 5;
            this.VC11_PATHS = 6;
        }

        @Override
        protected String[] getResourceNames(IPlatform iPlatform, IChassisModel iChassisModel) {
            String[] stringArray = null;
            stringArray = iPlatform.hasVC11() && iPlatform.hasXcMixedMode(iChassisModel) ? xcResourceNamesVc11 : xcResourceNamesNoVc11;
            return stringArray;
        }

        @Override
        public void resetLabel(int n, String string) {
            String string2 = SmpXcResourcePane.this._platform.hasVC11() && SmpXcResourcePane.this._platform.hasXcMixedMode(SmpXcResourcePane.this.chassis) ? xcResourceNamesVc11[n] : xcResourceNamesNoVc11[n];
            ((JLabel)this.labelList.get(n)).setText(string2);
            ((JLabel)this.usageLabelList.get(n)).setText(string);
        }

        @Override
        public synchronized void resetGaugeValues(sXcResources sXcResources2) {
            this.resetValue(0, this.xcResGauges[0], sXcResources2.maxSts, sXcResources2.numSts);
            this.resetValue(1, this.xcResGauges[1], sXcResources2.maxTermVc4, sXcResources2.numTermVc4);
            this.resetValue(2, this.xcResGauges[2], sXcResources2.maxTug3, sXcResources2.numTug3);
            this.resetValue(3, this.xcResGauges[3], sXcResources2.maxTermVt2, sXcResources2.numTermVt2);
            this.resetValue(4, this.xcResGauges[4], sXcResources2.maxVt2, sXcResources2.numVt2);
            if (SmpXcResourcePane.this._platform.hasVC11() && SmpXcResourcePane.this._platform.hasXcMixedMode(SmpXcResourcePane.this.chassis)) {
                this.resetValue(5, this.xcResGauges[5], sXcResources2.maxTermVt15, sXcResources2.numTermVt15);
                this.resetValue(6, this.xcResGauges[6], sXcResources2.maxVt15, sXcResources2.numVt15);
            }
        }
    }

    private class SonetXcResourcePanel
    extends XcResourcePanel {
        private final int STS_PATHS = 0;
        private final int VT2_TERMS = 1;
        private final int VT2_PATHS = 2;
        private final int VT15_TERMS = 3;
        private final int VT15_PATHS = 4;
        private final int VT15_TERMS_ONLY = 1;
        private final int VT15_PATHS_ONLY = 2;

        public SonetXcResourcePanel(IPlatform iPlatform, IChassisModel iChassisModel) {
            super(iPlatform, iChassisModel);
            this.STS_PATHS = 0;
            this.VT2_TERMS = 1;
            this.VT2_PATHS = 2;
            this.VT15_TERMS = 3;
            this.VT15_PATHS = 4;
            this.VT15_TERMS_ONLY = 1;
            this.VT15_PATHS_ONLY = 2;
        }

        @Override
        protected String[] getResourceNames(IPlatform iPlatform, IChassisModel iChassisModel) {
            String[] stringArray = null;
            stringArray = iPlatform.hasVT2() && iPlatform.hasXcMixedMode(iChassisModel) ? xcResourceNamesVT2 : xcResourceNamesNoVT2;
            return stringArray;
        }

        @Override
        public void resetLabel(int n, String string) {
            String string2 = SmpXcResourcePane.this._platform.hasVT2() && SmpXcResourcePane.this._platform.hasXcMixedMode(SmpXcResourcePane.this.chassis) ? xcResourceNamesVT2[n] : xcResourceNamesNoVT2[n];
            ((JLabel)this.labelList.get(n)).setText(string2);
            ((JLabel)this.usageLabelList.get(n)).setText(string);
        }

        @Override
        public synchronized void resetGaugeValues(sXcResources sXcResources2) {
            this.resetValue(0, this.xcResGauges[0], sXcResources2.maxSts, sXcResources2.numSts);
            if (SmpXcResourcePane.this._platform.hasVT2() && SmpXcResourcePane.this._platform.hasXcMixedMode(SmpXcResourcePane.this.chassis)) {
                this.resetValue(1, this.xcResGauges[1], sXcResources2.maxTermVt2, sXcResources2.numTermVt2);
                this.resetValue(2, this.xcResGauges[2], sXcResources2.maxVt2, sXcResources2.numVt2);
                this.resetValue(3, this.xcResGauges[3], sXcResources2.maxTermVt15, sXcResources2.numTermVt15);
                this.resetValue(4, this.xcResGauges[4], sXcResources2.maxVt15, sXcResources2.numVt15);
            } else {
                this.resetValue(1, this.xcResGauges[1], sXcResources2.maxTermVt15, sXcResources2.numTermVt15);
                this.resetValue(2, this.xcResGauges[2], sXcResources2.maxVt15, sXcResources2.numVt15);
            }
        }
    }

    private class XcResourceModel
    extends Observable {
        private XcResourceModel() {
        }

        void refreshButtonPushed() {
            this.setChanged();
            this.notifyObservers();
        }
    }

    private abstract class XcResourcePanel
    extends JPanel {
        protected List labelList;
        protected List usageLabelList;
        protected JProgressBar[] xcResGauges;
        protected JPanel loAditUsageButtonRow;
        protected JPanel matrixPortRadioRow;
        JPanel loAditPanel;

        protected XcResourcePanel(IPlatform iPlatform, IChassisModel iChassisModel) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createResourcePanel(iPlatform, iChassisModel), "West");
            this.loAditPanel = this.createLoAditPanel();
            this.add((Component)this.loAditPanel, "Center");
        }

        protected abstract String[] getResourceNames(IPlatform var1, IChassisModel var2);

        protected JPanel createResourcePanel(IPlatform iPlatform, IChassisModel iChassisModel) {
            JPanel jPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(3);
            borderLayout.setVgap(3);
            jPanel.setLayout(borderLayout);
            jPanel.setBorder(BorderFactory.createTitledBorder("Summary"));
            JPanel jPanel2 = new JPanel();
            UScrollPane uScrollPane = new UScrollPane((Component)jPanel2, 20, 30);
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(0, 3, 0, 3);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridwidth = -1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridwidth = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridwidth = 0;
            this.labelList = new ArrayList();
            this.usageLabelList = new ArrayList();
            int n = 3;
            String[] stringArray = this.getResourceNames(iPlatform, iChassisModel);
            this.xcResGauges = new JProgressBar[stringArray.length];
            for (int i = 0; i < this.xcResGauges.length; ++i) {
                JLabel jLabel = new JLabel(stringArray[i], 2);
                this.labelList.add(jLabel);
                this.xcResGauges[i] = new JProgressBar();
                this.xcResGauges[i].setStringPainted(true);
                gridBagConstraints.gridy = i * n;
                jPanel2.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints2.gridy = i * n;
                jPanel2.add((Component)this.xcResGauges[i], gridBagConstraints2);
                jLabel = new JLabel("             ");
                this.usageLabelList.add(jLabel);
                gridBagConstraints3.gridy = i * n;
                jPanel2.add((Component)jLabel, gridBagConstraints3);
                gridBagConstraints4.gridy = i * n + 1;
                jPanel2.add(Box.createRigidArea(new Dimension(250, 5)), gridBagConstraints4);
            }
            jPanel.add((Component)uScrollPane, "Center");
            return jPanel;
        }

        protected JPanel createLoAditPanel() {
            db.info("XcResourcePanel <init>");
            TDMTerminology tDMTerminology = SmpXcResourcePane.this.chassis.getTDMTerminology();
            String string = tDMTerminology.getGeneralTerms(1);
            SmpXcResourcePane.this.loAditUsageSP = SmpXcResourcePane.this._dsc.initTable();
            boolean bl = SmpXcResourcePane.this._platform.hasVC11() && SmpXcResourcePane.this._platform.hasXcMixedMode(SmpXcResourcePane.this.chassis);
            boolean bl2 = SmpXcResourcePane.this._platform.hasVT2() && SmpXcResourcePane.this._platform.hasXcMixedMode(SmpXcResourcePane.this.chassis);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            this.loAditUsageButtonRow = AbstractPane.createHorizontalPanel(null);
            this.matrixPortRadioRow = AbstractPane.createHorizontalPanel(null);
            ITdmProtocolType iTdmProtocolType = SmpXcResourcePane.this.chassis.getTdmProtocolTypeObj();
            if (iTdmProtocolType.isSdh()) {
                jPanel.setBorder(BorderFactory.createTitledBorder("TUG3 Matrix Port Detail"));
                SmpXcResourcePane.this.radioButtonGroup = new ButtonGroup();
                if (bl) {
                    SmpXcResourcePane.this.radioButtonGroup.add(SmpXcResourcePane.this.vc11RadioBtn = new JRadioButton("VC11"));
                }
                SmpXcResourcePane.this.radioButtonGroup.add(SmpXcResourcePane.this.vc12RadioBtn = new JRadioButton("VC12"));
                SmpXcResourcePane.this.radioButtonGroup.add(SmpXcResourcePane.this.vc3RadioBtn = new JRadioButton("VC3"));
                SmpXcResourcePane.this.radioButtonGroup.add(SmpXcResourcePane.this.unusedRadioBtn = new JRadioButton("Unused"));
                String string2 = null;
                if (bl) {
                    this.matrixPortRadioRow.add(SmpXcResourcePane.this.vc11RadioBtn);
                    SmpXcResourcePane.this.vc11RadioBtn.setSelected(true);
                    string2 = SmpXcResourcePane.this.vc11RadioBtn.getText();
                } else {
                    SmpXcResourcePane.this.vc12RadioBtn.setSelected(true);
                    string2 = SmpXcResourcePane.this.vc12RadioBtn.getText();
                }
                SmpXcResourcePane.this.setExportTableName(string2);
                this.matrixPortRadioRow.add(SmpXcResourcePane.this.vc12RadioBtn);
                this.matrixPortRadioRow.add(SmpXcResourcePane.this.vc3RadioBtn);
                this.matrixPortRadioRow.add(SmpXcResourcePane.this.unusedRadioBtn);
                SmpXcResourcePane.this.matrixSelListener = new RadioListener();
                if (bl) {
                    SmpXcResourcePane.this.vc11RadioBtn.addActionListener(SmpXcResourcePane.this.matrixSelListener);
                }
                SmpXcResourcePane.this.vc12RadioBtn.addActionListener(SmpXcResourcePane.this.matrixSelListener);
                SmpXcResourcePane.this.vc3RadioBtn.addActionListener(SmpXcResourcePane.this.matrixSelListener);
                SmpXcResourcePane.this.unusedRadioBtn.addActionListener(SmpXcResourcePane.this.matrixSelListener);
                jPanel.add((Component)this.matrixPortRadioRow, "North");
            } else {
                jPanel.setBorder(BorderFactory.createTitledBorder(string + " Matrix Port Detail"));
                SmpXcResourcePane.this.radioButtonGroup = new ButtonGroup();
                SmpXcResourcePane.this.radioButtonGroup.add(SmpXcResourcePane.this.vt15RadioBtn = new JRadioButton("VT1.5"));
                if (bl2) {
                    SmpXcResourcePane.this.radioButtonGroup.add(SmpXcResourcePane.this.vt2RadioBtn = new JRadioButton("VT2"));
                }
                this.matrixPortRadioRow.add(SmpXcResourcePane.this.vt15RadioBtn);
                if (bl2) {
                    this.matrixPortRadioRow.add(SmpXcResourcePane.this.vt2RadioBtn);
                    SmpXcResourcePane.this.vt15RadioBtn.setSelected(true);
                    SmpXcResourcePane.this.vt2RadioBtn.setSelected(false);
                } else {
                    SmpXcResourcePane.this.vt15RadioBtn.setSelected(true);
                }
                SmpXcResourcePane.this.setExportTableName(SmpXcResourcePane.this.vt15RadioBtn.getText());
                SmpXcResourcePane.this.matrixSelListener = new RadioListener();
                SmpXcResourcePane.this.vt15RadioBtn.addActionListener(SmpXcResourcePane.this.matrixSelListener);
                if (bl2) {
                    SmpXcResourcePane.this.vt2RadioBtn.addActionListener(SmpXcResourcePane.this.matrixSelListener);
                }
                jPanel.add((Component)this.matrixPortRadioRow, "North");
            }
            SmpXcResourcePane.this.deleteButton = new JButton(SmpXcResourcePane.DELETE);
            SmpXcResourcePane.this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    XcResourcePanel.this.deleteSelectedLoAdit();
                }
            });
            this.loAditUsageButtonRow.add(Box.createHorizontalStrut(5));
            this.loAditUsageButtonRow.add(SmpXcResourcePane.this.deleteButton);
            SmpXcResourcePane.this.manageButtons();
            jPanel.add((Component)SmpXcResourcePane.this.loAditUsageSP, "Center");
            jPanel.add((Component)this.loAditUsageButtonRow, "South");
            return jPanel;
        }

        private void deleteSelectedLoAdit() {
            LoAditUsageRowObject loAditUsageRowObject = SmpXcResourcePane.this._dsc.getSelected();
            if (loAditUsageRowObject != null && CerentDialog.yesNoDialog((Component)this, (String)"Deleting the selected cross-connect\n might lead to loss of traffic and/or partial circuits.\n\nIs it OK to continue?", (String)"Confirm Deletion")) {
                try {
                    loAditUsageRowObject.deleteLoAdit();
                }
                catch (Busy busy) {
                    ErrorMsg.displayError((Component)this, (EID)EMC.EID_FAIL_DELETE_CIRCUIT_IN_USE);
                }
            }
        }

        protected void resetValue(int n, JProgressBar jProgressBar, int n2, int n3) {
            String string = " (" + n3 + " of " + n2 + ") ";
            jProgressBar.setMaximum(n2);
            jProgressBar.setValue(n3);
            this.resetLabel(n, string);
            if (n2 == 0) {
                ((JLabel)this.labelList.get(n)).setEnabled(false);
                jProgressBar.setString("0%");
            } else {
                ((JLabel)this.labelList.get(n)).setEnabled(true);
                jProgressBar.setStringPainted(true);
                jProgressBar.setString(Integer.toString((int)Math.round(jProgressBar.getPercentComplete() * 100.0)) + "%");
            }
            jProgressBar.setToolTipText("total = " + n2 + ", used = " + n3);
            jProgressBar.repaint();
        }

        public abstract void resetLabel(int var1, String var2);

        public abstract void resetGaugeValues(sXcResources var1);

        public void dispose() {
            this.labelList = null;
            this.xcResGauges = null;
        }
    }
}

