/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IChassisModel;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractSppTimingBitsPane;
import cerent.cms.ui.shelf.AbstractTimingBitsFacilityPane;
import cerent.cms.ui.shelf.SonetSppTimingBitsPane;
import cerent.cms.ui.shelf.sdh.SdhSppTimingBitsPane;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Observable;
import javax.swing.JPanel;

public class SonetTimingBitsFacilityPane
extends AbstractTimingBitsFacilityPane {
    private JPanel cards;
    private CardLayout cardLayout;
    private AbstractSppTimingBitsPane sonetCard;
    private AbstractSppTimingBitsPane sdhCard;
    private AbstractSppTimingBitsPane topCard;
    private boolean is454;
    private boolean isUTS;

    public SonetTimingBitsFacilityPane(String string, TabbedView tabbedView, SynchronizationModel synchronizationModel) {
        super(string, tabbedView, synchronizationModel);
    }

    @Override
    public JPanel getBitsFacilityPane(String string, TabbedView tabbedView) {
        this.cards = new JPanel();
        this.cardLayout = new CardLayout();
        this.cards.setLayout(this.cardLayout);
        this.sonetCard = new SonetSppTimingBitsPane(string, tabbedView, this.syncModel);
        this.cards.add((Component)((Object)this.sonetCard), "SONET_BITS_FACILITY_CARD");
        this.is454 = ((IChassisModel)this.getUiModel()).getPlatform().is454();
        this.isUTS = ((IChassisModel)this.getUiModel()).getPlatform().isUTS();
        if (this.is454 || this.isUTS) {
            this.sdhCard = new SdhSppTimingBitsPane(string, tabbedView, this.syncModel);
            this.cards.add((Component)((Object)this.sdhCard), "SDH_BITS_FACILITY_CARD");
        }
        return this.cards;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.isShowing()) {
            this.showTopCard();
            super.update(observable, object);
        }
    }

    @Override
    public void refresh() throws Exception {
        if (db.on()) {
            db.println("topCard refresh");
        }
        this.topCard.refresh();
    }

    @Override
    public void enteringPage() throws Exception {
        this.showTopCard();
        if (db.on()) {
            db.println("topCard enteringPage");
        }
        this.topCard.enteringPage();
    }

    @Override
    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("topCard leavingPage");
        }
        this.topCard.leavingPage();
    }

    @Override
    public void dispose() {
        if (this.sonetCard != null) {
            this.sonetCard.destroy();
        }
        if (this.sdhCard != null) {
            this.sdhCard.destroy();
        }
        this.cardLayout = null;
        super.dispose();
    }

    private void showTopCard() {
        if (this.is454 || this.isUTS) {
            if (this.syncModel.isSonetTimingStandard()) {
                this.cardLayout.show(this.cards, "SONET_BITS_FACILITY_CARD");
                this.topCard = this.sonetCard;
            } else {
                this.cardLayout.show(this.cards, "SDH_BITS_FACILITY_CARD");
                this.topCard = this.sdhCard;
            }
        } else {
            this.topCard = this.sonetCard;
        }
        if (db.on()) {
            db.println("topCard=" + this.topCard.getClass().getName());
        }
    }
}

