/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.Attribute;
import cerent.cms.model.DhcpProvisioned;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.Feature;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.IServerTrailsManager;
import cerent.cms.model.InvalidMask;
import cerent.cms.model.IpConfigError;
import cerent.cms.model.LanOSPFProvisioned;
import cerent.cms.model.LcdIpSetting;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProxyPortError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.StandbyTccNotReady;
import cerent.cms.model.SubnetsDifferent;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.IpAddrPanel;
import cerent.cms.ui.shelf.ProxySettingsPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.IpSubnet;
import cerent.util.KDebug;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SppNetworkGeneralPane
extends NodeProvPane
implements ActionListener,
PropertyChangeListener,
DocumentListener {
    private static final Dimension ROW_SIZE = new Dimension(TabbedView.TABBED_VIEW_DIM.width, 25);
    private JTextField dhcpTF = null;
    private int iiopPortVal;
    private JCheckBox useDhcpCB = null;
    private boolean mustReboot = false;
    private IpAddrPanel ipAddrPanel;
    private ProxySettingsPane proxyPanel;
    private int proxyPortVal = 0;
    private JLabel proxyStatusLabel;
    private boolean proxyIsDirty = false;
    private static final Attribute[] LCD_IP_SETTING_ATTRS = new Attribute[LcdIpSetting.LCD_IP_SETTING.length];
    protected static final SDebug db;

    public SppNetworkGeneralPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        super(string, tabbedView);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.SppNetworkGeneralPane;
    }

    private void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        JPanel jPanel = new JPanel();
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.add((Component)uScrollPane);
        Dimension dimension = new Dimension(SppNetworkGeneralPane.ROW_SIZE.width, 400);
        jPanel.setPreferredSize(dimension);
        jPanel.setMaximumSize(dimension);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = SppNetworkGeneralPane.createHorizontalPanel(null);
        this.ipAddrPanel = new IpAddrPanel(this, true);
        this.ipAddrPanel.setAlignmentX(0.0f);
        jPanel2.add(this.ipAddrPanel);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = SppNetworkGeneralPane.createHorizontalPanel(null);
        this.getDhcpPanel(jPanel2);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = SppNetworkGeneralPane.createHorizontalPanel(null);
        jPanel2.add(this.createProxyPanel());
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        this.registerWithModel();
        if (db.on()) {
            db.println("init: finish");
        }
    }

    private ProxySettingsPane createProxyPanel() {
        if (db.on()) {
            db.println("Adding Proxy Panel");
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.proxyPanel = new ProxySettingsPane(this, this.isUserAuthorized());
        this.proxyPanel.init(nodeModelDelegate);
        return this.proxyPanel;
    }

    private JPanel getDhcpPanel(JPanel jPanel) {
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        this.useDhcpCB = new JCheckBox("Forward DHCP Requests to:");
        jPanel.add(this.useDhcpCB);
        this.useDhcpCB.addActionListener(this);
        this.useDhcpCB.setEnabled(this.isUserAuthorized());
        this.dhcpTF = this.addTextPanel(jPanel, null, 13, new DhcpDocListener());
        return jPanel;
    }

    private JTextField addTextPanel(JPanel jPanel, String string, int n, DocumentListener documentListener) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        JTextField jTextField = new JTextField(n);
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jPanel2.add(jTextField);
        jPanel.add(jPanel2);
        if (this.isUserAuthorized()) {
            jTextField.getDocument().addDocumentListener(documentListener);
        } else {
            jTextField.setEditable(false);
        }
        return jTextField;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(100, 20));
        return jLabel;
    }

    private JCheckBox addCheckBox(JPanel jPanel, String string, boolean bl, ActionListener actionListener) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setAlignmentX(0.0f);
        jCheckBox.setEnabled(bl);
        jCheckBox.addActionListener(actionListener);
        jPanel.add(jCheckBox);
        return jCheckBox;
    }

    private JRadioButton addRadioButton(JPanel jPanel, ButtonGroup buttonGroup, String string, boolean bl, ActionListener actionListener) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setAlignmentX(0.0f);
        jRadioButton.setEnabled(bl);
        jRadioButton.addActionListener(actionListener);
        jRadioButton.setSize(new Dimension(80, 20));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel2.add(jRadioButton);
        jPanel.add(jPanel2);
        buttonGroup.add(jRadioButton);
        return jRadioButton;
    }

    protected void setDhcpWidgets(boolean bl) {
        if (db.on()) {
            db.println("called setDhcpWidgets with state " + bl);
        }
        this.dhcpTF.setEnabled(bl);
        this.useDhcpCB.setSelected(bl);
        if (!bl) {
            this.dhcpTF.setText("");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.useDhcpCB) {
            boolean bl = this.useDhcpCB.isSelected();
            if (db.on()) {
                db.println("itemStateChanged: DHCP=" + bl);
            }
            this.setDhcpWidgets(bl);
        }
        this.setDirty();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringPage() throws Exception {
        try {
            this.setCursor(3);
            if (this.ipAddrPanel == null) {
                this.init();
            }
            super.enteringPage();
        }
        finally {
            this.setCursor(0);
        }
    }

    @Override
    public boolean onValidate() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        IIpConfig iIpConfig = nodeModelDelegate.getIpConfig();
        ISecureIpConfig iSecureIpConfig = nodeModelDelegate.getSecureIpConfig();
        if (this.ipAddrPanel.mustReboot()) {
            this.mustReboot = true;
        }
        if (iIpConfig.getNodeMode() && !this.ipAddrPanel.isNodeInIPv6Mode()) {
            if (!ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_DISABLE_IPV6_MODE, "Disable IPv6 mode")) {
                return false;
            }
            if (!nodeModelDelegate.getSecurityModel().getIPv4Access()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_IPV6_ACCESS_CANNOT_BE_DISABLED_IPV4_DISABLED, (Object)"Disable IPv6 mode");
                return false;
            }
        }
        try {
            if (this.mustReboot) {
                if (!nodeModelDelegate.isResetAllowed()) {
                    ErrorMsg.displayWarning((Component)((Object)this), (WID)EMC.WID_SOFTWARE_UPGRADE_DENIED);
                    return false;
                }
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Changing the network configuration will cause a reboot or\nprotection switch of the active " + this.pci.getControlCardName() + " and may lead to loss\n" + "of communication with the node.\n\n" + "Make the change anyway?"), (String)"Change Network Configuration?")) {
                    return false;
                }
            }
            if (!this.ipAddrPanel.validatePanel()) {
                return false;
            }
            iIpConfig.setIpAddress(this.ipAddrPanel.getIpAddr());
            iIpConfig.setDefaultRouter(this.ipAddrPanel.getDefaultRouterAddr());
            iIpConfig.setNetMaskPrefixLength(this.ipAddrPanel.getNetmaskPrefixLength());
            if (nodeModelDelegate.isSecureMode()) {
                InetUtil.validateIpConfig(iSecureIpConfig, iIpConfig, "Backplane LAN port ");
            } else {
                InetUtil.validateIpConfig(iIpConfig, "Host ");
            }
            if (!this.proxyPanel.validateProxySettings(nodeModelDelegate)) {
                return false;
            }
        }
        catch (IpConfigError ipConfigError) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONFIG_PARAM_1, (Object)ipConfigError.getMessage());
            return false;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VALIDATION_ERROR);
            return false;
        }
        return true;
    }

    @Override
    public void applyChangesToModel() throws IpConfigError, ProxyPortError, InvalidMask, SubnetsDifferent, DhcpProvisioned, LanOSPFProvisioned, StandbyTccNotReady, EMCProvisionError, Exception {
        IIpAddr iIpAddr;
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        IIpConfig iIpConfig = nodeModelDelegate.getIpConfig();
        ISecureIpConfig iSecureIpConfig = nodeModelDelegate.getSecureIpConfig();
        boolean bl = false;
        boolean bl2 = true;
        if (this.useDhcpCB != null) {
            if (this.useDhcpCB.isSelected()) {
                String string = this.dhcpTF.getText();
                iIpAddr = InetUtil.makeIpAddr(string);
                try {
                    nodeModelDelegate.setDhcpServerAddr(iIpAddr);
                }
                catch (xProvisionError xProvisionError2) {
                    EMCProvisionError eMCProvisionError = new EMCProvisionError(xProvisionError2, this.formatInternalSubnets(), nodeModelDelegate.getPlatform());
                    ErrorMsg.displayError((Component)((Object)this), (EID)eMCProvisionError.getEID());
                }
                if (db.on()) {
                    db.println("Setting DHCP to non-zero.");
                }
            } else {
                if (InetUtil.makeIpV4(nodeModelDelegate.getDhcpServerAddr()) != 0) {
                    if (db.on()) {
                        db.println("applyChangesToModel: clearing DHCP host");
                    }
                    nodeModelDelegate.setDhcpServerAddr(InetUtil.makeIpAddr(0));
                }
                if (db.on()) {
                    db.println("Setting DHCP zero value.");
                }
            }
        }
        if (nodeModelDelegate.provides(Feature.IDL_LCDIp)) {
            nodeModelDelegate.setLcdIpSetting(this.ipAddrPanel.getLcdIpSetting(), bl2);
        }
        boolean bl3 = this.ipAddrPanel.getCtcIpSuppressed();
        if (nodeModelDelegate.getCtcIpDisplaySuppression(bl2) != bl3) {
            nodeModelDelegate.setCtcIpDisplaySuppression(bl2, bl3);
        }
        this.proxyPanel.applyChanges(nodeModelDelegate);
        if (this.ipAddrPanel.isDefRouterChanged()) {
            iIpConfig.setDefaultRouter(this.ipAddrPanel.getDefaultRouterAddr());
            bl = true;
        }
        iIpConfig.setNodeMode(this.ipAddrPanel.isNodeInIPv6Mode());
        iIpConfig.setIpv6Address(this.ipAddrPanel.getIpAddrV6());
        iIpConfig.setDefaultRouterV6(this.ipAddrPanel.getV6DefaultRouterAddr());
        iIpConfig.setV6PrefixLength(this.ipAddrPanel.getIpv6PrefixLength());
        if (this.mustReboot || this.ipAddrPanel.isIpv6ConfigChanged()) {
            iIpConfig.setIpAddress(this.ipAddrPanel.getIpAddr());
            try {
                iIpConfig.setNetMaskPrefixLength(this.ipAddrPanel.getNetmaskPrefixLength());
            }
            catch (NumberFormatException numberFormatException) {
                SDebug.printStackTrace((Throwable)numberFormatException);
            }
            bl = true;
        }
        if (bl) {
            if (db.on()) {
                db.println("applyChangesToModel: set IP config");
            }
            try {
                if (nodeModelDelegate.getPlatform().isSecureModeSupported() && nodeModelDelegate.isSecureMode()) {
                    nodeModelDelegate.setSecureIpConfig(iIpConfig, iSecureIpConfig);
                } else {
                    IServerTrailsManager iServerTrailsManager;
                    iIpAddr = nodeModelDelegate.getVirtualLinksManager();
                    if (iIpAddr != null && iIpAddr.getVirtualLinks() != null && iIpAddr.getVirtualLinks().length > 0) {
                        ErrorMsg.displayWarning((Component)((Object)this), (WID)EMC.WID_CHG_IP_ADDR_REPAIR_PPCS);
                    }
                    if ((iServerTrailsManager = nodeModelDelegate.getServerTrailsManager()) != null && iServerTrailsManager.getServerTrails() != null && iServerTrailsManager.getServerTrails().length > 0) {
                        ErrorMsg.displayWarning((Component)((Object)this), (WID)EMC.WID_CHG_IP_ADDR_REPAIR_SERVER_TRAILS);
                    }
                    nodeModelDelegate.setIpConfig(iIpConfig);
                }
            }
            catch (xProvisionError xProvisionError3) {
                EMCProvisionError eMCProvisionError = new EMCProvisionError(xProvisionError3, nodeModelDelegate.getPlatform());
                ErrorMsg.displayError((Component)((Object)this), (EID)eMCProvisionError.getEID());
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("applyChangesToModel: Error setting IP address");
                }
                super.setDirty(false);
                throw new Exception(exception.getMessage());
            }
        }
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }

    @Override
    public void refreshFromModel() {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        IIpConfig iIpConfig = nodeModelDelegate.getIpConfig();
        boolean bl = true;
        this.ipAddrPanel.setIpConfig(nodeModelDelegate, iIpConfig.getIpAddress(), iIpConfig.getDefaultRouter(), iIpConfig.getNetMaskPrefixLength(), iIpConfig.getNodeMode(), iIpConfig.getIpv6Address(), iIpConfig.getV6PrefixLength(), iIpConfig.getDefaultRouterV6());
        if (this.useDhcpCB != null) {
            int n = InetUtil.makeIpV4(nodeModelDelegate.getDhcpServerAddr());
            boolean bl2 = n != 0;
            this.useDhcpCB.setSelected(bl2);
            this.dhcpTF.setText(bl2 ? InetUtil.makeDottedString(n) : "");
            this.setDhcpWidgets(bl2);
        }
        this.proxyPanel.refresh(nodeModelDelegate, true);
        this.mustReboot = false;
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    private String formatInternalSubnets() {
        String string;
        block5: {
            string = " ";
            try {
                StringBuffer stringBuffer = new StringBuffer();
                NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
                if (nodeModelDelegate != null) {
                    IpSubnet[] ipSubnetArray = nodeModelDelegate.getPlatform().getInternalSubnets(nodeModelDelegate);
                    if (ipSubnetArray != null && ipSubnetArray.length > 0) {
                        stringBuffer.append("The DHCP server address cannot be the same as the node IP \n");
                        stringBuffer.append("address or the IP ");
                        stringBuffer.append(PluralisationUtil.s("address", ipSubnetArray.length));
                        stringBuffer.append(" (");
                        stringBuffer.append(ipSubnetArray[0]);
                        for (int i = 1; i < ipSubnetArray.length; ++i) {
                            stringBuffer.append(", ");
                            stringBuffer.append(ipSubnetArray[i]);
                        }
                        stringBuffer.append(") ");
                        stringBuffer.append(" reserved for internal communication.");
                    }
                    string = stringBuffer.toString();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("error getting internal subnets");
            }
        }
        return string;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
        this.mustReboot = true;
    }

    static {
        for (int i = 0; i < LCD_IP_SETTING_ATTRS.length; ++i) {
            SppNetworkGeneralPane.LCD_IP_SETTING_ATTRS[i] = new Attribute(LcdIpSetting.LCD_IP_SETTING[i], i);
        }
        db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppNetworkGeneralPane");
    }

    private class DhcpDocListener
    implements DocumentListener {
        private DhcpDocListener() {
        }

        protected void generalChanges(DocumentEvent documentEvent) {
            SppNetworkGeneralPane.this.setDirty();
            try {
                String string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getEndPosition().getOffset()).trim();
                if (string.equals("0.0.0.0")) {
                    CerentDialog.infoDialog((Component)((Object)SppNetworkGeneralPane.this), (String)"Setting the DHCP forwarding address to 0.0.0.0 effectively disables DHCP forwarding.", (String)"DHCP Forwarding Will Be Disabled");
                    SppNetworkGeneralPane.this.setDhcpWidgets(false);
                }
            }
            catch (Exception exception) {
                db.println("Caught exception in generalChanges");
                SDebug.printStackTrace((Throwable)exception);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.generalChanges(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.generalChanges(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.generalChanges(documentEvent);
        }
    }
}

