/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.sGreTunnel;
import cerent.cms.model.IOsiConstants;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.OsiModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.GreTunnelCreationDialog;
import cerent.cms.ui.shelf.GreTunnelEditDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.InetUtil;
import cerent.util.ObservableManager;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

public class SppOsiGreTunnelPane
extends AbstractShelfEditTablePane
implements IOsiConstants {
    public static final int GRE_DEST_IP_IDX = 0;
    public static final int GRE_DEST_IPMASK_IDX = 1;
    public static final int GRE_OSPF_METRIC_IDX = 2;
    public static final int GRE_DEST_NSAP_IDX = 3;
    protected OsiModel osiModel;

    public SppOsiGreTunnelPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    @Override
    protected void localInit() {
        super.localInit();
        ListSelectionModel listSelectionModel = this.getTable().getSelectionModel();
        listSelectionModel.setSelectionMode(2);
    }

    @Override
    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new DestIpColumnRenderer(), new DestIpMaskColumnRenderer(), new OspfMetricColumnRenderer(), new DestNsapColumnRenderer()};
        this.osiModel = this.nodeModel.getOsiModel();
        GreTableRowSource greTableRowSource = new GreTableRowSource();
        this.model = new SortableRowTableModel((RowDataSource)greTableRowSource, columnRendererArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        super.actionPerformed(actionEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (this.getTable().getSelectedRowCount() > 1) {
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateTableData() {
        List list = this.tableData;
        synchronized (list) {
            this.tableData = new ArrayList();
            try {
                sGreTunnel[] sGreTunnelArray = this.osiModel.getGreTunnels();
                for (int i = 0; i < sGreTunnelArray.length; ++i) {
                    this.tableData.add(sGreTunnelArray[i]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                db.println("Error in getting GRE Table: " + exception);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.table != null) {
            this.table.removeMouseListener(this);
        }
        super.destroy();
    }

    @Override
    protected void createTableEntry() {
        GreTunnelCreationDialog greTunnelCreationDialog = GreTunnelCreationDialog.instance(this);
        greTunnelCreationDialog.show();
        greTunnelCreationDialog.dispose();
    }

    @Override
    protected void editSelectedTableEntry(int n) {
        sGreTunnel sGreTunnel2 = (sGreTunnel)this.model.getValueAt(n, 0);
        GreTunnelEditDialog greTunnelEditDialog = GreTunnelEditDialog.instance(this);
        if (sGreTunnel2 != null) {
            greTunnelEditDialog.setSelectedTunnel(sGreTunnel2);
        }
        greTunnelEditDialog.show();
        greTunnelEditDialog.dispose();
    }

    @Override
    protected void deleteSelectedTableEntry(int n) {
        int n2;
        int[] nArray = this.getTable().getSelectedRows();
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Are you sure you want to delete  the selected IP Over CLNS Tunnel" + (nArray.length > 1 ? "s?" : "?")), (String)"Confirmation Dialog")) {
            return;
        }
        this.setEditDeleteEnabled(false);
        sGreTunnel[] sGreTunnelArray = new sGreTunnel[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 0 && nArray[n2] < this.model.getRowCount()) {
                sGreTunnelArray[n2] = (sGreTunnel)this.model.getValueAt(nArray[n2], 0);
                continue;
            }
            db.severe("Selected entry does not exist, index: " + nArray[n2]);
            sGreTunnelArray[n2] = null;
        }
        for (n2 = 0; n2 < sGreTunnelArray.length; ++n2) {
            if (sGreTunnelArray[n2] == null) continue;
            try {
                this.osiModel.removeGreTunnel(sGreTunnelArray[n2].ip.address, sGreTunnelArray[n2].ip.mask, sGreTunnelArray[n2].nsap);
                continue;
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_GRE_TUNNEL_DELETE_FAIL);
            }
        }
    }

    @Override
    protected void registerWithModels() {
        if (this.osiModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.osiModel));
        }
    }

    @Override
    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.OsiGreTunnelPane;
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 100;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(sGreTunnel sGreTunnel2, int n) {
            String string = "???";
            switch (n) {
                case 0: {
                    string = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sGreTunnel2.ip.address));
                    break;
                }
                case 1: {
                    string = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sGreTunnel2.ip.mask));
                    break;
                }
                case 2: {
                    string = Integer.toString(sGreTunnel2.ospfMetric);
                    break;
                }
                case 3: {
                    string = OsiHelper.getNsapString((byte[])sGreTunnel2.nsap);
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sGreTunnel sGreTunnel2 = (sGreTunnel)jTable.getValueAt(n, 0);
            String string = this.getStringValue(sGreTunnel2, n2);
            JLabel jLabel = new JLabel(string);
            if (n2 == 3) {
                jLabel.setFont(OsiHelper.FIXED_WIDTH_FONT);
            }
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((sGreTunnel)object, n);
            String string2 = this.getStringValue((sGreTunnel)object2, n);
            return string.compareTo(string2);
        }
    }

    class DestIpColumnRenderer
    extends BaseColumnRenderer {
        DestIpColumnRenderer() {
        }

        public String getName() {
            return "Destination IP";
        }

        @Override
        public int getWidth() {
            return 130;
        }
    }

    class DestIpMaskColumnRenderer
    extends BaseColumnRenderer {
        DestIpMaskColumnRenderer() {
        }

        public String getName() {
            return "Destination IP Mask";
        }

        @Override
        public int getWidth() {
            return 130;
        }
    }

    class DestNsapColumnRenderer
    extends BaseColumnRenderer {
        DestNsapColumnRenderer() {
        }

        public String getName() {
            return "Destination NSAP";
        }

        @Override
        public int getWidth() {
            return 400;
        }
    }

    class GreTableRowSource
    extends AbstractRowDataSource {
        GreTableRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = SppOsiGreTunnelPane.this.tableData;
            synchronized (list) {
                var2_2 = SppOsiGreTunnelPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = SppOsiGreTunnelPane.this.tableData;
            synchronized (list) {
                n = SppOsiGreTunnelPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = SppOsiGreTunnelPane.this.tableData;
            synchronized (list) {
                return SppOsiGreTunnelPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return sGreTunnel.class;
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            SppOsiGreTunnelPane.this.resetObservableManager();
            SppOsiGreTunnelPane.this.registerWithModels();
            SppOsiGreTunnelPane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            SppOsiGreTunnelPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)SppOsiGreTunnelPane.this), true);
            }
            return this.dscObservableManager;
        }
    }

    class OspfMetricColumnRenderer
    extends BaseColumnRenderer {
        OspfMetricColumnRenderer() {
        }

        public String getName() {
            return "OSPF Cost";
        }

        @Override
        public int getWidth() {
            return 75;
        }
    }
}

