/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.GfpPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.MrSlot;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.DwdmCardView;
import cerent.cms.ui.shelf.DwdmGenericPortGraphic;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class XP40GCardView
extends DwdmCardView {
    private static final SDebug db = new SDebug("XP40GCardView");
    private static final int MAX_NUM_GFP_40G = 4;

    public XP40GCardView(ModuleModel moduleModel, AbstractCardViewPanel abstractCardViewPanel) {
        super((EntityModel)moduleModel, abstractCardViewPanel);
    }

    @Override
    protected List<PortModel> getPorts() {
        Object object;
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>();
        if ((this.model.getEqTypeEnum() == eEqType.XT_40G_LINE_CARD || this.model.getEqTypeEnum() == eEqType.XT_40E_LINE_CARD) && (object = ((DwdmModuleModel)this.model).getMrSlot()) != null) {
            arrayList.addAll(((EntityModel)object).getDescendantsOfClassType(7));
        }
        object = this.model.getDescendantsOfType(eEqType.DWDM_TRUNK_PORT);
        ArrayList<DwdmPortModel> arrayList2 = new ArrayList<DwdmPortModel>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            DwdmPortModel dwdmPortModel = (DwdmPortModel)iterator.next();
            if (dwdmPortModel.isClientPort()) continue;
            arrayList2.add(dwdmPortModel);
        }
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    @Override
    protected void addPorts(boolean bl) {
        this.moduleM = (DwdmModuleModel)this.model;
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = new Insets(2, 3, 2, 2);
        this.ports = new GenericPortGraphic[this.numPorts + 4];
        this.add((Component)new JLabel("Port"), this.gbc);
        this.addDwdmPortsToCard();
        if (this.model.getEqTypeEnum() == eEqType.XM_40G_LINE_CARD || this.model.getEqTypeEnum() == eEqType.XM_40G_CE_LINE_CARD) {
            this.addFiller();
            this.add((Component)new JLabel("GFP/WIS"), this.gbc);
            this.updateGfpPorts();
            this.updateWisPorts();
        }
        this.invalidate();
    }

    private void addDwdmPortsToCard() {
        if (this.moduleM.supportSfpPort()) {
            this.addPpmPorts();
        } else {
            this.addMrPorts();
        }
        for (int i = 0; i < this.numPorts; ++i) {
            PortModel portModel = (PortModel)this.portModels.get(i);
            if (portModel.getEqType() != 123) continue;
            this.ports[i] = new DwdmGenericPortGraphic((CardView)this, (EntityModel)portModel, portModel.getPort(), portModel.isSpecial(), this.cardViewPanel);
            if (this.pci.positionPortsVertically()) {
                ++this.gbc.gridy;
            } else {
                ++this.gbc.gridx;
            }
            this.add((Component)this.ports[i], this.gbc);
        }
    }

    private void addFiller() {
        JPanel jPanel = new JPanel();
        if (this.pci.positionPortsVertically()) {
            jPanel.setPreferredSize(new Dimension(20, 0));
            ++this.gbc.gridx;
            this.gbc.gridy = 0;
            this.add((Component)jPanel, this.gbc);
            ++this.gbc.gridx;
        } else {
            jPanel.setPreferredSize(new Dimension(0, 20));
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.add((Component)jPanel, this.gbc);
            ++this.gbc.gridy;
        }
    }

    private void updateGfpPorts() {
        GfpPortModel[] gfpPortModelArray = this.moduleM.getGfpPorts();
        if (db.on()) {
            db.println("updageGfpPorts: length= " + gfpPortModelArray.length);
        }
        for (int i = 0; i < gfpPortModelArray.length; ++i) {
            int n = this.portModels.indexOf(gfpPortModelArray[i]);
            if (n != -1) continue;
            int n2 = gfpPortModelArray[i].getPositionInParent();
            if (db.on()) {
                db.println("updageGfpPorts Add Gfp port= " + n2);
            }
            if (this.pci.positionPortsVertically()) {
                this.gbc.gridy = n2;
            } else {
                this.gbc.gridx = n2;
            }
            this.portModels.add(gfpPortModelArray[i]);
            this.ports[this.numPorts] = new GenericPortGraphic(this, gfpPortModelArray[i], n2);
            this.add((Component)this.ports[this.numPorts], this.gbc);
            ++this.numPorts;
        }
    }

    private void updateWisPorts() {
        TdmPortModel[] tdmPortModelArray = this.moduleM.getWisPorts();
        if (db.on()) {
            db.println("updageWisPorts: length= " + tdmPortModelArray.length);
        }
        for (int i = 0; i < tdmPortModelArray.length; ++i) {
            int n = this.portModels.indexOf(tdmPortModelArray[i]);
            if (n != -1) continue;
            int n2 = tdmPortModelArray[i].getPositionInParent();
            if (db.on()) {
                db.println("updageWisPorts Add Gfp port= " + n2);
            }
            if (this.pci.positionPortsVertically()) {
                this.gbc.gridy = n2;
            } else {
                this.gbc.gridx = n2;
            }
            this.portModels.add(tdmPortModelArray[i]);
            this.ports[this.numPorts] = new GenericPortGraphic(this, tdmPortModelArray[i], n2);
            this.add((Component)this.ports[this.numPorts], this.gbc);
            ++this.numPorts;
        }
    }

    @Override
    protected void registerForLocalUpdates() {
        int n;
        MrSlot mrSlot;
        this._obsMgr.reset();
        this._obsMgr.addObservable((Observable)((Object)this.moduleM));
        if (this.model.getEqTypeEnum() == eEqType.XM_40G_LINE_CARD || this.model.getEqTypeEnum() == eEqType.XM_40G_CE_LINE_CARD) {
            this._obsMgr.addObservable((Observable[])this.moduleM.getGfpPorts());
            this._obsMgr.addObservable((Observable[])this.moduleM.getWisPorts());
        }
        if ((mrSlot = this.moduleM.getMrSlot()) != null) {
            this._obsMgr.addObservable((Observable)((Object)mrSlot));
            this._obsMgr.addObservable((Observable[])mrSlot.getDescendantsOfClassType(7).toArray(new PortModel[0]));
        }
        PluggableSlotModel[] pluggableSlotModelArray = this.moduleM.getPpmSlots();
        for (n = 0; n < pluggableSlotModelArray.length; ++n) {
            this._obsMgr.addObservable((Observable)((Object)pluggableSlotModelArray[n]));
        }
        for (n = 0; n < pluggableSlotModelArray.length; ++n) {
            List list = pluggableSlotModelArray[n].getChildren();
            for (EntityModel entityModel : list) {
                if (!(entityModel instanceof PpmModel)) continue;
                this._obsMgr.addObservable((Observable)((Object)entityModel));
                EntityModel entityModel2 = (EntityModel)entityModel.getParent();
                this._obsMgr.addObservable((Observable)((Object)entityModel2));
            }
        }
        this._obsMgr.setActive(true);
        this._obsMgr.setPassing(true);
    }
}

