/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp.crs;

import cerent.cms.idl.Lmp.sControlChannelAttrsEx;
import cerent.cms.model.LmpException;
import cerent.cms.ui.shelf.lmp.crs.CcCommand;
import cerent.cms.ui.shelf.lmp.crs.CrsControlChannelManager;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLIControlChannelAction;
import cerent.util.tty.CLIShowArpAction;
import java.awt.Component;
import java.util.List;

class CcCreateCmd
extends CcCommand {
    private String crsIpAddr;
    private sControlChannelAttrsEx attrs;
    private boolean setLocal;
    private UndoData undoData = new UndoData();
    private boolean setRemote;

    public CcCreateCmd(CrsControlChannelManager crsControlChannelManager, String string, sControlChannelAttrsEx sControlChannelAttrsEx2, boolean bl, boolean bl2) {
        super(crsControlChannelManager);
        this.crsIpAddr = string;
        this.attrs = sControlChannelAttrsEx2;
        this.setLocal = bl;
        this.setRemote = bl2;
    }

    @Override
    public boolean execute() {
        this.undoData.state = UndoState.NO_CHANGE;
        if (this.setRemote) {
            CLIShowArpAction cLIShowArpAction = new CLIShowArpAction(this.crsIpAddr, (KDebug)this.mgr.db);
            List list = cLIShowArpAction.get();
            if (list == null) {
                this.showCliError((CLIAction)cLIShowArpAction);
                return false;
            }
            String string = null;
            for (CLIShowArpAction.ArpInfo arpInfo : list) {
                if (!arpInfo.getIp().equals(this.crsIpAddr)) continue;
                string = arpInfo.getMgmtInterface();
                break;
            }
            if (string == null) {
                ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_CRS_BAD_ARP_PARAM_1, (Object)this.crsIpAddr);
                return false;
            }
            CLIControlChannelAction cLIControlChannelAction = new CLIControlChannelAction(this.crsIpAddr, (KDebug)this.mgr.db);
            if (cLIControlChannelAction.create(this.mgr.localIp, this.crsIpAddr, string)) {
                this.showCliError((CLIAction)cLIControlChannelAction);
                return false;
            }
            this.undoData.state = UndoState.SET_REMOTE;
        }
        if (this.setLocal) {
            try {
                this.undoData.ctrlChannelId = this.mgr.node.getLmpCtrlChannelModels().createCtrlChannel(this.attrs);
            }
            catch (LmpException lmpException) {
                ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)lmpException.getEid());
                return false;
            }
            this.undoData.state = UndoState.SET_LOCAL;
        }
        return true;
    }

    @Override
    public boolean undo() {
        switch (this.undoData.state) {
            case SET_LOCAL: {
                try {
                    this.mgr.node.getLmpCtrlChannelModels().deleteCtrlChannel(this.undoData.ctrlChannelId);
                }
                catch (LmpException lmpException) {
                    ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)lmpException.getEid());
                    return false;
                }
                if (!this.setRemote) break;
            }
            case SET_REMOTE: {
                CLIControlChannelAction cLIControlChannelAction = new CLIControlChannelAction(this.crsIpAddr, (KDebug)this.mgr.db);
                if (!cLIControlChannelAction.delete(this.mgr.localIp)) break;
                this.showCliError((CLIAction)cLIControlChannelAction);
                return false;
            }
        }
        return true;
    }

    private class UndoData {
        UndoState state;
        int ctrlChannelId;

        private UndoData() {
        }
    }

    private static enum UndoState {
        NO_CHANGE,
        SET_REMOTE,
        SET_LOCAL;

    }
}

