/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.sSnmpTrapDestination;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.InvalidData;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.MaxSnmpDestinations;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.shelf.snmp.SnmpAttrsPane;
import cerent.cms.ui.shelf.snmp.SnmpTrapPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.event.DocumentEvent;

public class SnmpEditPane
extends SnmpAttrsPane {
    private static final SDebug snmpEditDb = new SDebug((KDebug)SnmpTrapPane.db, "SnmpEditPane");
    private sSnmpTrapDestination trapDest;

    public SnmpEditPane(SnmpTrapPane snmpTrapPane) {
        super(snmpEditDb, "EditPane", snmpTrapPane);
        this.setComponentsEnabled(false);
    }

    public void setTrapDest(sSnmpTrapDestination sSnmpTrapDestination2) {
        if (sSnmpTrapDestination2 != this.trapDest) {
            this.trapDest = sSnmpTrapDestination2;
            this.refresh();
        }
    }

    public sSnmpTrapDestination getTrapDest() {
        return this.trapDest;
    }

    public void applyChangesToModel() throws MaxSnmpDestinations, ConfigError {
        if (this.db.on()) {
            this.db.println("applyChangesToModel: start");
        }
        SnmpModel snmpModel = this.parent.getSnmpModel();
        if (this.trapDest != null && snmpModel != null) {
            try {
                snmpModel.setSnmpTrapDestination(new sSnmpTrapDestination(this.ipAddr, this.commName, (short)this.udpPort, this.version, this.trapRate, this.relayIpAddr, this.relayCommName));
            }
            catch (MaxSnmpDestinations maxSnmpDestinations) {
                SDebug.printStackTrace((Throwable)maxSnmpDestinations);
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_SNMP_MAX_DESTINATIONS);
            }
            catch (xProvisionError xProvisionError2) {
                EMCProvisionError eMCProvisionError = new EMCProvisionError(xProvisionError2, this.parent.getNMD().getPlatform());
                ErrorMsg.displayError((Component)this, (EID)eMCProvisionError.getEID());
            }
            catch (ConfigError configError) {
                IIpAddr iIpAddr = IpAddrFactory.getIIpAddr(this.ipAddr);
                String string = InetUtil.makeDottedString(iIpAddr);
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_SNMP_INVALID_IP_PARAM_1, (Object)string);
            }
        }
        if (this.db.on()) {
            this.db.println("applyChangesToModel: finish");
        }
    }

    public void refreshFromModel() throws InvalidData {
        SnmpAttrsPane.Proxy proxy = this.getDestination();
        if (this.db.on()) {
            this.db.println("refreshFromModel: start");
        }
        if (this.trapDest == null) {
            if (this.db.on()) {
                this.db.println("refreshFromModel: trapDest is null");
            }
            proxy.ipAddr.setText("");
            proxy.commName.setText("");
            this.udpPortTF.setText(DEFAULT_UDP_PORT);
            this.versionCB.setSelectedIndex(0);
            if (this.pci.supportsMaxTrapsperSecond()) {
                this.trapRateTF.setText("0");
            }
            this.clearProxyFields();
            this.setComponentsEnabled(false);
        } else {
            int n = this.trapDest.udpSocketNumber & 0xFFFF;
            proxy.ipAddr.setText(this.toString(this.trapDest.ipAddress));
            proxy.commName.setText(this.trapDest.communityName);
            this.udpPortTF.setText(Integer.toString(n));
            this.versionCB.setSelectedIndex(this.trapDest.version - 1);
            if (this.pci.supportsMaxTrapsperSecond()) {
                this.trapRateTF.setText(Short.toString(this.trapDest.trapsPerSecond));
            }
            this.setProxyFields(this.toString(this.trapDest.proxyIpAddress), new Integer(n), new Integer(this.trapDest.version), this.trapDest.proxyCommunity);
            this.setComponentsEnabled(true);
        }
        if (this.db.on()) {
            this.db.println("refreshFromModel: finish");
        }
    }

    @Override
    public void validateFields() throws InvalidData {
        if (this.trapDest != null) {
            super.validateFields();
        }
    }

    @Override
    protected void setComponentsEnabled(boolean bl) {
        super.setComponentsEnabled(bl);
        SnmpAttrsPane.Proxy proxy = this.getDestination();
        proxy.ipAddr.setEnabled(false);
    }

    @Override
    protected boolean hasProxyPanel() {
        return this.parent.getNMD().getPlatform().isSnmpProxyCapable() && this.parent.canCreateRelays();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.parent.setDirty();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.parent.setDirty();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.parent.setDirty();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.parent.setDirty();
    }
}

