/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.SnmpV3AuthProtocol;
import cerent.cms.idl.Node.SnmpV3PrivProtocol;
import cerent.cms.idl.Node.sSnmpV3Engine;
import cerent.cms.idl.Node.sSnmpV3User;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.snmp.UserCreateDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

public class UsersPane
extends AbstractShelfEditTablePane {
    public static final int USER_NAME_IDX = 0;
    public static final int USER_AUTH_PROTOCOL_IDX = 1;
    public static final int USER_PRIV_PROTOCOL_IDX = 2;
    public static final int GROUP_NAME_IDX = 3;
    SnmpModel snmpModel = this.getSnmpModel();

    public UsersPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    @Override
    protected void localInit() {
        super.localInit();
        ListSelectionModel listSelectionModel = this.getTable().getSelectionModel();
        listSelectionModel.setSelectionMode(2);
    }

    @Override
    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new UserNameColumnRenderer(), new AuthProtocolColumnRenderer(), new PrivProtocolColumnRenderer(), new GroupNameColumnRenderer()};
        UserTableRowSource userTableRowSource = new UserTableRowSource();
        this.model = new SortableRowTableModel((RowDataSource)userTableRowSource, columnRendererArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        super.actionPerformed(actionEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (this.getTable().getSelectedRowCount() > 1) {
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateTableData() {
        List list = this.tableData;
        synchronized (list) {
            this.tableData = new ArrayList();
            try {
                sSnmpV3User[] sSnmpV3UserArray = this.snmpModel.getSnmpV3User();
                for (int i = 0; i < sSnmpV3UserArray.length; ++i) {
                    if (!this.compareEngineId(sSnmpV3UserArray[i].engine, this.snmpModel.getSnmpV3Engine())) continue;
                    this.tableData.add(sSnmpV3UserArray[i]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                db.println("Error in getting GRE Table: " + exception);
            }
        }
    }

    public boolean compareEngineId(sSnmpV3Engine sSnmpV3Engine2, sSnmpV3Engine sSnmpV3Engine3) {
        boolean bl = false;
        if (sSnmpV3Engine2.engineidlen == sSnmpV3Engine3.engineidlen) {
            bl = true;
            for (int i = 0; i < sSnmpV3Engine2.engineidlen; ++i) {
                if (sSnmpV3Engine2.engineid[i] == sSnmpV3Engine3.engineid[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public SnmpModel getSnmpModel() {
        return (SnmpModel)this.getUiModel().getNodeModel().getSnmpModel();
    }

    @Override
    public void destroy() {
        if (this.table != null) {
            this.table.removeMouseListener(this);
        }
        super.destroy();
    }

    @Override
    protected void createTableEntry() {
        UserCreateDialog userCreateDialog = UserCreateDialog.instance(this, this.getSnmpModel());
        userCreateDialog.show();
        userCreateDialog.dispose();
    }

    @Override
    protected void editSelectedTableEntry(int n) {
        sSnmpV3User sSnmpV3User2 = (sSnmpV3User)this.model.getValueAt(n, 0);
        UserCreateDialog userCreateDialog = UserCreateDialog.instance(this, this.getSnmpModel());
        if (sSnmpV3User2 != null) {
            userCreateDialog.setSelectedTrap(sSnmpV3User2);
        }
        userCreateDialog.show();
        userCreateDialog.dispose();
    }

    @Override
    protected void deleteSelectedTableEntry(int n) {
        int n2;
        int[] nArray = this.getTable().getSelectedRows();
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Do you really want to delete the selected User" + (nArray.length > 1 ? "s?" : "?")), (String)"Delete User")) {
            return;
        }
        this.setEditDeleteEnabled(false);
        sSnmpV3User[] sSnmpV3UserArray = new sSnmpV3User[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 0 && nArray[n2] < this.model.getRowCount()) {
                sSnmpV3UserArray[n2] = (sSnmpV3User)this.model.getValueAt(nArray[n2], 0);
                continue;
            }
            db.severe("Selected entry does not exist, index: " + nArray[n2]);
            sSnmpV3UserArray[n2] = null;
        }
        for (n2 = 0; n2 < sSnmpV3UserArray.length; ++n2) {
            if (sSnmpV3UserArray[n2] == null) continue;
            try {
                this.getSnmpModel().deleteSnmpV3User(sSnmpV3UserArray[n2].username, sSnmpV3UserArray[n2].engine);
                continue;
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_PROVISION_ERROR);
            }
        }
    }

    @Override
    protected void registerWithModels() {
        if (this.snmpModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.snmpModel));
        }
    }

    @Override
    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.UserConfigurationPane;
    }

    class AuthProtocolColumnRenderer
    extends BaseColumnRenderer {
        AuthProtocolColumnRenderer() {
        }

        public String getName() {
            return "Authentication Protocol";
        }

        @Override
        public int getWidth() {
            return 200;
        }
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 100;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(sSnmpV3User sSnmpV3User2, int n) {
            String string = "???";
            switch (n) {
                case 0: {
                    string = sSnmpV3User2.username;
                    break;
                }
                case 1: {
                    string = this.convertAuthProto(sSnmpV3User2.authProtocol);
                    break;
                }
                case 2: {
                    string = this.convertPrivProto(sSnmpV3User2.privProtocol);
                    break;
                }
                case 3: {
                    string = sSnmpV3User2.group;
                }
            }
            return " " + string;
        }

        public String convertAuthProto(SnmpV3AuthProtocol snmpV3AuthProtocol) {
            switch (snmpV3AuthProtocol.value()) {
                case 1: {
                    return "MD5";
                }
                case 2: {
                    return "SHA";
                }
                case 0: {
                    return "NONE";
                }
            }
            return "???";
        }

        protected String convertPrivProto(SnmpV3PrivProtocol snmpV3PrivProtocol) {
            switch (snmpV3PrivProtocol.value()) {
                case 1: {
                    return "DES";
                }
                case 0: {
                    return "NONE";
                }
            }
            return "???";
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sSnmpV3User sSnmpV3User2 = (sSnmpV3User)jTable.getValueAt(n, 0);
            String string = this.getStringValue(sSnmpV3User2, n2);
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((sSnmpV3User)object, n);
            String string2 = this.getStringValue((sSnmpV3User)object2, n);
            return string.compareTo(string2);
        }
    }

    class EngineIdColumnRenderer
    extends BaseColumnRenderer {
        EngineIdColumnRenderer() {
        }

        public String getName() {
            return "Engine ID";
        }

        @Override
        public int getWidth() {
            return 200;
        }
    }

    class GroupNameColumnRenderer
    extends BaseColumnRenderer {
        GroupNameColumnRenderer() {
        }

        public String getName() {
            return "Group Name ";
        }

        @Override
        public int getWidth() {
            return 130;
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            UsersPane.this.resetObservableManager();
            UsersPane.this.registerWithModels();
            UsersPane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            UsersPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)UsersPane.this), true);
            }
            return this.dscObservableManager;
        }
    }

    class PrivProtocolColumnRenderer
    extends BaseColumnRenderer {
        PrivProtocolColumnRenderer() {
        }

        public String getName() {
            return "Privacy Protocol";
        }

        @Override
        public int getWidth() {
            return 200;
        }
    }

    class UserNameColumnRenderer
    extends BaseColumnRenderer {
        UserNameColumnRenderer() {
        }

        public String getName() {
            return "User Name ";
        }

        @Override
        public int getWidth() {
            return 130;
        }
    }

    class UserTableRowSource
    extends AbstractRowDataSource {
        UserTableRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = UsersPane.this.tableData;
            synchronized (list) {
                var2_2 = UsersPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = UsersPane.this.tableData;
            synchronized (list) {
                n = UsersPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = UsersPane.this.tableData;
            synchronized (list) {
                return UsersPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return sSnmpV3User.class;
        }
    }
}

