/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.sonet.TdmLinePmThresholdsTableModel;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public class SonetLinePmThresholdsTableModel
extends TdmLinePmThresholdsTableModel {
    private static final SDebug db = new SDebug("SonetLinePmThresholdsTableModel");

    public SonetLinePmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl, ModuleModel moduleModel) {
        super(iNodeModel, tdmLineModelArray, eIntervalType2, bl, moduleModel);
    }

    @Override
    protected void initColumnNames() {
        this.columnNames = ElementDefaults.getPmColumnNames(this.moduleModel.getEqType(), this.getTerms(), this.nearEnd);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        block38: {
            try {
                if (db.on()) {
                    db.println("Change in value " + n + " " + n2);
                }
                int n3 = -1;
                TDMTerminology tDMTerminology = this.getTerms();
                if (object instanceof Integer) {
                    n3 = (Integer)object;
                } else if (object instanceof String) {
                    n3 = Integer.parseInt((String)object);
                }
                if (n3 < 0) {
                    throw new Exception("Thresholds cannot be negative.");
                }
                switch (n2) {
                    case 1: {
                        if (this.thresholdsVal[n].cv == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(1), object.toString());
                        this.thresholdsVal[n].cv = n3;
                        break;
                    }
                    case 2: {
                        if (this.thresholdsVal[n].es == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(2), object.toString());
                        this.thresholdsVal[n].es = n3;
                        break;
                    }
                    case 3: {
                        if (this.thresholdsVal[n].ses == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(3), object.toString());
                        this.thresholdsVal[n].ses = n3;
                        break;
                    }
                    case 4: {
                        if (this.thresholdsVal[n].fc == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(0), object.toString());
                        this.thresholdsVal[n].fc = n3;
                        break;
                    }
                    case 7: {
                        if (this.thresholdsVal[n].psd == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(15), object.toString());
                        this.thresholdsVal[n].psd = n3;
                        break;
                    }
                    case 6: {
                        if (this.thresholdsVal[n].psc == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(14), object.toString());
                        this.thresholdsVal[n].psc = n3;
                        break;
                    }
                    case 8: {
                        if (this.thresholdsVal[n].pscw == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(16), object.toString());
                        this.thresholdsVal[n].pscw = n3;
                        break;
                    }
                    case 9: {
                        if (this.thresholdsVal[n].psdw == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(17), object.toString());
                        this.thresholdsVal[n].psdw = n3;
                        break;
                    }
                    case 10: {
                        if (this.thresholdsVal[n].pscs == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(18), object.toString());
                        this.thresholdsVal[n].pscs = n3;
                        break;
                    }
                    case 11: {
                        if (this.thresholdsVal[n].psds == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(19), object.toString());
                        this.thresholdsVal[n].psds = n3;
                        break;
                    }
                    case 12: {
                        if (this.thresholdsVal[n].pscr == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(20), object.toString());
                        this.thresholdsVal[n].pscr = n3;
                        break;
                    }
                    case 13: {
                        if (this.thresholdsVal[n].psdr == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(21), object.toString());
                        this.thresholdsVal[n].psdr = n3;
                        break;
                    }
                    case 5: {
                        if (this.thresholdsVal[n].uas == n3) {
                            return;
                        }
                        this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(9), object.toString());
                        this.thresholdsVal[n].uas = n3;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid column #" + n2);
                    }
                }
                this.rowDirty[n] = true;
                this.fireTableCellUpdated(n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                db.println("NumberFormatException caught in SonetLinePmThresholdsTableModel::setValueAt()");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)numberFormatException);
                }
            }
            catch (ProvisionError provisionError) {
                this.presentProvisionError(this.getColumnName(n2), provisionError);
            }
            catch (Exception exception) {
                db.println("Error in setValueAt " + exception);
                if (!db.on()) break block38;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            int n3 = this.model[n].getPortModel().getEqType();
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return new Integer(this.getCv(n));
                }
                case 2: {
                    return new Integer(this.getEs(n));
                }
                case 3: {
                    return new Integer(this.getSes(n));
                }
                case 4: {
                    return new Integer(this.getFc(n));
                }
                case 7: {
                    return new Integer(this.getPsd(n));
                }
                case 6: {
                    return new Integer(this.getPsc(n));
                }
                case 8: {
                    if (n3 == 28) {
                        return "N/A";
                    }
                    return new Integer(this.getPscW(n));
                }
                case 9: {
                    if (n3 == 28) {
                        return "N/A";
                    }
                    return new Integer(this.getPsdW(n));
                }
                case 10: {
                    if (n3 == 28 || n3 == 29) {
                        return "N/A";
                    }
                    return new Integer(this.getPscS(n));
                }
                case 11: {
                    if (n3 == 28 || n3 == 29) {
                        return "N/A";
                    }
                    return new Integer(this.getPsdS(n));
                }
                case 12: {
                    if (n3 == 28 || n3 == 29) {
                        return "N/A";
                    }
                    return new Integer(this.getPscR(n));
                }
                case 13: {
                    if (n3 == 28 || n3 == 29) {
                        return "N/A";
                    }
                    return new Integer(this.getPsdR(n));
                }
                case 5: {
                    return new Integer(this.getUas(n));
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt " + exception);
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        try {
            int n3 = this.model[n].getPortModel().getEqType();
            switch (n2) {
                case 8: 
                case 9: {
                    if (n3 == 28) {
                        return false;
                    }
                    return super.isCellEditable(n, n2);
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (n3 == 28 || n3 == 29) {
                        return false;
                    }
                    return super.isCellEditable(n, n2);
                }
            }
            return super.isCellEditable(n, n2);
        }
        catch (Exception exception) {
            return super.isCellEditable(n, n2);
        }
    }
}

