/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.SonetMedia.sPhysicalThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.model.nedefaults.ValueAccessor;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;

public class TdmPhysicalAlarmThresholdsTableModel
extends TdmTableModel
implements ResettablePmThresholdsTableModel {
    protected boolean[] rowDirty = null;
    protected sPhysicalThresholds[] statsVal;
    protected EntityCellRenderer myPortRenderer;
    protected static String[] columnNames = new String[]{"Port ", "LBC-LOW", "LBC-HIGH", "OPT-LOW", "OPT-HIGH", "OPR-LOW", "OPR-HIGH", "Set OPR"};
    protected static final int LINENUMBER_INDEX = 0;
    protected static final int LBC_LOW_INDEX = 1;
    protected static final int LBC_HIGH_INDEX = 2;
    protected static final int OPT_LOW_INDEX = 3;
    protected static final int OPT_HIGH_INDEX = 4;
    protected static final int OPR_LOW_INDEX = 5;
    protected static final int OPR_HIGH_INDEX = 6;
    protected static final int SET_OPR_INDEX = 7;
    protected boolean nearEnd = true;
    protected eIntervalType intervalType = null;
    private static final SDebug db = new SDebug("TdmPhysicalPmThresholdsTableModel");

    public TdmPhysicalAlarmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray) {
        super(iNodeModel);
        this.model = tdmLineModelArray;
        this.nearEnd = true;
        this.intervalType = null;
        this.myPortRenderer = new EntityCellRenderer();
        this.init();
    }

    private void init() {
        this.numLines = this.model.length;
        this.rowDirty = new boolean[this.numLines];
        this.statsVal = new sPhysicalThresholds[this.numLines];
    }

    protected void refreshPmStats(int n) {
        try {
            if (this.statsVal[n] == null) {
                this.statsVal[n] = this.model[n].getPhysicalAlmThresholds();
                if (db.on()) {
                    db.println("Stats val got for line " + n);
                }
                this.printStats(this.statsVal[n]);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return Integer.class;
    }

    private void validate(int n, int n2, int n3, Object object) throws ProvisionError {
        final String string = this.getValueAt(n, n3).toString();
        this.getTerms();
        this.validatePmThresholds(11, (InterfaceModel)this.model[n], this.intervalType, columnNames[n2], object.toString(), new ValueAccessor(){

            @Override
            public String getValue(String string2) {
                return string;
            }
        });
    }

    @Override
    public Object getThresholdNeDefault(NeDefaultsModel neDefaultsModel, int n) throws Exception {
        eEqType eEqType2 = this.model[n].getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.model[n].getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefPhysicalAlmThresholds(eEqType2, eEqType3);
    }

    @Override
    public void setThresholdValue(int n, Object object) {
        if (object instanceof sPhysicalThresholds) {
            if (db.on()) {
                db.println("Updating threshold value at line " + n);
            }
            this.statsVal[n] = (sPhysicalThresholds)object;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        block24: {
            try {
                if (db.on()) {
                    db.println("Change in value " + n + " " + n2);
                }
                int n3 = -1;
                if (n2 == 7) {
                    return;
                }
                if (object instanceof Integer) {
                    n3 = (Integer)object;
                } else if (object instanceof String) {
                    n3 = Integer.parseInt((String)object);
                }
                switch (n2) {
                    case 2: {
                        if (this.statsVal[n].lbcHigh == n3) {
                            return;
                        }
                        this.validate(n, 2, 1, object);
                        this.statsVal[n].lbcHigh = n3;
                        break;
                    }
                    case 1: {
                        if (this.statsVal[n].lbcLow == n3) {
                            return;
                        }
                        this.validate(n, 1, 2, object);
                        this.statsVal[n].lbcLow = n3;
                        break;
                    }
                    case 4: {
                        if (this.statsVal[n].optHigh == n3) {
                            return;
                        }
                        this.validate(n, 4, 3, object);
                        this.statsVal[n].optHigh = n3;
                        break;
                    }
                    case 3: {
                        if (this.statsVal[n].optLow == n3) {
                            return;
                        }
                        this.validate(n, 3, 4, object);
                        this.statsVal[n].optLow = n3;
                        break;
                    }
                    case 6: {
                        if (this.statsVal[n].oprHigh == n3) {
                            return;
                        }
                        this.validate(n, 6, 5, object);
                        this.statsVal[n].oprHigh = n3;
                        break;
                    }
                    case 5: {
                        if (this.statsVal[n].oprLow == n3) {
                            return;
                        }
                        this.validate(n, 5, 6, object);
                        this.statsVal[n].oprLow = n3;
                        break;
                    }
                    default: {
                        if (!db.isSevereEnabled()) break;
                        db.severe("Received update for Unknown Column " + n2);
                    }
                }
                this.rowDirty[n] = true;
                this.fireTableCellUpdated(n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                if (db.isSevereEnabled()) {
                    db.severe("NumberFormatException caught " + numberFormatException);
                    SDebug.printStackTrace((Throwable)numberFormatException);
                }
            }
            catch (ProvisionError provisionError) {
                this.presentProvisionError(this.getColumnName(n2), provisionError);
            }
            catch (Exception exception) {
                if (!db.isSevereEnabled()) break block24;
                db.severe("Error in setting value " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    public sPhysicalThresholds getStatsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.statsVal[n];
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 2: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].lbcHigh);
                }
                case 1: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].lbcLow);
                }
                case 4: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].optHigh);
                }
                case 3: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].optLow);
                }
                case 6: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].oprHigh);
                }
                case 5: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].oprLow);
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getValueAt " + exception);
            }
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        }
        return false;
    }

    public void refreshMyLines(TdmLineModel[] tdmLineModelArray) {
        this.model = tdmLineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public void refreshLineFromModel(int n) {
        this.statsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.statsVal[i] = null;
            this.rowDirty[i] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    @Override
    public void markRowDirty(int n) {
        this.rowDirty[n] = true;
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public void setOpr(int n) {
        try {
            this.model[n].setOpr();
            CerentDialog.infoDialog((Component)this.getFrame(), (String)"OPR nominal has been set successfully.", (String)"Set OPR");
        }
        catch (InternalCommError internalCommError) {
            String string = ErrorMsg.getString((EID)EMC.EID_FAIL_SET_OPR);
            string = string + "\nAn internal communication error was encountered while trying to set the OPR.\nThis can happen when equipment is not present or when equipment is resetting.\nCheck the equipment state and try to set the OPR again.\n";
            DetailedLog detailedLog = new DetailedLog(1, string);
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_FAIL_SET_OPR);
        }
    }

    protected void printStats(sPhysicalThresholds sPhysicalThresholds2) {
        if (db.isFineEnabled()) {
            db.fine("Near End = " + this.nearEnd);
            if (this.intervalType == null) {
                db.fine("Interval type = alarm");
            } else {
                db.fine("Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            }
            db.fine("===============================================");
            db.fine("LBC-HIGH " + sPhysicalThresholds2.lbcHigh);
            db.fine("LBC-LOW" + sPhysicalThresholds2.lbcLow);
            db.fine("OPT-HIGH " + sPhysicalThresholds2.optHigh);
            db.fine("OPT-LOW" + sPhysicalThresholds2.optLow);
            db.fine("OPR-HIGH " + sPhysicalThresholds2.oprHigh);
            db.fine("OPR-LOW" + sPhysicalThresholds2.oprLow);
            db.fine("===============================================");
        }
    }
}

