/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tdcu;

import cerent.cms.idl.Optics.eCtdcu_comp;
import cerent.cms.idl.Optics.eFtdcu_comp;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.TdcuModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TdcuCompensationProvPane
extends NodeProvPane
implements ActionListener {
    protected TdcuModuleModel opticsModuleModel = (TdcuModuleModel)this.getUiModel();
    private OpticsLineModel lineModel = this.opticsModuleModel.getOpticsLineModels()[1];
    private JComboBox cardCompensationCB;
    private String cardCompensationKey = this.opticsModuleModel.getEqType() == 298 ? "fTdcuComp" : "cTdcuComp";
    protected static final SDebug db = new SDebug("TdcuCompesationProvPane");

    public TdcuCompensationProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.initProvPane();
    }

    protected void initProvPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane);
        jPanel.add(this.createCardInfoPanel());
        if (db.on()) {
            db.println("init: finish");
        }
    }

    protected Attribute[] getAttributeFor(String string) {
        return ElementDefaults.getAttributeMap(this.opticsModuleModel).getAttributeArray(string);
    }

    protected Attribute getAttributeValFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.opticsModuleModel).getAttributeForVal(string, n);
    }

    private JLabel createLabel(String string) {
        return this.createLabel(string, 175, 20);
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    private JPanel createCardInfoPanel() {
        JPanel jPanel = TdcuCompensationProvPane.createVerticalPanel("Card Provisioning");
        Object[] objectArray = this.getAttributeFor(this.cardCompensationKey);
        this.cardCompensationCB = this.addComboBox(jPanel, "Compensation Value: ", objectArray);
        return jPanel;
    }

    private JComboBox addComboBox(JPanel jPanel, String string, Object[] objectArray) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jPanel2.add(jComboBox);
        jComboBox.addActionListener(this);
        jPanel.add(jPanel2);
        this.enableComponent(jComboBox);
        return jComboBox;
    }

    private eCtdcu_comp getCTdcuCompensationValueFromCB() {
        return eCtdcu_comp.from_int(((Attribute)this.cardCompensationCB.getSelectedItem()).getIntValue());
    }

    private eFtdcu_comp getFTdcuCompensationValueFromCB() {
        return eFtdcu_comp.from_int(((Attribute)this.cardCompensationCB.getSelectedItem()).getIntValue());
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update from " + observable + "arg obj is " + object);
        }
        if (observable instanceof OpticsLineModel && observable == this.lineModel && object.equals(ModelUpdateType.CHANGED)) {
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                TdcuCompensationProvPane.this.refreshModule(observable);
            }
        };
    }

    protected void refreshModule(Observable observable) {
        if (observable instanceof OpticsLineModel) {
            try {
                this.refreshFromModel();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH_PANE);
            }
        }
    }

    @Override
    protected void registerWithModel() {
        this.opticsModuleModel.addObserver((Observer)((Object)this));
        this.lineModel.addObserver((Observer)((Object)this));
    }

    protected void unRegisterWithModel() {
        this.opticsModuleModel.deleteObserver((Observer)((Object)this));
        this.lineModel.deleteObserver((Observer)((Object)this));
    }

    @Override
    public void destroy() {
        this.unRegisterWithModel();
        super.destroy();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("calling applyChangesToModel");
        }
        if (AdminState.isFormOfIS(this.lineModel.getAdminStateEnum())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Changing Compensation value while a circuit\n");
            stringBuilder.append("is in place will cause a service disruption.\n");
            stringBuilder.append("The Compensation value will be set to the value that\n");
            stringBuilder.append("was provisioned on the Provisioning tab.\n\n");
            stringBuilder.append(this.getApplyString(false));
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuilder.toString(), (String)"Confirmation Dialog")) {
                this.refreshFromModel();
                return;
            }
        }
        try {
            this.setCursor(3);
            if (this.opticsModuleModel.getEqType() == 299) {
                this.lineModel.setCTdcuCompensationValue(this.getCTdcuCompensationValueFromCB());
            } else {
                this.lineModel.setFTdcuCompensationValue(this.getFTdcuCompensationValueFromCB());
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            throw new ConfigError(noSuchInterface.getMessage());
        }
        finally {
            this.setCursor(0);
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("calling refreshFromModel");
        }
        this.setCompensationValueCB();
        this.resetDirty();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        this.registerWithModel();
    }

    @Override
    public void leavingPage() throws Exception {
        super.leavingPage();
        this.unRegisterWithModel();
    }

    @Override
    public boolean hasSubTabs() {
        return false;
    }

    private void setCompensationValueCB() throws Exception {
        Attribute attribute = null;
        attribute = this.opticsModuleModel.getEqType() == 299 ? this.getAttributeValFor(this.cardCompensationKey, this.lineModel.getCTdcuCompensationValue().value()) : this.getAttributeValFor(this.cardCompensationKey, this.lineModel.getFTdcuCompensationValue().value());
        this.cardCompensationCB.setSelectedItem(attribute);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.TdcuCompesationProvPane;
    }
}

