/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.idl.If.eALSMode;
import cerent.cms.idl.If.eLaserStatus;
import cerent.cms.idl.If.eOSRIStatus;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TNCAlsTableModel
extends AbstractTableModel {
    public static final String[] columnNames = new String[]{"Port", "OSRI", "ALS Mode", "Recovery Pulse Duration ( sec. )", "Recovery Pulse Interval ( sec. )", "Currently Shutdown", "Request Laser Restart"};
    public static final String[] LaserStatusStrings = new String[]{"YES", "NO", "APR"};
    public static final String[] ALSCommandStrings = new String[]{"Disabled", "Auto Restart", "Manual Restart", "Manual Restart for Test"};
    public static final String[] OSRICommandStrings = new String[]{"OFF", "ON"};
    public static final String[] OSRIStatusStrings = new String[]{"OSRI Off", "OSRI On", "N/A"};
    public static final int PORT_NAME_INDEX = 0;
    public static final int OSRI_MODE_INDEX = 1;
    public static final int ALS_MODE_INDEX = 2;
    public static final int RECOVERY_DURATION_INDEX = 3;
    public static final int RECOVERY_INTERVAL_INDEX = 4;
    public static final int CURRENTLY_SHUTDOWN_INDEX = 5;
    public static final int LASER_RESTART_INDEX = 6;
    private static final float ALS_PULSE_WIDTH = 10.0f;
    private int[] LaserStatus;
    private int[] OSRIStatus;
    private int[] ALSCommand;
    private int[] OSRICommand;
    private boolean[][] isDirty;
    protected Boolean[] LaserRestart;
    int newALSCommand = 0;
    int newOSRICommand = 0;
    private ElementModelsDelegate elementModel;
    private InterfaceModel[] ifModel = null;
    protected Float[] alsPulseWidthVal = null;
    protected Short[] alsRecIntVal = null;
    protected Boolean[] laserShutdownVal = null;
    private int ALSPort = 0;
    private int numLines;
    private EntityCellRenderer myPortRenderer;
    private static final SDebug db = new SDebug("TNCAlsTableModel");

    public TNCAlsTableModel(InterfaceModel[] interfaceModelArray) {
        this.ifModel = interfaceModelArray;
        this.numLines = interfaceModelArray.length;
        this.myPortRenderer = new EntityCellRenderer(false);
        if (interfaceModelArray.length > 0 && interfaceModelArray[0] != null) {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)interfaceModelArray[0].getNodeModel();
            this.elementModel = nodeModelDelegate.getElementModelsDelegate();
        }
        this.init();
    }

    private void init() {
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.LaserStatus = new int[this.numLines];
        this.OSRIStatus = new int[this.numLines];
        this.ALSCommand = new int[this.numLines];
        this.OSRICommand = new int[this.numLines];
        this.LaserRestart = new Boolean[this.numLines];
        this.alsPulseWidthVal = new Float[this.numLines];
        this.alsRecIntVal = new Short[this.numLines];
        this.laserShutdownVal = new Boolean[this.numLines];
        this.resetDirtyBits();
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 6: {
                return Boolean.class;
            }
            case 3: {
                return Float.class;
            }
            case 4: {
                return Short.class;
            }
        }
        return Object.class;
    }

    public String[] getALSCommandStrings() {
        return ALSCommandStrings;
    }

    public String[] getOSRICommandStrings() {
        return OSRICommandStrings;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (this.ifModel[n] != null) {
            bl = AbstractPane.isUserAuthorized(this.ifModel[0], SecurityLevel.MAINTENANCE);
        }
        if (this.ifModel[n] != null && bl) {
            if (n2 == 2 || n2 == 1) {
                return true;
            }
            if (n2 == 6) {
                return this.TestAlsMode(n);
            }
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            if (db.on()) {
                db.println("Riga [" + n + "]-" + columnNames[n2] + ":");
            }
            switch (n2) {
                case 0: {
                    return this.getPort(n);
                }
                case 2: {
                    return this.getALSMode(n);
                }
                case 1: {
                    return this.getOSRIMode(n);
                }
                case 3: {
                    return this.getRecPulseDuration(n);
                }
                case 4: {
                    return this.getRecPulseInterval(n);
                }
                case 6: {
                    return this.getLaserRestart(n);
                }
                case 5: {
                    return this.getLaserStatusString(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Barolo AlsTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return "N/A";
        }
    }

    private String getPort(int n) {
        IPortModel iPortModel;
        block2: {
            iPortModel = null;
            try {
                iPortModel = this.ifModel[n].getPortModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        try {
            switch (n2) {
                case 2: {
                    Attribute attribute = (Attribute)object;
                    String string = attribute.getKey();
                    this.ALSCommand[n] = this.newALSCommand = this.getIndexOf(string, ALSCommandStrings);
                    if (this.ALSCommand[n] != 2 && this.ALSCommand[n] != 3 && this.LaserRestart[n] != Boolean.FALSE) {
                        this.LaserRestart[n] = Boolean.FALSE;
                        this.isDirty[n][6] = true;
                        this.fireTableCellUpdated(n, 6);
                    }
                    break;
                }
                case 1: {
                    this.newOSRICommand = this.getIndexOf((String)object, OSRICommandStrings);
                    if (this.OSRICommand[n] == this.newOSRICommand) {
                        return;
                    }
                    this.OSRICommand[n] = this.newOSRICommand;
                    break;
                }
                case 6: {
                    Boolean bl = (Boolean)object;
                    if (this.LaserRestart[n].equals(bl)) {
                        return;
                    }
                    this.LaserRestart[n] = bl;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public void setOSRIOn(int n) {
        try {
            this.ifModel[n].setOSRIStatus(eOSRIStatus.OSRI_ON);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void setOSRIOff(int n) {
        try {
            this.ifModel[n].setOSRIStatus(eOSRIStatus.OSRI_OFF);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public String getLaserStatusString(int n) {
        eLaserStatus eLaserStatus2 = this.getLaserStatus(n);
        if (eLaserStatus2 != null) {
            if (eLaserStatus2 == eLaserStatus.OFF) {
                this.LaserStatus[n] = 0;
            } else if (eLaserStatus2 == eLaserStatus.ON) {
                this.LaserStatus[n] = 1;
            } else if (eLaserStatus2 == eLaserStatus.APR) {
                this.LaserStatus[n] = 2;
            }
        } else {
            return "N/A";
        }
        return LaserStatusStrings[this.LaserStatus[n]];
    }

    private eLaserStatus getLaserStatus(int n) {
        block6: {
            try {
                return this.ifModel[n] != null ? this.ifModel[n].getLaserStatus() : eLaserStatus.OFF;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (InternalCommError internalCommError) {
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)internalCommError);
            }
        }
        return null;
    }

    private Float getRecPulseDuration(int n) {
        int n2 = n;
        if (this.alsPulseWidthVal[n] == null) {
            try {
                this.alsPulseWidthVal[n] = new Float((float)this.ifModel[n2].getALSAttributesforTNC().mvALSRecoveryPulseWidth / 10.0f);
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting ALS Pulse Width:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.alsPulseWidthVal[n] = new Float(0.0f);
            }
            catch (InternalCommError internalCommError) {
                db.severe("Error in getting ALS Pulse Width:" + internalCommError.toString());
            }
        }
        return this.alsPulseWidthVal[n];
    }

    private Boolean getLaserRestart(int n) {
        if (this.LaserRestart[n] == null) {
            this.LaserRestart[n] = false;
        }
        return this.LaserRestart[n];
    }

    protected Short getRecPulseInterval(int n) {
        if (this.alsRecIntVal[n] == null) {
            try {
                int n2 = n;
                this.alsRecIntVal[n] = new Short(this.ifModel[n2].getALSAttributesforTNC().mvALSRecoveryInt);
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting ALS Pulse Interval:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.alsRecIntVal[n] = new Short("0");
            }
            catch (InternalCommError internalCommError) {
                db.severe("Error in getting Rec Pulse Interval :" + internalCommError.toString());
            }
        }
        return this.alsRecIntVal[n];
    }

    public String getALSMode(int n) {
        if (this.ALSCommand[n] == -1) {
            try {
                int n2 = n;
                eALSMode eALSMode2 = this.ifModel[n2].getALSAttributesforTNC().mvALSMode;
                this.ALSCommand[n] = eALSMode2.value();
            }
            catch (Exception exception) {
                this.ALSCommand[n] = 1;
            }
        }
        return ALSCommandStrings[this.ALSCommand[n]];
    }

    public String getOSRIMode(int n) {
        if (this.OSRICommand[n] == -1) {
            try {
                eOSRIStatus eOSRIStatus2;
                eOSRIStatus eOSRIStatus3 = eOSRIStatus2 = this.ifModel[n] != null ? this.ifModel[n].getALSAttributesforTNC().mvOSRIStatus : eOSRIStatus.OSRI_OFF;
                this.OSRICommand[n] = eOSRIStatus2 == eOSRIStatus.OSRI_OFF ? 0 : 1;
            }
            catch (Exception exception) {
                this.OSRIStatus[n] = 0;
            }
        }
        return OSRICommandStrings[this.OSRICommand[n]];
    }

    private boolean TestAlsMode(int n) {
        return this.ALSCommand[n] == 2 && this.getLaserStatus(n) == eLaserStatus.OFF || this.ALSCommand[n] == 3 && this.getLaserStatus(n) == eLaserStatus.OFF;
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.LaserRestart[i] = null;
            this.refreshLineFromModel(i);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    public void refreshFromReset() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
    }

    public void refreshLineFromModel(int n) {
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.LaserStatus[n] = -1;
        this.OSRIStatus[n] = -1;
        this.ALSCommand[n] = -1;
        this.OSRICommand[n] = -1;
        this.alsPulseWidthVal[n] = null;
        this.alsRecIntVal[n] = null;
        this.laserShutdownVal[n] = null;
        this.LaserRestart[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void applyToModel() throws Exception {
        int n = 0;
        if (db.on()) {
            db.println("applyToModel");
        }
        String string = "The selected operation will be service affecting.\nIs it OK to apply the changes anyway?";
        if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)string, (String)"Confirmation Dialog")) {
            try {
                for (n = 0; n < this.numLines; ++n) {
                    if (this.isDirty[n][2]) {
                        this.ifModel[n].setALSMode(this.ALSCommand[n]);
                    }
                    if (this.isDirty[n][1]) {
                        if (this.OSRICommand[n] == 1) {
                            this.setOSRIOn(n);
                        } else {
                            this.setOSRIOff(n);
                        }
                    }
                    if (!this.isDirty[n][6]) continue;
                    this.ifModel[n].restartLaser();
                }
                this.resetDirtyBits();
            }
            catch (ConfigError configError) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ERROR_LASER_ON);
                this.refreshFromModel();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
                this.refreshFromModel();
            }
            catch (Exception exception) {
                throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_ERROR_APPLYING_CHANGES), exception);
            }
        } else {
            this.refreshFromModel();
        }
    }

    public void refreshMyLines(InterfaceModel[] interfaceModelArray) {
        this.ifModel = interfaceModelArray;
        this.numLines = this.ifModel.length;
        this.init();
        this.fireTableDataChanged();
    }

    private Frame getFrame() {
        return this.elementModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }
}

