/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.AlsPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;

public class TNCMaintenancePane
extends AbstractSubTabbedPane
implements ITabName {
    PluggableCarrierModel pcm = (PluggableCarrierModel)this.getUiModel();
    PortModel[] pt = null;

    public TNCMaintenancePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.registerLineModels(this.pcm);
    }

    public void registerLineModels(PluggableCarrierModel pluggableCarrierModel) {
        this.pcm.addObserver((Observer)((Object)this));
        PpmModel[] ppmModelArray = this.pcm.getPpmModels();
        for (int i = 0; i < ppmModelArray.length; ++i) {
            PpmModel ppmModel = ppmModelArray[i];
            ppmModel.addObserver((Observer)((Object)this));
        }
    }

    public void unregisterLineModels(PluggableCarrierModel pluggableCarrierModel) {
        this.pcm.deleteObserver((Observer)((Object)this));
        PpmModel[] ppmModelArray = this.pcm.getPpmModels();
        for (int i = 0; i < ppmModelArray.length; ++i) {
            PpmModel ppmModel = ppmModelArray[i];
            ppmModel.deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        db.info("Got an Update Message for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                TNCMaintenancePane.this.refreshTabs();
            }
        };
    }

    private void refreshTabs() {
        TabbedView tabbedView;
        int n = this.subTabs.getSelectedIndex();
        Component component = this.subTabs.getSelectedComponent();
        int n2 = -1;
        if (component instanceof Pane && (tabbedView = ((Pane)component).getSubTabs()) != null && tabbedView.getTabCount() > 0) {
            n2 = tabbedView.getSelectedIndex();
        }
        if (n > -1) {
            this.subTabs.setSelectedIndex(n);
            component = this.subTabs.getSelectedComponent();
            if (component instanceof Pane && (tabbedView = ((Pane)component).getSubTabs()) != null && n2 > -1 && tabbedView.getTabCount() > 0) {
                tabbedView.setSelectedIndex(n2);
            }
        }
    }

    @Override
    public void dispose() {
        db.info("Called dispose");
        this.unregisterLineModels((PluggableCarrierModel)this.getUiModel());
        super.dispose();
    }

    @Override
    protected void createSubTabs() {
        this.subTabs.addTab("ALS", (Component)((Object)new AlsPane("ALS", this.getParentView(), this.pcm.getAllInterfaceModels())));
    }
}

