/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.model.ChassisModel;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.TNCModuleModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ppm.PpmProvPane;
import cerent.cms.ui.rmon.RmonThresholdPane;
import cerent.cms.ui.tnc.TNCCardProvPane;
import cerent.cms.ui.tnc.TNCLinePane;
import cerent.cms.ui.tnc.TNCOpticalThresholdPane;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;

public class TNCProvPane
extends AbstractSubTabbedPane
implements ITabName {
    private TNCModuleModel pcm = (TNCModuleModel)this.getUiModel();
    private PortModel[] pt = null;

    public TNCProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.registerLineModels(this.pcm);
        this.registerWithModel();
    }

    public void registerLineModels(PluggableCarrierModel pluggableCarrierModel) {
        this.pcm.addObserver((Observer)((Object)this));
        PpmModel[] ppmModelArray = this.pcm.getPpmModels();
        for (int i = 0; i < ppmModelArray.length; ++i) {
            PpmModel ppmModel = ppmModelArray[i];
            ppmModel.addObserver((Observer)((Object)this));
        }
    }

    public void unregisterLineModels(TNCModuleModel tNCModuleModel) {
        this.pcm.deleteObserver((Observer)((Object)this));
        PpmModel[] ppmModelArray = this.pcm.getPpmModels();
        for (int i = 0; i < ppmModelArray.length; ++i) {
            PpmModel ppmModel = ppmModelArray[i];
            ppmModel.deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        db.info("Got an Update Message for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                TNCProvPane.this.refreshTabs();
            }
        };
    }

    private void refreshTabs() {
        TabbedView tabbedView;
        int n = this.subTabs.getSelectedIndex();
        Component component = this.subTabs.getSelectedComponent();
        int n2 = -1;
        if (component instanceof Pane && (tabbedView = ((Pane)component).getSubTabs()) != null && tabbedView.getTabCount() > 0) {
            n2 = tabbedView.getSelectedIndex();
        }
        if (n > -1) {
            this.subTabs.setSelectedIndex(n);
            component = this.subTabs.getSelectedComponent();
            if (component instanceof Pane && (tabbedView = ((Pane)component).getSubTabs()) != null && n2 > -1 && tabbedView.getTabCount() > 0) {
                tabbedView.setSelectedIndex(n2);
            }
        }
    }

    @Override
    public void dispose() {
        db.info("Called dispose");
        this.unregisterLineModels((TNCModuleModel)this.getUiModel());
        super.dispose();
    }

    @Override
    protected void createSubTabs() {
        this.subTabs.addTab("Line", (Component)((Object)new TNCLinePane("Line", this.subTabs)));
        this.subTabs.addTab("Optics Thresholds", (Component)((Object)new TNCOpticalThresholdPane("Optics Thresholds", this.subTabs, this.pcm)));
        this.subTabs.addTab("RMON Thresholds", (Component)((Object)new RmonThresholdPane("RMON Thresholds", this.subTabs, this.pcm.getRmonModels())));
        this.subTabs.addTab("Pluggable Port Modules", (Component)((Object)new PpmProvPane("Pluggable Port Modules", this.subTabs, false)));
        ChassisModel chassisModel = (ChassisModel)this.pcm.getChassis();
        if (!chassisModel.isM2Chassis()) {
            this.subTabs.addTab("UDC / VOIP", (Component)((Object)new TNCCardProvPane("UDC / VOIP", this.subTabs)));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
    }
}

