/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.nedefaults.DefaultsManager;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractValidatingTableModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Frame;

public abstract class TNCThresholdsTableModel
extends AbstractValidatingTableModel {
    protected InterfaceModel[] model;
    protected int numLines;
    protected EntityCellRenderer myPortRenderer;
    protected String[] portNames;
    protected ModuleModel eqpmtModel;
    private DefaultsManager validationManager;
    private final SDebug db;

    protected TNCThresholdsTableModel(SDebug sDebug, InterfaceModel[] interfaceModelArray) {
        super(interfaceModelArray.length > 0 ? interfaceModelArray[0].getNodeModelDelegate() : null, sDebug);
        this.db = sDebug;
        this.model = interfaceModelArray;
        this.numLines = interfaceModelArray.length;
        if (interfaceModelArray.length > 0) {
            try {
                this.eqpmtModel = interfaceModelArray[0].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
        this.myPortRenderer = new EntityCellRenderer(false);
        this.portNames = new String[this.numLines];
        this.validationManager = null;
    }

    public void refreshMyLines(InterfaceModel[] interfaceModelArray) {
        this.model = interfaceModelArray;
        this.numLines = this.model.length;
        this.portNames = new String[this.numLines];
        if (this.eqpmtModel == null && interfaceModelArray.length > 0) {
            try {
                this.eqpmtModel = this.model[0].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
    }

    public int getNumberOfLines() {
        return this.model.length;
    }

    public boolean resetToDefaultByLine() {
        return false;
    }

    @Override
    protected Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        if (n >= 0 && n < this.model.length) {
            IPortModel iPortModel = this.model[n].getPortModel();
            return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
        }
        return "!ERROR!";
    }

    protected Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal(string, n);
    }

    protected String getPortName(int n) {
        if (n >= 0 && n < this.portNames.length) {
            if (this.portNames[n] == null) {
                try {
                    this.portNames[n] = this.model[n].getAlias();
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            return this.portNames[n];
        }
        return "!ERROR!";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl;
        if (n < this.numLines && this.model != null && this.numLines > 0 && (bl = AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.MAINTENANCE))) {
            return n2 > 0;
        }
        return false;
    }

    public void validate(String string, String string2) throws ProvisionError {
        if (this.validationManager == null) {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.eqpmtModel.getNodeModel();
            this.validationManager = DefaultsManager.getInstance(nodeModelDelegate);
        }
        this.validationManager.validate(this.eqpmtModel.getEqTypeEnum(), string, string2);
    }

    @Override
    protected void presentProvisionError(String string, ProvisionError provisionError) {
        ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_INVALID_COLUMN_NAME_PARAM_1, string, provisionError.getMessage());
    }
}

