/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.uts;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.CardPanel;
import cerent.cms.ui.uts.UtsFmecCardPainter;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;

public class UtsFmecCardGraphic
extends CardGraphic {
    Icon icon;

    public UtsFmecCardGraphic(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, Dimension dimension) {
        super(entityModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, " FMEC Card:" + entityModel.getSlot()));
        this.cardPainter = new UtsFmecCardPainter(this, dimension);
    }

    @Override
    public String toString() {
        return "FMEC UNIT";
    }

    @Override
    public String getTooltipText(MouseEvent mouseEvent) {
        if (this.entityM.getModuleModel().getEqType() == 345 && this.entityM.getSlot() == 22) {
            return this.getEqLabel() + "P_A" + "[State:" + this.getStateString() + "]";
        }
        if (this.entityM.getModuleModel().getEqType() == 345 && this.entityM.getSlot() == 28) {
            return this.getEqLabel() + "P_B" + "[State:" + this.getStateString() + "]";
        }
        if (this.entityM.getModuleModel().getEqType() == 347 && this.entityM.getSlot() == 24) {
            return "MSISC_A[State:" + this.getStateString() + "]";
        }
        if (this.entityM.getModuleModel().getEqType() == 347 && this.entityM.getSlot() == 26) {
            return "MSISC_B[State:" + this.getStateString() + "]";
        }
        if (this.entityM.getModuleModel().getEqType() == 351 && this.entityM.getSlot() == 30) {
            if (this.entityM.getChassis().isM6Chassis()) {
                return "POWERSUPPLY_A " + this.getPowerType() + "[State:" + this.getStateString() + "]";
            }
            if (this.entityM.getChassis().isM2Chassis()) {
                return "POWERSUPPLY_A " + this.getPowerType() + "[State:" + this.getStateString() + "], POWERSUPPLY_B [State:" + this.getPowerBStateString() + "]";
            }
            return this.getEqLabel() + " " + this.getPowerType() + "[State:" + this.getStateString() + "]";
        }
        if (this.entityM.getModuleModel().getEqType() == 351 && this.entityM.getSlot() == 32) {
            return "POWERSUPPLY_B " + this.getPowerType() + "[State:" + this.getStateString() + "]";
        }
        if (this.entityM.getModuleModel().getEqType() == 344 && this.entityM.getSlot() == 21) {
            return "ENV_ALARMS_CONTACTS_A[State:" + this.getStateString() + "]";
        }
        if (this.entityM.getModuleModel().getEqType() == 350 && this.entityM.getSlot() == 29) {
            return "ENV_ALARMS_CONTACTS_B[State:" + this.getStateString() + "]";
        }
        return this.getEqLabel() + "[State:" + this.getStateString() + "]";
    }

    private String getPowerType() {
        if (this.entityM instanceof ModuleModel) {
            ModuleModel moduleModel = (ModuleModel)this.entityM;
            String string = moduleModel.getMfgData().name;
            String string2 = string.substring(string.lastIndexOf("-") + 1);
            return string2;
        }
        return null;
    }

    private String getPowerBStateString() {
        String string = "";
        List list = null;
        if (this.entityM instanceof ModuleModel) {
            IModel iModel;
            ModuleModel moduleModel = (ModuleModel)this.entityM;
            int n = 32;
            try {
                iModel = moduleModel.getChassis();
                list = ((ChassisModel)iModel).getEntityTableModel().getEntityModelBySlot((IChassisModel)iModel, n).getChildren();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            iModel = null;
            if (list != null && list.size() > 0) {
                iModel = (ModuleModel)list.get(0);
            }
            if (iModel != null) {
                string = ElementDefaults.eqStateToString(((MfgEntityModel)iModel).getState());
            }
        }
        return string;
    }

    @Override
    public int getSlot() {
        return this.entityM.getSlot();
    }

    @Override
    public int getIconHeight() {
        return this.cardPainter.getCardHeight();
    }

    @Override
    public int getIconWidth() {
        return this.cardPainter.getCardWidth();
    }

    @Override
    public Dimension getDimension() {
        return new Dimension(this.getIconWidth(), this.getIconHeight());
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        ((UtsFmecCardPainter)this.cardPainter).updateIcon(icon);
    }

    public void setDimension(Dimension dimension) {
        ((UtsFmecCardPainter)this.cardPainter).setDimension(dimension);
        this.cardPainter.updateWidth();
        this.setSize(dimension);
    }

    @Override
    public void rightMouseClicked(Point point, CardPanel cardPanel) {
    }
}

