/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wxc;

import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.wxc.WxcInventoryPane;
import cerent.cms.ui.wxc.WxcMaintenancePane;
import cerent.cms.ui.wxc.WxcPerfPane;
import cerent.cms.ui.wxc.WxcProvPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;

public class WxcCardTabbedView
extends CardTabbedView
implements ITabName {
    ModuleModel module = null;
    NodeModelDelegate node = null;
    private static final SDebug db = new SDebug("WxcCardTabbedView");

    public WxcCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        this.init();
    }

    @Override
    public void showTabs() {
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
        this.addTab("Inventory", (Component)this.getInventoryTab());
        this.addTab("Performance", (Component)this.getPerformanceTab());
    }

    private void init() {
        this.module = (ModuleModel)this.getUiModel();
        this.node = ((ModuleModel)this.getUiModel()).getNodeModelDelegate();
        this.showTabs();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public Pane getMaintenanceTab() {
        WxcMaintenancePane wxcMaintenancePane = null;
        wxcMaintenancePane = new WxcMaintenancePane("Maintenance", this, this.module);
        return wxcMaintenancePane;
    }

    @Override
    public Pane getPerformanceTab() {
        return new WxcPerfPane("Performance", this, this.module);
    }

    @Override
    public Pane getProvTab() {
        return new WxcProvPane("Provisioning", this, this.module);
    }

    public Pane getInventoryTab() {
        return new WxcInfoPane("Inventory", (TabbedView)this);
    }

    private class WxcInfoPane
    extends AbstractPane
    implements ITabName {
        public WxcInfoPane(String string, TabbedView tabbedView) {
            super(string, tabbedView);
            this.subTabs = new SubTabbedView(null, tabbedView);
            this.subTabs.addTab("Info", (Component)this.getWxcInfoTab());
            this.subTabs.setTabPlacement(2);
            this.setLayout(new GridLayout(1, 1));
            this.add((Component)this.subTabs);
        }

        protected Pane getWxcInfoTab() {
            return new WxcInventoryPane("Info", this.getParentView());
        }

        @Override
        public void leavingPage() throws Exception {
        }

        @Override
        public void enteringPage() throws Exception {
        }

        @Override
        public void refresh() throws Exception {
        }
    }
}

