/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wxc;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.wxc.WxcOchOpticalThresholdTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class WxcOchOpticalThresholdProvPane
extends NodeProvPane
implements TableModelListener {
    protected AbstractOpticsLineModel[] ochmodels = null;
    protected AbstractOpticsLineModel[] lowerInterfaces;
    private WxcOchOpticalThresholdTableModel dataModel;
    private ObservableManager _obsMgr = null;
    protected int thresholdLayer;
    private boolean notInited = true;
    private int wl = -1;
    private int port = -1;
    protected static final SDebug db = new SDebug("WxcOchOpticalThresholdProvPane");

    public WxcOchOpticalThresholdProvPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray, int n) {
        super(string, tabbedView);
        this.lowerInterfaces = abstractOpticsLineModelArray;
        this.thresholdLayer = n;
    }

    protected void init() {
        this.ochmodels = this.getHO();
        this.dataModel = this.getDataModel(this.thresholdLayer);
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
        this.notInited = false;
        this.getObsMgr().addObservable((Observable[])this.ochmodels);
        this.getObsMgr().addObservable((Observable[])this.lowerInterfaces);
        super.registerWithModel();
    }

    private OpticsOchTermModel[] getHO() {
        ArrayList<AbstractOpticsLineModel> arrayList = new ArrayList<AbstractOpticsLineModel>();
        for (int i = 0; i < this.lowerInterfaces.length; ++i) {
            if (!this.lowerInterfaces[i].isOppositePortSupported()) continue;
            arrayList.add(this.lowerInterfaces[i]);
        }
        Collection collection = InterfaceModel.getHigherLayerModels(arrayList.toArray(new InterfaceModel[0]), 1, this.getUiModel());
        return collection.toArray(new OpticsOchTermModel[0]);
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        super.leavingPage();
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        if (this.dataModel != null) {
            this.dataModel.refreshFromModel();
        }
        this.resetDirty();
    }

    @Override
    public void destroy() {
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.lowerInterfaces);
            this._obsMgr.removeObservable((Observable[])this.ochmodels);
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.notInited = true;
        super.destroy();
    }

    protected void removeColumn(int n) {
        String string = WxcOchOpticalThresholdTableModel.columnNames[n];
        TableColumn tableColumn = this.table.getColumn(string);
        this.table.removeColumn(tableColumn);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.ochmodels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            if (this.dataModel != null) {
                try {
                    this.dataModel.refreshLineFromModel(n);
                }
                catch (Exception exception) {
                    KDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ROW_PARAM_1, (Object)Integer.toString(n + 1));
                }
            }
        } else if (db.on()) {
            db.println("changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void applyChangesToModel() throws Exception, ConfigError {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
            this._obsMgr.setPassing(true);
        }
        return this._obsMgr;
    }

    @Override
    protected void structureChangeMessage(Observable observable, Object object) {
        this.getObsMgr().removeObservable((Observable[])this.ochmodels);
        this.ochmodels = this.getHO();
        this.getObsMgr().addObservable((Observable[])this.ochmodels);
        this.dataModel.setOchTermModel(this.ochmodels);
        super.structureChangeMessage(observable, object);
    }

    @Override
    protected void deleteMessage(Observable observable, Object object) {
        this.getObsMgr().removeObservable((Observable[])this.ochmodels);
        this.ochmodels = this.getHO();
        this.dataModel.setOchTermModel(this.ochmodels);
        this.getObsMgr().addObservable((Observable[])this.ochmodels);
    }

    private WxcOchOpticalThresholdTableModel getDataModel(int n) {
        WxcOchOpticalThresholdTableModel wxcOchOpticalThresholdTableModel = null;
        try {
            wxcOchOpticalThresholdTableModel = new WxcOchOpticalThresholdTableModel(this.ochmodels, (OpticsModuleModel)this.lowerInterfaces[0].getModuleModel(), n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        return wxcOchOpticalThresholdTableModel;
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: got CHANGED from " + observable.getClass());
        }
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                WxcOchOpticalThresholdProvPane.this.refreshLine(observable);
            }
        };
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.WxcOpticalThresholdProvPane;
    }
}

