/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eRepPortType;
import cerent.cms.idl.EtherL2Media.sCVlanRange;
import cerent.cms.idl.EtherL2Media.sRepPortConfig;
import cerent.cms.idl.EtherL2Media.sRepSegmentRange;
import cerent.cms.idl.EtherL2Media.sRepStcnConfig;
import cerent.cms.idl.EtherL2Media.sRepVlbConfig;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RepPortInfo;
import cerent.cms.model.RepSegmentAttribute;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.xpl2.REPCreationPane;
import cerent.cms.ui.xpl2.XPL2REPProvPane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;

public class REPCreationDialog
extends WizardDialog {
    private static final String TITLE = "Create Segment";
    public static final String EASTPORT = "REP Port#1";
    public static final String WESTPORT = "REP Port#2";
    REPCreationPane repCreationPane1;
    REPCreationPane repCreationPane2;
    private sRepPortConfig eastPortConfig;
    private sRepPortConfig westPortConfig;
    private sRepStcnConfig eastStcnConfig;
    private sRepStcnConfig westStcnConfig;
    private sRepVlbConfig eastVlbConfig;
    private sRepVlbConfig westVlbConfig;
    protected int eastPDelay = 0;
    protected int westPDelay = 0;
    private XPL2Layer2LineModel eastPort;
    private XPL2Layer2LineModel westPort;
    protected int WIDTH = 750;
    protected int HEIGHT = 450;
    XPL2ModuleModel moduleM;
    private int mode = 0;
    RepPortInfo[] repPortInfo;
    int segId;
    XPL2REPProvPane thePane = null;

    public REPCreationDialog(Frame frame, String string, XPL2ModuleModel xPL2ModuleModel, XPL2REPProvPane xPL2REPProvPane) {
        super(frame, string);
        this.moduleM = xPL2ModuleModel;
        this.setSize(new Dimension(this.WIDTH, this.HEIGHT));
        this.setLocationRelativeTo(frame);
        this.mode = 0;
        this.initialize();
        this.createPane();
        this.thePane = xPL2REPProvPane;
    }

    public REPCreationDialog(Frame frame, String string, XPL2ModuleModel xPL2ModuleModel, RepSegmentAttribute repSegmentAttribute, XPL2REPProvPane xPL2REPProvPane) {
        super(frame, string);
        this.moduleM = xPL2ModuleModel;
        this.setSize(new Dimension(this.WIDTH, this.HEIGHT));
        this.setLocationRelativeTo(frame);
        this.mode = 1;
        this.repPortInfo = repSegmentAttribute.getPortInfo();
        this.segId = repSegmentAttribute.getSegmentId();
        this.initialize(this.repPortInfo);
        this.createPaneForMode(this.mode);
        this.thePane = xPL2REPProvPane;
    }

    private void initialize(RepPortInfo[] repPortInfoArray) {
        switch (repPortInfoArray.length) {
            case 1: {
                int n;
                this.eastPort = this.getXPL2Layer2LineModel(repPortInfoArray[0].portIndex);
                this.eastStcnConfig = repPortInfoArray[0].stcnConfig;
                this.eastVlbConfig = repPortInfoArray[0].vlbConfig;
                this.eastPortConfig = new sRepPortConfig();
                this.eastPortConfig.portType = repPortInfoArray[0].portType;
                this.eastPortConfig.preferred = repPortInfoArray[0].prefer;
                this.eastPortConfig.segId = this.segId;
                this.eastPDelay = repPortInfoArray[0].pDelay;
                this.westPort = null;
                this.westStcnConfig = new sRepStcnConfig();
                this.westStcnConfig.segRange = new sRepSegmentRange[2];
                for (n = 0; n < 2; ++n) {
                    this.westStcnConfig.segRange[n] = new sRepSegmentRange();
                }
                this.westVlbConfig = new sRepVlbConfig();
                this.westVlbConfig.vlanRange = new sCVlanRange[10];
                for (n = 0; n < 10; ++n) {
                    this.westVlbConfig.vlanRange[n] = new sCVlanRange();
                }
                this.westPortConfig = new sRepPortConfig();
                break;
            }
            case 2: {
                this.eastPort = this.getXPL2Layer2LineModel(repPortInfoArray[0].portIndex);
                this.eastStcnConfig = repPortInfoArray[0].stcnConfig;
                this.eastVlbConfig = repPortInfoArray[0].vlbConfig;
                this.eastPortConfig = new sRepPortConfig();
                this.eastPortConfig.portType = repPortInfoArray[0].portType;
                this.eastPortConfig.preferred = repPortInfoArray[0].prefer;
                this.eastPortConfig.segId = this.segId;
                this.eastPDelay = repPortInfoArray[0].pDelay;
                this.westPort = this.getXPL2Layer2LineModel(repPortInfoArray[1].portIndex);
                this.westStcnConfig = repPortInfoArray[1].stcnConfig;
                this.westVlbConfig = repPortInfoArray[1].vlbConfig;
                this.westPortConfig = new sRepPortConfig();
                this.westPortConfig.portType = repPortInfoArray[1].portType;
                this.westPortConfig.preferred = repPortInfoArray[1].prefer;
                this.westPortConfig.segId = this.segId;
                this.westPDelay = repPortInfoArray[1].pDelay;
            }
        }
    }

    public int getMode() {
        return this.mode;
    }

    private void initialize() {
        int n;
        this.eastPortConfig = new sRepPortConfig();
        this.westPortConfig = new sRepPortConfig();
        this.eastStcnConfig = new sRepStcnConfig();
        this.westStcnConfig = new sRepStcnConfig();
        this.eastVlbConfig = new sRepVlbConfig();
        this.westVlbConfig = new sRepVlbConfig();
        this.eastStcnConfig.segRange = new sRepSegmentRange[2];
        for (n = 0; n < 2; ++n) {
            this.eastStcnConfig.segRange[n] = new sRepSegmentRange();
        }
        this.westStcnConfig.segRange = new sRepSegmentRange[2];
        for (n = 0; n < 2; ++n) {
            this.westStcnConfig.segRange[n] = new sRepSegmentRange();
        }
        this.eastVlbConfig.vlanRange = new sCVlanRange[10];
        for (n = 0; n < 10; ++n) {
            this.eastVlbConfig.vlanRange[n] = new sCVlanRange();
        }
        this.westVlbConfig.vlanRange = new sCVlanRange[10];
        for (n = 0; n < 10; ++n) {
            this.westVlbConfig.vlanRange[n] = new sCVlanRange();
        }
    }

    private void createPaneForMode(int n) {
        if (n == 1 && this.repPortInfo.length > 1) {
            this.repCreationPane1 = new REPCreationPane(EASTPORT, this, this.moduleM, n);
            this.addPage(this.repCreationPane1);
            this.repCreationPane2 = new REPCreationPane(WESTPORT, this, this.moduleM, n);
            this.addPage(this.repCreationPane2);
        } else if (n == 1 && this.repPortInfo.length == 1) {
            this.repCreationPane1 = new REPCreationPane(EASTPORT, this, this.moduleM, n);
            this.addPage(this.repCreationPane1);
            this.repCreationPane2 = new REPCreationPane(WESTPORT, this, this.moduleM, 0);
            this.addPage(this.repCreationPane2);
        }
    }

    private void createPane() {
        this.repCreationPane1 = new REPCreationPane(EASTPORT, this, this.moduleM, this.mode);
        this.addPage(this.repCreationPane1);
        this.repCreationPane2 = new REPCreationPane(WESTPORT, this, this.moduleM, this.mode);
        this.addPage(this.repCreationPane2);
    }

    @Override
    public void back() {
        super.back();
        this.setFinishEnabled(true);
    }

    public void setEastPort(XPL2Layer2LineModel xPL2Layer2LineModel) {
        this.eastPort = xPL2Layer2LineModel;
    }

    public XPL2Layer2LineModel getEastPort() {
        return this.eastPort;
    }

    public XPL2Layer2LineModel getWestPort() {
        return this.westPort;
    }

    public void setWestPort(XPL2Layer2LineModel xPL2Layer2LineModel) {
        this.westPort = xPL2Layer2LineModel;
    }

    public int getRepSegmentId() {
        return this.repCreationPane1.getRepSegmentId();
    }

    public int getEastSegmentPortIndex() {
        return this.eastPort.getIndex();
    }

    public int getWestSegmentPortIndex() {
        return this.westPort.getIndex();
    }

    public sRepPortConfig getEastRepConfig() {
        return this.eastPortConfig;
    }

    public sRepPortConfig getWestRepConfig() {
        return this.westPortConfig;
    }

    public sRepStcnConfig getEastRepStcnConfig() {
        return this.eastStcnConfig;
    }

    public sRepStcnConfig getWestRepStcnConfig() {
        return this.westStcnConfig;
    }

    public sRepVlbConfig getEastRepVlbConfig() {
        return this.eastVlbConfig;
    }

    public sRepVlbConfig getWestRepVlbConfig() {
        return this.westVlbConfig;
    }

    @Override
    protected void apply() throws NoSuchInterface, WrongInterfaceType {
        Object object;
        Object object2;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = true;
        boolean bl8 = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.eastPort != null) {
            eRepPortType eRepPortType2;
            if (this.mode != 1) {
                try {
                    this.eastPort.setRepPortConfig(this.eastPortConfig);
                }
                catch (ProvisionError provisionError) {
                    object2 = provisionError.getEID();
                    if (object2 != null) {
                        ErrorMsg.displayDetailed((Component)this, object2, (Exception)((Object)provisionError));
                    } else {
                        ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                    }
                    bl = false;
                }
            }
            try {
                eRepPortType2 = this.eastPort.getRepPortConfig().portType;
            }
            catch (ProvisionError provisionError) {
                object2 = provisionError.getEID();
                if (object2 != null) {
                    ErrorMsg.displayDetailed((Component)this, object2, (Exception)((Object)provisionError));
                } else {
                    ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                }
                Object var12_27 = null;
                return;
            }
            try {
                if (eRepPortType2 != null && eRepPortType2 != eRepPortType.REGULAR_PORT) {
                    this.eastPort.setRepStcnConfig(this.eastStcnConfig);
                }
            }
            catch (ProvisionError provisionError) {
                object2 = provisionError.getEID();
                if (object2 != null) {
                    ErrorMsg.displayDetailed((Component)this, object2, (Exception)((Object)provisionError));
                } else {
                    ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                }
                bl3 = false;
            }
            if (eRepPortType2 != null && eRepPortType2 != eRepPortType.REGULAR_PORT) {
                try {
                    object = this.eastPort.getRepVlbConfig();
                    if (this.mode == 0 && this.eastVlbConfig.vlbEnabled) {
                        this.eastPort.setRepVlbConfig(this.eastVlbConfig);
                    } else if (this.mode == 1 && (((sRepVlbConfig)object).vlbEnabled || this.eastVlbConfig.vlbEnabled)) {
                        this.eastPort.setRepVlbConfig(this.eastVlbConfig);
                    }
                }
                catch (ProvisionError provisionError) {
                    object2 = provisionError.getEID();
                    if (object2 != null) {
                        ErrorMsg.displayDetailed((Component)this, object2, (Exception)((Object)provisionError));
                    } else {
                        ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                    }
                    bl2 = false;
                }
                try {
                    this.eastPort.setRepVlbPreemptDelay(this.eastPDelay);
                }
                catch (ProvisionError provisionError) {
                    object2 = provisionError.getEID();
                    if (object2 != null) {
                        ErrorMsg.displayDetailed((Component)this, object2, (Exception)((Object)provisionError));
                    } else {
                        ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                    }
                    bl7 = false;
                }
            }
        }
        object = new EntityCellRenderer();
        try {
            string2 = ((EntityCellRenderer)object).getPortString((IEntityModel)this.eastPort.getPort(), false);
            string2 = string2 != null ? " [" + string2 + "]" : null;
        }
        catch (Exception exception) {
            string2 = null;
        }
        if (bl) {
            if (!bl2 && !bl3) {
                string = "Only the REP Port#1 could be configured successfully.\nThe VLB and STCN Configuration could not be applied to Port#1" + string2;
            } else if (!bl3) {
                string = "The STCN configuration could not be applied to Port#1" + string2;
            } else if (!bl2) {
                string = "The VLB configuration could not be applied to Port#1" + string2;
            }
            if (!bl7) {
                string = (string != null ? string : "") + "\nThe Preempt Delay could not be applied to Port#1" + string2;
            }
        } else {
            string = "The REP Configuration failed for Port#1" + string2;
        }
        if (this.westPort != null && this.getCurrent().getName().equalsIgnoreCase(WESTPORT)) {
            eRepPortType eRepPortType3;
            EID eID;
            if (this.mode == 0 || this.mode == 1 && this.repPortInfo.length != 2) {
                try {
                    this.westPort.setRepPortConfig(this.westPortConfig);
                }
                catch (ProvisionError provisionError) {
                    eID = provisionError.getEID();
                    if (eID != null) {
                        ErrorMsg.displayDetailed((Component)this, eID, (Exception)((Object)provisionError));
                    } else {
                        ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                    }
                    bl4 = false;
                }
            }
            try {
                eRepPortType3 = this.westPort.getRepPortConfig().portType;
            }
            catch (ProvisionError provisionError) {
                eID = provisionError.getEID();
                if (eID != null) {
                    ErrorMsg.displayDetailed((Component)this, eID, (Exception)((Object)provisionError));
                } else {
                    ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                }
                Object var13_30 = null;
                return;
            }
            try {
                if (eRepPortType3 != null && eRepPortType3 != eRepPortType.REGULAR_PORT) {
                    this.westPort.setRepStcnConfig(this.westStcnConfig);
                }
            }
            catch (ProvisionError provisionError) {
                eID = provisionError.getEID();
                if (eID != null) {
                    ErrorMsg.displayDetailed((Component)this, eID, (Exception)((Object)provisionError));
                } else {
                    ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                }
                bl6 = false;
            }
            if (eRepPortType3 != null && eRepPortType3 != eRepPortType.REGULAR_PORT) {
                try {
                    object2 = this.westPort.getRepVlbConfig();
                    if (this.mode == 0 && this.westVlbConfig.vlbEnabled) {
                        this.westPort.setRepVlbConfig(this.westVlbConfig);
                    } else if (this.mode == 1 && (object2.vlbEnabled || this.westVlbConfig.vlbEnabled)) {
                        this.westPort.setRepVlbConfig(this.westVlbConfig);
                    }
                }
                catch (ProvisionError provisionError) {
                    eID = provisionError.getEID();
                    if (eID != null) {
                        ErrorMsg.displayDetailed((Component)this, eID, (Exception)((Object)provisionError));
                    } else {
                        ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                    }
                    bl5 = false;
                }
                try {
                    this.westPort.setRepVlbPreemptDelay(this.westPDelay);
                }
                catch (ProvisionError provisionError) {
                    eID = provisionError.getEID();
                    if (eID != null) {
                        ErrorMsg.displayDetailed((Component)this, eID, (Exception)((Object)provisionError));
                    } else {
                        ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
                    }
                    bl8 = false;
                }
            }
            try {
                string3 = ((EntityCellRenderer)object).getPortString((IEntityModel)this.westPort.getPort(), false);
                string3 = string3 != null ? " [" + string3 + "]" : null;
            }
            catch (Exception exception) {
                string3 = null;
            }
        }
        if (bl4) {
            if (!bl5 && !bl6) {
                string = (string != null ? string : "") + "\nThe VLB and STCN Configuration could not be applied to REP Port#2" + string3;
            } else if (!bl5) {
                string = (string != null ? string : "") + "\nThe VLB configuration could not be applied to REP Port#2" + string3;
            } else if (!bl6) {
                string = (string != null ? string : "") + "\nThe STCN configuration could not be applied to REP Port#2" + string3;
            }
            if (!bl8) {
                string = (string != null ? string : "") + "\nThe Preempt Delay could not be applied to Port#2" + string3;
            }
        } else {
            string = !bl ? "The REP Configuration failed for both Ports" : "The REP Configuration failed for Port#2" + string3;
        }
        if (string != null) {
            CerentDialog.warningDialog((Component)this, (String)string, (String)"Partial REP Configuration Success");
        }
        this.thePane.resetTable();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public XPL2Layer2LineModel getXPL2Layer2LineModel(int n) {
        try {
            XPL2Layer2LineModel xPL2Layer2LineModel = null;
            XPL2Layer2LineModel[] xPL2Layer2LineModelArray = this.moduleM.getXPL2Layer2EtherLines();
            for (int i = 0; i < xPL2Layer2LineModelArray.length; ++i) {
                if (xPL2Layer2LineModelArray[i].getIndex() != n) continue;
                xPL2Layer2LineModel = xPL2Layer2LineModelArray[i];
                return xPL2Layer2LineModel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

