/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eRepPortType;
import cerent.cms.idl.EtherL2Media.sCVlanRange;
import cerent.cms.idl.EtherL2Media.sRepSegmentRange;
import cerent.cms.idl.EtherL2Media.sRepStcnConfig;
import cerent.cms.idl.EtherL2Media.sRepVlbConfig;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.xpl2.REPCreationDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;

public class REPCreationPane
extends WizardPane
implements ActionListener {
    private REPCreationDialog parent;
    private ComboBoxRenderer comboRenderer = new ComboBoxRenderer();
    String paneName = null;
    private XPL2Layer2LineModel[] lineModels;
    private JComboBox portCB;
    private JComboBox stcnPortCB;
    private JRadioButton rbEdge;
    private JRadioButton rbNone;
    private ButtonGroup bg = new ButtonGroup();
    private JCheckBox primary;
    private JCheckBox pref;
    private JCheckBox noneighbor;
    private JCheckBox stcnEnable;
    private JCheckBox vlbEnable;
    private JCheckBox vlbPref;
    private JTextField segmentTF;
    private JTextField rangeTF;
    private JTextField vlanRangeTF;
    private JTextField delayTF;
    private JTextField portTF;
    private static final Dimension lblDim = new Dimension(90, 20);
    XPL2ModuleModel moduleM;
    private HashMap l2ModelMap = new HashMap();
    private int mode;

    public REPCreationPane(String string, REPCreationDialog rEPCreationDialog, XPL2ModuleModel xPL2ModuleModel, int n) {
        super(string, rEPCreationDialog);
        this.paneName = string;
        this.parent = rEPCreationDialog;
        this.moduleM = xPL2ModuleModel;
        this.mode = n;
        this.lineModels = xPL2ModuleModel.getXPL2Layer2EtherLines();
        Integer[] integerArray = xPL2ModuleModel.getXPL2Layer2EtherLineIndices();
        for (int i = 0; i < integerArray.length; ++i) {
            this.l2ModelMap.put(integerArray[i], this.lineModels[i]);
        }
        int[] nArray = xPL2ModuleModel.getAvailableL2IfForRep();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<XPL2Layer2LineModel> arrayList2 = new ArrayList<XPL2Layer2LineModel>();
        arrayList.addAll(Arrays.asList(integerArray));
        XPL2Layer2LineModel xPL2Layer2LineModel = null;
        for (int i = 0; i < nArray.length; ++i) {
            xPL2Layer2LineModel = (XPL2Layer2LineModel)this.l2ModelMap.get(new Integer(nArray[i]));
            if (xPL2Layer2LineModel == null) continue;
            arrayList2.add(xPL2Layer2LineModel);
        }
        this.lineModels = arrayList2.toArray(new XPL2Layer2LineModel[0]);
        this.init();
        if (n == 0) {
            this.addListeners();
            this.selectRegularPort();
        } else {
            this.initializeFromSegment();
            if (this.rbNone.isSelected()) {
                this.selectRegularPort();
            }
            this.addListeners();
        }
    }

    public void init() {
        JPanel jPanel = REPCreationPane.createVerticalPanel(null);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(this.getSegmentPortPanel());
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(this.getPortRolePanel());
        jPanel2.add(this.getSTCNPanel());
        jPanel.add(jPanel2);
        jPanel.add(this.getVLBPanel());
        jPanel.add(this.getDelayPanel());
        this.add(jPanel);
        this.rbNone.setSelected(true);
    }

    private void addListeners() {
        this.rbEdge.addActionListener(this);
        this.rbNone.addActionListener(this);
        this.primary.addActionListener(this);
        this.pref.addActionListener(this);
        this.vlbPref.addActionListener(this);
        this.vlbEnable.addActionListener(this);
        this.stcnEnable.addActionListener(this);
    }

    private JPanel getVLBPanel() {
        JPanel jPanel = REPCreationPane.createVerticalPanel("VLAN Load Balancing");
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        this.vlbEnable = new JCheckBox("Enable");
        jPanel2.add(this.vlbEnable);
        jPanel.add(jPanel2);
        this.vlanRangeTF = new JTextField(20);
        jPanel.add(REPCreationPane.createAttributePanel("SVLAN:", "(Single/Range)", lblDim, this.vlanRangeTF));
        jPanel.add(Box.createVerticalStrut(5));
        this.portTF = new JTextField(20);
        JPanel jPanel3 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel3.add(REPCreationPane.createAttributePanel("REP PortId:", null, lblDim, this.portTF));
        jPanel3.add(Box.createHorizontalStrut(10));
        this.vlbPref = new JCheckBox("Preferred");
        jPanel3.add(this.vlbPref);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel getDelayPanel() {
        JPanel jPanel = REPCreationPane.createVerticalPanel("VLB Preempt Delay");
        jPanel.add(Box.createVerticalStrut(5));
        this.delayTF = new JTextField(20);
        jPanel.add(REPCreationPane.createAttributePanel("Trigger Delay:", "(15..300 sec)", lblDim, this.delayTF));
        return jPanel;
    }

    private JPanel getSTCNPanel() {
        JPanel jPanel = REPCreationPane.createVerticalPanel("STCN");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(Arrays.asList(this.moduleM.getXPL2Layer2EtherLines()));
        Object[] objectArray = null;
        if (arrayList.size() > 0) {
            arrayList.add(0, new String("----------------"));
        }
        objectArray = arrayList.toArray();
        this.stcnPortCB = new JComboBox<Object>(objectArray);
        this.stcnPortCB.setRenderer(this.comboRenderer);
        this.stcnEnable = new JCheckBox("Enable");
        this.rangeTF = new JTextField(20);
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel2.add(this.stcnEnable);
        jPanel.add(jPanel2);
        jPanel.add(REPCreationPane.createAttributePanel("Port :", null, lblDim, this.stcnPortCB));
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(REPCreationPane.createAttributePanel("Segment#:", null, lblDim, this.rangeTF));
        return jPanel;
    }

    private JPanel getPortRolePanel() {
        JPanel jPanel = REPCreationPane.createVerticalPanel("Port Role");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel.add(jPanel2);
        JPanel jPanel3 = REPCreationPane.createVerticalPanel(null);
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.rbEdge = new JRadioButton("Edge");
        this.rbNone = new JRadioButton("None");
        jPanel3.add(this.rbEdge);
        jPanel3.add(this.rbNone);
        jPanel2.add(jPanel3);
        this.bg.add(this.rbEdge);
        this.bg.add(this.rbNone);
        JPanel jPanel4 = REPCreationPane.createVerticalPanel(null);
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.primary = new JCheckBox("Primary");
        this.pref = new JCheckBox("Preferred");
        this.noneighbor = new JCheckBox("NoNeighbor");
        jPanel4.add(this.primary);
        jPanel4.add(this.pref);
        jPanel4.add(this.noneighbor);
        jPanel2.add(jPanel4);
        return jPanel;
    }

    public static JPanel createVerticalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    private JPanel getSegmentPortPanel() {
        JPanel jPanel = REPCreationPane.createVerticalPanel(null);
        this.segmentTF = new JTextField(20);
        VetoableComboBoxModel vetoableComboBoxModel = new VetoableComboBoxModel(this.lineModels);
        this.portCB = new JComboBox();
        this.portCB.setModel(vetoableComboBoxModel);
        this.portCB.setRenderer(this.comboRenderer);
        jPanel.add(REPCreationPane.createAttributePanel("Segment# :", "(1..1024)", lblDim, this.segmentTF));
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(REPCreationPane.createAttributePanel("Port :", null, lblDim, this.portCB));
        return jPanel;
    }

    private static JPanel createAttributePanel(String string, String string2, Dimension dimension, JComponent jComponent) {
        JPanel jPanel = new JPanel(new FlowLayout(3, 0, 0));
        if (string != null) {
            JLabel jLabel = new JLabel(string);
            jLabel.setPreferredSize(dimension);
            jPanel.add(jLabel);
        }
        jPanel.add(jComponent);
        jPanel.add(Box.createHorizontalStrut(2));
        if (string2 != null) {
            jPanel.add(new JLabel(string2));
        }
        return jPanel;
    }

    private void checkForValidSTCNConfig() throws Exception {
        if (this.stcnPortCB.getSelectedItem() != null && this.stcnPortCB.getSelectedIndex() != 0 && ((XPL2Layer2LineModel)this.stcnPortCB.getSelectedItem()).getIndex() == ((XPL2Layer2LineModel)this.portCB.getSelectedItem()).getIndex()) {
            throw new Exception(EMC.EID_SAME_INTERFACE.getMessage());
        }
        if (this.stcnPortCB.getSelectedItem() != null && this.stcnPortCB.getSelectedIndex() == 0 && this.stcnEnable.isSelected() && this.rangeTF.getText().equalsIgnoreCase("")) {
            throw new Exception(EMC.EID_STCN_INVALID_CONFIG.getMessage());
        }
    }

    private void checkValidRanges(JTextField jTextField, int n, sRepStcnConfig sRepStcnConfig2, sRepVlbConfig sRepVlbConfig2) throws Exception {
        block22: {
            block20: {
                block21: {
                    int n2;
                    if (n != 0) break block20;
                    if (jTextField.getText().equalsIgnoreCase("")) break block21;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    String string = jTextField.getText();
                    String[] stringArray = string.split(",");
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        Object object;
                        if (stringArray[n2].matches("[0-9]{1,4}-[0-9]{1,4}")) {
                            object = stringArray[n2].split("-");
                            sRepSegmentRange sRepSegmentRange2 = new sRepSegmentRange();
                            int n3 = Integer.parseInt(object[0]);
                            int n4 = Integer.parseInt(object[1]);
                            if (n3 < 1 || n3 > 1024 || n4 < 1 || n4 > 1024) {
                                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_REP_SEGMENT_RANGE);
                                throw new Exception();
                            }
                            sRepSegmentRange2.first = new Integer(n3);
                            sRepSegmentRange2.last = new Integer(n4);
                            arrayList.add(sRepSegmentRange2);
                            continue;
                        }
                        if (stringArray[n2].matches("[0-9]{1,4}")) {
                            object = new sRepSegmentRange();
                            int n5 = Integer.parseInt(stringArray[n2]);
                            if (n5 < 1 || n5 > 1024) {
                                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_REP_SEGMENT_RANGE);
                                throw new Exception();
                            }
                            object.first = new Integer(n5);
                            object.last = new Integer(n5);
                            arrayList.add(object);
                            continue;
                        }
                        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_REP_SEGMENT_RANGE);
                        throw new Exception();
                    }
                    if (arrayList.size() > 2) {
                        throw new Exception("Number of REP Segment Ranges exceed the permitted limit");
                    }
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        sRepStcnConfig2.segRange[n2] = (sRepSegmentRange)arrayList.get(n2);
                    }
                    sRepStcnConfig2.segRangeCnt = (short)arrayList.size();
                    break block22;
                }
                if (this.mode != 1) break block22;
                sRepStcnConfig2.segRangeCnt = 0;
                sRepStcnConfig2.segRange = new sRepSegmentRange[2];
                for (int i = 0; i < 2; ++i) {
                    sRepStcnConfig2.segRange[i] = new sRepSegmentRange();
                }
                break block22;
            }
            if (n == 1) {
                if (!jTextField.getText().equalsIgnoreCase("")) {
                    int n6;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    String string = jTextField.getText();
                    String[] stringArray = string.split(",");
                    for (n6 = 0; n6 < stringArray.length; ++n6) {
                        Object object;
                        if (stringArray[n6].matches("[0-9]{1,4}-[0-9]{1,4}")) {
                            object = stringArray[n6].split("-");
                            sCVlanRange sCVlanRange2 = new sCVlanRange();
                            short s = (short)Integer.parseInt(object[0]);
                            short s2 = (short)Integer.parseInt(object[1]);
                            if (s < 1 || s > 4094 || s2 < 1 || s2 > 4094) {
                                throw new Exception(EMC.EID_SVLAN_OUT_OF_RANGE.getMessage());
                            }
                            sCVlanRange2.first = s;
                            sCVlanRange2.last = s2;
                            arrayList.add(sCVlanRange2);
                            continue;
                        }
                        if (stringArray[n6].matches("[0-9]{1,4}")) {
                            object = new sCVlanRange();
                            short s = (short)Integer.parseInt(stringArray[n6]);
                            if (s < 1 || s > 4094) {
                                throw new Exception(EMC.EID_SVLAN_OUT_OF_RANGE.getMessage());
                            }
                            object.first = s;
                            object.last = s;
                            arrayList.add(object);
                            continue;
                        }
                        throw new Exception(EMC.EID_INVALID_SVLAN_RANGE.getMessage());
                    }
                    if (arrayList.size() > 10) {
                        throw new Exception("Number of SVLAN Ranges exceed the permitted limit");
                    }
                    for (n6 = 0; n6 < arrayList.size(); ++n6) {
                        sRepVlbConfig2.vlanRange[n6] = (sCVlanRange)arrayList.get(n6);
                    }
                    sRepVlbConfig2.vlanRangeCnt = new Short((short)arrayList.size());
                } else if (this.mode == 1) {
                    sRepVlbConfig2.vlanRangeCnt = 0;
                    sRepVlbConfig2.vlanRange = new sCVlanRange[10];
                    for (int i = 0; i < 10; ++i) {
                        sRepVlbConfig2.vlanRange[i] = new sCVlanRange();
                    }
                }
            }
        }
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.paneName.equalsIgnoreCase("REP Port#2")) {
            this.segmentTF.setText(String.valueOf(this.parent.getRepSegmentId()));
            this.segmentTF.setEnabled(false);
        }
    }

    private void checkForValidConfigs() throws Exception {
        int n;
        if (this.segmentTF.getText().equalsIgnoreCase("")) {
            throw new Exception(EMC.EID_INVALID_SEGMENT_ID.getMessage());
        }
        try {
            n = Integer.parseInt(this.segmentTF.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception(EMC.EID_INVALID_SEGMENT_ID.getMessage());
        }
        if (n < 1 || n > 1024) {
            throw new Exception(EMC.EID_INVALID_SEGMENT_ID.getMessage());
        }
        if (this.portCB.getSelectedItem() == null) {
            throw new Exception(EMC.EID_INVALID_REP_PORT.getMessage());
        }
        int n2 = 0;
        if (!this.delayTF.getText().equalsIgnoreCase("")) {
            try {
                n2 = new Integer(Integer.parseInt(this.delayTF.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception(EMC.EID_INVALID_TRIGGER_DELAY.getMessage());
            }
            if (n2 != 0 && (n2 < 15 || n2 > 300)) {
                throw new Exception(EMC.EID_INVALID_TRIGGER_DELAY.getMessage());
            }
        }
        if (!(this.vlbEnable.isSelected() || this.vlanRangeTF.getText().equalsIgnoreCase("") && this.portTF.getText().equalsIgnoreCase("") && !this.vlbPref.isSelected())) {
            throw new Exception(EMC.EID_VLB_INVALID_CONFIG.getMessage());
        }
        if (!this.stcnEnable.isSelected() && (this.stcnPortCB.getSelectedItem() != null && this.stcnPortCB.getSelectedIndex() != 0 || !this.rangeTF.getText().equalsIgnoreCase(""))) {
            throw new Exception(EMC.EID_STCN_NOT_ENABLED.getMessage());
        }
        if (this.portTF.isEnabled() && !this.portTF.getText().equalsIgnoreCase("") && !this.vlbPref.isSelected()) {
            String string = this.portTF.getText();
            String string2 = string.substring(2, string.length());
            if (string.charAt(0) != '0' || string.charAt(1) != 'x' && string.charAt(1) != 'X' || string2 != null && string2.length() != 16 || string2 == null || !string2.matches("[0-9a-fA-F]{1,16}")) {
                throw new Exception("Not a valid REP Port Id");
            }
        }
        if (this.vlbEnable.isSelected() && !this.rbNone.isSelected() && !this.vlbPref.isSelected() && this.portTF.getText().equalsIgnoreCase("")) {
            throw new Exception("VLB Preferred option or a valid REP Port ID is required when VLB is enabled");
        }
        if (this.rbNone.isSelected() && this.vlbEnable.isSelected()) {
            throw new Exception("VLB cannot be enabled for a Regular Port");
        }
    }

    @Override
    public void validatePage() throws Exception {
        this.checkForValidConfigs();
        if (this.paneName.equalsIgnoreCase("REP Port#1")) {
            int n;
            this.parent.getEastRepConfig().preferred = this.pref.isSelected();
            if (this.rbEdge.isSelected()) {
                if (this.primary.isSelected() && !this.noneighbor.isSelected()) {
                    this.parent.getEastRepConfig().portType = eRepPortType.EDGE_PRIMARY_PORT;
                } else if (!this.primary.isSelected() && !this.noneighbor.isSelected()) {
                    this.parent.getEastRepConfig().portType = eRepPortType.EDGE_PORT;
                } else if (!this.primary.isSelected() && this.noneighbor.isSelected()) {
                    this.parent.getEastRepConfig().portType = eRepPortType.EDGE_NO_NEIGHBOR_PORT;
                } else if (this.primary.isSelected() && this.noneighbor.isSelected()) {
                    this.parent.getEastRepConfig().portType = eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT;
                }
            } else {
                this.parent.getEastRepConfig().portType = eRepPortType.REGULAR_PORT;
            }
            this.parent.getEastRepConfig().segId = Integer.parseInt(this.segmentTF.getText());
            this.parent.getEastRepConfig().preferred = this.pref.isSelected();
            this.parent.setEastPort((XPL2Layer2LineModel)this.portCB.getSelectedItem());
            this.parent.getEastRepStcnConfig().stcnEnabled = this.stcnEnable.isSelected();
            this.checkForValidSTCNConfig();
            if (this.stcnPortCB.getSelectedIndex() != 0 && (XPL2Layer2LineModel)this.stcnPortCB.getSelectedItem() != null) {
                n = ((XPL2Layer2LineModel)this.stcnPortCB.getSelectedItem()).getIndex();
                this.parent.getEastRepStcnConfig().index = new Integer(n);
            } else {
                this.parent.getEastRepStcnConfig().index = new Integer(0);
            }
            this.checkValidRanges(this.rangeTF, 0, this.parent.getEastRepStcnConfig(), null);
            this.parent.getEastRepVlbConfig().vlbEnabled = this.vlbEnable.isSelected();
            this.parent.eastPDelay = 0;
            if (!this.delayTF.getText().equalsIgnoreCase("") && (n = new Integer(Integer.parseInt(this.delayTF.getText())).intValue()) != 0) {
                this.parent.eastPDelay = n;
            }
            this.checkValidRanges(this.vlanRangeTF, 1, null, this.parent.getEastRepVlbConfig());
            this.parent.getEastRepVlbConfig().preferred = this.vlbPref.isSelected();
            char[] cArray = new char[18];
            for (int i = 0; i < 18; ++i) {
                cArray[i] = '\u0000';
            }
            if (this.portTF.isEnabled() && !this.portTF.getText().equalsIgnoreCase("") && !this.vlbPref.isSelected()) {
                char[] cArray2 = this.portTF.getText().toCharArray();
                if (cArray2.length <= 18) {
                    for (int i = 0; i < cArray2.length; ++i) {
                        cArray[i] = cArray2[i];
                    }
                }
            } else {
                cArray[0] = '\u0000';
            }
            this.parent.getEastRepVlbConfig().repPortId = cArray;
        } else if (this.paneName.equalsIgnoreCase("REP Port#2")) {
            int n;
            this.parent.getWestRepConfig().preferred = this.pref.isSelected();
            if (this.rbEdge.isSelected()) {
                if (this.primary.isSelected() && !this.noneighbor.isSelected()) {
                    this.parent.getWestRepConfig().portType = eRepPortType.EDGE_PRIMARY_PORT;
                } else if (!this.primary.isSelected() && !this.noneighbor.isSelected()) {
                    this.parent.getWestRepConfig().portType = eRepPortType.EDGE_PORT;
                } else if (!this.primary.isSelected() && this.noneighbor.isSelected()) {
                    this.parent.getWestRepConfig().portType = eRepPortType.EDGE_NO_NEIGHBOR_PORT;
                } else if (this.primary.isSelected() && this.noneighbor.isSelected()) {
                    this.parent.getWestRepConfig().portType = eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT;
                }
            } else {
                this.parent.getWestRepConfig().portType = eRepPortType.REGULAR_PORT;
            }
            this.parent.getWestRepConfig().segId = Integer.parseInt(this.segmentTF.getText());
            this.parent.getWestRepConfig().preferred = this.pref.isSelected();
            this.parent.setWestPort((XPL2Layer2LineModel)this.portCB.getSelectedItem());
            if (this.parent.getWestSegmentPortIndex() == this.parent.getEastSegmentPortIndex()) {
                throw new Exception(EMC.EID_INVALID_REP_PORT_CONFIG.getMessage());
            }
            eRepPortType eRepPortType2 = this.parent.getEastRepConfig().portType;
            eRepPortType eRepPortType3 = this.parent.getWestRepConfig().portType;
            if (eRepPortType2 != eRepPortType3) {
                if (eRepPortType2 == eRepPortType.REGULAR_PORT ? eRepPortType3 == eRepPortType.EDGE_PORT || eRepPortType3 == eRepPortType.EDGE_PRIMARY_PORT : eRepPortType3 == eRepPortType.REGULAR_PORT && (eRepPortType2 == eRepPortType.EDGE_PORT || eRepPortType2 == eRepPortType.EDGE_PRIMARY_PORT)) {
                    throw new Exception(EMC.EID_PORT_TYPE_INCOMPATIBLE.getMessage());
                }
                if (eRepPortType2 == eRepPortType.EDGE_NO_NEIGHBOR_PORT ? eRepPortType3 == eRepPortType.EDGE_PORT || eRepPortType3 == eRepPortType.EDGE_PRIMARY_PORT : eRepPortType3 == eRepPortType.EDGE_NO_NEIGHBOR_PORT && (eRepPortType2 == eRepPortType.EDGE_PORT || eRepPortType2 == eRepPortType.EDGE_PRIMARY_PORT)) {
                    throw new Exception(EMC.EID_PORT_TYPE_INCOMPATIBLE.getMessage());
                }
                if (eRepPortType2 == eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT ? eRepPortType3 == eRepPortType.EDGE_PORT || eRepPortType3 == eRepPortType.EDGE_PRIMARY_PORT : eRepPortType3 == eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT && (eRepPortType2 == eRepPortType.EDGE_PORT || eRepPortType2 == eRepPortType.EDGE_PRIMARY_PORT)) {
                    throw new Exception(EMC.EID_PORT_TYPE_INCOMPATIBLE.getMessage());
                }
            } else {
                if (eRepPortType2 == eRepPortType.EDGE_NO_NEIGHBOR_PORT ? eRepPortType3 == eRepPortType.EDGE_NO_NEIGHBOR_PORT || eRepPortType3 == eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT : eRepPortType3 == eRepPortType.EDGE_NO_NEIGHBOR_PORT && (eRepPortType2 == eRepPortType.EDGE_NO_NEIGHBOR_PORT || eRepPortType2 == eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT)) {
                    throw new Exception(EMC.EID_PORT_TYPE_INCOMPATIBLE.getMessage());
                }
                if (eRepPortType2 == eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT ? eRepPortType3 == eRepPortType.EDGE_NO_NEIGHBOR_PORT || eRepPortType3 == eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT : eRepPortType3 == eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT && (eRepPortType2 == eRepPortType.EDGE_NO_NEIGHBOR_PORT || eRepPortType2 == eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT)) {
                    throw new Exception(EMC.EID_PORT_TYPE_INCOMPATIBLE.getMessage());
                }
            }
            this.parent.getWestRepStcnConfig().stcnEnabled = this.stcnEnable.isSelected();
            this.checkForValidSTCNConfig();
            if (this.stcnPortCB.getSelectedIndex() != 0 && (XPL2Layer2LineModel)this.stcnPortCB.getSelectedItem() != null) {
                n = ((XPL2Layer2LineModel)this.stcnPortCB.getSelectedItem()).getIndex();
                this.parent.getWestRepStcnConfig().index = new Integer(n);
            } else {
                this.parent.getWestRepStcnConfig().index = new Integer(0);
            }
            this.checkValidRanges(this.rangeTF, 0, this.parent.getWestRepStcnConfig(), null);
            this.parent.getWestRepVlbConfig().vlbEnabled = this.vlbEnable.isSelected();
            this.parent.westPDelay = 0;
            if (!this.delayTF.getText().equalsIgnoreCase("") && (n = new Integer(Integer.parseInt(this.delayTF.getText())).intValue()) != 0) {
                this.parent.westPDelay = n;
            }
            this.checkValidRanges(this.vlanRangeTF, 1, null, this.parent.getWestRepVlbConfig());
            this.parent.getWestRepVlbConfig().preferred = this.vlbPref.isSelected();
            char[] cArray = new char[18];
            for (int i = 0; i < 18; ++i) {
                cArray[i] = '\u0000';
            }
            if (this.portTF.isEnabled() && !this.portTF.getText().equalsIgnoreCase("") && !this.vlbPref.isSelected()) {
                char[] cArray3 = this.portTF.getText().toCharArray();
                if (cArray3.length <= 18) {
                    for (int i = 0; i < cArray3.length; ++i) {
                        cArray[i] = cArray3[i];
                    }
                }
                this.parent.getWestRepVlbConfig().repPortId = cArray;
            } else {
                cArray[0] = '\u0000';
                this.parent.getWestRepVlbConfig().repPortId = cArray;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.rbNone) {
            this.selectRegularPort();
        } else if (object == this.rbEdge) {
            this.selectEdgePort();
        } else if (object == this.vlbEnable) {
            if (this.vlbEnable.isSelected()) {
                this.vlbPref.setEnabled(true);
                this.vlbPref.setSelected(true);
                this.vlanRangeTF.setEnabled(true);
                this.portTF.setEnabled(false);
            } else {
                this.vlbPref.setSelected(false);
                this.vlbPref.setEnabled(false);
                this.vlanRangeTF.setEnabled(false);
                this.portTF.setEnabled(false);
            }
        } else if (object == this.vlbPref) {
            if (this.vlbPref.isSelected()) {
                this.portTF.setEnabled(false);
            } else {
                this.portTF.setEnabled(true);
            }
        } else if (object == this.stcnEnable) {
            if (this.stcnEnable.isSelected()) {
                this.rangeTF.setEnabled(true);
                this.stcnPortCB.setEnabled(true);
            } else {
                this.rangeTF.setEnabled(false);
                this.stcnPortCB.setEnabled(false);
            }
        }
    }

    public void selectRegularPort() {
        this.primary.setSelected(false);
        this.primary.setEnabled(false);
        this.noneighbor.setSelected(false);
        this.noneighbor.setEnabled(false);
        this.stcnEnable.setSelected(false);
        this.stcnEnable.setEnabled(false);
        this.rangeTF.setEnabled(false);
        this.stcnPortCB.setEnabled(false);
        this.vlbEnable.setSelected(false);
        this.vlbEnable.setEnabled(false);
        this.vlbPref.setSelected(false);
        this.vlbPref.setEnabled(false);
        this.vlanRangeTF.setText(null);
        this.vlanRangeTF.setEnabled(false);
        this.delayTF.setText("0");
        this.delayTF.setEnabled(true);
        this.portTF.setText(null);
        this.portTF.setEnabled(false);
    }

    @Override
    public void refresh() {
        if (this.paneName.equalsIgnoreCase("REP Port#1")) {
            this.parent.setBackEnabled(false);
            this.parent.setCancelEnabled(true);
            this.parent.setNextEnabled(true);
            this.parent.setFinishEnabled(true);
        } else {
            this.parent.setBackEnabled(true);
            this.parent.setCancelEnabled(true);
            this.parent.setNextEnabled(false);
            this.parent.setFinishEnabled(true);
        }
    }

    private void selectEdgePort() {
        this.stcnEnable.setEnabled(true);
        this.stcnEnable.setSelected(false);
        this.rangeTF.setEnabled(true);
        this.stcnPortCB.setEnabled(true);
        this.primary.setEnabled(true);
        this.noneighbor.setEnabled(true);
        this.vlbEnable.setEnabled(true);
        this.delayTF.setText("0");
        this.delayTF.setEnabled(true);
        this.portTF.setEnabled(false);
        this.vlbPref.setEnabled(true);
        this.vlanRangeTF.setEnabled(true);
    }

    public int getRepSegmentId() {
        if (!this.segmentTF.getText().equalsIgnoreCase("")) {
            return Integer.parseInt(this.segmentTF.getText());
        }
        return 0;
    }

    private void initializeFromSegment() {
        if ("REP Port#1".equalsIgnoreCase(this.paneName)) {
            int n;
            int n2;
            int n3;
            this.segmentTF.setText(String.valueOf(this.parent.getEastRepConfig().segId));
            this.segmentTF.setEnabled(false);
            ((VetoableComboBoxModel)this.portCB.getModel()).addElement(this.parent.getEastPort());
            this.portCB.setSelectedItem(this.parent.getEastPort());
            this.portCB.setEnabled(false);
            if (this.parent.getEastRepConfig().preferred) {
                this.pref.setSelected(true);
            } else {
                this.pref.setSelected(false);
            }
            if (this.parent.getEastRepConfig().portType == eRepPortType.EDGE_PRIMARY_PORT) {
                this.rbEdge.setSelected(true);
                this.primary.setSelected(true);
            } else if (this.parent.getEastRepConfig().portType == eRepPortType.EDGE_NO_NEIGHBOR_PORT) {
                this.rbEdge.setSelected(true);
                this.noneighbor.setSelected(true);
            } else if (this.parent.getEastRepConfig().portType == eRepPortType.EDGE_PORT) {
                this.rbEdge.setSelected(true);
                this.primary.setSelected(false);
                this.noneighbor.setSelected(false);
            } else if (this.parent.getEastRepConfig().portType == eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT) {
                this.rbEdge.setSelected(true);
                this.primary.setSelected(true);
                this.noneighbor.setSelected(true);
            } else if (this.parent.getEastRepConfig().portType == eRepPortType.REGULAR_PORT) {
                this.rbNone.setSelected(true);
                this.primary.setSelected(false);
                this.noneighbor.setSelected(false);
            }
            this.rbEdge.setEnabled(false);
            this.rbNone.setEnabled(false);
            this.primary.setEnabled(false);
            this.noneighbor.setEnabled(false);
            this.pref.setEnabled(false);
            this.stcnEnable.setSelected(this.parent.getEastRepStcnConfig().stcnEnabled);
            int n4 = this.parent.getEastRepStcnConfig().index;
            if (n4 > 0) {
                this.stcnPortCB.setSelectedItem(this.parent.getXPL2Layer2LineModel(n4));
            } else if (this.stcnPortCB.getItemCount() > 0) {
                this.stcnPortCB.setSelectedIndex(0);
            }
            String string = null;
            int n5 = this.parent.getEastRepStcnConfig().segRangeCnt;
            if (n5 > 0) {
                for (n3 = 0; n3 < n5; ++n3) {
                    n2 = this.parent.getEastRepStcnConfig().segRange[n3].first;
                    n = this.parent.getEastRepStcnConfig().segRange[n3].last;
                    if (n3 == 0) {
                        if (n2 != n) {
                            string = String.valueOf(n2) + "-" + String.valueOf(n);
                            continue;
                        }
                        string = String.valueOf(n2);
                        continue;
                    }
                    string = n2 != n ? string + "," + String.valueOf(n2) + "-" + String.valueOf(n) : string + "," + String.valueOf(n2);
                }
                this.rangeTF.setText(string);
            }
            this.vlbEnable.setSelected(this.parent.getEastRepVlbConfig().vlbEnabled);
            this.delayTF.setText(String.valueOf(this.parent.eastPDelay));
            this.vlbPref.setSelected(this.parent.getEastRepVlbConfig().preferred);
            if (this.vlbPref.isSelected()) {
                this.portTF.setEnabled(false);
            } else {
                char[] cArray = this.parent.getEastRepVlbConfig().repPortId;
                char[] cArray2 = new char[18];
                for (int i = 0; i < 18; ++i) {
                    cArray2[i] = '\u0000';
                }
                String string2 = null;
                if (cArray.length > 0) {
                    int n6 = 0;
                    for (n6 = 0; n6 < cArray.length; ++n6) {
                        if (cArray[n6] == '\u0000') {
                            cArray2[n6] = '\u0000';
                            break;
                        }
                        cArray2[n6] = cArray[n6];
                    }
                    string2 = String.valueOf(cArray2);
                    string2 = string2.substring(0, n6);
                }
                this.portTF.setText(string2);
            }
            string = null;
            n5 = this.parent.getEastRepVlbConfig().vlanRangeCnt;
            if (n5 > 0) {
                for (n3 = 0; n3 < n5; ++n3) {
                    n2 = this.parent.getEastRepVlbConfig().vlanRange[n3].first;
                    n = this.parent.getEastRepVlbConfig().vlanRange[n3].last;
                    if (n3 == 0) {
                        if (n2 != n) {
                            string = String.valueOf(n2) + "-" + String.valueOf(n);
                            continue;
                        }
                        string = String.valueOf(n2);
                        continue;
                    }
                    string = n2 != n ? string + "," + String.valueOf(n2) + "-" + String.valueOf(n) : string + "," + String.valueOf(n2);
                }
                this.vlanRangeTF.setText(string);
            }
        } else if ("REP Port#2".equalsIgnoreCase(this.paneName)) {
            int n;
            int n7;
            this.segmentTF.setText(String.valueOf(this.parent.getWestRepConfig().segId));
            this.segmentTF.setEnabled(false);
            ((VetoableComboBoxModel)this.portCB.getModel()).addElement(this.parent.getWestPort());
            this.portCB.setSelectedItem(this.parent.getWestPort());
            this.portCB.setEnabled(false);
            if (this.parent.getWestRepConfig().preferred) {
                this.pref.setSelected(true);
            } else {
                this.pref.setSelected(false);
            }
            if (this.parent.getWestRepConfig().portType == eRepPortType.EDGE_PRIMARY_PORT) {
                this.rbEdge.setSelected(true);
                this.primary.setSelected(true);
            } else if (this.parent.getWestRepConfig().portType == eRepPortType.EDGE_NO_NEIGHBOR_PORT) {
                this.rbEdge.setSelected(true);
                this.noneighbor.setSelected(true);
            } else if (this.parent.getWestRepConfig().portType == eRepPortType.EDGE_NO_NEIGHBOR_PRIMARY_PORT) {
                this.rbEdge.setSelected(true);
                this.primary.setSelected(true);
                this.noneighbor.setSelected(true);
            } else if (this.parent.getWestRepConfig().portType == eRepPortType.EDGE_PORT) {
                this.rbEdge.setSelected(true);
                this.primary.setSelected(false);
                this.noneighbor.setSelected(false);
            } else if (this.parent.getWestRepConfig().portType == eRepPortType.REGULAR_PORT) {
                this.rbNone.setSelected(true);
                this.primary.setSelected(false);
                this.noneighbor.setSelected(false);
            }
            this.rbEdge.setEnabled(false);
            this.rbNone.setEnabled(false);
            this.primary.setEnabled(false);
            this.noneighbor.setEnabled(false);
            this.pref.setEnabled(false);
            this.stcnEnable.setSelected(this.parent.getWestRepStcnConfig().stcnEnabled);
            int n8 = this.parent.getWestRepStcnConfig().index;
            if (n8 > 0) {
                this.stcnPortCB.setSelectedItem(this.parent.getXPL2Layer2LineModel(n8));
            } else {
                this.stcnPortCB.setSelectedIndex(0);
            }
            String string = null;
            int n9 = this.parent.getWestRepStcnConfig().segRangeCnt;
            if (n9 > 0) {
                for (int i = 0; i < n9; ++i) {
                    n7 = this.parent.getWestRepStcnConfig().segRange[i].first;
                    n = this.parent.getWestRepStcnConfig().segRange[i].last;
                    if (i == 0) {
                        if (n7 != n) {
                            string = String.valueOf(n7) + "-" + String.valueOf(n);
                            continue;
                        }
                        string = String.valueOf(n7);
                        continue;
                    }
                    string = n7 != n ? string + "," + String.valueOf(n7) + "-" + String.valueOf(n) : string + "," + String.valueOf(n7);
                }
                this.rangeTF.setText(string);
            }
            this.vlbEnable.setSelected(this.parent.getWestRepVlbConfig().vlbEnabled);
            this.delayTF.setText(String.valueOf(this.parent.westPDelay));
            this.vlbPref.setSelected(this.parent.getWestRepVlbConfig().preferred);
            if (this.vlbPref.isSelected()) {
                this.portTF.setEnabled(false);
            } else {
                char[] cArray = this.parent.getWestRepVlbConfig().repPortId;
                char[] cArray3 = new char[18];
                for (int i = 0; i < 18; ++i) {
                    cArray3[i] = '\u0000';
                }
                String string3 = null;
                if (cArray.length > 0) {
                    int n10 = 0;
                    for (n10 = 0; n10 < cArray.length; ++n10) {
                        if (cArray[n10] == '\u0000') {
                            cArray3[n10] = '\u0000';
                            break;
                        }
                        cArray3[n10] = cArray[n10];
                    }
                    string3 = String.valueOf(cArray3);
                    string3 = string3.substring(0, n10);
                }
                this.portTF.setText(string3);
            }
            string = null;
            n9 = this.parent.getWestRepVlbConfig().vlanRangeCnt;
            if (n9 > 0) {
                for (int i = 0; i < n9; ++i) {
                    n7 = this.parent.getWestRepVlbConfig().vlanRange[i].first;
                    n = this.parent.getWestRepVlbConfig().vlanRange[i].last;
                    if (i == 0) {
                        if (n7 != n) {
                            string = String.valueOf(n7) + "-" + String.valueOf(n);
                            continue;
                        }
                        string = String.valueOf(n7);
                        continue;
                    }
                    string = n7 != n ? string + "," + String.valueOf(n7) + "-" + String.valueOf(n) : string + "," + String.valueOf(n7);
                }
                this.vlanRangeTF.setText(string);
            }
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.setText("");
                return this;
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof XPL2Layer2LineModel) {
                XPL2Layer2LineModel xPL2Layer2LineModel = (XPL2Layer2LineModel)object;
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                try {
                    this.setText(entityCellRenderer.getPortString((IEntityModel)xPL2Layer2LineModel.getPort(), false));
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            } else {
                this.setText((String)object);
            }
            return this;
        }
    }

    class VetoableChangeEvent
    extends ChangeEvent {
        private Object newValue;

        public VetoableChangeEvent(Object object, Object object2) {
            super(object);
            this.newValue = object2;
        }

        public Object getNewValue() {
            return this.newValue;
        }
    }

    class VetoableComboBoxModel
    extends DefaultComboBoxModel {
        private ArrayList<VetoableComboBoxSelectionListener> selectionListeners;

        public VetoableComboBoxModel() {
            this.selectionListeners = new ArrayList();
        }

        public VetoableComboBoxModel(Object[] objectArray) {
            super(objectArray);
            this.selectionListeners = new ArrayList();
        }

        public void addVetoableSelectionListener(VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener) {
            this.selectionListeners.add(vetoableComboBoxSelectionListener);
        }

        public void removeVetoableSelectionListener(VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener) {
            this.selectionListeners.remove(vetoableComboBoxSelectionListener);
        }

        protected boolean fireVetoableSelectionChange(Object object) {
            boolean bl = true;
            VetoableChangeEvent vetoableChangeEvent = new VetoableChangeEvent(this, object);
            for (VetoableComboBoxSelectionListener vetoableComboBoxSelectionListener : this.selectionListeners) {
                bl &= vetoableComboBoxSelectionListener.selectionChanged(vetoableChangeEvent);
            }
            return bl;
        }
    }

    static interface VetoableComboBoxSelectionListener
    extends EventListener {
        public boolean selectionChanged(VetoableChangeEvent var1);
    }
}

