/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sCFMIICondReportInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.KDebug;
import cerent.util.MacAddrFormat;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class XPL2CXConnTableModel
extends AbstractTableModel
implements Observer {
    public static final int PORT_INDEX = 0;
    static final String[] columnNames = new String[]{"Port"};
    private XPL2ModuleModel eqpmtModel = null;
    private int numLines = 0;
    private EntityTableModel etm;
    protected EntityCellRenderer myPortRenderer;
    private InterfaceModels ifs;
    private ArrayList reportInfoList = new ArrayList();
    private static final String DNAME = "DOMAIN NAME";
    private static final String SVLANID = "SVLAN ID";
    private static final String RMPID = "REMOTE MPID";
    private static final String RMAC = "REMOTE MAC";
    private static final String LMNAME = "LOCAL MA NAME";
    private static final String RMNAME = "REMOTE MA NAME";
    private static final SDebug db = new SDebug("XPL2CXConnTableModel");

    public XPL2CXConnTableModel(XPL2ModuleModel xPL2ModuleModel) {
        this.eqpmtModel = xPL2ModuleModel;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.etm = xPL2ModuleModel.getNodeModelDelegate().getEntityTableModel();
        this.ifs = xPL2ModuleModel.getNodeModelDelegate().getIfModels();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string;
        block5: {
            string = null;
            try {
                switch (n2) {
                    case 0: {
                        string = this.getPortName(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("Error in getValueAt in XPL2AffectedVlanTableModel " + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public StringBuffer getAffectedMEPs(int n) {
        AffectedCXConnInfo affectedCXConnInfo = (AffectedCXConnInfo)this.reportInfoList.get(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DNAME + this.myPortRenderer.fillWhiteSpace(32) + "\t" + SVLANID + "\t" + RMPID + "\t" + RMAC + this.myPortRenderer.fillWhiteSpace(8) + "\t" + LMNAME + this.myPortRenderer.fillWhiteSpace(30) + "\t" + RMNAME + "\n");
        for (int i = 0; i < affectedCXConnInfo.cxInfo.length; ++i) {
            stringBuffer.append(affectedCXConnInfo.cxInfo[i].domainName + this.myPortRenderer.fillWhiteSpace(1, affectedCXConnInfo.cxInfo[i].domainName) + "\t" + Short.toString(affectedCXConnInfo.cxInfo[i].vlanId) + this.myPortRenderer.fillWhiteSpace(3, Short.toString(affectedCXConnInfo.cxInfo[i].vlanId)) + "\t" + affectedCXConnInfo.cxInfo[i].remoteMpId + this.myPortRenderer.fillWhiteSpace(4, Short.toString(affectedCXConnInfo.cxInfo[i].remoteMpId)) + "\t" + MacAddrFormat.format(affectedCXConnInfo.cxInfo[i].remoteMac.addr) + this.myPortRenderer.fillWhiteSpace(2, MacAddrFormat.format(affectedCXConnInfo.cxInfo[i].remoteMac.addr)) + "\t" + affectedCXConnInfo.cxInfo[i].localMAName + this.myPortRenderer.fillWhiteSpace(1, affectedCXConnInfo.cxInfo[i].localMAName) + "\t" + affectedCXConnInfo.cxInfo[i].remoteMAName + "\n");
        }
        return stringBuffer;
    }

    public String getPortName(int n) {
        block5: {
            AffectedCXConnInfo affectedCXConnInfo = (AffectedCXConnInfo)this.reportInfoList.get(n);
            if (affectedCXConnInfo.cxInfo.length > 0) {
                try {
                    IPortModel iPortModel = this.ifs.getInterfaceModel(affectedCXConnInfo.ifIndex).getPortModel();
                    return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("Error in getPortName in XPL2SecurityTableModel " + (Object)((Object)noSuchInterface));
                        KDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block5;
                    db.println("Error in getPortName in XPL2SecurityTableModel " + (Object)((Object)abstractCmsNoSuchEntityException));
                    KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return null;
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    public void reload(String string, int n) {
        XPL2Layer2LineModel[] xPL2Layer2LineModelArray = this.eqpmtModel.getXPL2Layer2EtherLines();
        this.numLines = 0;
        this.reportInfoList.clear();
        if (xPL2Layer2LineModelArray != null) {
            for (int i = 0; i < xPL2Layer2LineModelArray.length; ++i) {
                try {
                    sCFMIICondReportInfo[] sCFMIICondReportInfoArray = this.eqpmtModel.getActualCrossConnectedConditions(xPL2Layer2LineModelArray[i].getIndex(), string, n);
                    if (sCFMIICondReportInfoArray == null || sCFMIICondReportInfoArray.length <= 0) continue;
                    this.reportInfoList.add(new AffectedCXConnInfo(xPL2Layer2LineModelArray[i].getIndex(), sCFMIICondReportInfoArray));
                    ++this.numLines;
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!db.on()) continue;
                    db.println("Error in reload in XPL2AffectedVlanTableModel " + (Object)((Object)noSuchInterface));
                    KDebug.printStackTrace((Throwable)noSuchInterface);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) continue;
                    db.println("Error in reload in XPL2AffectedVlanTableModel " + (Object)((Object)wrongInterfaceType));
                    KDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
        }
        this.fireTableDataChanged();
    }

    public void dispose() {
        this.reportInfoList.clear();
    }

    private class AffectedCXConnInfo {
        int ifIndex;
        sCFMIICondReportInfo[] cxInfo;

        AffectedCXConnInfo(int n, sCFMIICondReportInfo[] sCFMIICondReportInfoArray) {
            this.ifIndex = n;
            this.cxInfo = new sCFMIICondReportInfo[sCFMIICondReportInfoArray.length];
            this.cxInfo = sCFMIICondReportInfoArray;
        }
    }
}

