/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sChannelGroupAttributes;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2ChannelGroupModel;
import cerent.cms.model.XPL2ChannelGroupUpdate;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.HexTextField;
import cerent.cms.ui.xpl2.XPL2ChannelGroupCreationDlg;
import cerent.cms.ui.xpl2.XPL2ChannelGroupTableModel;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.DetailedLogDialog;
import cerent.util.gui.NumberTextField;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class XPL2ChannelGroupProvPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener,
ActionListener {
    static final int MAX_CH_GROUP_ON_XP_10GE = 2;
    static final int MAX_CH_GROUP_ON_XP_GE = 11;
    protected XPL2ChannelGroupTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = null;
    private XPL2ChannelGroupModel[] channelGroupModels = null;
    private NodeModelDelegate nmd;
    private ObservableManager _obsMgr;
    private JButton createChGroupBt;
    private JButton addRemovePortBt;
    private JButton deleteChGroupBt;
    private static final SDebug db = new SDebug("XPL2ChannelGroupProvPane");

    public XPL2ChannelGroupProvPane(String string, TabbedView tabbedView, final XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.eqpmtModel = xPL2ModuleModel;
        this.nmd = xPL2ModuleModel.getNodeModelDelegate();
        this.channelGroupModels = xPL2ModuleModel.getChannelGroupModels();
        if (xPL2ModuleModel == null) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + xPL2ModuleModel);
            }
            return;
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.dataModel = new XPL2ChannelGroupTableModel(xPL2ModuleModel, this.channelGroupModels);
        this.dataModel.addTableModelListener(this);
        final DefaultCellEditor defaultCellEditor = new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getEtherSpeedAttrsFE()));
        final DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getEtherSpeedAttrs1GE()));
        final DefaultCellEditor defaultCellEditor3 = new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getEtherSpeedAttr10GE()));
        final DefaultCellEditor defaultCellEditor4 = new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getEtherExpSpeedAttrs1GEAuto()));
        final DefaultCellEditor defaultCellEditor5 = new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getEtherExpSpeedAttrs1GE()));
        this.table = new UTable(this.dataModel){

            public TableCellEditor getCellEditor(int n, int n2) {
                if (this.convertColumnIndexToModel(n2) == 8) {
                    if (XPL2ChannelGroupProvPane.this.dataModel.getPortList(n).length == 0) {
                        if (xPL2ModuleModel.getEqType() == 271) {
                            if (db.on()) {
                                db.println("No port -> 10GE (10000)");
                            }
                            return defaultCellEditor3;
                        }
                        if (db.on()) {
                            db.println("No port -> 1GE (1000, Auto)");
                        }
                        return defaultCellEditor2;
                    }
                    if (XPL2ChannelGroupProvPane.this.dataModel.isBundlingOneGE(n)) {
                        if (db.on()) {
                            db.println("1GE (1000, Auto)");
                        }
                        return defaultCellEditor2;
                    }
                    if (XPL2ChannelGroupProvPane.this.dataModel.isBundlingFE(n)) {
                        if (db.on()) {
                            db.println("FE (100)");
                        }
                        return defaultCellEditor;
                    }
                    if (db.on()) {
                        db.println("10GE (10000)");
                    }
                    return defaultCellEditor3;
                }
                if (this.convertColumnIndexToModel(n2) == 9) {
                    if (XPL2ChannelGroupProvPane.this.dataModel.getPortList(n).length == 0) {
                        if (xPL2ModuleModel.getEqType() == 271) {
                            if (db.on()) {
                                db.println("No port -> 10GE (10000)");
                            }
                            return defaultCellEditor3;
                        }
                        if (db.on()) {
                            db.println("1GE (1000, 100, 10)");
                        }
                        return defaultCellEditor4;
                    }
                    if (XPL2ChannelGroupProvPane.this.dataModel.isBundlingOneGE(n)) {
                        if (XPL2ChannelGroupProvPane.this.dataModel.getSpeed(n).getIntValue() == 3) {
                            if (db.on()) {
                                db.println("1GE (1000, 100, 10)");
                            }
                            return defaultCellEditor4;
                        }
                        if (db.on()) {
                            db.println("1GE (1000)");
                        }
                        return defaultCellEditor5;
                    }
                    if (XPL2ChannelGroupProvPane.this.dataModel.isBundlingFE(n)) {
                        if (db.on()) {
                            db.println("FE (100)");
                        }
                        return defaultCellEditor;
                    }
                    if (db.on()) {
                        db.println("10GE (10000)");
                    }
                    return defaultCellEditor3;
                }
                return super.getCellEditor(n, n2);
            }
        };
        this.table.setCellSelectionEnabled(true);
        this.customizeTable();
        JPanel jPanel = new JPanel(new BorderLayout());
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        jPanel.add((Component)uScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        this.createChGroupBt = new JButton("Create...");
        this.addRemovePortBt = new JButton("Add/Remove Ports...");
        this.deleteChGroupBt = new JButton("Delete");
        this.createChGroupBt.addActionListener(this);
        this.addRemovePortBt.addActionListener(this);
        this.deleteChGroupBt.addActionListener(this);
        jPanel2.add(this.createChGroupBt);
        jPanel2.add(this.addRemovePortBt);
        jPanel2.add(this.deleteChGroupBt);
        this.enableComponent(this.createChGroupBt, this.nmd);
        this.enableComponent(this.addRemovePortBt, this.nmd);
        this.enableComponent(this.deleteChGroupBt, this.nmd);
        jPanel.add((Component)jPanel2, "South");
        this.add(jPanel);
        this.registerWithModel();
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    protected void addColumn(int n) {
        TableColumn tableColumn = new TableColumn(n);
        this.table.addColumn(tableColumn);
    }

    @Override
    public void refreshMyLines(Object object) {
        if (object instanceof XPL2ChannelGroupUpdate) {
            if (db.on()) {
                db.println("refreshMyLines from XPL2ChannelGroupUpdate");
            }
            this.channelGroupModels = ((XPL2ChannelGroupUpdate)object).getChGroupModels();
            this.dataModel.refreshMyLines(((XPL2ChannelGroupUpdate)object).getChGroupModels());
        } else if (object instanceof XPL2ChannelGroupModel[]) {
            if (db.on()) {
                db.println("refreshMyLines from XPL2ChannelGroupModel[]");
            }
            this.channelGroupModels = (XPL2ChannelGroupModel[])object;
            this.dataModel.refreshMyLines((XPL2ChannelGroupModel[])object);
        }
    }

    @Override
    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("calling enteringPage");
        }
        super.enteringPage();
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.unRegisterWithModel();
    }

    @Override
    protected void registerWithModel() {
        super.registerWithModel();
        if (db.on()) {
            db.println("calling registerWithModel");
        }
        for (int i = 0; i < this.channelGroupModels.length; ++i) {
            this.getObsMgr().addObservable((Observable)((Object)this.channelGroupModels[i]));
        }
    }

    protected void unRegisterWithModel() {
        if (db.on()) {
            db.println("calling unRegisterWithModel");
        }
        for (int i = 0; i < this.channelGroupModels.length; ++i) {
            this.getObsMgr().removeObservable((Observable)((Object)this.channelGroupModels[i]));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    protected void customizeTable() {
        TableColumn tableColumn = null;
        Object[] objectArray = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        NumberTextField numberTextField = new NumberTextField(4);
        NumberTextField numberTextField2 = new NumberTextField(3);
        NumberTextField numberTextField3 = new NumberTextField(3);
        try {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
            objectArray = this.dataModel.getLacpModeAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(4));
            objectArray = this.dataModel.getLacpHashingModeAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
            tableColumn.setCellRenderer(new PortListCellRenderer());
            boolean bl = AdminState.isANSI(this.getTdmProtocolType());
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(5));
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(AdminState.getAdminStatesIS_DSBLD(bl))));
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(7));
            tableColumn.setCellEditor(new NumberRangeCellEditor(numberTextField, 64, 9700, EMC.EID_MTU_OUT_OF_RANGE));
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(11));
            tableColumn.setCellEditor(new NumberRangeCellEditor(numberTextField3, 0, 100, EMC.EID_INFO_RATE_OUT_OF_RANGE));
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(13));
            objectArray = this.dataModel.getBucketAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(12));
            objectArray = this.dataModel.getBucketAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(14));
            objectArray = this.dataModel.getNimAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(15));
            objectArray = this.dataModel.getIngressAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(16));
            tableColumn.setCellEditor(new DefaultCellEditor(new HexTextField(4)));
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(17));
            tableColumn.setCellEditor(new DefaultCellEditor(new HexTextField(4)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.table.doLayout();
    }

    private int getTdmProtocolType() {
        return this.eqpmtModel.getNodeModel().getTdmProtocolType();
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        Exception exception = null;
        for (int i = 0; i < this.channelGroupModels.length; ++i) {
            try {
                this.dataModel.applyToModel(i);
                continue;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (exception != null) {
            this.dataModel.refreshFromModel();
            throw exception;
        }
        this.resetDirty();
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("calling refreshFromModel");
        }
        this.dataModel.refreshFromModel();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2ChannelGroupsProvPane;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.deleteChGroupBt) {
            this.deleteChGroups();
        } else if (object == this.createChGroupBt) {
            this.createChannelGroup();
        } else if (object == this.addRemovePortBt) {
            this.addRemovePorts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createChannelGroup() {
        int n = this.channelGroupModels.length;
        DetailedLog detailedLog = new DetailedLog(0);
        if (this.eqpmtModel.getEqType() == 271 && n == 2 || this.eqpmtModel.getEqType() == 272 && n == 11) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CH_GROUP_MAX_NUMBER_REACHED);
            return;
        }
        XPL2ChannelGroupCreationDlg xPL2ChannelGroupCreationDlg = new XPL2ChannelGroupCreationDlg(JOptionPane.getFrameForComponent((Component)((Object)this)), this.eqpmtModel, this.channelGroupModels, -1);
        try {
            xPL2ChannelGroupCreationDlg.setVisible(true);
            if (!xPL2ChannelGroupCreationDlg.isCancelled()) {
                sChannelGroupAttributes sChannelGroupAttributes2 = xPL2ChannelGroupCreationDlg.getChannelGroupAttributes();
                ArrayList<XPL2ChannelGroupCreationDlg.PortDescriptor> arrayList = xPL2ChannelGroupCreationDlg.getAddedPorts();
                int[] nArray = new int[arrayList.size()];
                int n2 = 0;
                for (XPL2ChannelGroupCreationDlg.PortDescriptor portDescriptor : arrayList) {
                    nArray[n2++] = portDescriptor.getIfIndex();
                }
                this.dataModel.createChGroup(sChannelGroupAttributes2, nArray);
            }
        }
        catch (EMCProvisionError eMCProvisionError) {
            DetailedLog detailedLog2 = new DetailedLog(3, ErrorMsg.getString((EID)EMC.EID_CH_GROUP_CREATION_FAILURE));
            DetailedLog detailedLog3 = new DetailedLog(0, ErrorMsg.getString((EID)eMCProvisionError.getEID()));
            detailedLog2.addChild(detailedLog3);
            detailedLog.addChild(detailedLog2);
            detailedLog.updateTime();
        }
        catch (Exception exception) {
            DetailedLog detailedLog4 = new DetailedLog(3, ErrorMsg.getString((EID)EMC.EID_CH_GROUP_CREATION_FAILURE), exception);
            detailedLog.addChild(detailedLog4);
            detailedLog.updateTime();
        }
        finally {
            xPL2ChannelGroupCreationDlg.dispose();
            if (detailedLog.getChildCount() > 0) {
                DetailedLogDialog detailedLogDialog = DetailedLogDialog.getMixedDetailedLogDialog((Frame)JOptionPane.getFrameForComponent(this.getParent()), (DetailedLog)detailedLog);
                detailedLogDialog.show();
            }
        }
    }

    private void addRemovePorts() {
        int[] nArray = this.table.getSelectedRows();
        DetailedLog detailedLog = new DetailedLog(0);
        if (nArray.length > 0) {
            DetailedLogDialog detailedLogDialog;
            XPL2ChannelGroupCreationDlg xPL2ChannelGroupCreationDlg = new XPL2ChannelGroupCreationDlg(JOptionPane.getFrameForComponent((Component)((Object)this)), this.eqpmtModel, this.channelGroupModels, nArray[0]);
            xPL2ChannelGroupCreationDlg.setVisible(true);
            if (!xPL2ChannelGroupCreationDlg.isCancelled()) {
                DetailedLog detailedLog2;
                DetailedLog detailedLog3;
                detailedLogDialog = xPL2ChannelGroupCreationDlg.getAddedPorts();
                ArrayList<XPL2ChannelGroupCreationDlg.PortDescriptor> arrayList = xPL2ChannelGroupCreationDlg.getRemovedPorts();
                for (XPL2ChannelGroupCreationDlg.PortDescriptor portDescriptor : detailedLogDialog) {
                    try {
                        this.channelGroupModels[nArray[0]].attachPort(portDescriptor.getIfIndex());
                    }
                    catch (EMCProvisionError eMCProvisionError) {
                        detailedLog3 = new DetailedLog(3, ErrorMsg.getString((EID)EMC.EID_CH_GROUP_ATTACH_PARAM1, (Object)portDescriptor.toString()));
                        detailedLog2 = new DetailedLog(0, ErrorMsg.getString((EID)eMCProvisionError.getEID()));
                        detailedLog3.addChild(detailedLog2);
                        detailedLog.addChild(detailedLog3);
                        detailedLog.updateTime();
                    }
                    catch (ResourceInUse resourceInUse) {
                        detailedLog3 = new DetailedLog(3, ErrorMsg.getString((EID)EMC.EID_CH_GROUP_ATTACH_PARAM1, (Object)portDescriptor.toString()));
                        detailedLog2 = new DetailedLog(0, ErrorMsg.getString((EID)EMC.EID_CH_GRP_PORT_IN_ONE_PLUS_ONE));
                        detailedLog3.addChild(detailedLog2);
                        detailedLog.addChild(detailedLog3);
                        detailedLog.updateTime();
                    }
                    catch (Exception exception) {
                        detailedLog3 = new DetailedLog(3, ErrorMsg.getString((EID)EMC.EID_CH_GROUP_ATTACH_PARAM1, (Object)portDescriptor.toString()), exception);
                        detailedLog.addChild(detailedLog3);
                        detailedLog.updateTime();
                    }
                }
                for (XPL2ChannelGroupCreationDlg.PortDescriptor portDescriptor : arrayList) {
                    try {
                        this.channelGroupModels[nArray[0]].detachPort(portDescriptor.getIfIndex());
                    }
                    catch (EMCProvisionError eMCProvisionError) {
                        detailedLog3 = new DetailedLog(3, ErrorMsg.getString((EID)EMC.EID_CH_GROUP_DETACH_PARAM1, (Object)portDescriptor.toString()));
                        detailedLog2 = new DetailedLog(0, ErrorMsg.getString((EID)eMCProvisionError.getEID()));
                        detailedLog3.addChild(detailedLog2);
                        detailedLog.addChild(detailedLog3);
                        detailedLog.updateTime();
                    }
                    catch (Exception exception) {
                        detailedLog3 = new DetailedLog(3, ErrorMsg.getString((EID)EMC.EID_CH_GROUP_DETACH_PARAM1, (Object)portDescriptor.toString()), exception);
                        detailedLog.addChild(detailedLog3);
                        detailedLog.updateTime();
                    }
                }
            }
            xPL2ChannelGroupCreationDlg.dispose();
            if (detailedLog.getChildCount() > 0) {
                detailedLogDialog = DetailedLogDialog.getMixedDetailedLogDialog((Frame)JOptionPane.getFrameForComponent(this.getParent()), (DetailedLog)detailedLog);
                detailedLogDialog.show();
            }
        } else {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CH_GROUP_NO_LINE_SELECTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteChGroups() {
        int[] nArray = this.table.getSelectedRows();
        DetailedLog detailedLog = new DetailedLog(0);
        if (nArray.length > 0) {
            XPL2ChannelGroupModel[] xPL2ChannelGroupModelArray = new XPL2ChannelGroupModel[nArray.length];
            DetailedLogDialog detailedLogDialog = this.channelGroupModels;
            synchronized (detailedLogDialog) {
                for (int i = 0; i < nArray.length; ++i) {
                    xPL2ChannelGroupModelArray[i] = this.channelGroupModels[nArray[i]];
                }
                String string = "The selected Channel Group will be deleted.\nDo you want to continue?";
                int n = JOptionPane.showConfirmDialog((Component)((Object)this), string, "Delete Channel Group", 0, 3, null);
                if (n == 0) {
                    for (int i = 0; i < xPL2ChannelGroupModelArray.length; ++i) {
                        DetailedLog detailedLog2;
                        DetailedLog detailedLog3;
                        int[] nArray2 = xPL2ChannelGroupModelArray[i].getPortList();
                        for (int j = 0; j < nArray2.length; ++j) {
                            try {
                                xPL2ChannelGroupModelArray[i].detachPort(nArray2[j]);
                                continue;
                            }
                            catch (EMCProvisionError eMCProvisionError) {
                                detailedLog3 = new DetailedLog(3, ErrorMsg.getString((EID)EMC.EID_CH_GROUP_DETACH_PARAM1, (Object)this.getPortDesc(nArray2[j])));
                                DetailedLog detailedLog4 = new DetailedLog(0, ErrorMsg.getString((EID)eMCProvisionError.getEID()));
                                detailedLog3.addChild(detailedLog4);
                                detailedLog.addChild(detailedLog3);
                                detailedLog.updateTime();
                                continue;
                            }
                            catch (Exception exception) {
                                detailedLog3 = new DetailedLog(3, ErrorMsg.getString((EID)EMC.EID_CH_GROUP_DETACH_PARAM1, (Object)this.getPortDesc(nArray2[j])), exception);
                                detailedLog.addChild(detailedLog3);
                                detailedLog.updateTime();
                            }
                        }
                        if (detailedLog.getChildCount() != 0) continue;
                        try {
                            this.eqpmtModel.getChGrpManager().deleteChannelGroup(xPL2ChannelGroupModelArray[i].getIndex());
                            continue;
                        }
                        catch (EMCProvisionError eMCProvisionError) {
                            detailedLog2 = new DetailedLog(3, ErrorMsg.getString((EID)EMC.EID_CH_GROUP_DELETION_FAILURE));
                            detailedLog3 = new DetailedLog(0, ErrorMsg.getString((EID)eMCProvisionError.getEID()));
                            detailedLog2.addChild(detailedLog3);
                            detailedLog.addChild(detailedLog2);
                            detailedLog.updateTime();
                            continue;
                        }
                        catch (Exception exception) {
                            detailedLog2 = new DetailedLog(3, ErrorMsg.getString((EID)EMC.EID_CH_GROUP_DELETION_FAILURE));
                            detailedLog.addChild(detailedLog2);
                            detailedLog.updateTime();
                        }
                    }
                }
            }
            if (detailedLog.getChildCount() > 0) {
                detailedLogDialog = DetailedLogDialog.getMixedDetailedLogDialog((Frame)JOptionPane.getFrameForComponent(this.getParent()), (DetailedLog)detailedLog);
                detailedLogDialog.show();
            }
        } else {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CH_GROUP_NO_LINE_SELECTED);
        }
    }

    private String getPortDesc(int n) {
        IEntityTableModel iEntityTableModel = this.nmd.getEntityTable();
        try {
            if (iEntityTableModel != null) {
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer(false);
                return entityCellRenderer.getPortString(iEntityModel, false);
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return "";
    }

    private class NumberRangeCellEditor
    extends DefaultCellEditor {
        private int min;
        private int max;
        private EID err;

        public NumberRangeCellEditor(JTextField jTextField, int n, int n2, EID eID) {
            super(jTextField);
            this.min = n;
            this.max = n2;
            this.err = eID;
        }

        @Override
        public boolean stopCellEditing() {
            JTextField jTextField = (JTextField)this.getComponent();
            boolean bl = false;
            try {
                int n = Integer.parseInt(jTextField.getText());
                if (n < this.min || n > this.max) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (bl) {
                ErrorMsg.displayError((Component)XPL2ChannelGroupProvPane.this.getParent(), (EID)this.err);
                return false;
            }
            return super.stopCellEditing();
        }
    }

    private class PortListCellRenderer
    extends DefaultTableCellRenderer {
        PortListCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                this.setText(object.toString());
                StringBuilder stringBuilder = new StringBuilder();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
                stringBuilder.append("<html>");
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuilder.append(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    stringBuilder.append("<br>");
                }
                stringBuilder.append("<html>");
                this.setToolTipText(stringBuilder.toString());
            }
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }
}

